//--- Fast Rending Plants
//---- Texture for the right side of leaf
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
#declare Leaf_Texture_R = 
texture {
  pigment { color DarkGreen }
  finish { ambient 0.35 diffuse 0.5 phong 0.75 phong_size 40 }
  normal { waves 0.8 frequency 0.05 }
  scale <10, 0.01, 10>
  rotate z*45
}
texture {
  pigment {
    wood
    color_map {
      [0 0.5 color Black filter 0.8 color DarkGreen filter 0.7]
      [0.5 1 color DarkGreen filter 0.7 color Yellow filter 0.7]
    }
  } 
  finish { diffuse 0.5 }
  scale <30, 40, 20>
}

//---- Texture for left side of leaf
#declare Leaf_Texture_L = 
texture {
  pigment { color DarkGreen }
  finish { ambient 0.35 diffuse 0.5 phong 0.75 phong_size 40 }
  normal { waves 0.8 frequency 0.05 }
  scale <10, 0.01, 10>
  rotate z*45
}
texture {
  pigment {
    wood
    color_map {
      [0 0.5 color Black filter 0.8 color DarkGreen filter 0.7]
      [0.5 1 color DarkGreen filter 0.7 color Yellow filter 0.7]
    }
  } 
  finish { diffuse 0.5 }
  scale <30, 40, 20>
}

//--- Texture for leaf stem
#declare StemTexture = 
texture {
  pigment { color DarkGreen }
  finish { ambient 0.35 diffuse 0.5 phong 0.75 phong_size 40 }
  normal { waves 0.8 frequency .05 }
  scale <10, 0.1, 10>
  rotate z*45
}

//----- Right 1/2 of leaf
#declare Leaf_R = 
object {
  sphere { 0, 1 scale <10, 20, 8> translate x*5 }
  clipped_by {
    sphere { 0, 1 scale <12.5, 30, 12.5> translate y*15 }
    object { Cylinder_X scale <1, 22, 8> translate z*1.7 inverse }
    plane { x, 0 inverse }
  }
  texture { Leaf_Texture_R }
}

//--- Left 1/2 of leaf
#declare Leaf_L = 
object {
  sphere { 0, 1 scale <10, 20, 8> translate x*-5 }
  clipped_by {
    sphere { 0, 1 scale <12.5, 30, 12.5> translate y*15 }
    object { Cylinder_X scale <1, 22, 8> translate z*1.7 inverse }
    plane { x, 0 }
  }
  texture { Leaf_Texture_L }
}

#declare Stem = 
object {
  difference {
    object { Disk_Z scale <41.5, 41.5, 1.5> translate <-36.5, 19.9, 0> }
    object { Cylinder_Z scale <42.8, 40, 1> translate <-39.8, 20.1, 0> }
    plane { y, 0 }
  }
  texture { StemTexture }  
  bounded_by { box { -1, 1 scale <48, 48, 5> translate <-36.5, 20, 0> } }
  rotate y*-90
}

//---- Plant stalk
#declare T_Texture = 
texture {
  pigment {
    gradient x
    turbulence 0.1
    color_map {
      [0 0.6 color DarkGreen color DarkGreen]
      [0.6 0.8 color DarkGreen color MediumForestGreen]
      [0.8 1 color Khaki color Tan]
    }
  }
  finish { crand 0.07 ambient 0.2 diffuse 0.5 }
}
texture {
  pigment { color Clear }
  normal { waves 0.5 }
  finish { phong 0.6 phong_size 20 }
  scale <20, 2, 20>
}

#declare Dot = sphere { 0, 1 }

#declare Connector_1 = 
object {
  quadric { <0, 1, 1>, 0, 0, -1 }
  clipped_by {
    plane { x, 1 }
    plane { -x, 0 }
  }
}

#declare Connector_2 = quadric { <1, -1, 1>, 0, 0, 0 rotate z*90 }

/*----------------------------------------------------------------------------*/
#declare Stalk =
   union {
      sphere { 0, 9.333330 texture { T_Texture } }
      object { Connector_2
         clipped_by {
            plane { x, 9.312603 }
            plane { x, 8.647423 inverse }
         }
         texture { T_Texture }
         translate x*-9.312603
         scale <14.979824, 1, 1>
         translate x*-0.621676
         rotate y*180
         rotate z*87.614085
         rotate y*60.000128
         }
      sphere { 0, 8.666670 translate <0.20833, 10, -0.360840> texture { T_Texture } }
      object { Connector_2
         clipped_by {
            plane { x, 8.647489 }
            plane { x, 7.982295 inverse }
         }
         texture { T_Texture }       
         translate x*-8.647489
         scale <15.005653, 1, 1>
         translate x*-0.576282
         rotate y*180
         rotate z*85.872172
         rotate y*149.999582
         translate <0.20833, 10, -0.360840>
      }
      sphere { 0, 8 translate <-0.41667, 20, -0.721690> texture { T_Texture } }
      object { Connector_2
         clipped_by {
            plane { x, 7.982416 }
            plane { x, 7.317212 inverse }
         }
         texture { T_Texture }
         translate x*-7.982416
         scale <15.057626, 1, 1>
         translate x*-0.530124
         rotate y*180
         rotate z*83.709142
         rotate y*-139.106407
         translate <-0.41667, 20, -0.721690>
      }
      sphere { 0, 7.333330 translate <-1.25, 30, 0> texture { T_Texture } }
      object { Connector_2
         clipped_by {
            plane { x, 7.317376 }
            plane { x, 6.652167 inverse }
         }
         texture { T_Texture }
         translate x*-7.317376
         scale <15.135480, 1, 1>
         translate x*-0.483458
         rotate y*180
         rotate z*81.456245
         rotate y*-73.89781
         translate <-1.25, 30, 0>
      }
      sphere { 0, 6.66667 translate <-0.83333, 40, 1.443380> texture { T_Texture } }
      object { Connector_2
         clipped_by {
            plane { x, 6.652361 }
            plane { x, 5.987122 inverse }
         }
         texture { T_Texture }
         translate x*-6.652361
         scale <15.238136, 1, 1>
         translate x*-0.436560
         rotate y*180
         rotate z*79.190028
         rotate y*-10.893279
         translate <-0.83333, 40, 1.443380>
      }
      sphere { 0, 6 translate <1.04167, 50, 1.804220> texture { T_Texture } }
      object { Connector_2
         clipped_by {
            plane { x, 5.987334 }
            plane { x, 5.322071 inverse }
         }
         texture { T_Texture }
         translate x*-5.987334
         scale <15.365773, 1, 1>
         translate x*-0.389654
         rotate y*180
         rotate z*76.938992
         rotate y*51.051795
         translate <1.04167, 50, 1.804220>
      }
      sphere { 0, 5.33333 translate <2.5, 60, -0> texture { T_Texture } }
      object { Connector_2
         clipped_by {
            plane { x, 5.322290 }
            plane { x, 4.657010 inverse }
         }
         texture { T_Texture }
         translate x*-5.32229
         scale <15.517788, 1, 1>
         translate x*-0.34298
         rotate y*180
         rotate z*74.718236
         rotate y*112.410955
         translate <2.5, 60, -0>
      }
      sphere { 0, 4.66667 translate <1.45833, 70, -2.525910> texture { T_Texture } }
      object { Connector_2
         clipped_by {
            plane { x, 4.657224 }
            plane { x, 3.991903 inverse }
         }
         texture { T_Texture }
         translate x*-4.657224
         scale <15.692774, 1, 1>
         translate x*-0.296775
         rotate y*180
         rotate z*72.537656
         rotate y*173.413295
         translate <1.45833, 70, -2.525910>
      }
      sphere { 0, 4 translate <-1.66667, 80, -2.886750> texture { T_Texture } }
      object { Connector_2
         clipped_by {
            plane { x, 3.992103 }
            plane { x, 3.326749 inverse }
         }
         texture { T_Texture }
         translate x*-3.992103
         scale <15.890659, 1, 1>
         translate x*-0.251223
         rotate y*180
         rotate z*70.404278
         rotate y*-125.817495
         translate <-1.66667, 80, -2.886750>
      }
      sphere { 0, 3.33333 translate <-3.75, 90, 0> texture { T_Texture } }
      object { Connector_2
         clipped_by {
            plane { x, 3.326927 }
            plane { x, 2.661548 inverse }
         }
         texture { T_Texture }
         translate x*-3.326927
         scale <16.110621, 1, 1>
         translate x*-0.206505
         rotate y*180
         rotate z*68.323422
         rotate y*-65.20868
         translate <-3.75, 90, 0>
      }
      sphere { 0, 2.66667 translate <-2.08333, 100, 3.608440> texture { T_Texture } }
      object { Connector_2
         clipped_by {
            plane { x, 2.661697 }
            plane { x, 1.996270 inverse }
         }
         texture { T_Texture }
         translate x*-2.661697
         scale <16.351045, 1, 1>
         translate x*-0.162785
         rotate y*180
         rotate z*66.299220
         rotate y*-4.714953
         translate <-2.08333, 100 ,3.608440>
      }
      sphere { 0, 2 translate <2.29167, 110, 3.969280> texture { T_Texture } }
      object { Connector_2
         clipped_by {
            plane { x, 1.996386 }
            plane { x, 1.330921 inverse }
         }
         texture { T_Texture }
         translate x*-1.996386
         scale <16.611751, 1, 1>
         translate x*-0.120179
         rotate y*180
         rotate z*64.334645
         rotate y*55.693393
         translate <2.29167, 110, 3.969280>
      }
      sphere { 0, 1.333330 translate <5, 120, -0> texture { T_Texture } }
      bounded_by { sphere { 0, 73.318661 translate y*56 } }
   }

//--- Complete Leaf & Stem
#declare Leaf1 =
union {
  object { Leaf_L rotate x*90 translate <0, 54, -38> }
  object { Leaf_R rotate x*90 translate <0, 54, -38> }
  object { Stem }
  bounded_by { box { -1, 1 scale <20, 40, 36> translate <0, 38, -28> } }
}

//--- A 17 Leaf Plant
#declare Plant17 =
union {
  object { Stalk }
  object { Leaf1 scale 0.6 rotate x*-20 rotate y*30 translate <5, 119, 0> }
  object { Leaf1 scale 0.4 rotate x*-20 rotate y*-30 translate <5, 119, 0> }
  object { Leaf1 scale 0.7 rotate x*-20 rotate y*20 translate <-2, 100, 3.6> }
  object { Leaf1 scale 0.7 rotate x*-20 rotate y*120 translate <-2, 100, 3.6> }
  object { Leaf1 scale 0.65 rotate x*-20 rotate y*240 translate <-2, 100, 3.6> }
  object { Leaf1 scale 0.4 rotate x*-20 rotate y*-40 translate <-2, 100, 3.6> }
  object { Leaf1 scale 0.5 rotate x*-20 rotate y*-20 translate <-3.75, 90, -2> }
  object { Leaf1 scale 0.5 rotate x*-20 rotate y*140 translate <-3.75, 90, -2> }
  object { Leaf1 scale 0.6 rotate x*-20 rotate y*180 translate <-1.66, 80, -2> }
  object { Leaf1 scale 0.6 rotate x*-20 rotate y*50 translate <-1.66, 80, -2> }
  object { Leaf1 scale 0.6 rotate x*-20 rotate y*-50 translate <-1.66, 80, -2> }
  object { Leaf1 scale 0.5 rotate x*-20 rotate y*-110 translate <-1.66, 80, -2> }
  object { Leaf1 scale 0.6 rotate x*-20 rotate y*110 translate <-1.66, 80, -2> }
  object { Leaf1 scale 0.5 rotate x*-20 rotate y*10 translate <-1.66, 80, -2> }
  object { Leaf1 scale 0.6 rotate x*-20 rotate y*30 translate <2.5, 60, -2> }
  object { Leaf1 scale 0.5 rotate x*-20 rotate y*-40 translate <4.5, 60, -2> }
  object { Leaf1 scale 0.5 rotate x*-20 rotate y*100 translate <5.5, 60, 0> }
  bounded_by { box { -1, 1 scale <60, 120, 60> translate y*90 } }
}

//--- A 6 Leaf Plant
#declare Plant6 =
union {
  object { Stalk }
  object { Leaf1 scale 0.6 rotate x*-20 rotate y*30 translate <5, 119, 0> }
  object { Leaf1 scale 0.4 rotate x*-20 rotate y*-30 translate <5, 119, 0> }
  object { Leaf1 scale 0.7 rotate x*-20 rotate y*-20 translate <-2, 100, 3.6> }
  object { Leaf1 scale 0.7 rotate x*-20 rotate y*-70 translate <-2, 100, 3.6> }
  object { Leaf1 scale 0.65 rotate x*-20 rotate y*-180 translate <-2, 100, 3.6> }
  object { Leaf1 scale 0.4 rotate x*-20 rotate y*-40 translate <-2, 100, 3.6> }
  bounded_by { box { -1, 1 scale <60, 120, 60> translate y*90 } }
}

//--- A 3 Leaf Plant
#declare Plant3 =
union {
  object { Stalk }
  object { Leaf1 scale 0.6 rotate x*-20 rotate y*30 translate <5 119 0> }
  object { Leaf1 scale 0.4 rotate x*-20 rotate y*-30 translate <5 119 0> }
  object { Leaf1 scale 0.7 rotate x*-20 rotate y*-20 translate <-2 100 3.6> }
  bounded_by { box { -1, 1 scale <60, 100, 60> translate y*90 } }
}

//---- Complete Plant
//---- On Left
union {
  object { Plant17 }
  object { Plant6 scale 0.7 rotate 0 translate <20, 0, -10> }
  object { Plant6 scale 0.7 rotate y*200 translate <-15, 0, 15> }
  object { Plant17 scale 0.55 translate <-10, 0, -11> }
  object { Plant3 scale 0.6 translate <3, 0, 9> }
  bounded_by { box { -1, 1 scale <90, 100, 90> translate y*90 } }
  scale 7
  translate <-200, 600, 610>
}

//---- Complete Plant
union {
  object { Plant17 }
  object { Plant6 scale 0.7 rotate 0 translate <20, 0, -10> }
  object { Plant6 scale 0.7 rotate y*200 translate <-25, 0, 15> }
  object { Plant17 scale 0.55 translate <-6, 0, -11> }
  object { Plant17 scale 0.6 translate <12, 0, 9> }
  bounded_by { box { -1, 1 scale <100 80 100> translate y*49 } }
  scale 5
  translate <1800, 600, 910>
}