//---- Pedis World
//
//--- A Rock Gourge
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
//  Both the "land_map.tga" and "land_tex.gif" are corrupted,
//  so unless someone has the TGA and GIF files, we're stuffed!
//
height_field {
  //tga "land_map.tga"
  gif "test_land_map.gif"
  smooth
  water_level 0.01
  scale <5000, 1300, 5000>
  translate <-2500, 0, -2500>
  texture {
    //pigment { image_map { gif "land_tex.gif" interpolate 2 } }
    pigment { image_map { gif "test_land_tex.gif" interpolate 2 } }
    scale <5000, 1, 5000> 
    translate <-2500, 0, -2500>
    finish { phong 0.2 phong_size 20 ambient 0.2 diffuse 0.4 crand 0.1 }
  }
}

//---- Atmosphere
union {
  sphere { 0, 1
    texture {
      pigment {
        gradient y
        turbulence 0.1
        color_map {
          [0 0.05 color Black color Black]
          [0.05 0.1 color Black color Violet]
          [0.1 0.2 color Violet color CadetBlue]
          [0.2 0.3 color CadetBlue color Violet]
          [0.3 0.4 color Violet color Black]
          [0.4 1 color Black color Black]
        }
      }
      scale <0.1, 2, 0.1>
      translate y*-2
      finish { ambient 0.6 diffuse 0 }
    }
    scale 10000
    rotate x*35
    rotate z*25
  }
  //--- Ceiling
  plane { y, 2000
    texture {
      pigment {
        gradient y
        turbulence 0.1
        color_map {
          [0 0.05 color Black color Black]
          [0.05 0.1 color Black color Violet]
          [0.1 0.2 color Violet color CadetBlue]
          [0.2 0.5 color CadetBlue color Violet]
          [0.5 0.7 color Violet color Black]
          [0.7 1 color Black color Black]
        }
      }
      scale <0.3, 2, 0.3>
      finish { ambient 0.8 diffuse 0 }
    }
    scale 10000
  }
}

//--- Swamp Water
plane { y, 460
  texture {
    pigment { color SeaGreen filter 0.7 }
    finish { ambient 0.2 diffuse 0.7 reflection { 0.8 } }
    normal  { ripples 0.3 frequency 0.03 }  //  added by me
  }
  interior { ior 1.2 }
}