//--- Ancient Towers

//--- Torus For Dome Base
#declare T20 = 
   quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -50.320000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        49.680000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -50.320000 0.000000 617.025600 >
sturm
   }


//--- Hersey Kiss Shape
#declare Piriform =
quartic {
   < 4.0   0.0   0.0   -4.0  0.0   0.0   0.0   0.0   0.0  0.0
   0.0   0.0   0.0    0.0  0.0   0.0   0.0   0.0   0.0  0.0
   0.0   0.0   0.0    0.0  0.0   1.0   0.0   0.0   0.0  0.0
   0.0   0.0   1.0    0.0  0.0 >
}

//--- Bright Metallic Gold
#declare Gold2 = 
texture {  
	0.02  
	ambient 0.3 
	diffuse 0.5 
	colour red 0.64 green 0.51 blue 0.05
	reflection 0.6 
	brilliance 8 
	specular 0.5 
}



#declare DomeTexture =
texture {
  gradient <0 1 0> 
   color_map {
   [0 1  color Gold color Gray60]
   }
  scale <2 2 2>
  turbulence .3
  ambient .1
  phong 1
  .1
}

#declare FrameTexture =
texture {
  color Feldspar 
  ambient .1
  phong 1
  .15
}

#declare Muck = color red .76 green .74 blue .67

#declare Body2Texture =
texture {
  color Muck  
  ambient .1
  phong 1
  .15
}


#declare BodyTexture =
texture {
  color Gray50
  ambient .1
  phong 1
  .15
}



//--- Kiss shaped Object
#declare Kiss =
object {
  quartic { Piriform rotate <0 0 -90> }
   texture { DomeTexture }
     bounded_by {
     box { UnitBox scale <.66 .6 .66> translate <0 -.55 0> }
     }
}

//--- Kiss shape for Rib
#declare RKiss =
  quartic { Piriform rotate <0 0 -90> }


//--- Dome Ribs
#declare DRib =
object {
  intersection { 
   quartic { RKiss scale <11 11 11> } 
   plane { <0 0 1> .3 }
   plane { <0 0 1> -.3 inverse }
  }
   texture { Gold2 }
     bounded_by {
     box { UnitBox scale <7 6 3> translate <0 -5.5 0> }
     }
}




//---- Tower Type1
#declare Tower1 =
composite {
   //--- Dome
   composite {
    object { Kiss scale <10 10 10> translate <0 10 0> }
    object { Kiss scale <2.9 2.9 2.9> translate <0 10.7 0> texture { Gold2 }}
    object { Kiss scale <1.07 6 1.07> translate <0 14.3 0> texture { Gold2 }}
    object { DRib rotate <0 0 0> translate <0 10.5 0> }
    object { DRib rotate <0 60 0> translate <0 10.5 0> }
    object { DRib rotate <0 120 0> translate <0 10.5 0> }
      bounded_by {
      box { UnitBox scale <7 7.5 7> translate <0 7.3 0> }
      }
    translate <0 42 0>
    }
    
    //--- Torus Base
    object {
     quartic { T20 }
      texture { Gold2 }
        bounded_by {
        box { UnitBox scale <5.5 .5 5.5> }
        }
    translate <0 42 0> 
    }
   
    //--- Tower Body
    object {
     difference {
      intersection { Disk_Y scale <5 21 5> translate <0 21 0> }
      quadric { Cylinder_Y scale <4 1 4> }
      quadric { Cylinder_Z scale <3 3 1> translate <0 35.2 0> }
      box { UnitBox scale <1.8 3.4 6> translate <0 33.2 0> }
     }
      texture { BodyTexture }
        bounded_by {
        box { UnitBox scale <5.5 22 5.5> translate <0 21 0> }
        }
    } 

    //--- Tower Window
    object {
     difference {
      union {
      quadric { Cylinder_Z scale <3.8 3.8 1> translate <0 35.2 0> }
      box { UnitBox scale <2.6 4.2 6> translate <0 33.2 0> }
      }
      quadric { Cylinder_Z scale <3 3 1> translate <0 35.2 0> }
      box { UnitBox scale <1.8 3.4 6> translate <0 33.2 0> }
      quadric { Cylinder_Y scale <5.5 1 5.5> inverse }
     }
      texture { FrameTexture }
        bounded_by {
        box { UnitBox scale <4.2 6 6> translate <0 33.9 0> }
        }
   }   

   object { 
    union {
      intersection { Disk_Y scale <5.5 1 5.5> translate <0 40.6 0> }
      intersection { Disk_Y scale <5.5 13 5.5> translate <0 13 0> }
    }
       texture { FrameTexture }
   }
        bounded_by {
        box { UnitBox scale <7 30 7> translate <0 29 0> }
        }
}


//---- Tower Type2
#declare Tower2 =
composite {
   //--- Dome
   composite {
    object { Kiss scale <10 10 10> translate <0 10 0> texture { BodyTexture } }
    object { Kiss scale <2.9 2.9 2.9> translate <0 10.7 0> texture { Gold2 }}
    object { Kiss scale <1.07 6 1.07> translate <0 14.3 0> texture { Gold2 }}
    object { DRib rotate <0 0 0> translate <0 10.5 0> }
    object { DRib rotate <0 60 0> translate <0 10.5 0> }
    object { DRib rotate <0 120 0> translate <0 10.5 0> }
      bounded_by {
      box { UnitBox scale <7 7.5 7> translate <0 7.3 0> }
      }
    translate <0 42 0>
    }
    
    //--- Torus Base
    object {
     quartic { T20 }
      texture { Gold2 }
        bounded_by {
        box { UnitBox scale <5.5 .5 5.5> }
        }
    translate <0 42 0> 
    }
   
    //--- Tower Body
    object {
     difference {
      intersection { Disk_Y scale <5 21 5> translate <0 21 0> }
      quadric { Cylinder_Y scale <4 1 4> }
      quadric { Cylinder_Z scale <3 3 1> translate <0 35.2 0> }
      box { UnitBox scale <1.8 3.4 6> translate <0 33.2 0> }
     }
      texture { BodyTexture }
        bounded_by {
        box { UnitBox scale <5.5 22 5.5> translate <0 21 0> }
        }
    } 

    //--- Tower Window
    object {
     difference {
      union {
      quadric { Cylinder_Z scale <3.8 3.8 1> translate <0 35.2 0> }
      box { UnitBox scale <2.6 4.2 6> translate <0 33.2 0> }
      }
      quadric { Cylinder_Z scale <3 3 1> translate <0 35.2 0> }
      box { UnitBox scale <1.8 3.4 6> translate <0 33.2 0> }
      quadric { Cylinder_Y scale <5.5 1 5.5> inverse }
     }
      texture { Body2Texture }
        bounded_by {
        box { UnitBox scale <4.2 6 6> translate <0 33.9 0> }
        }
   }   

   object { 
    union {
      intersection { Disk_Y scale <5.5 1 5.5> translate <0 40.6 0> }
      intersection { Disk_Y scale <5.5 13 5.5> translate <0 13 0> }
    }
       texture { Body2Texture }
   }
        bounded_by {
        box { UnitBox scale <7 30 7> translate <0 29 0> }
        }
}

//--- Post for Bridge
#declare Post1 = intersection { Disk_Y scale <.2 1.8 .2> }



//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++  

//--- Complete Tower 
composite {
  composite {
  composite { Tower1 translate <-22 0 0> }
  composite { Tower1 translate <22 0 0> }
  composite { Tower1 scale <3 2 3> translate <0 -61 0> }
  composite { Tower2 scale <1.6 1.6 1.6> translate <14.3 0 23> }
        bounded_by {
        box { UnitBox scale <33 50 30> translate <0 49 7.7> }
        }
  }

  composite {
  composite { Tower1 scale <1 1 1> translate <64.6 0 0> }
  composite { Tower2 scale <1.6 1.6 1.6> translate <75 0 23.1> }
  composite { Tower2 scale <1.6 1.6 1.6> translate <75 -49.5 -9.1> }
        bounded_by {
        box { UnitBox scale <19 50 30> translate <72.5 49 7.7> }
        }
  }


 //--- Bridge Span
 composite {
  composite {
  //--- Bridge Trim
  object {
   union {
    difference {
     intersection { Disk_Z scale <12 12 2> translate <0 -14 0> }
     quadric { Cylinder_Z scale <11 11 1> translate <0 -14 0> }
     plane { <0 1 0> -14 }
    }
     box { UnitBox scale <16.5 .6 2> translate <0 -.6 0> }
     box { UnitBox scale <1.9 1.1 2> translate <-14.7 -15 0> }
     box { UnitBox scale <1.9 1.1 2> translate <14.7 -15 0> }
   }
     texture { FrameTexture }
        bounded_by {
        box { UnitBox scale <17.5 9 3> translate <0 -8 0> }
        }
  }

  //--- Bridge Wall
  object {
   difference {
    box { UnitBox scale <16.5 6.45 1.6> translate <0 -7.6 0> }
    quadric { Cylinder_Z scale <12 12 1> translate <0 -14 0> }
   }
     texture { BodyTexture }
        bounded_by {
        box { UnitBox scale <17.5 9 3> translate <0 -8 0> }
        }
 }
        bounded_by {
        box { UnitBox scale <17.5 9 3> translate <0 -8 0> }
        }
 }
  object {
    union {
    intersection { Post1 translate <-15 1.8 0> }
    intersection { Post1 translate <-13.5 1.8 0> }
    intersection { Post1 translate <-12 1.8 0> }
    intersection { Post1 translate <-10.5 1.8 0> }
    intersection { Post1 translate <-9 1.8 0> }
    intersection { Post1 translate <-7.5 1.8 0> }
    intersection { Post1 translate <-6 1.8 0> }
    intersection { Post1 translate <-4.5 1.8 0> }
    intersection { Post1 translate <-3 1.8 0> }
    intersection { Post1 translate <-1.5 1.8 0> }
    intersection { Post1 translate <0 1.8 0> }
    intersection { Post1 translate <15 1.8 0> }
    intersection { Post1 translate <13.5 1.8 0> }
    intersection { Post1 translate <12 1.8 0> }
    intersection { Post1 translate <10.5 1.8 0> }
    intersection { Post1 translate <9 1.8 0> }
    intersection { Post1 translate <7.5 1.8 0> }
    intersection { Post1 translate <6 1.8 0> }
    intersection { Post1 translate <4.5 1.8 0> }
    intersection { Post1 translate <3 1.8 0> }
    intersection { Post1 translate <1.5 1.8 0> }
   }
     texture { Gold2 }
        bounded_by {
        box { UnitBox scale <16 2.3 .5> translate <0 1.7 0> }
        }
  }
  translate <43.6 30.6 0>  
 }
        bounded_by {
        box { UnitBox scale <65 50 30> translate <28.8 49 7.7> }
        }

scale <16.6666 16.6666 16.6666>
translate <290 1040 1100>

}


