//--- Jack's World & Misc textures
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

union {
  sphere { 0, 1
    texture {
      pigment {
        gradient y 
        color_map {
          [0.00 0.05 color Black     color Black]
          [0.05 0.10 color Black     color Violet]
          [0.10 0.20 color Violet    color CadetBlue]
          [0.20 0.30 color CadetBlue color Violet]
          [0.30 0.40 color Violet    color Black]
          [0.40 1.00 color Black     color Black]
        }
        scale <0.1, 2, 0.1>
        translate y*-2
        turbulence 0.1
      }
      finish {
        ambient 0.6
        diffuse 0
      }
    }
    scale 10000
    rotate x*35
    rotate z*25
  } 
  //--- Ceiling
   plane { y, 2000
     texture {
       pigment {
         gradient y
	 color_map {
           [0.00 0.05 color Black     color Black]
           [0.05 0.10 color Black     color Violet]
           [0.10 0.20 color Violet    color CadetBlue]
           [0.20 0.50 color CadetBlue color Violet]
           [0.50 0.70 color Violet    color Black]
           [0.70 1.00 color Black     color Black]
         }
	 scale <0.3, 2, 0.3>
	 turbulence 0.1
       }
       finish {
         ambient 0.8
         diffuse 0
       }
    }
    scale 10000
  }
}

//--- Textures For "Jack Coaster"

//--- Bright Metallic Gold
#declare Gold2 = 
texture {
  pigment { colour red 0.64 green 0.51 blue 0.05 }
  finish {
    crand 0.02  
    ambient 0.3 
    diffuse 0.5 
    reflection { 0.6 }
    brilliance 8 
    specular 0.5 
  }
}

//--- Dark Metallic Steel
#declare Steel2 = 
texture {  
  pigment { colour red 0.55 green 0.56 blue 0.7 }
  finish {
    crand 0.02  
    ambient 0.2 
    diffuse 0.5 
    reflection { 0.6 }
    brilliance 8 
    specular 0.5 
  }
}

#declare BellowTexture =
texture {
  pigment { color Salmon }
  finish {
    ambient 0.1
    diffuse 0.7
    phong 1
    phong_size 80
  }
}

#declare WhiteWash =
texture {
  pigment { color Gray40 }
  finish {
    ambient 0.1
    diffuse 0.4
    phong 0.3
    phong_size 80
  }
}

#declare WhiteWash2 =
texture {
  pigment { color Gray50 }
  finish {
    ambient 0.1
    diffuse 0.5
    phong 0.3
    phong_size 80
  }
}

#declare TrimTexture = texture { Gold2 }

//--- Box Top Texture
#declare BTTexture =
texture {
  pigment { color Gray40 }
  finish {
    ambient 0.2
    diffuse 0.6
    reflection { 0.5 }
  }
}

//--- Steel Wheel Texture
#declare Steel = texture { Steel2 }