//----- Coaster Rails
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

//---- Concave Track
#declare Rail1 =
union {
  object {
    difference {
      cylinder { x, -x, 1 scale < 5, 1000, 1000> }
      object { Cylinder_X scale <1, 990, 990> }
      plane { y, 0 }
    }
    texture { Steel2 }
  }
  object {
    difference {
      cylinder { x, -x, 1 scale <10, 990, 990> }
      object { Cylinder_X scale <1, 970, 970> }
      plane { y, 0 }
    }
    texture { WhiteWash2 }
  }
  bounded_by { box { -1, 1 scale <11, 502, 1002 > translate y*500 } }
}

#declare Tressle =
box { -1, 1 scale <58, 3, 5> translate y*980 texture { WhiteWash2 } }

//---- Tressle Arch
#declare TArch =
union {
  object { Tressle rotate  x*3 }
  object { Tressle rotate  x*6 }
  object { Tressle rotate  x*9 }
  object { Tressle rotate x*12 }
  object { Tressle rotate x*15 }
  object { Tressle rotate x*18 }
  object { Tressle rotate x*21 }
  object { Tressle rotate x*24 }
  object { Tressle rotate x*27 }
  object { Tressle rotate x*30 }
  object { Tressle rotate x*33 }
  object { Tressle rotate x*36 }
  object { Tressle rotate x*39 }
  object { Tressle rotate x*42 }
  object { Tressle rotate x*45 }
  object { Tressle rotate x*48 }
  object { Tressle rotate x*51 }
  object { Tressle rotate x*54 }
  object { Tressle rotate x*57 }
  object { Tressle rotate x*60 }
  object { Tressle rotate x*63 }
  object { Tressle rotate x*66 }
  object { Tressle rotate x*69 }
  object { Tressle rotate x*72 }
  object { Tressle rotate x*75 }
  object { Tressle rotate x*78 }
  object { Tressle rotate x*81 }
  object { Tressle rotate x*84 }
  object { Tressle rotate x*87 }
  object { Tressle rotate x*90 }
  object { Tressle rotate x*93 } // added
  object { Tressle rotate x*96 } // added
  object { Tressle }
  object { Tressle rotate  x*-3 }
  object { Tressle rotate  x*-6 }
  object { Tressle rotate  x*-9 }
  object { Tressle rotate x*-12 }
  object { Tressle rotate x*-15 }
  object { Tressle rotate x*-18 }
  object { Tressle rotate x*-21 }
  object { Tressle rotate x*-24 }
  object { Tressle rotate x*-27 }
  object { Tressle rotate x*-30 }
  object { Tressle rotate x*-33 }
  object { Tressle rotate x*-36 }
  object { Tressle rotate x*-39 }
  object { Tressle rotate x*-42 }
  object { Tressle rotate x*-45 }
  object { Tressle rotate x*-48 }
  object { Tressle rotate x*-51 }
  object { Tressle rotate x*-54 }
  object { Tressle rotate x*-57 }
  object { Tressle rotate x*-60 }
  object { Tressle rotate x*-63 }
  object { Tressle rotate x*-66 }
  object { Tressle rotate x*-69 }
  object { Tressle rotate x*-72 }
  object { Tressle rotate x*-75 }
  object { Tressle rotate x*-78 }
  object { Tressle rotate x*-81 }
  object { Tressle rotate x*-84 }
  object { Tressle rotate x*-87 }
  object { Tressle rotate x*-90 }
  bounded_by { box { -1, 1 scale <60, 502, 1002 > translate y*500 } }
}
 
#declare FR1 = box { -1, 1 scale <7, 1000, 7> } 
#declare FR2 = box { -1, 1 scale <1000, 14, 8> }

#declare FrameWork =
object {
  difference {
    union {
      box { FR1 translate     x*0 }
      box { FR1 translate   x*100 }
      box { FR1 translate   x*200 }
      box { FR1 translate   x*300 }
      box { FR1 translate   x*400 }
      box { FR1 translate   x*500 }
      box { FR1 translate   x*600 }
      box { FR1 translate   x*700 }
      box { FR1 translate   x*800 }
      box { FR1 translate   x*900 }
      box { FR1 translate  x*1000 }
      box { FR1 translate  x*-100 }
      box { FR1 translate  x*-200 }
      box { FR1 translate  x*-300 }
      box { FR1 translate  x*-400 }
      box { FR1 translate  x*-500 }
      box { FR1 translate  x*-600 }
      box { FR1 translate  x*-700 }
      box { FR1 translate  x*-800 }
      box { FR1 translate  x*-900 }
      box { FR1 translate x*-1000 }
      box { FR1 translate x*-1100 }
      box { FR1 translate x*-1200 }
      box { FR1 translate x*-1300 }
    }
    object { Cylinder_Z scale <985, 985, 1> inverse }
  } 
  texture { WhiteWash }
  bounded_by { box { -1, 1 scale <1300, 1300, 10> } }
  rotate y*90
}

//--- 1/2 Frame
#declare FrameWork2 =
object {
  difference {
    union {
      box { FR1 translate x*300 }
      box { FR1 translate x*400 }
      box { FR1 translate x*500 }
      box { FR1 translate x*600 }
      box { FR1 translate x*700 }
      box { FR1 translate x*800 }
      box { FR1 translate x*900 }
      box { FR1 translate x*1000 }
    }
    object { Cylinder_Z scale <985, 985, 1> inverse }
  } 
  texture { WhiteWash }
  bounded_by { box { -1, 1 scale <1000, 1000, 10> } }
  rotate y*90
}

//---- Track Under Jack
union {
  object { Rail1 translate <58, -1000, 0> }
  object { Rail1 translate <-58, -1000, 0> }
  union {
    object { Tressle rotate  x*0 }
    object { Tressle rotate x*-3 }
    object { Tressle rotate x*-6 }
    object { Tressle rotate  x*3 }
    object { Tressle rotate  x*6 }
    object { Tressle rotate  x*9 }
    object { Tressle rotate x*12 }
    object { Tressle rotate x*15 }
    object { Tressle rotate x*18 }
    object { Tressle rotate x*21 }
    translate y*-1000
  }
  object { FrameWork translate < 58, -1000, 0> }
  object { FrameWork translate <-58, -1000, 0> }
  bounded_by { box { -1, 1 scale <65, 1005, 1005> translate y*-1000 } }
}

//---- Track out of Castle
union {
  object { Rail1 translate < 58, -1000, 0> } 
  object { Rail1 translate <-58, -1000, 0> }
  object { TArch translate y*-1000 }
  object { FrameWork translate < 58, -1000, 0> }
  object { FrameWork translate <-58, -1000, 0> }
  bounded_by { box { -1, 1 scale <65, 1005, 1005> translate y*-1000 } }
  translate <-908, -330, 2520>
}

//---- Track beside Jack
union {
  object { Rail1 translate < 58, -1000, 0> }
  object { Rail1 translate <-58, -1000, 0> }
  object { TArch translate y*-1000 }
  object { FrameWork translate < 58, -1000, 0> }
  object { FrameWork translate <-58, -1000, 0> }
  bounded_by { box { -1, 1 scale <65, 1005, 1005> translate y*-1000 } }
  translate <-1000, -400, 800>
}