//--- Textures For "Jack Coaster"
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

//---- Face Mask Texture
#declare FaceMask =
texture {
  pigment {
    // image_map { <1, -1, 0> gif "face5.gif" interpolate 4 }
    image_map { gif "face5.gif" interpolate 4 }
    //image_map { gif "JackMapCJF.gif" interpolate 4 }
    scale <90, 90, 1>
    translate <-45, -36.3, 1>
  }
  finish {
    ambient 0.25
    diffuse 0.7
    phong 0.5
    phong_size 100
    crand 0.01
    roughness 0.02
  }
}

//---- Skin Texture
#declare SkinTexture =
texture {
  pigment {
    // image_map { <1, -1, 0> gif "skin.gif" interpolate 4 }
    image_map { gif "skin.gif" interpolate 4 }
    //image_map { gif "JackMapCJF.gif" interpolate 4 }
    scale <90, 90, 1>
    translate <-45, -36.3, 1>
  }
  finish {
    ambient 0.25
    diffuse 0.7
    phong 0.5
    phong_size 100
    crand 0.01
    roughness 0.02
  }
}

//--- Texture For Jack's Box
#declare BoxImage =
texture {
  pigment {
    // image_map { <1, -1, 0> gif "boxart.gif" interpolate 4 }
    image_map { gif "boxart.gif" interpolate 4 }
    //image_map { gif "BoxTestCJF.gif" interpolate 4 }
    scale <90, 90, 1>
    translate <-45, -45, 0>                                              
  }
  finish {
    ambient 0.3
    diffuse 0.6
  }
}  

#declare HatTexture = 
texture {
  pigment {
    gradient y
    color_map {
      [0    0.2  color Red     color Red]
      [0.2  0.23 color Gold    color Gold]
      [0.23 0.35 color Magenta color Magenta]
      [0.35 0.38 color Gold    color Gold]
      [0.38 1    color Red     color Violet]
    }
    scale <100, 52, 100>
    rotate z*30
    translate y
  }
  finish {
    phong 1
    phong_size 30
    crand 0.02
  }
}