//----Jack2.......Head Case
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

//--- Jacks CTDS Parts 
#declare YourTexture =
texture {
  pigment { color rgb <0.556863, 0.419608, 0.137255> }
  finish {
    ambient 0.1
    diffuse 0.6
    phong 1
  }
}

#declare Dot = quadric { 1, 0, 0, -1 }

#declare Connector_1 = 
object {
  quadric { <0, 1, 1>, 0, 0, -1 }
  clipped_by {
    plane {  x, 1 }
    plane { -x, 0 }
  }
}

#declare Connector_2 = quadric { <1, -1, 1>, 0, 0, 0 rotate z*90  }

#declare Connector_4 = 
intersection {
  quadric { <0, 1, 1>, 0, 0, -1 }
  plane {  x, 1 }
  plane { -x, 0 }
}

//------ Jack's Skull & Chin with cut-out mouth opening
//--- Mouth cutter
#declare MCut =
difference {
  union {
    object { Cylinder_Z scale < 9.2, 9.2, 1> translate <-4, 2.9, 0> }
    object { Cylinder_Z scale < 9.2, 9.2, 1> translate < 4, 2.9, 0> }
    object { Cylinder_Z scale <11.1, 4.3, 1> translate < 0, -2.7, 0> }
  }
  object { Cylinder_Z scale <15.2, 15.2, 1> translate <-4, 16.2, 0> }
  object { Cylinder_Z scale <15.2, 15.2, 1> translate < 4, 16.2, 0> }
  scale <0.9, 1, 1>
}

//----- Skull
#declare Head=
object {
  difference {
   union {
       sphere { 0, 27.1 translate <-2, 22.7, -14.7> }
 
       intersection { object { Connector_2 }
       plane { x, 23.577342 }
       plane { x, 16.791244 inverse }
        translate <-23.577342, 0, 0>
        scale     < 1.764626, 1, 1>
        translate <-13.361098, 0, 0>
        rotate y*180
        rotate    < 0, 0, -87.078905>
        rotate    < 0, 150.255119, 0>
        translate <-2, 22.7, -14.7>
       }
 
       sphere { 0, 19.3 translate <-2.7, 6.9, -15.1> }
  
       intersection { object { Connector_2 }
       plane { x, 19.155296 }
       plane { x, 17.765793 inverse }
        translate <-19.155296, 0, 0>
        scale     < 8.120269, 1, 1>
        translate <-2.358948, 0, 0>
        rotate y*180
        rotate    < 0, 0, -77.905243>
        rotate y*90
        translate <-2.7, 6.9, -15.1>
       }
  
       sphere { 0, 17.9 translate <-2.7, -4.3, -17.5> }
  
       intersection { object { Connector_2 }
       plane { x, 16.387693 }
       plane { x, 12.542536 inverse }
        translate <-16.387693, 0, 0>
        scale     < 2.275772, 1, 1>
        translate <-7.200938, 0, 0>
        rotate y*180
        rotate    < 0, 0, -69.829347>
        rotate y*90
        translate <-2.7, -4.3, -17.5>
       }
  
       sphere { 0, 13.7 translate <-2.7, -14.1, -21.1> }
 
       intersection { object { Connector_2 }
       plane { x, 11.978087 }
       plane { x, 8.305973 inverse }
        translate <-11.978087, 0, 0>
        scale     < 1.801360, 1, 1>
        translate <-6.649469, 0, 0>
        rotate y*180
        rotate    < 0, 0, -56.309932>
        rotate y*90
        translate <-2.7, -14.1, -21.1>
       }
 
       sphere { 0, 9.5 translate <-2.7, -21.3, -25.9> }
 
       intersection { object { Connector_2 }
       plane { x, 8.764492 }
       plane { x, 6.089016 inverse }
        translate <-8.764492, 0, 0>
        scale     < 2.391274, 1, 1>
        translate <-3.665197, 0, 0>
        rotate y*180
        rotate    < 0, 0, -56.944177>
        rotate y*90
        translate <-2.7, -21.3, -25.9>
       }
  
       sphere { 0, 6.6 translate <-2.7, -27.6, -30> }

       sphere { 0, 27.1 translate < 2, 22.7, -14.7> }
  
       intersection { object { Connector_2 }
       plane { x, 23.577342 }
       plane { x, 16.791244 inverse }
        translate <-23.577342, 0, 0>
        scale     < 1.764626, 1, 1>
        translate <-13.361098, 0, 0>
        rotate y*180
        rotate    < 0, 0, -87.078905>
        rotate    < 0, 29.744881, 0>
        translate < 2, 22.7, -14.7>
       }
 
       sphere { 0, 19.3 translate < 2.7, 6.9, -15.1> }
 
       intersection { object { Connector_2 }
       plane { x, 19.155296 }
       plane { x, 17.765793 inverse }
        translate <-19.155296, 0, 0>
        scale     < 8.120269, 1, 1>
        translate <-2.358948, 0, 0>
        rotate y*180
        rotate    < 0, 0, -77.905243>
        rotate y*90
        translate < 2.7, 6.9, -15.1>
       }
  
       sphere { 0, 17.9 translate < 2.7, -4.3, -17.5> }
 
 
       intersection { object { Connector_2 }
       plane { x, 16.387693 }
       plane { x, 12.542536 inverse }
        translate <-16.387693, 0, 0>
        scale     < 2.275772, 1, 1>
        translate <-7.200938, 0, 0>
        rotate y*180
        rotate    < 0, 0, -69.829347>
        rotate y*90
        translate < 2.7, -4.3, -17.5>
       }
 
       sphere { 0, 13.7 translate < 2.7, -14.1, -21.1> }
 
       intersection { object { Connector_2 }
       plane { x, 11.978087 }
       plane { x, 8.305973 inverse }
        translate <-11.978087, 0, 0>
        scale     < 1.801360, 1, 1>
        translate <-6.649469, 0, 0>
        rotate y*180
        rotate    < 0, 0, -56.309932>
        rotate y*90
        translate < 2.7, -14.1, -21.1>
       }
 
       sphere { 0, 9.5 translate < 2.7, -21.3, -25.9> }
 
       intersection { object { Connector_2 }
       plane { x, 8.764492 }
       plane { x, 6.089016 inverse }
        translate <-8.764492, 0, 0>
        scale     < 2.391274, 1, 1>
        translate <-3.665197, 0, 0>
        rotate y*180
        rotate    < 0, 0, -56.944177>
        rotate y*90
        translate < 2.7, -21.3, -25.9>
       }
 
       sphere { 0, 6.6 translate < 2.7, -27.6, -30> }
    }
      //--- Cut out Mouth
      difference { MCut translate <0, -14, 0> }
  }
   texture { YourTexture }
	bounded_by { box { -1, 1 scale <32, 45, 32> translate <0, 7.9, -14> } }
}

//---- Jacks Jaw
#declare Jaw =
object {
  difference {
    union {
       sphere { 0, 12.21 translate <-7, -3.9, -24.9> } 
 
       intersection { object { Connector_2 }
       plane { x, 11.761033 }
       plane { x, 11.096404 inverse }
        translate <-11.761033, 0, 0>
        scale     < 3.585046, 1, 1>
        translate <-3.280581, 0, 0>
        rotate y*180
        rotate    < 0, 0, -73.393743>
        rotate    < 0, -47.058865, 0>
        translate <-7, -3.9, -24.9>
       } 

    sphere { 0, 11.52 translate <-6.5, -6.361, -24.36271> }
 
    intersection { object { Connector_2 }
    plane { x, 11.096405 }
    plane { x, 10.431777 inverse }
     translate <-11.096405, 0, 0>
     scale     < 3.585050, 1, 1>
     translate <-3.095189, 0, 0>
     rotate y*180
     rotate    < 0, 0, -76.850672>
     rotate    < 0, -31.147087, 0>
     translate <-6.5, -6.361000, -24.362710>
    }

    sphere { 0, 10.83 translate <-6, -8.861780, -24.060530> }

    intersection { object { Connector_2 }
    plane { x, 10.431774 }
    plane { x, 9.767146 inverse }
     translate <-10.431774, 0, 0>
     scale     < 3.585037, 1, 1>
     translate <-2.909809, 0, 0>
     rotate y*180
     rotate    < 0, 0, -78.679190>
     rotate    < 0, -7.334781, 0>
     translate <-6, -8.861780, -24.060530>
    }

    sphere { 0, 10.14 translate <-5.5, -11.379920, -23.996170> }
 
       intersection { object { Connector_2 }
       plane { x, 9.767148 }
       plane { x, 9.102519 inverse }
        translate <-9.767148, 0, 0>
        scale     < 3.585047, 1, 1>
        translate <-2.724413, 0, 0>
        rotate y*180
        rotate    < 0, 0, -78.103073>
        rotate    < 0, 19.190963, 0>
        translate <-5.5, -11.379920, -23.996170>
       }
 
       sphere { 0, 9.45 translate <-5, -13.892870, -24.170200> }
 
       intersection { object { Connector_2 }
       plane { x, 9.102521 }
       plane { x, 8.437892 inverse }
        translate <-9.102521, 0, 0>
        scale     < 3.585055, 1, 1>
        translate <-2.539018, 0, 0>
        rotate y*180
        rotate    < 0, 0, -75.404275>
        rotate    < 0, 39.411314, 0>
        translate <-5, -13.892870, -24.170200>
       }

       sphere { 0, 8.76 translate <-4.5, -16.378110, -24.581070> }
 
       intersection { object { Connector_2 }
       plane { x, 8.437891 }
       plane { x, 7.773263 inverse }
        translate <-8.437891, 0, 0>
        scale     < 3.585047, 1, 1>
        translate <-2.353635, 0, 0>
        rotate y*180
        rotate    < 0, 0, -71.489295>
        rotate    < 0, 52.175186, 0>
        translate <-4.5, -16.378110, -24.581070>
       }
 
       sphere { 0, 8.07 translate <-4, -18.813360, -25.225090> }
 
       intersection { object { Connector_2 }
       plane { x, 7.773262 }
       plane { x, 7.108633 inverse }
        translate <-7.773262, 0, 0>
        scale     < 3.585042, 1, 1>
        translate <-2.168249, 0, 0>
        rotate y*180
        rotate    < 0, 0, -66.970481>
        rotate    < 0, 60.153257, 0>
        translate <-4, -18.813360, -25.225090>
       }
 
       sphere { 0, 7.38 translate <-3.5, -21.176800, -26.096490> }
 
       intersection { object { Connector_2 }
       plane { x, 7.108634 }
       plane { x, 6.444006 inverse }
        translate <-7.108634, 0, 0>
        scale     < 3.585047, 1, 1>
        translate <-1.982857, 0, 0>
        rotate y*180
        rotate    < 0, 0, -62.140556>
        rotate    < 0, 65.377647, 0>
        translate <-3.5, -21.176800, -26.096490>
       }
  
       sphere { 0, 6.69 translate <-3, -23.447260, -27.187460> }
 
       intersection { object { Connector_2 }
       plane { x, 6.444007 }
       plane { x, 5.779379 inverse }
        translate <-6.444007, 0, 0>
        scale     < 3.585057, 1, 1>
        translate <-1.797463, 0, 0>
        rotate y*180
        rotate    < 0, 0, -57.136399>
        rotate    < 0, 68.974001, 0>
        translate <-3, -23.447260, -27.187460>
       }
 
       sphere { 0, 6 translate <-2.5, -25.604390, -28.488240> }
 
       intersection { object { Connector_2 }
       plane { x, 5.779376 }
       plane { x, 5.114748 inverse }
        translate <-5.779376, 0, 0>
        scale     < 3.585037, 1, 1>
        translate <-1.612083, 0, 0>
        rotate y*180
        rotate    < 0, 0, -52.027720>
        rotate    < 0, 71.552553, 0>
        translate <-2.5, -25.604390, -28.488240>
       }

       sphere { 0, 5.31 translate <-2, -27.628850, -29.987150> }

       sphere { 0, 12.21 translate < 7, -3.9, -24.9> }
  
       intersection { object { Connector_2 }
       plane { x, 11.761033 }
       plane { x, 11.096404 inverse }
        translate <-11.761033, 0, 0>
        scale     < 3.585046, 1, 1>
        translate <-3.280581, 0, 0>
        rotate y*180
        rotate    < 0, 0, -73.393743>
        rotate    < 0, -132.941135, 0>
        translate < 7, -3.9, -24.9>
       }

       sphere { 0, 11.52 translate < 6.5, -6.361000, -24.362710> }

       intersection { object { Connector_2 }
       plane { x, 11.096405 }
       plane { x, 10.431777 inverse }
        translate <-11.096405, 0, 0>
        scale     < 3.585050, 1, 1>
        translate <-3.095189, 0, 0>
        rotate y*180
        rotate    < 0, 0, -76.850672>
        rotate    < 0, -148.852913, 0>
        translate < 6.5, -6.361000, -24.362710>
       }
  
       sphere { 0, 10.83 translate < 6, -8.861780, -24.060530> }
  
       intersection { object { Connector_2 }
       plane { x, 10.431774 }
       plane { x, 9.767146 inverse }
        translate <-10.431774, 0, 0>
        scale     < 3.585037, 1, 1>
        translate <-2.909809, 0, 0>
        rotate y*180
        rotate    < 0, 0, -78.679190>
        rotate    < 0, -172.665219, 0>
        translate < 6, -8.861780, -24.060530>
       }

       sphere { 0, 10.14 translate < 5.5, -11.379920, -23.996170> }
  
       intersection { object { Connector_2 }
       plane { x, 9.767148 }
       plane { x, 9.102519 inverse }
        translate <-9.767148, 0, 0>
        scale     < 3.585047, 1, 1>
        translate <-2.724413, 0, 0>
        rotate y*180
        rotate    < 0, 0, -78.103073>
        rotate    < 0, 160.809037, 0>
        translate < 5.5, -11.379920, -23.996170>
       }

       sphere { 0, 9.45 translate < 5 ,-13.892870, -24.170200> }
 
       intersection { object { Connector_2 }
       plane { x, 9.102521 }
       plane { x, 8.437892 inverse }
        translate <-9.102521, 0, 0>
        scale     < 3.585055, 1, 1>
        translate <-2.539018, 0, 0>
        rotate y*180
        rotate    < 0, 0, -75.404275>
        rotate    < 0, 140.588686, 0>
        translate < 5, -13.892870, -24.170200>
       }
 
       sphere { 0, 8.76 translate < 4.5, -16.378110, -24.581070> }
  
       intersection { object { Connector_2 }
       plane { x, 8.437891 }
       plane { x, 7.773263 inverse }
        translate <-8.437891, 0, 0>
        scale     < 3.585047, 1, 1>
        translate <-2.353635, 0, 0>
        rotate y*180
        rotate    < 0, 0, -71.489295>
        rotate    < 0, 127.824814, 0>
        translate < 4.5, -16.378110, -24.581070>
       }

       sphere { 0, 8.07 translate < 4, -18.813360, -25.225090> }
 
       intersection { object { Connector_2 }
       plane { x, 7.773262 }
       plane { x, 7.108633 inverse }
        translate <-7.773262, 0, 0>
        scale     < 3.585042, 1, 1>
        translate <-2.168249, 0, 0>
        rotate y*180
        rotate    < 0, 0, -66.970481>
        rotate    < 0, 119.846743, 0>
        translate < 4, -18.813360, -25.225090>
       }

       sphere { 0, 7.38 translate < 3.5, -21.176800, -26.096490> }
 
       intersection { object { Connector_2 }
       plane { x, 7.108634 }
       plane { x, 6.444006 inverse }
        translate <-7.108634, 0, 0>
        scale     < 3.585047, 1, 1>
        translate <-1.982857, 0, 0>
        rotate y*180
        rotate    < 0, 0, -62.140556>
        rotate    < 0, 114.622353, 0>
        translate < 3.5, -21.176800, -26.096490>
       }
 
       sphere { 0, 6.69 translate < 3, -23.447260, -27.187460> }
 
       intersection { object { Connector_2 }
       plane { x, 6.444007 }
       plane { x, 5.779379 inverse }
        translate <-6.444007, 0, 0>
        scale     < 3.585057, 1, 1>
        translate <-1.797463, 0, 0>
        rotate y*180
        rotate    < 0, 0, -57.136399>
        rotate    < 0, 111.025999, 0>
        translate < 3, -23.447260, -27.187460>
       }
  
       sphere { 0, 6 translate < 2.5, -25.604390, -28.488240> }
 
       intersection { object { Connector_2 }
       plane { x, 5.779376 }
       plane { x, 5.114748 inverse }
        translate <-5.779376, 0, 0>
        scale     < 3.585037, 1, 1>
        translate <-1.612083, 0, 0>
        rotate y*180
        rotate    < 0, 0, -52.027720>
        rotate    < 0, 108.447447, 0>
        translate < 2.5, -25.604390, -28.488240>
       }
 
       sphere { 0, 5.31 translate < 2, -27.628850, -29.987150> }

       sphere { 0, 1 scale <13, 11, 11> translate <0, -15.1, -27.5> }
    }
  //--- Cut out Mouth
  difference { MCut translate <0, -14, 0> }
  }
    texture { YourTexture}
	bounded_by { box { -1, 1 scale <24, 24, 15> translate <0, -13.3, -25.8> } }
}

#declare Neck =
object {
  union {
   sphere { 0, 1 scale <17, 38, 16> translate <0, -17.4, -6.4> }
   sphere { 0, 1 scale <11.5, 38, 12> translate <0, -24, -11.3> }
  }
  texture { YourTexture }
} 

//---- Jack's Eye Brows
#declare Brow1 =
object {
   union {
       sphere { 0, 3 translate <-2.6, 11.4, -41.800000> }
 
       intersection { object { Connector_2 }
       plane { x, 2.990451 }
       plane { x, 2.840928 inverse }
        translate <-2.990451, 0, 0>
        scale     < 12.53333, 1, 1>
        translate <-0.239172, 0, 0>
        rotate y*180
        rotate    < 0, 0, 25.163020>
        rotate    < 0, -176.633539, 0>
        translate <-2.6, 11.4, -41.800000>
       }
 
       sphere { 0, 2.850000 translate <-4.3, 12.2, -41.7> }
  
       intersection { object { Connector_2 }
       plane { x, 2.848917 }
       plane { x, 2.798936 inverse }
        translate <-2.848917, 0, 0>
        scale     < 36.262929, 1, 1>
        translate <-0.078563, 0, 0>
        rotate y*180
        rotate    < 0, 0, 19.316775>
        rotate    < 0, -173.290163, 0>
        translate <-4.3, 12.2, -41.7>
       }
  
       sphere { 0, 2.800000 translate <-6, 12.800000, -41.5> }
 
       intersection { object { Connector_2 }
       plane { x, 2.795903 }
       plane { x, 2.696050 inverse }
        translate <-2.795903, 0, 0>
        scale     < 18.466185, 1, 1>
        translate <-0.151407, 0, 0>
        rotate y*180
        rotate    < 0, 0, 9.335859>
        rotate    < 0, -170.537678, 0>
        translate <-6, 12.800000, -41.5>
       }
  
       sphere { 0, 2.7 translate <-7.800000, 13.1, -41.2> }
  
       intersection { object { Connector_2 }
       plane { x, 2.697647 }
       plane { x, 2.597734 inverse }
        translate <-2.697647, 0, 0>
        scale     < 23.937418, 1, 1>
        translate <-0.112696, 0, 0>
        rotate y*180
        rotate    < 0, 0, 7.193321>
        rotate    < 0, -165.379126, 0>
        translate <-7.800000, 13.1, -41.2>
       }
 
       sphere { 0, 2.6 translate <-10.1, 13.4, -40.6> }

       intersection { object { Connector_2 }
       plane { x, 2.595604 }
       plane { x, 2.495773 inverse }
        translate <-2.595604, 0, 0>
        scale     < 17.175564, 1, 1>
        translate <-0.151122, 0, 0>
        rotate y*180
        rotate    < 0, 0, 6.675592>
        rotate    < 0, -159.443955, 0>
        translate <-10.1, 13.4, -40.6>
       }
 
       sphere { 0, 2.5 translate <-11.7, 13.6, -40> }
  
       intersection { object { Connector_2 }
       plane { x, 2.495026 }
       plane { x, 2.345324 inverse }
        translate <-2.495026, 0, 0>
        scale     < 15.828947, 1, 1>
        translate <-0.157624, 0, 0>
        rotate y*180
        rotate    < 0, 0, 2.409031>
        rotate    < 0, -157.750976, 0>
        translate <-11.7, 13.6, -40>
       }
 
       sphere { 0, 2.350000 translate <-13.9, 13.7, -39.1> }
  
       intersection { object { Connector_2 }
       plane { x, 2.343912 }
       plane { x, 2.144430 inverse }
        translate <-2.343912, 0, 0>
        scale     < 13.865425, 1, 1>
        translate <-0.169047, 0, 0>
        rotate y*180
        rotate    < 0, 0, -2.061231>
        rotate    < 0, -149.743563, 0>
        translate <-13.9, 13.7, -39.1>
       }
  
       sphere { 0, 2.150000 translate <-16.3, 13.6, -37.7> }
 
       intersection { object { Connector_2 }
       plane { x, 2.140516 }
       plane { x, 1.891619 inverse }
        translate <-2.140516, 0, 0>
        scale     < 10.611315, 1, 1>
        translate <-0.201720, 0, 0>
        rotate y*180
        rotate    < 0, 0, 2.150777>
        rotate    < 0, -145.713123, 0>
        translate <-16.3, 13.6, -37.7>
       }
  
       sphere { 0, 1.9 translate <-18.5, 13.7, -36.2> }
 
       intersection { object { Connector_2 }
       plane { x, 1.893849 }
       plane { x, 1.654626 inverse }
        translate <-1.893849, 0, 0>
        scale     < 12.397076, 1, 1>
        translate <-0.152766, 0, 0>
        rotate y*180
        rotate    < 0, 0, 1.919840>
        rotate    < 0, -140.440332, 0>
        translate <-18.5, 13.7, -36.2>
       }
 
       sphere { 0, 1.660000 translate <-20.800000, 13.800000, -34.3> }
 
       intersection { object { Connector_2 }
       plane { x, 1.657220 }
       plane { x, 1.497488 inverse }
        translate <-1.657220, 0, 0>
        scale     < 17.257698, 1, 1>
        translate <-0.096028, 0, 0>
        rotate y*180
        rotate    < 0, 0, 4.146686>
        rotate    < 0, -133.531199, 0>
        translate <-20.800000, 13.800000, -34.3>
       }
 
       sphere { 0, 1.5 translate <-22.7, 14, -32.3> }
 
       intersection { object { Connector_2 }
       plane { x, 1.496982 }
       plane { x, 1.297384 inverse }
        translate <-1.496982, 0, 0>
        scale     < 15.740076, 1, 1>
        translate <-0.095106, 0, 0>
        rotate y*180
        rotate    < 0, 0, 5.457443>
        rotate    < 0, -127.234834, 0>
        translate <-22.7, 14, -32.3>
       }
 
       sphere { 0, 1.3 translate <-24.6, 14.3, -29.800000> }
 
       intersection { object { Connector_2 }
       plane { x, 1.298656 }
       plane { x, 1.148811 inverse }
        translate <-1.298656, 0, 0>
        scale     < 21.977261, 1, 1>
        translate <-0.059091, 0, 0>
        rotate y*180
        rotate    < 0, 0, 12.246690>
        rotate    < 0, -119.744881, 0>
        translate <-24.6, 14.3, -29.800000>
       }
 
       sphere { 0, 1.150000 translate <-26.2, 15, -27> }
 
       intersection { object { Connector_2 }
       plane { x, 1.144309 }
       plane { x, 0.895546 inverse }
        translate <-1.144309, 0, 0>
        scale     < 10.013990, 1, 1>
        translate <-0.114271, 0, 0>
        rotate y*180
        rotate    < 0, 0, 16.154297>
        rotate    < 0, -114.443955, 0>
        translate <-26.2, 15, -27>
       }
  
       sphere { 0, 0.9 translate <-27.2, 15.7, -24.800000> }

       intersection { object { Connector_2 }
       plane { x, 0.887271 }
       plane { x, 0.443636 inverse }
        translate <-0.887271, 0, 0>
        scale     < 5.882596, 1, 1>
        translate <-0.150830, 0, 0>
        rotate y*180
        rotate    < 0, 0, 17.333651>
        rotate    < 0, -110.556045, 0>
        translate <-27.2, 15.7, -24.800000>
       }
 
       sphere { 0, 0.450000 translate <-28.1, 16.5, -22.4> }
     }
        //texture { YourTexture }
texture {
  pigment { color Salmon }
  //pigment { color White }
  finish {
   ambient 0.1
   phong 1
   phong_size 100
  }
}
	bounded_by { box { -1, 1 scale <16, 7.5, 13> translate <-14, 12.1, -33.2> } } 
 }

//*********************************************************************

#declare Brow2 =
object {
   union {
       sphere { 0, 3 translate < 2.6, 11.4, -41.800000> }
 
       intersection { object { Connector_2 }
       plane { x, 2.990451 }
       plane { x, 2.840928 inverse }
        translate <-2.990451, 0, 0>
        scale     < 12.53333, 1, 1>
        translate <-0.239172, 0, 0>
        rotate y*180
        rotate    < 0, 0, 25.163020>
        rotate    < 0, -3.366461, 0>
        translate < 2.6, 11.4, -41.800000>
       }
 
       sphere { 0, 2.850000 translate < 4.3, 12.2, -41.7> }
 
       intersection { object { Connector_2 }
       plane { x, 2.848917 }
       plane { x, 2.798936 inverse }
        translate <-2.848917, 0, 0>
        scale     < 36.262929, 1, 1>
        translate <-0.078563, 0, 0>
        rotate y*180
        rotate    < 0, 0, 19.316775>
        rotate    < 0, -6.709837, 0>
        translate < 4.3, 12.2, -41.7>
       }
  
       sphere { 0, 2.800000 translate < 6, 12.800000, -41.5> }
 
       intersection { object { Connector_2 }
       plane { x, 2.795903 }
       plane { x, 2.696050 inverse }
        translate <-2.795903, 0, 0>
        scale     < 18.466185, 1, 1>
        translate <-0.151407, 0, 0>
        rotate y*180
        rotate    < 0, 0, 9.335859>
        rotate    < 0, -9.462322, 0>
        translate < 6, 12.800000, -41.5>
       }
  
       sphere { 0, 2.7 translate < 7.800000, 13.1, -41.2> }
  
       intersection { object { Connector_2 }
       plane { x, 2.697647 }
       plane { x, 2.597734 inverse }
        translate <-2.697647, 0, 0>
        scale     < 23.937418, 1, 1>
        translate <-0.112696, 0, 0>
        rotate y*180
        rotate    < 0, 0, 7.193321>
        rotate    < 0, -14.620874, 0>
        translate < 7.800000, 13.1, -41.2>
       }
 
       sphere { 0, 2.6 translate < 10.1, 13.4, -40.6> }
 
       intersection { object { Connector_2 }
       plane { x, 2.595604 }
       plane { x, 2.495773 inverse }
        translate <-2.595604, 0, 0>
        scale     < 17.175564, 1, 1>
        translate <-0.151122, 0, 0>
        rotate y*180
        rotate    < 0, 0, 6.675592>
        rotate    < 0, -20.556045, 0>
        translate < 10.1, 13.4, -40.6>
       }
 
       sphere { 0, 2.5 translate < 11.7, 13.6, -40> }
  
       intersection { object { Connector_2 }
       plane { x, 2.495026 }
       plane { x, 2.345324 inverse }
        translate <-2.495026, 0, 0>
        scale     < 15.828947, 1, 1>
        translate <-0.157624, 0, 0>
        rotate y*180
        rotate    < 0, 0, 2.409031>
        rotate    < 0, -22.249024, 0>
        translate < 11.7, 13.6, -40>
       }
 
       sphere { 0, 2.350000 translate < 13.9, 13.7, -39.1> }
 
       intersection { object { Connector_2 }
       plane { x, 2.343912 }
       plane { x, 2.144430 inverse }
        translate <-2.343912, 0, 0>
        scale     < 13.865425, 1, 1>
        translate <-0.169047, 0, 0>
        rotate y*180
        rotate    < 0, 0, -2.061231>
        rotate    < 0, -30.256437, 0>
        translate < 13.9, 13.7, -39.1>
       }
 
       sphere { 0, 2.150000 translate < 16.3, 13.6, -37.7> }
 
       intersection { object { Connector_2 }
       plane { x, 2.140516 }
       plane { x, 1.891619 inverse }
        translate <-2.140516, 0, 0>
        scale     < 10.611315, 1, 1>
        translate <-0.201720, 0, 0>
        rotate y*180
        rotate    < 0, 0, 2.150777>
        rotate    < 0, -34.286877, 0>
        translate < 16.3, 13.6, -37.7>
       }
  
       sphere { 0, 1.9 translate < 18.5, 13.7, -36.2> }
 
       intersection { object { Connector_2 }
       plane { x, 1.893849 }
       plane { x, 1.654626 inverse }
        translate <-1.893849, 0, 0>
        scale     < 12.397076, 1, 1>
        translate <-0.152766, 0, 0>
        rotate y*180
        rotate    < 0, 0, 1.919840>
        rotate    < 0, -39.559668, 0>
        translate < 18.5, 13.7, -36.2>
       }
  
       sphere { 0, 1.660000 translate < 20.800000, 13.800000, -34.3> }
 
       intersection { object { Connector_2 }
       plane { x, 1.657220 }
       plane { x, 1.497488 inverse }
        translate <-1.657220, 0, 0>
        scale     < 17.257698, 1, 1>
        translate <-0.096028, 0, 0>
        rotate y*180
        rotate    < 0, 0, 4.146686>
        rotate    < 0, -46.468801, 0>
        translate < 20.800000, 13.800000, -34.3>
       }
  
       sphere { 0, 1.5 translate < 22.7, 14, -32.3> }
 
       intersection { object { Connector_2 }
       plane { x, 1.496982 }
       plane { x, 1.297384 inverse }
        translate <-1.496982, 0, 0>
        scale     < 15.740076, 1, 1>
        translate <-0.095106, 0, 0>
        rotate y*180
        rotate    < 0, 0, 5.457443>
        rotate    < 0, -52.765166, 0>
        translate < 22.7, 14, -32.3>
       }
  
       sphere { 0, 1.3 translate < 24.6, 14.3, -29.800000> }
 
       intersection { object { Connector_2 }
       plane { x, 1.298656 }
       plane { x, 1.148811 inverse }
        translate <-1.298656, 0, 0>
        scale     < 21.977261, 1, 1>
        translate <-0.059091, 0, 0>
        rotate y*180
        rotate    < 0, 0, 12.246690>
        rotate    < 0, -60.255119, 0>
        translate < 24.6, 14.3, -29.800000>
       }
  
       sphere { 0, 1.150000 translate < 26.2, 15, -27> }
  
       intersection { object { Connector_2 }
       plane { x, 1.144309 }
       plane { x, 0.895546 inverse }
        translate <-1.144309, 0, 0>
        scale     < 10.013990, 1, 1>
        translate <-0.114271, 0, 0>
        rotate y*180
        rotate    < 0, 0, 16.154297>
        rotate    < 0, -65.556045, 0>
        translate < 26.2, 15, -27>
       }
 
       sphere { 0, 0.9 translate < 27.2, 15.7, -24.800000> }
 
       intersection { object { Connector_2 }
       plane { x, 0.887271 }
       plane { x, 0.443636 inverse }
        translate <-0.887271, 0, 0>
        scale     < 5.882596, 1, 1>
        translate <-0.150830, 0, 0>
        rotate y*180
        rotate    < 0, 0, 17.333651>
        rotate    < 0, -69.443955, 0>
        translate < 27.2, 15.7, -24.800000>
       }
 
       sphere { 0, 0.450000 translate < 28.1, 16.5, -22.4> }
    }
	//texture { YourTexture }
texture {
  pigment { color Salmon }
  //pigment { color White }
  finish {
   ambient 0.1
   phong 1
   phong_size 100
  }
}
	bounded_by { box { -1, 1 scale <16, 7.5, 13> translate <14, 12.1, -33.2> } } 

}

//---- Jack Eyes
#declare EyeTexture =
texture {
  pigment {
   // image_map { <1 -1 0> gif "eyeball.gif" interpolate 4 }
   // image_map { gif "FishEyeCJF.gif" interpolate 4 } // taken from Fish.POV
   // image_map { gif "Iris_Blue.gif" interpolate 4 }  // taken from Meat.POV
   image_map { gif "eyeball.gif" interpolate 4 }
   scale <12, 12, 1>
   translate <-6, -6, 0>
  }
  finish {
   ambient 0.2
   diffuse 0.7
   phong 1
   phong_size 100
  }
}

//--- Movable Lid & Eye Socket Mass
#declare LSocket =
object { 
  union {  
    difference { sphere { 0, 1 scale <9, 7, 7>  } plane { y, 0 rotate z*-15 translate y } }
    difference { sphere { 0, 1 scale <9, 7, 7>  } plane { y, 0 rotate z*-15 translate y*2 } }
    difference {
    union {
      sphere { 0, 1 scale <9, 7, 6> }
      sphere { 0, 1 scale <12, 8, 8> translate z*4 }
    }
    object { Cylinder_Z scale <6, 3, 1> translate y*-0.4 }
    }
  }
  texture { YourTexture }
  bounded_by { sphere { 0, 1 scale <12, 9, 8> translate z }	 }
}

#declare RSocket =
object { 
  union {  
    difference { sphere { 0, 1 scale <9, 7, 7>  } plane { y, 0 rotate z*15 translate y } }
    difference { sphere { 0, 1 scale <9, 7, 7>  } plane { y, 0 rotate z*15 translate y*2 } }
    difference {
    union {
      sphere { 0, 1 scale <9, 7, 6> }
      sphere { 0, 1 scale <12, 8, 8> translate z*4 }
    }
    object { Cylinder_Z scale <6, 3, 1> translate y*-0.4 }
    }
  }
  texture { YourTexture }
  bounded_by { sphere { 0, 1 scale <12, 9, 8> translate z }	 }
}

//--- EyeBall
#declare Eye = sphere { 0, 1 scale <8.5, 6.5, 5.2>  texture { EyeTexture } }

//--- Jack's Ear
#declare Ear =
object {
  union {
    quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -142.25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 130, 0, 0, 0, 0, 1, 0, -142.25, 0, 4225> sturm }
    quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -142.25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 130, 0, 0, 0, 0, 1, 0, -142.25, 0, 4225> scale <0.7, 1, 0.7> translate x*2 sturm }
    sphere { 0, 1 scale <3, 1, 3> translate x*3 }
    sphere { 0, 1 scale <9, 0.11, 9> translate -y }
  }
  rotate x*90 
  scale <1, 1.2, 1>
  rotate y*90 
  texture { YourTexture }
  bounded_by { box { -1, 1 scale <10, 13, 4> } }
}

//--- Jacks Nose
#declare Nose =
object {
  union {
       sphere { 0, 1.8 }
      
       object { Connector_4
        scale     <1.216553, 1.8, 1.8>
        rotate z*-80.537678
        rotate y*-90
       }
  
       sphere { 0, 1.8 translate <0 -1.2  0.2> }
      
       intersection { object { Connector_2 }
       plane { x, 1.997317 }
       plane { x, 1.797586 inverse }
        translate <-1.797586, 0, 0>
        scale     <19.287302, 1, 1>
        translate <0.093200, 0, 0>
        rotate z*-68.749494
        rotate y*90
        translate <0, -1.2, 0.2>
       }
  
       sphere { 0, 2 translate <0, -4.8, -1.2> }
  
       intersection { object { Connector_2 }
       plane { x, 2.880312 }
       plane { x, 1.986422 inverse }
        translate <-1.986422, 0, 0>
        scale     <8.538222, 1, 1>
        translate <0.232651, 0, 0>
        rotate z*-75.784147
        rotate y*90
        translate <0, -4.8, -1.2>
       }
  
       sphere { 0, 2.9 translate <0, -12.3, -3.1> }
  
       intersection { object { Connector_2 }
       plane { x, 3.381544 }
       plane { x, 2.801851 inverse }
        translate <-2.801851, 0, 0>
        scale     <3.745368, 1, 1>
        translate <0.748084, 0, 0>
        rotate z*-64.536655
        rotate y*90
        translate <0, -12.3, -3.1>
       }
  
       sphere { 0, 3.5 translate <0, -14.4, -4.1> }
     }
	texture { YourTexture }
	bounded_by { sphere { 0, 12.652989 translate <0, -8.05, -2.8> } }
}

//--- Bottom part of nose
#declare N2 =
object {
  union {
 
       sphere { 0, 2.85 translate <-4.1, -14.1, -1.8> }
  
       intersection { object { Connector_2 }
       plane { x, 2.899833 }
       plane { x, 2.849836 inverse }
        translate <-2.849836, 0, 0>
        scale     <93.246984, 1, 1>
        translate <0.030562, 0, 0>
        rotate z*22.708896
        rotate    <0, 17.592425, 0>
        translate <-4.1, -14.1, -1.8>
       }
      
       sphere { 0, 2.9 translate <0, -12.3, -3.1> }
  
       intersection { object { Connector_2  }
       plane { x, 2.899833 }
       plane { x, 2.849836 inverse }
        translate <-2.899833, 0, 0>
        scale     <93.246984, 1, 1>
        translate <-0.031098, 0, 0>
        rotate y*180
        rotate z*-22.708896
        rotate    <0, -17.592425, 0>
        translate <0, -12.3, -3.1>
       }
   
       sphere { 0, 2.85 translate <4.1, -14.1, -1.8> }
     }
	texture { YourTexture }
	bounded_by { sphere { 0, 9.52493 translate <0, -13.175, -2.475> } }
}

//---- Jack's Lips
#declare Lip =
object {
  union {
       sphere { 0, 1.4 translate <0.6, -6.7, 0> }
 
       intersection { object { Connector_2 }
       plane { x, 1.396755 }
       plane { x, 1.296987 inverse }
        translate <-1.396755, 0, 0>
        scale     <14.662878, 1, 1>
        translate <-0.095258, 0, 0>
        rotate y*180
        rotate z*15.793169
        rotate    <0, -8.130102, 0>
        translate <0.6, -6.7, 0>
      }
 
       sphere { 0, 1.3 translate <2, -6.3, 0.2> }
 
       intersection { object { Connector_2 }
       plane { x, 1.299565 }
       plane { x, 1.249582 inverse }
        translate <-1.299565, 0, 0>
        scale     <38.665230, 1, 1>
        translate <-0.033611, 0, 0>
        rotate y*180
        rotate z*5.936002
        rotate    <0, -8.972627, 0>
        translate <2, -6.3, 0.2>
       }
  
       sphere { 0, 1.25 translate <3.9, -6.1, 0.5> }
  
       intersection { object { Connector_2 }
       plane { x, 1.249173 }
       plane { x, 1.199206 inverse }
        translate <-1.249173, 0, 0>
        scale     <27.477263, 1, 1>
        translate <-0.045462, 0, 0>
        rotate y*180
        rotate z*8.364994
        rotate    <0, -17.102729, 0>
        translate <3.9, -6.1, 0.5>
       }
 
       sphere { 0, 1.2 translate <5.2, -5.9, 0.9> }
 
       intersection { object { Connector_2 }
       plane { x, 1.199409 }
       plane { x, 1.149434 inverse }
        translate <-1.199409, 0, 0>
        scale     <31.859065, 1, 1>
        translate <-0.037647, 0, 0>
        rotate y*180
        rotate z*10.8499
        rotate    <0, -26.565051, 0>
        translate <5.2, -5.9, 0.9>
       }
  
       sphere { 0, 1.15 translate <6.6, -5.6, 1.6> }
 
       intersection { object { Connector_2 }
       plane { x, 1.148370 }
       plane { x, 1.048512 inverse }
        translate <-1.148370, 0, 0>
        scale     <18.761663, 1, 1>
        translate <-0.061208, 0, 0>
        rotate y*180
        rotate z*25.201124
        rotate    <0, -28.072487, 0>
        translate <6.6, -5.6, 1.6>
       }
 
       sphere { 0, 1.05 translate <8.1, -4.8, 2.4> }
 
       intersection { object { Connector_2 }
       plane { x, 1.046316 }
       plane { x, 0.847018 inverse }
        translate <-1.046316, 0, 0>
        scale     <11.905881, 1, 1>
        translate <-0.087882, 0, 0>
        rotate y*180
        rotate z*38.882878
        rotate    <0, -36.253838, 0>
        translate <8.1, -4.8, 2.4>
       }
 
       sphere { 0, 0.85 translate <9.6, -3.3, 3.5> }
 
       intersection { object { Connector_2 }
       plane { x, 0.848163 }
       plane { x, 0.698487 inverse }
        translate <-0.848163, 0, 0>
        scale     <15.184056, 1, 1>
        translate <-0.055859, 0, 0>
        rotate y*180
        rotate z*44.55098
        rotate    <0, -47.489553, 0>
        translate <9.6, -3.3, 3.5>
       }
  
       sphere { 0, 0.7 translate <10.7, -1.7, 4.7> }
  
       intersection { object { Connector_2 }
       plane { x, 0.698817 }
       plane { x, 0.598986 inverse }
        translate <-0.698817, 0, 0>
        scale     <17.175564, 1, 1>
        translate <-0.040687, 0, 0>
        rotate y*180
        rotate z*54.462322
        rotate    <0, -53.130102, 0>
        translate <10.7, -1.7, 4.7>
       }
 
       sphere { 0, 0.6 translate <11.3, -0.3, 5.5> }
 
       intersection { object { Connector_2 }
       plane { x, 0.598376 }
       plane { x, 0.498647 inverse }
        translate <-0.598376, 0, 0>
        scale     <13.564660, 1, 1>
        translate <-0.044113, 0, 0>
        rotate y*180
        rotate z*61.915901
        rotate    <0, -51.340192, 0>
        translate <11.3, -0.3, 5.5>
       }
  
       sphere { 0, 0.5 translate <11.7, 0.9, 6> }
     }
    texture { YourTexture }
	bounded_by { box { -1, 1 scale <7, 6.5, 5> translate <5.6, -2.5, 3.2> } }
}

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++

#declare Lip2 =
object {
   union {
       sphere { 0, 1.4 translate <-0.6, -6.7, 0> }
 
       intersection { object { Connector_2 }
       plane { x, 1.396755 }
       plane { x, 1.296987 inverse }
        translate <-1.396755, 0, 0>
        scale     <14.662878, 1, 1>
        translate <-0.095258, 0, 0>
        rotate y*180
        rotate z*15.793169
        rotate    <0, -171.869898, 0>
        translate <-0.6, -6.7, 0>
       }
 
       sphere { 0, 1.3 translate <-2, -6.3, 0.2> }
 
       intersection { object { Connector_2 }
       plane { x, 1.299565 }
       plane { x, 1.249582 inverse }
        translate <-1.299565, 0, 0>
        scale     <38.665230, 1, 1>
        translate <-0.033611, 0, 0>
        rotate y*180
        rotate z*5.936002
        rotate    <0, -171.027373, 0>
        translate <-2, -6.3, 0.2>
       }
  
       sphere { 0, 1.25 translate <-3.9, -6.1, 0.5> }
  
       intersection { object { Connector_2 }
       plane { x, 1.249173 }
       plane { x, 1.199206 inverse }
        translate <-1.249173, 0, 0>
        scale     <27.477263, 1, 1>
        translate <-0.045462, 0, 0>
        rotate y*180
        rotate z*8.364994
        rotate    <0, -162.897271, 0>
        translate <-3.9, -6.1, 0.5>
       }
 
       sphere { 0, 1.2 translate <-5.2, -5.9, 0.9> }
 
       intersection { object { Connector_2 }
       plane { x, 1.199409 }
       plane { x, 1.149434 inverse }
        translate <-1.199409, 0, 0>
        scale     <31.859065, 1, 1>
        translate <-0.037647, 0, 0>
        rotate y*180
        rotate z*10.8499
        rotate    <0, -153.434949, 0>
        translate <-5.2, -5.9, 0.9>
       }
  
       sphere { 0, 1.15 translate <-6.6, -5.6, 1.6> }
  
       intersection { object { Connector_2 }
       plane { x, 1.148370 }
       plane { x, 1.048512 inverse }
        translate <-1.148370, 0, 0>
        scale     <18.761663, 1, 1>
        translate <-0.061208, 0, 0>
        rotate y*180
        rotate z*25.201124
        rotate    <0, -151.927513, 0>
        translate <-6.6, -5.6, 1.6>
       }
 
       sphere { 0, 1.05 translate <-8.1, -4.8, 2.4> }
 
       intersection { object { Connector_2 }
       plane { x, 1.046316 }
       plane { x, 0.847018 inverse }
        translate <-1.046316, 0, 0>
        scale     <11.905881, 1, 1>
        translate <-0.087882, 0, 0>
        rotate y*180
        rotate z*38.882878
        rotate    <0, -143.746162, 0>
        translate <-8.1, -4.8, 2.4>
       }
  
       sphere { 0, 0.85 translate <-9.6, -3.3, 3.5> }
  
       intersection { object { Connector_2 }
       plane { x, 0.848163 }
       plane { x, 0.698487 inverse }
        translate <-0.848163, 0, 0>
        scale     <15.184056, 1, 1>
        translate <-0.055859, 0, 0>
        rotate y*180
        rotate z*44.55098
        rotate    <0, -132.510447, 0>
        translate <-9.6, -3.3, 3.5>
       }
  
       sphere { 0, 0.7 translate <-10.7, -1.7, 4.7> }
  
       intersection { object { Connector_2 }
       plane { x, 0.698817 }
       plane { x, 0.598986 inverse }
        translate <-0.698817, 0, 0>
        scale     <17.175564, 1, 1>
        translate <-0.040687, 0, 0>
        rotate y*180
        rotate z*54.462322
        rotate    <0, -126.869898, 0>
        translate <-10.7, -1.7, 4.7>
       }
 
       sphere { 0, 0.6 translate <-11.3, -0.3, 5.5> }
 
       intersection { object { Connector_2 }
       plane { x, 0.598376 }
       plane { x, 0.498647 inverse }
        translate <-0.598376, 0, 0>
        scale     <13.564660, 1, 1>
        translate <-0.044113, 0, 0>
        rotate y*180
        rotate z*61.915901
        rotate    <0, -128.659808, 0>
        translate <-11.3, -0.3, 5.5>
       }

       sphere { 0, 0.5 translate <-11.7, 0.9, 6> }
      }
    texture { YourTexture }
	bounded_by { box { -1, 1 scale <7, 6.5, 5> translate <-5.6, -2.5, 3.2> } }
}

//------- Torus's used for Hair
#declare TA = quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -313, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 312, 0, 0, 0, 0, 1, 0, -313, 0, 24336> } //----- 13/12
#declare TB = quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -265, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 264, 0, 0, 0, 0, 1, 0, -265, 0, 17424> } //----- 12/11
#declare TC = quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -221, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 220, 0, 0, 0, 0, 1, 0, -221, 0, 12100> } //----- 11/10
#declare TD = quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -181, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 180, 0, 0, 0, 0, 1, 0, -181, 0, 8100> }  //----- 10/9
#declare TE = quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -145, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 144, 0, 0, 0, 0, 1, 0, -145, 0, 5184> }  //----- 9/8
#declare TF = quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0,  -85, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0,  84, 0, 0, 0, 0, 1, 0,  -85, 0, 1764> }  //----- 7/6
#declare TG = quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0,  -61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0,  60, 0, 0, 0, 0, 1, 0,  -61, 0,  900> }  //----- 6/5
#declare TH = quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0,  -41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0,  40, 0, 0, 0, 0, 1, 0,  -41, 0,  400> }  //----- 5/4
#declare TI = quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0,  -25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0,  24, 0, 0, 0, 0, 1, 0,  -25, 0,  144> }  //----- 4/3
#declare TJ = quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0,  -13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0,  12, 0, 0, 0, 0, 1, 0,  -13, 0,   36> }  //----- 3/2
#declare TK = quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0,   -5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0,   4, 0, 0, 0, 0, 1, 0,   -5, 0,    4> }  //----- 2/1

#declare HairTexture =
texture {
  pigment { color Salmon }
  //pigment { color White }
  finish {
   ambient 0.1
   phong 1
   phong_size 100
  }
}

#declare Stran =
object {
  union {
    difference { object { TA rotate x*90 }                plane { y, 0 } }
    difference { object { TJ rotate x*90 translate x*15 } plane { y, 0 inverse} }
    difference { object { TG rotate x*90 translate x*23 } plane { y, 0 } }
  }
  texture { HairTexture }
  bounded_by {  box { -1, 1 scale <22, 14, 2> translate x*7.8 } }
  scale <1, 1, 1.3>
}

#declare Hair1 =
union {

  object {
    union {
      difference { object { TE rotate x*90 }                plane { y, 0 } }
      difference { object { TF rotate x*90 translate x*15 } plane { y, 0 inverse} }
      difference { object { TK rotate x*90 translate x*23 } plane { y, 0 } }
    }
    texture { HairTexture }
    bounded_by { box { -1, 1 scale <22, 14, 2> translate x*7.8 } }
  }

  object {
    union {
      difference { object { TD rotate x*90 }                plane { y, 0 } }
      difference { object { TG rotate x*90 translate x*15 } plane { y, 0 inverse} }
      difference { object { TJ rotate x*90 translate x*23 } plane { y, 0 }
      }
    }
    texture { HairTexture }
    bounded_by { box { -1, 1 scale <22, 14, 2> translate x*7.8 } }
  }

  object {
    union {
      difference { object { TC rotate x*90 }                plane { y, 0 } }
      difference { object { TH rotate x*90 translate x*15 } plane { y, 0 inverse} }
      difference { object { TI rotate x*90 translate x*23 } plane { y, 0 } }
    }
    texture { HairTexture }
    bounded_by { box { -1, 1 scale <22, 14, 2> translate x*7.8 } }
  }

  object {
    union {
      difference { object { TB rotate x*90 }                plane { y, 0 } }
      difference { object { TI rotate x*90 translate x*15 } plane { y, 0 inverse} }
      difference { object { TH rotate x*90 translate x*23 } plane { y, 0 } }
    }
    texture { HairTexture }
    bounded_by { box { -1, 1 scale <22, 14, 2> translate x*7.8 } }
  }

  object {
    union {
      difference { object { TA rotate x*90 }                plane { y, 0 } }
      difference { object { TJ rotate x*90 translate x*15 } plane { y, 0 inverse} }
      difference { object { TG rotate x*90 translate x*23 } plane { y, 0 } }
    }
    texture { HairTexture }
    bounded_by { box { -1, 1 scale <22, 14, 2> translate x*7.8 } }
  }
  scale <1, 1, 1.3>
}

#declare Hair =
union {
  object { Hair1 }
  object { Hair1 translate y*5 }
  object { Stran translate <0, 5, 1.2> }
  object { Stran translate <0, 5, 2.4> }
  object { Stran translate <0, 5, 3.6> }
  object { Stran translate <0, 5, 4.8> }
  object { Stran translate <0, 5, 6> }
  object { Stran translate <0, 5, 7.2> }
  object { Stran translate <0, 5, 8.4> }
  object { Stran translate <0, 5, 9.6> }

  object { Stran translate <0, 5, 10.8> }
  object { Stran translate <0, 5, 12> }
  object { Stran translate <0, 5, 13.2> }
  object { Stran translate <0, 5, 14.4> }
  object { Stran translate <0, 5, 15.6> }
  object { Stran translate <0, 5, 16.8> }
  object { Stran translate <0, 5, 18> }
  object { Stran translate <0, 5, 19.2> }

}