//--- Colored Flood Lights for Castle
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

//--- Blue
#declare BFlood =
union {
  object { 
    sphere { 0, 10 }
    texture { pigment { color Gray } finish { phong 1 ambient 0.05 } }
    clipped_by { plane { z, 0  } }
  }
  object { light_source { z*-4 color Blue } }
}

//--- Red Flood
#declare RFlood =
union {
  object { 
    sphere { 0, 10 }
    texture { pigment { color Gray } finish { phong 1 ambient 0.05 } }
    clipped_by { plane { z, 0  } }
  }
  object { light_source { z*-4 color Magenta } }
}

object { BFlood rotate y*45 rotate x*-50 translate <-3500, -600, 1000> }