//----- The Jack Coaster                       Miller 12/18/92
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
global_settings {
  //assumed_gamma 1
  //ambient_light 0.1
  max_trace_level 20
}

// +w800 +h500 +a0.2 +am2 +j +r4

#version 3.1;

#include "colors.inc"
#include "shapes.inc"
#include "shapes2.inc"
#include "World.inc"
#include "Flood.inc"
#include "JackBox.inc"
#include "Rail.inc"
#include "Castle.inc"

// Use this for a square image,
// i.e. +h1000 +w1000
#declare Cam1 =
camera {
  location <320, 300, -470> 
  direction z*1.4
  up y*1 
  right x*image_width/image_height
  look_at <-40, 170, 0>
}

#declare Cam2 =
camera {
  location <320, 300, -470> 
  direction z*2
  up y*1.5 
  right x*image_width/image_height
  look_at <-40, 170, 0>
}

camera { Cam2 }

//-------light
object { light_source { <-100,   100,  -600> color White } }
object { light_source { < 100,  1000, -1000> color White } }
object { light_source { < 600,   900,     0> color Gold } }
object { light_source { <1000, -1200,  4000> color White } }