//--- Jack's Castle
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare CastleStone =
texture {
  pigment { color Gray20 }
  finish {
    ambient 0.1
    diffuse 0.4
    phong 0.2
    phong_size 20
    //crand 0.05  // this could be swapped with roughness!
    //roughness 0.07  // this could be swapped with crand!
    crand 0.07
    roughness 0.05
  }
}

#declare TileRoof =
texture {
  pigment { color Salmon }
  finish {
    ambient 0.1
    diffuse 0.35
    phong 0.2
    phong_size 50
    //crand 0.05  // this could be swapped with roughness!
    //roughness 0.07  // this could be swapped with crand!
    //crand 0.07
    //roughness 0.05
  }
}

#declare RodTexture =
texture {
  pigment { color Gold }
  finish {
    ambient 0.1
    diffuse 0.2
    phong 1
    phong_size 90
  }
}

#declare MoldingTexture =
texture {
  pigment { color Tan }
  finish {
    ambient 0.1
    diffuse 0.2
    phong 0.2
    phong_size 90
  }
}

//-- Graduated Stone
#declare GradStone =
texture {
  pigment {
    gradient y
    color_map {
      [0.0 0.1 color Black color Black]
      [0.1 0.5 color Black color Gray10]
      [0.5 1.0 color Gray10 color Gray20]
    }
  }
  finish {
    ambient 0.1
    diffuse 0.3
    phong 0.2
    phong_size 20
    crand 0.07
  }
  scale <100, 400, 100>
  translate y*-400
}
 
#declare Tower1 =
union {
  object {
    union {
      difference {
        cylinder { y, -y, 1 scale <10, 45, 10> translate y*45 }
        object { Cylinder_Z scale <5.25, 5.25, 1> translate y*77.5 }
        box { -1, 1 scale <5.25, 10, 12> translate y*67.5 }
      }
      cylinder { y, -y, 1 scale <11.3, 2.5, 11.3> translate y*87.5 }
    }
    texture { CastleStone }
    bounded_by { box { -1, 1 scale <11, 46, 11> translate y*45 } }
  }
  //--- Tower Peek
  object {
    intersection {  
      object { QCone_Y scale <13.8, 30, 13.8> translate y*120 }
      plane { y, 120 }
      plane { y, 90 inverse }
    }
    texture { TileRoof }
    bounded_by { box { -1, 1 scale <14, 15, 14> translate y*105 } }
  }
  //--- Roof Points
  object {
    union {
      intersection {
        object { QCone_Y scale <3.8, 11.5, 3.8> translate y*128 }
        plane { y, 128 }
        plane { y, 115 inverse }
      }
      intersection {
        object { QCone_Y scale <1.3, 29.3, 1.3> translate y*148 }
        plane { <0, 1, 0>, 148 }
        plane { <0, 1, 0>, 118.7 inverse }
      }
    }
    texture { RodTexture }
    bounded_by { box { -1, 1 scale <5, 19, 5> translate y*131 } }
  }
  bounded_by { box { -1, 1 scale <15, 75, 15> translate y*75 } }
}

#declare MainExit =
union {
  object {
    difference {
      box { -1, 1 scale <22.5, 25,    35> translate y*25 }
      box { -1, 1 scale <20.5, 26,    33> translate y*25 }
      box { -1, 1 scale <10.5, 15.01, 40> translate y*15 }
	  
      object { Cylinder_Z scale <10.5, 10.5, 1> translate y*30 }

      box { -1, 1 scale <30, 5, 2> translate <0, 30, -25> }
      box { -1, 1 scale <30, 5, 2> translate <0, 30, -15> }
      box { -1, 1 scale <30, 5, 2> translate <0, 30,  15> }
      box { -1, 1 scale <30, 5, 2> translate <0, 30,  25> }
    }
    texture { CastleStone }
    bounded_by { box { -1, 1 scale <23, 26, 36> translate y*25 } }
  }
  //--- Molding
  object {
    union {
      box { -1, 1 scale <25, 2.5, 37.5> translate <0, 47.5, 0> }     
      difference {
        union{
          cylinder { z, -z, 1 scale <15, 15, 2.5> translate <0, 30, -35> }
          box { -1, 1 scale <15, 15, 2.5> translate <0, 15, -35> }
        }
        object { Cylinder_Z scale <10, 10, 1> translate y*30 }
        box { -1, 1 scale <10, 15.01, 40> translate y*15 }
      }
    }
    texture { MoldingTexture }
    bounded_by { box { -1, 1 scale <26, 26, 40> translate y*25 } }
  }
  //--- Exit Roof
  object {
    intersection {
      plane { y, 50 inverse }
      plane { y, 80 }
      plane { x, 0 rotate  z*14 translate < 30, 50,   0> }
      plane { x, 0 rotate z*-14 translate <-30, 50,   0> inverse}
      plane { z, 0 rotate  x*28 translate <  0, 50, -40> inverse}
      plane { z, 0 rotate x*-28 translate <  0, 50,  40> }
    }
    texture { TileRoof }
    bounded_by { box { -1, 1 scale <31, 16, 41> translate y*65 } }
  }
  bounded_by { box { -1, 1 scale <31, 41, 41> translate y*40 } }
}

//--- Castle Slab
#declare Slab =
object {
  union {
    box { -1, 1 scale <90, 3, 30> translate <0, -3, 16.5> }
    box { -1, 1 scale <50, 3, 40> translate <0, -3,  0> }
    box { -1, 1 scale <27, 3, 50> translate <0, -3,  0> }
  }
  texture { MoldingTexture }
}

#declare BR1 =
box { -1, 1 scale <2.5, 27.5, 1> }

#declare Brace =
object { 
  union { 
    box { BR1 translate z*-16 }
    box { BR1 translate z*-8 } 
    box { BR1 } 
    box { BR1 translate z*16 }
    box { BR1 translate z*8 } 
  }
  texture { MoldingTexture }
  bounded_by { box { -1, 1 scale <3, 28, 25> } }
}

#declare BR2 = box { -1, 1 scale <1, 10, 50> }

#declare Brace2 =
object { 
  union { 
    box { BR2 translate x*-24 }
    box { BR2 translate x*-16 }
    box { BR2 translate x*-8 }
    box { BR2 translate x*-0 }
    box { BR2 translate x*24 }
    box { BR2 translate x*16 }
    box { BR2 translate x*8 }
    box { BR2 }
  }
  texture { MoldingTexture }
  bounded_by { box { -1, 1 scale <27, 11, 51> } }
}