//----- Jack's Box
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

//--- Box Trim Section
#declare BTS = box { -1, 1 scale < 50, 2.5, 2.5> }

//--- Box Panel with Image Map
#declare BP1 =
object {
  Square_Z scale <49, 49, 49>
  texture { BoxImage }
}

//--- Torus For Fender
#declare T30 = quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -900.5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 324.5, 0, 0, 0, 0, 1, 0, -900.5, 0, 26325.0625> }

//--- Fender
#declare Fender =
object {
  union {
    intersection {
      object { T30 rotate x*90 }
      plane { y, 10 inverse }
    }
    intersection {
      sphere { 0, 1 scale <2.5, 19, 12> translate <0, 28.4, 9> }
      plane { z, 10  }
    }
  }
  texture { TrimTexture }
  bounded_by { box { -1, 1 scale <31.5, 22.5, 20> translate <0, 25.5, 4.9> } }
}

#declare Wheel =
object { 
  union {
    difference {
     cylinder { z, -z, 1 scale <22, 22, 5> }
     object { Cylinder_Z scale <16, 16, 1> }
    } 
    object { Disk_Z scale <8.5, 8.5, 11> } 
    box { -1, 1 scale <18, 3.5, 3> }
    box { -1, 1 scale <3.5, 18, 3> }
  }
  texture { Steel }
  bounded_by { box { -1, 1 scale <23, 23, 12> } }
  rotate y*90
}     

//--- Complete Jack 'n Box
#declare JBox =
union {
  union {
    union {
      //--- Gold Trim 
      object {
        union {
          box { BTS translate <0,  47.5, -47.5> }
          box { BTS translate <0,  47.5,  47.5> }
          box { BTS translate <0, -47.5, -47.5> }
          box { BTS translate <0, -47.5,  47.5> }
          box { BTS rotate z*90 translate < 47.5,   0,  47.5> }
          box { BTS rotate z*90 translate < 47.5,   0, -47.5> }
          box { BTS rotate z*90 translate <-47.5,   0,  47.5> }
          box { BTS rotate z*90 translate <-47.5,   0, -47.5> }
          box { BTS rotate y*90 translate < 47.5,  47.5, 0> }
          box { BTS rotate y*90 translate < 47.5, -47.5, 0> }
          box { BTS rotate y*90 translate <-47.5,  47.5, 0> }
          box { BTS rotate y*90 translate <-47.5, -47.5, 0> }
       } 
       texture { TrimTexture }
	   bounded_by { box { -1, 1 scale <51, 51, 51> } }
      }
      //--- Insert Panels
      union {
        object { BP1 translate  z*48 }
        object { BP1 translate z*-48 }
        object { BP1 rotate y*90 translate x*-48 }
        object { BP1 rotate y*90 translate  x*48 }
        object { BP1 rotate x*90 translate y*-48 }
        bounded_by { box { -1, 1 scale <51, 51, 51> } }
      }
      //--- BoxTop
      object {
        difference {
          union {
            box { -1, 1 scale <49, 1,   49> translate y*47 }
            box { -1, 1 scale <38, 2.5, 38> translate y*47.5 }
          } 
          box { -1, 1 scale <33, 10, 33> translate y*47 }
        }
        texture { BTTexture }
        bounded_by { box { -1, 1 scale <49, 4, 49> translate y*47 } }
      }
      bounded_by { box { -1, 1 scale <51, 51, 51> } }
    }

    //--- Box Lid
    union {   
      //--- Box Lid Trid
      object { 
        union {
          box { BTS translate  y*2.5 }
          box { BTS translate y*97.5 }
          box { BTS rotate z*90 translate <-47.5, 50, 0> }
          box { BTS rotate z*90 translate  <47.5, 50, 0> }
        }
        texture { TrimTexture }
        bounded_by { box { -1, 1 scale <51, 51, 3> translate y*50 } }
      }

      //--- Inside Box Lid
      object {
        union {
          box { -1, 1 scale <49, 49, 0.2> translate <0, 50,  2> }
          box { -1, 1 scale <33, 33, 3>   translate <0, 50, -1> }
        }
        texture { BTTexture }
        bounded_by { box { -1, 1 scale <51, 51, 3> translate y*50 } }
      }
      bounded_by { box { -1, 1 scale <51, 51, 3> translate y*50 } }
      rotate x*30
      translate <0, 52, 52>
    }
    translate y*77.8
  }

  //--- Attach Wheels & Axil
  union {
    object { Wheel translate <-58, 22, -45> }
    object { Wheel translate <-58, 22,  45> }
    object { Wheel translate < 58, 22, -45> }
    object { Wheel translate < 58, 22,  45> }
    object {
      union {
       cylinder { x, -x, 1 scale <75, 4, 4> translate <0, 22, -45> }
       cylinder { x, -x, 1 scale <75, 4, 4> translate <0, 22,  45> }
      }
      texture { Steel }
    }
    bounded_by { box { -1, 1 scale <76, 25, 70>  translate y*22 } }
  } 

  union {
    object { Fender rotate y*-90 translate < 58, 22, -47.5> }
    object { Fender rotate y*-90 translate < 58, 22,  47.5> }
    object { Fender rotate  y*90 translate <-58, 22, -47.5> }
    object { Fender rotate  y*90 translate <-58, 22,  47.5> }
    bounded_by { box { -1, 1 scale <76, 23, 76> translate y*47 } }
  }

  //--- Crank Handle
  union {
    object { 
      union {
        difference {
          cylinder { z, -z, 1 scale <7.5, 7.5, 3.5> }
          object { Cylinder_Z scale <4.5, 4.5, 1> }
        }
        cylinder { z, -z, 1 scale <2.2, 2.2, 8.5> translate z*-3.3 }      
        cylinder { z, -z, 1 scale <4.4, 4.4, 1>   translate z*-9.6 }      
        cylinder { z, -z, 1 scale <4.4, 4.4, 1>   translate <40.8, 0, -9.6> }      
        box { -1, 1 scale <20.4, 4.4, 1> translate <20.4, 0, -9.6> }
      }      
      texture { TrimTexture }
      bounded_by { box { -1, 1 scale <28, 8, 9> translate <19.6, 0, -4.8> } }
    }

    object { 
      union {
        cylinder { z, -z, 1 scale <5, 5, 5> translate <40.8, 0, -16.2> }      
        sphere { 0, 1 scale <5, 5, 3> translate <40.8, 0, -21.2> }
        sphere { 0, 1 scale <2, 2, 1> translate <40.8, 0, -25> }
      }      
      texture { color Red phong 1 }
      bounded_by { box { -1, 1 scale <7, 7, 9> translate <40.8, 0, -17> } } 
    }
    rotate z*30 //--- +Z Turns crank up 
    rotate y*-90
    translate <49, 77.8, 0> 
  }
}