//----- Jack's Box

//--- Box Trim Section
#declare BTS =
box { UnitBox scale < 50 2.5 2.5> }

//--- Box Panel with Image Map
#declare BP1 =
object {
  union { Square_Z scale <49 49 49> }
   texture { BoxImage }
}

//--- Torus For Fender
#declare T30 = 
   quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -900.500000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        324.500000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -900.500000 0.000000 26325.062500 >
   }

//--- Fender
#declare Fender =
object {
  union {
   intersection {
     quartic { T30 rotate <90 0 0> }
     plane { <0 1 0> 10 inverse }
   }
   intersection {
     quadric { Sphere scale <2.5 19 12> translate <0 28.4 9> }
     plane { <0 0 1> 10  }
   }
  }
      texture { TrimTexture }
 	bounded_by {
	box { UnitBox scale <31.5 22.5 20> translate <0 25.5 4.9> }
	}
}





#declare Wheel =
object { 
  union {
    difference {
     intersection { Disk_Z scale <22 22 5> }
     quadric { Cylinder_Z scale <16 16 1> }
    } 
     intersection { Disk_Z scale <8.5 8.5 11> } 
     box { UnitBox scale <18 3.5 3> }
     box { UnitBox scale <3.5 18 3> }
  }
     texture { Steel }
 	bounded_by {
	box { UnitBox scale <23 23 12> }
	}
rotate <0 90 0>
}     

//--- Complete Jack 'n Box
#declare JBox =
composite {
 composite {
  composite {
  //--- Gold Trim 
  object {
   union {
    box { BTS translate <0 47.5 -47.5> }
    box { BTS translate <0 47.5 47.5> }
    box { BTS translate <0 -47.5 -47.5> }
    box { BTS translate <0 -47.5 47.5> }
    box { BTS rotate <0 0 90> translate <47.5 0 47.5> }
    box { BTS rotate <0 0 90> translate <47.5 0 -47.5> }
    box { BTS rotate <0 0 90> translate <-47.5 0 47.5> }
    box { BTS rotate <0 0 90> translate <-47.5 0 -47.5> }
    box { BTS rotate <0 90 0> translate <47.5 47.5 0> }
    box { BTS rotate <0 90 0> translate <47.5 -47.5 0> }
    box { BTS rotate <0 90 0> translate <-47.5 47.5 0> }
    box { BTS rotate <0 90 0> translate <-47.5 -47.5 0> }
   } 
      texture { TrimTexture }
	 bounded_by {
    	 box { UnitBox scale <51 51 51> }
	 }
  }
  //--- Insert Panels
  composite {
    object { BP1 translate <0 0 48> }
    object { BP1 translate <0 0 -48> }
    object { BP1 rotate <0 90 0> translate <-48 0 0> }
    object { BP1 rotate <0 90 0> translate <48 0 0> }
    object { BP1 rotate <90 0 0> translate <0 -48 0> }
	 bounded_by {
    	 box { UnitBox scale <51 51 51> }
	 }
  }

  //--- BoxTop
  object {
   difference {
    union {
     box { UnitBox scale <49 1 49> translate <0 47 0> }
     box { UnitBox scale <38 2.5 38> translate <0 47.5 0> }
    } 
     box { UnitBox scale <33 10 33> translate <0 47 0> }
   }
      texture { BTTexture }
	bounded_by {
	box { UnitBox scale <49 4 49> translate <0 47 0> }
	}
  }
	 bounded_by {
    	 box { UnitBox scale <51 51 51> }
	 }
 }

  //--- Box Lid
  composite {   
    //--- Box Lid Trid
    object { 
      union {
        box { BTS translate <0 2.5 0> }
        box { BTS translate <0 97.5 0> }
        box { BTS rotate <0 0 90> translate <-47.5 50 0> }
        box { BTS rotate <0 0 90> translate <47.5 50 0> }
      }
         texture { TrimTexture }
		bounded_by {
		box { UnitBox scale <51 51 3> translate <0 50 0> }
		}
    }

    //--- Inside Box Lid
    object {
      union {
        box { UnitBox scale <49 49 .2> translate <0 50 2> }
        box { UnitBox scale <33 33 3> translate <0 50 -1> }
      }
         texture { BTTexture }
	  	bounded_by {
		box { UnitBox scale <51 51 3> translate <0 50 0> }
		}
    }
	bounded_by {
	box { UnitBox scale <51 51 3> translate <0 50 0> }
	}	
   rotate <30 0 0> translate <0 52 52>
  }
  translate <0 77.8 0>
  }


  //--- Attach Wheels & Axil
  composite {
    object { Wheel translate <-58 22 -45> }
    object { Wheel translate <-58 22 45> }
    object { Wheel translate <58 22 -45> }
    object { Wheel translate <58 22 45> }
    object {
      union {
       intersection { Disk_X scale <75 4 4> translate <0 22 -45> }
       intersection { Disk_X scale <75 4 4> translate <0 22 45> }
      }
        texture { Steel }
    }
	bounded_by {
	box { UnitBox scale <76 25 70>  translate <0 22 0> }
	}	
  } 

   composite {
    object { Fender rotate <0 -90 0> translate <58 22 -47.5> }
    object { Fender rotate <0 -90 0> translate <58 22 47.5> }
    object { Fender rotate <0 90 0> translate <-58 22 -47.5> }
    object { Fender rotate <0 90 0> translate <-58 22 47.5> }
 	bounded_by {
	box { UnitBox scale <76 23 76> translate <0 47 0> }
	}
   }

   //--- Crank Handle
   composite {
    object { 
      union {
       difference {
        intersection { Disk_Z scale <7.5 7.5 3.5> }
        quadric { Cylinder_Z scale <4.5 4.5 1> }
       }
        intersection { Disk_Z scale <2.2 2.2 8.5> translate <0 0 -3.3> }      
        intersection { Disk_Z scale <4.4 4.4 1> translate <0 0 -9.6> }      
        intersection { Disk_Z scale <4.4 4.4 1> translate <40.8 0 -9.6> }      
        box { UnitBox scale <20.4 4.4 1> translate <20.4 0 -9.6> }
      }      
	  texture { TrimTexture }
	 	bounded_by {
		box { UnitBox scale <28 8 9> translate <19.6 0 -4.8> }
		}
   }

    object { 
      union {
        intersection { Disk_Z scale <5 5 5> translate <40.8 0 -16.2> }      
        quadric { Sphere scale <5 5 3> translate <40.8 0 -21.2> }
        quadric { Sphere scale <2 2 1> translate <40.8 0 -25> }
      }      
	  texture { color Red phong 1 }
	 	bounded_by {
		box { UnitBox scale <7 7 9> translate <40.8 0 -17> }
		}
   }
   rotate <0 0 30> //--- +Z Turns crank up 
   rotate <0 -90 0> 
   translate <49 77.8 0> 
  }

}






