//----- The Atrium Walk
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare WalkColor1 =
texture {
  pigment { color Gray45 }
  finish { ambient 0.2 diffuse 0.7 phong 0.3 phong_size 20 crand 0.04 reflection { 0.2 } }
}

#declare WalkColor2 =
texture {
  pigment { color Gray60 }
  finish { ambient 0.2 diffuse 0.7 phong 0.3 phong_size 20 crand 0.04 reflection { 0.2 } }
}

#declare WaterColor1 =
texture {
  pigment { color CadetBlue }
  finish { ambient 0.2 diffuse 0.7 phong 0.3 phong_size 20 reflection { 0.4 } }
}

#declare Walk = 
union {
  union {
    box { -1, 1 scale <8, 0.1, 31.9> translate z*-45.9 }
    box { -1, 1 scale <32.6, 0.1, 8> translate <40.6, 0, -69.8> }
    texture { WalkColor1 }
  }
  //--- Inside Walk
  union {
    box { -1, 1 scale <5, 0.2, 30.5> translate  z*-44.5 }
    box { -1, 1 scale <34.1, 0.2, 5> translate <39.1, 0, -69.9> }
    texture { WalkColor2 }
  }
  //--- Pool Rim
  union {
    object {
      difference {
        box { -1, 1 scale <26, 0.5, 12.1> translate <34, 0, -49.7> }
        box { -1, 1 scale <23, 1, 9.1> translate <34, 0, -49.7> }
      }
      texture { WalkColor1 }
    }
    //--- Pool Water
    box { -1, 1 scale <26, 0.05, 12.1> translate <34, 0, -49.7> texture { WaterColor1 } }
    bounded_by { box { -1, 1 scale <27, 0.7, 13.1> translate <34, 0, -49.7> } }
  }
}

object { Walk rotate y*10 }