//----- A Tree - Sort'a...room for mucho improvo'           Miller 12/05/92
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare YourTexture = 
texture {
  pigment { color rgb <0.556863, 0.419608, 0.137255> }
  finish { ambient 0.1 diffuse 0.6 phong 1 crand 0.03 }
}

#declare Dot = sphere { 0, 1 }

#declare Connector_1 = 
object {
  quadric { <0, 1, 1>, 0, 0, -1 }
  clipped_by {
    plane { x, 1 }
    plane { -x, 0 }
  }
}

#declare Connector_2 =
object {
  quadric { <1, -1, 1>, 0, 0, 0 }
  rotate z*90
}

/*----------------------------------------------------------------------------*/

#declare Trunk =
union {
  sphere { 0, 0.45 texture { YourTexture } }
  object {
    Connector_2
    clipped_by {
      plane { x, 0.429273 }
      plane { x, 0.286182 inverse }
    }
    translate x*-0.429273
    scale <3.179797, 1, 1>
    translate x*-0.135
    rotate y*180
    rotate z*90
    texture { YourTexture }
  }
  sphere { 0, 0.3 translate y*0.5 texture { YourTexture } }
  object {
    Connector_2
    clipped_by {
      plane { x, 0.299548 }
      plane { x, 0.249623 inverse }
    }
    translate x*-0.299548
    scale <18.193405, 1, 1>
    translate x*-0.016465
    rotate y*180
    rotate z*81.069858
    rotate y*-135
    translate y*0.5
    texture { YourTexture }
  }
  sphere { 0, 0.25 translate <-0.1, 1.4, 0.1> texture { YourTexture } }
  object {
    Connector_2
    clipped_by {
      plane { x, 0.249421 }
      plane { x, 0.199536 inverse }
    }
    translate x*-0.249421
    scale <14.662878, 1, 1>
    translate x*-0.017010
    rotate y*180
    rotate z*72.284528
    rotate y*116.565051
    translate <-0.1, 1.4, 0.1>
    texture { YourTexture }
  }
  sphere { 0, 0.2 translate <-0.2, 2.1, -0.1> texture { YourTexture } }
  object {
    Connector_2
    clipped_by {
      plane { x, 0.199797 }
      plane { x, 0.149847 inverse }
    }
    translate x*-0.199797
    scale <22.158520, 1, 1>
    translate x*-0.009017
    rotate y*180
    rotate z*82.673963
    rotate y*-45
    translate <-0.2, 2.1, -0.1>
    texture { YourTexture }
  }
  sphere { 0, 0.15 translate <-0.1, 3.2, 0> texture { YourTexture } }
  object {
    Connector_1
    scale <1.122497, 0.15, 0.15>
    rotate z*78.509540
    rotate y*26.565051
    translate <-0.1, 3.2, 0>
    texture { YourTexture }
  }
  sphere { 0, 0.15 translate <0.1, 4.3, -0.1> texture { YourTexture } }
  object {
    Connector_1
    scale <1.204159, 0.15, 0.15>
    rotate z*85.236358
    rotate y*-90
    translate <0.1, 4.3, -0.1>
    texture { YourTexture }
  }
  sphere { 0, 0.15 translate <0.1, 5.5, 0> texture { YourTexture } }
  bounded_by {sphere { 0, 3.427255 translate <0, 2.6, 0> } }
}

/*
#declare LeafTex =
texture {
  //pigment {
  //  image_map {
  //  2
  //  <1 -1 0>
  //  gif "leaf1.gif"
  //  alpha 5
  //  1
  //  interpolate 4
  //}
  pigment {
    bozo
    turbulence 0.5
    color_map {
      [0.0 0.2 color Clear color Clear]
      [0.2 0.3 color Black color DarkGreen]
      [0.3 0.7 color HuntersGreen color DarkGreen]
      [0.7 0.9 color HuntersGreen color DarkGreen]
      [0.9 1.0 color DarkGreen color Green]
    }
  scale 0.1
  translate <1, 5.2, 1>
  rotate y*40
  }
  finish { ambient 0.5 diffuse 0.2 crand 0.1 }
}
*/

// Leaf texture from landscape.pov v3.6 demo scene file
#declare LeafTex =
texture {
  pigment {
    agate
    color_map {
      [0.77 color rgbt 1]
      [0.77 color rgb <0.2, 0.5, 0.10> ]
      [0.85 color rgb <0.4, 0.6, 0.15> ]
      [0.97 color rgb <0.4, 0.6, 0.15> ]
      [0.99 color rgb <0.4, 0.2, 0.05> ]
    }
    scale 0.5
    warp { turbulence 0.4 }
  }
  finish { diffuse 0.5 brilliance 1.5 ambient 0.07 }
  normal { wrinkles 0.6 scale 0.5 }
  scale 3
}

#declare Mass1 =
union {
  sphere { 0, 1 scale <2.1, 2.6, 2.4> translate y*9.3 }
  sphere { 0, 2.6 translate y*7 }
}

#declare Slice1 =
difference {
  object { Mass1 }
  plane { z, -2.1 inverse }
  texture { LeafTex rotate y*40 }
}

#declare Slice2 =
difference {
  object  { Mass1 }
  plane { z, -1.5  }
  plane { z, -0.9 inverse }
  texture { LeafTex rotate y*-25 }
}

#declare Slice3 =
difference {
  object  { Mass1 }
  plane { z, -0.3  }
  plane { z, 0.3 inverse }
  texture { LeafTex }
}

//--- One Complete Tree
#declare Tree =
union {
  union {
    object { Slice1 }
    object { Slice1 rotate y*180 }
    object { Slice2 }
    object { Slice2 rotate y*180 }
    object { Slice3 }
    bounded_by { box { -1, 1 scale <2.8, 4, 2.8> translate y*8 } }
  }
  object { Trunk }
  scale 1.5
  rotate y*-50
}