//---- Dumby Building for Positioning
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare DumbTexture =
texture {
  pigment { color SeaGreen }
  finish { ambient 0.1 diffuse 0.7 phong 1 }
}

union {
  //--- Left Wing
  object {
    union {
      object { Disk_Y scale <9, 15, 9> translate <-30, 15, -36> }
      object { Disk_Y scale <9, 15, 9> translate <-21, 15, -15> }
      box { -1, 1 scale <9, 15, 15> translate <-30, 15, -21> }
    }
    texture { DumbTexture }
    bounded_by { box { -1, 1 scale <14.4, 16, 20.5> translate <-25.6, 15, -25.1> } }
  }

  //-- Right Wing
  object {
    union {
      object { Disk_Y scale <9, 15, 9> translate <29, 15, -15.2> }
      object { Disk_Y scale <9, 15, 9> translate <50, 15, -24.2> }
      box { -1, 1 scale <15, 15, 9> translate <44, 15, -15.2> }
      translate x*-10
    }
    texture { DumbTexture }
    bounded_by { box { -1, 1 scale <20.5, 16, 14.4> translate <39.3, 15, -19.8> } }
  }

  //-- Tower Front
  box { -1, 1 scale <12, 24, 15> translate y*24
    texture { DumbTexture }
  }

  object {
    Disk_Z scale <12, 12, 15>
    texture { DumbTexture }
    translate y*48
  }
 
  object {
    intersection {
      plane { y, 0 inverse }
      plane { z, 5 }
      plane { z, -5 inverse }
      plane { y, 14.8 }
      plane { y, 0 rotate z*39 translate <-20, 14.8, 0> }
      plane { y, 0 rotate z*-39 translate <20, 14.8, 0> }
    }
    texture { DumbTexture }
    bounded_by { box { -1, 1 scale <40, 16, 5> translate y*15 } }
    translate <0, 30, -10>
  }
  rotate y*10
}