//----- The Atrium                             Miller 12/05/92
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#include "colors.inc"
#include "shapes.inc"
#include "skies.inc"
#include "glass.inc"
#include "Atrium.INC"
//#include "Dumb.INC"  
#include "Walk.INC"
#include "Tree.INC"

global_settings {
  //assumed_gamma 1
  //ambient_light 0.5
  max_trace_level 20
}

#version 3.1;

camera {
  location <25, 13, -125> 
  direction z*1.3
  up y
  right x*image_width/image_height
  look_at <-3, 20, 0>
 }

light_source { < -70, 920, -360> color White }  //-------light 1
light_source { <-300, 465, -700> color White }  //-------light 2
light_source { < 200,  60, -200> color Gold }   //-------light 3


#declare GrassLand1 = // Origianl v1 texture
texture {
  pigment {
    image_map { tga "land2.tga" interpolate 4 }
    rotate x*90
    scale <10, 1, >
    translate <-85, 0, -85>
  }
  finish { phong 0.2 ambient 0.1 diffuse 0.6 crand 0.1 }
} 

#declare GrassLand2 =
texture {
  pigment { color DarkGreen }
  finish { phong 0.2 ambient 0.1 diffuse 0.6 crand 0.1 }
} 

#declare GrassLand3 =
texture {
  pigment { color rgb <0.5, 1.15, 0.3> }
  finish { specular 0.1 diffuse 0.3 brilliance 1.6 ambient <0.8, 0.9, 1.4>*0.03 }
  normal { granite 0.5 accuracy 0.01 scale 0.12 }
}

//--- Sky

sphere { 0, 1
  hollow on
  scale <3000, 1000, 3000>
  texture {
    pigment { color CadetBlue }
    pigment {
    //image_map { gif "sky1.gif" map_type 2 interpolate 4 }
    //image_map { gif "cloud3.gif" map_type 2 interpolate 4 }
    image_map { tga "sky1.tga" map_type 2 interpolate 4 }
      scale 3000
      rotate x*-60
      rotate y*-30
    }
    finish { ambient 0.8 diffuse 0 }
  }
}


//sky_sphere { S_Cloud2 }

//--- Grass
plane { y, 0 texture { GrassLand1 } }

//--- Plant trees
union {
  object { Tree translate <52, 0, -30.6> }      //
  //object { Tree translate <36.6, 0, -30.6> }  //  Modified by me - CjF
  object { Tree translate <28, 0, -30.6> }
  object { Tree translate <-39, 0, -51> }
  object { Tree translate <-29, 0, -51> }
  object { Tree translate <-19, 0, -51> }
  rotate y*10
}