//---- Atrium Parts & Building Materials
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

//--- Long Horizonal Frame
#declare Frame1 = box { -1, 1 scale <12, 0.15, 0.2> }

//--- Vertical Frame
#declare Frame2 = box { -1, 1 scale <0.15, 24, 0.2> }

//--- Short Horizonal Frame
#declare Frame3 = box { -1, 1 scale <4.15, 0.15, 0.2> }

//--- Vertical Frame
#declare Frame4 = box { -1, 1 scale <0.15, 7.5, 0.2> }

//--- Angle Frame
#declare AFrame1 = box { -1, 1 scale <15, 0.15, 0.2> translate x*-15 rotate z*39 }

//--- Top Arch Span
#declare Arch1 =
difference {
  object { Cylinder_Z scale <13, 13, 1> }
  plane { y, 0 }
  plane { z, -0.2 }
  plane { z, 0.2 inverse }
  object { Cylinder_Z scale <11.85, 11.85, 1> }
}

//--- Arch Divider 1
#declare Div1 = box { -1, 1 scale <6, 0.15, 0.2> translate x*-6 }

//--- Arch Divider 2
#declare Div2 = box { -1, 1 scale <4, 0.15, 0.2> translate x*-8 }

//--- Arch Divider 3
#declare Div3 = box { -1, 1 scale <2, 0.15, 0.2> translate x*-10 }


//---Interior Arches
#declare InArch =
union {
  object { Arch1 }
  box { -1, 1 scale <0.5, 1.5, 0.2> translate <12.5, -1.5, 0> }
  box { -1, 1 scale <0.5, 1.5, 0.2> translate <-12.5, -1.5, 0> }
  texture { FrameColor }
  bounded_by { box { -1, 1 scale <13, 9, 1> translate y*5 } }
} 

//--- Front Entrance Face
#declare ENT1 =
union {
  union {
    box { Frame2 translate <-12, 24, 0> }
    box { Frame2 translate <-8, 24, 0> }
    box { Frame2 translate <-4, 24, 0> }
    box { Frame2 translate y*24 }
    box { Frame2 translate <4, 24, 0> }
    box { Frame2 translate <8, 24, 0> }
    box { Frame2 translate <12, 24, 0> }
    texture { FrameColor }
    bounded_by { box { -1, 1 scale <13, 25, 1> translate y*24 } }
  }
  //--- Horizonal Frame around Door
  union {
    box { Frame3 translate x*-8 }
    box { Frame3 translate <-8, 3, 0> }
    box { Frame3 translate <-8, 6, 0> }
    box { Frame3 translate x*8 }
    box { Frame3 translate <8, 3, 0> }
    box { Frame3 translate <8, 6, 0> }
    texture { FrameColor }
    bounded_by { box { -1, 1 scale <13, 4, 1> translate y*3 } }
  }
  union {
    box { Frame1 translate y*9 }
    box { Frame1 translate y*12 }
    box { Frame1 translate y*15 }
    box { Frame1 translate y*18 }
    box { Frame1 translate y*21 }
    box { Frame1 translate y*24 }
    texture { FrameColor }
    bounded_by { box { -1, 1 scale <13, 9, 1> translate y*17 } }
  }
  union {
    box { Frame1 translate y*27 }
    box { Frame1 translate y*30 }
    box { Frame1 translate y*33 }
    box { Frame1 translate y*36 }
    box { Frame1 translate y*39 }
    box { Frame1 translate y*42 }
    box { Frame1 translate y*45 }
    box { Frame1 translate y*48 }
    texture { FrameColor }
    bounded_by { box { -1, 1 scale <13, 12, 1> translate y*37.5 } }
  }
  //--- Tan Dividing Panel
  union {
    box { -1, 1 scale <12, 1.5, 0.01> translate y*13.5 }
    box { -1, 1 scale <12, 1.5, 0.01> translate y*28.5 }
    texture { PanelColor }
  }
  //--- Arched Front Panel
  union { 
    object { Arch1 translate y*48 }
    difference {
      object { Cylinder_Z scale <8.15, 8.15, 1> }
      plane { y, 0 }
      plane { z, -0.2 }
      plane { z, 0.2 inverse }
      object { Cylinder_Z scale <7.85, 7.85, 1> }
      translate y*48
    }
    difference {
      object { Cylinder_Z scale <4.15, 4.15, 1> }
      plane { y, 0 }
      plane { z, -0.2 }
      plane { z, 0.2 inverse }
      object { Cylinder_Z scale <3.85, 3.85, 1> }
      translate y*48
    }
    texture { FrameColor }
    bounded_by { box { -1, 1 scale <13, 7, 1> translate y*54.5 } }
  }  
  //--- Dividers for Arched Panel
  union {
    box { Div1 rotate z*-51.428 }
    box { Div1 rotate z*-128.57 }
    box { Div2 rotate z*-25.71 }
    box { Div2 rotate z*-77.142 }
    box { Div2 rotate z*-102.856 }
    box { Div2 rotate z*-154.284 }
    box { Div3 rotate z*-12.857 }
    box { Div3 rotate z*-38.571 }
    box { Div3 rotate z*-64.28 }
    box { Div3 rotate z*-90 }
    box { Div3 rotate z*-115.71 }
    box { Div3 rotate z*-141.42 }
    box { Div3 rotate z*-167.14 }
    translate y*48
    texture { FrameColor }
    bounded_by { box { -1, 1 scale <13, 7, 1> translate y*54.5 } }
  } 
  //--- Arched Glass
  difference {
    object { Cylinder_Z scale <12, 12, 1> }
    plane { y, 0 }
    plane { z, -0.01 }
    plane { z, 0.01 inverse }
    translate y*48
    //texture { GlassColor }
    material { 
      texture {
        pigment { color rgbf <0.90, 1.0, 0.94, 0.8> }
        finish { ambient 0.8 diffuse 0.1 phong 1 phong_size 100 reflection { 0.2 } crand 0.001 }
      }
      interior { ior 1.5 }
    }
    bounded_by { box { -1, 1 scale <13, 7, 1> translate y*54.5 } }
  } 
  //--- Front Glass
  box { -1, 1 scale <12, 24, 0.01> translate y*24
    //texture { GlassColor }
    material { 
      texture {
        pigment { color rgbf <0.90, 1.0, 0.94, 0.8> }
        finish { ambient 0.8 diffuse 0.1 phong 1 phong_size 100 reflection { 0.2 } crand 0.001 }
      }
      interior { ior 1.5 }
    }
  } 
  //--- Additional Frame under arch
  union {
    box { -1, 1 scale <0.5, 1.5, 0.2> translate <12.5, 46.5, 0> }
    box { -1, 1 scale <0.5, 1.5, 0.2> translate <-12.5, 46.5, 0> }
    texture { FrameColor }
    bounded_by { box { -1, 1 scale <13, 2, 1> translate y*46.5 } }
  }    
}

//--- Front Face of left Wing
#declare LWing =
union {
  union {
    box { Frame3 translate x*-4 }
    box { Frame3 translate <-4, 3, 0> }
    box { Frame3 translate <-4, 6, 0> } 
    box { Frame3 translate <-4, 9, 0> }
    box { Frame3 translate <-4, 12, 0> }
    box { Frame3 translate <-4, 15, 0> }
    box { Frame4 translate <-4, 7.5, 0> }
    box { Frame4 translate <-8, 7.5, 0> }
    box { -1, 1 scale <4, 1.5, 0.01>  translate <-4, 13.5, 0> }
    texture { FrameColor }
    bounded_by { box { -1, 1 scale <4.2, 8.3, 1> translate <-4, 7.3, 0> } }
  } 
  box { -1, 1 scale <4, 1.5, 0.01> translate <-4, 13.5, 0> texture { PanelColor } }
  union {
    box { AFrame1 translate <-8, 15, 0> }
    box { AFrame1 translate <-8, 12, 0> }
    box { AFrame1 translate <-8, 9, 0> }
    box { AFrame1 translate <-8, 6, 0> }
    box { AFrame1 translate <-8, 3, 0> }
    box { -1, 1 scale <0.15, 5.8, 0.2> translate <-12, 5.8, 0> }
    box { -1, 1 scale <0.15, 4.2, 0.2> translate <-16, 4.2, 0> }
    box { -1, 1 scale <0.15, 2.6, 0.2> translate <-20, 2.6, 0> }
    texture { FrameColor }
    bounded_by { box { -1, 1 scale <9.5, 7.8, 1> translate <-17.3, 7.8, 0> } }
  } 
  union {
    triangle { <-8, 15, 0>, <-8, 11.8, 0>, <-26.4, 0, 0> }
    triangle { <-26.4, 0, 0>, <-22.6, 0, 0>, <-8, 11.8, 0> }
    texture { PanelColor }
    bounded_by { box { -1, 1 scale <9.5, 7.8, 1> translate <-17.3, 7.8, 0> } }
  } 
}

//--- Glass for Left Wing
#declare WGlass =
union {
  triangle { <-22.6, 0, 0>, <-8, 11.8, 0>, <0, 11.8, 0> }
  triangle { <-22.6, 0, 0>, <0, 0, 0>, <0, 11.8, 0> }
  //texture { GlassColor }
  material { 
    texture {
      pigment { color rgbf <0.90, 1.0, 0.94, 0.8> }
      finish { ambient 0.8 diffuse 0.1 phong 1 phong_size 100 reflection { 0.2 } crand 0.001 }
    }
    interior { ior 1.5 }
  }
}

//--- Glass for Arched Ceiling
#declare ACGlass =
difference {
  object { Cylinder_Z scale <12.8, 12.8, 1> }
  plane { y, 0 }
  plane { z, -15 }
  plane { z, 15 inverse }
  object { Cylinder_Z scale <12.7, 12.7, 1> }
  translate y*48
  //texture { GlassColor }
  material { 
    texture {
      pigment { color rgbf <0.90, 1.0, 0.94, 0.8> }
      finish { ambient 0.8 diffuse 0.1 phong 1 phong_size 100 reflection { 0.2 } crand 0.001 }
    }
    interior { ior 1.5 }
  }
}

#declare LeftWing =
union {
  object { LWing translate z*-5 }
  object { LWing translate z*5 }
  object { WGlass translate z*-5 }
  object { WGlass translate z*5 }
  object { WGlass translate z*-4.95 }
  object { WGlass translate z*4.95 }
  //--- Roof Patch
  union {
    triangle { <0, 15, -5>, <-8, 15, -5>, <-8, 15, 5> }
    triangle { <0, 15, -5>, <0, 15, 5>, <-8, 15, 5> }
    triangle { <-26.4, 0, -5>, <-8, 15, -5>, <-8, 15, 5> }
    triangle { <-26.4, 0, -5>, <-26.4, 0, 5>, <-8, 15, 5> }
    texture { RoofColor }
    bounded_by { box { -1, 1 scale <14, 8, 6> translate <-13.4, 7.6, 0> } }
  }
  bounded_by { box { -1, 1 scale <14, 8, 6> translate <-13.4, 7.6, 0> } }
}

//--- Front Side Walls
#declare FSWalls =
union {
  box { -1, 1 scale <0.1, 15, 15> translate <-12, 15, 0> }
  box { -1, 1 scale <0.1, 15, 15> translate <12, 15, 0> }
  box { -1, 1 scale <0.1, 7.5, 10> translate <-12, 37.5, 5> }
  box { -1, 1 scale <0.1, 7.5, 10> translate <12, 37.5, 5> }
  box { -1, 1 scale <0.1, 1.5, 15> translate <-12.8, 46.5, 0> }
  box { -1, 1 scale <0.1, 1.5, 15> translate <12.8, 46.5, 0> }
  texture { RoofColor }
  bounded_by { box { -1, 1 scale <13, 25, 16> translate y*24.5 } }
}

//---  Side Glass on Arch
#declare SGWalls =
union {
  box { -1, 1 scale <0.1, 1.5, 15> translate <-12.8, 46.5, 0> }
  box { -1, 1 scale <0.1, 1.5, 15> translate <12.8, 46.5, 0> }
  //texture { GlassColor }
  material { 
    texture {
      pigment { color rgbf <0.90, 1.0, 0.94, 0.8> }
      finish { ambient 0.8 diffuse 0.1 phong 1 phong_size 100 reflection { 0.2 } crand 0.001 }
    }
    interior { ior 1.5 }
  }
  bounded_by { box { -1, 1 scale <13, 25, 16> translate y*24.5 } }
}

//----------- Starts Lower Left Wing "Round Ends"

//--- Round Rib   
#declare RRib =
difference {
  object { Cylinder_Y scale <9, 1, 9> }
  plane { y, -0.15 }
  plane { y, 0.15 inverse }
  plane { z, 0 inverse }
  object { Cylinder_Y scale <8.8, 1, 8.8> }    
  texture { FrameColor }
  bounded_by { box { -1, 1 scale <9.2, 0.2, 5> translate z*-4.5 } }
}

//--- Solid Rib Panel
#declare RRPanel =
difference {
  object { Cylinder_Y scale <8.85, 1, 8.85> }
  plane { y, -1.5 }
  plane { y, 1.5 inverse }
  plane { z, 0 inverse }
  object { Cylinder_Y scale <8.8, 1, 8.8> }    
  texture { PanelColor }
  bounded_by { box { -1, 1 scale <9.2, 2, 5> translate z*-4.5 } }
}

//--- Vertical Frame
#declare Frame6 =
box { -1, 1 scale <0.15, 15, 0.2> translate <0, 15, -9> texture { FrameColor } }

//--- Vertical Frame
#declare Frame7 =
box { -1, 1 scale <0.2, 15, 0.15> translate y*15 texture { FrameColor } }

//--- Scaleable Panel
#declare SCPanel =
box { -1, 1 scale <0.15, 1.5, 1> texture { PanelColor } }

//--- Scaleable Glass
#declare SCGlass =
box { -1, 1 scale <0.05, 15, 1>
  //texture { GlassColor }
  material { 
    texture {
      pigment { color rgbf <0.90, 1.0, 0.94, 0.8> }
      finish { ambient 0.8 diffuse 0.1 phong 1 phong_size 100 reflection { 0.2 } crand 0.001 }
    }
    interior { ior 1.5 }
  }
}

//--- Scaleable Rib
#declare SCRib =
box { -1, 1 scale <0.2, 0.15, 1> texture { FrameColor } }

//---- Round Corner Building Section
#declare RoundF =
union {
  object { RRib }
  object { RRib translate y*3 }
  object { RRib translate y*6 }
  object { RRib translate y*9 }
  object { RRib translate y*12 }
  object { RRib translate y*15 }
  object { RRib translate y*18 }
  object { RRib translate y*21 }
  object { RRib translate y*24 }
  object { RRib translate y*27 }
  object { RRib translate y*30 }

  object { RRPanel translate y*28.5 }
  object { RRPanel translate y*13.5 }

  object { Frame6 }
  object { Frame6 rotate y*-30 }
  object { Frame6 rotate y*-60 }
  object { Frame6 rotate y*-90 }
  object { Frame6 rotate y*30 }
  object { Frame6 rotate y*60 }
  object { Frame6 rotate y*90 }

  //RoundGlass 
  difference {
    object { Cylinder_Y scale <8.82, 1, 8.82> }
    plane { y, -15 }
    plane { y, 15 inverse }
    plane { z, 0 inverse }
    object { Cylinder_Y scale <8.8, 1, 8.8> }    
    //texture { GlassColor }
    material { 
      texture {
        pigment { color rgbf <0.90, 1.0, 0.94, 0.8> }
        finish { ambient 0.8 diffuse 0.1 phong 1 phong_size 100 reflection { 0.2 } crand 0.001 }
      }
      interior { ior 1.5 }
    }
    bounded_by { box { -1, 1 scale <9.2, 16, 5> translate z*-4.5 } }
    translate y*15
  }
  bounded_by { box { -1, 1 scale <9.2, 16, 5> translate <0, 15.5, -4.5> } }
}