//----- A Tree - Sort'a...room for mucho improvo'           Miller 12/05/92



#declare YourTexture = 
    texture {
       color red 0.556863 green 0.419608 blue 0.137255
       ambient   0.1
       diffuse   0.6
       phong 1
       .03
    }

#declare Dot =
    quadric {
       < 1.0  1.0  1.0>
       < 0.0  0.0  0.0>
       < 0.0  0.0  0.0>
        -1.0
    }

#declare Connector_1 = 
   object {
      quadric {
         < 0.0  1.0  1.0>
         < 0.0  0.0  0.0>
         < 0.0  0.0  0.0>
          -1.0
      }
      clipped_by {
         plane { < 1.0  0.0  0.0> 1.0 }
         plane { <-1.0  0.0  0.0> 0.0 }
      }
   }

#declare Connector_2 =
   quadric {
      < 1.0 -1.0  1.0>
      < 0.0  0.0  0.0>
      < 0.0  0.0  0.0>
        0.0
      rotate < 0.0  0.0  90.0>
   }

/*----------------------------------------------------------------------------*/

#declare Trunk =
   composite {
      object {
         quadric {
            Dot
            scale     < 0.450000  0.450000  0.450000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.429273 }
            plane {     < 1.000000  0.000000  0.000000>  0.286182 inverse }
         }
         translate <-0.429273  0.000000  0.000000>
         scale     < 3.179797  1.000000  1.000000>
         translate <-0.135000  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  90.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.300000  0.300000  0.300000>
            translate < 0.000000  0.500000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.299548 }
            plane {     < 1.000000  0.000000  0.000000>  0.249623 inverse }
         }
         translate <-0.299548  0.000000  0.000000>
         scale     < 18.193405  1.000000  1.000000>
         translate <-0.016465  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  81.069858>
         rotate    < 0.000000 -135.000000  0.000000>
         translate < 0.000000  0.500000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.250000  0.250000  0.250000>
            translate <-0.100000  1.400000  0.100000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.249421 }
            plane {     < 1.000000  0.000000  0.000000>  0.199536 inverse }
         }
         translate <-0.249421  0.000000  0.000000>
         scale     < 14.662878  1.000000  1.000000>
         translate <-0.017010  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  72.284528>
         rotate    < 0.000000  116.565051  0.000000>
         translate <-0.100000  1.400000  0.100000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.200000  0.200000  0.200000>
            translate <-0.200000  2.100000 -0.100000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.199797 }
            plane {     < 1.000000  0.000000  0.000000>  0.149847 inverse }
         }
         translate <-0.199797  0.000000  0.000000>
         scale     < 22.158520  1.000000  1.000000>
         translate <-0.009017  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  82.673963>
         rotate    < 0.000000 -45.000000  0.000000>
         translate <-0.200000  2.100000 -0.100000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.150000  0.150000  0.150000>
            translate <-0.100000  3.200000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 1.122497  0.150000  0.150000>
         rotate    < 0.000000  0.000000  78.509540>
         rotate    < 0.000000  26.565051  0.000000>
         translate <-0.100000  3.200000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.150000  0.150000  0.150000>
            translate < 0.100000  4.300000 -0.100000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 1.204159  0.150000  0.150000>
         rotate    < 0.000000  0.000000  85.236358>
         rotate    < 0.000000 -90.000000  0.000000>
         translate < 0.100000  4.300000 -0.100000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 0.150000  0.150000  0.150000>
            translate < 0.100000  5.500000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      bounded_by {
         quadric {
            Dot
            scale < 3.427255  3.427255  3.427255>
            translate < 0.000000  2.600000  0.000000>
         }
      }
   }


#declare LeafTex =
texture {
//  image_map { 2 <1 -1 0> gif "leaf1.gif" alpha 5 1 interpolate 4 }
  bozo
  turbulence .5
  color_map {
  [0 .2 color Clear color Clear]
  [.2 .3 color Black color DarkGreen]
  [.3 .7 color HuntersGreen color DarkGreen]
  [.7 .9 color HuntersGreen color DarkGreen]
  [.9 1 color DarkGreen color Green]
  }
  scale <.1 .1 .1>
  translate <1 5.2 1>
  rotate <0 40 0>
  ambient .5
  diffuse .2
  .1
}



#declare Mass1 =
union {
  quadric { Sphere scale <2.1 2.6 2.4> translate <0 9.3 0> }
  quadric { Sphere scale <2.6 2.6 2.6> translate <0 7 0> }
}


#declare Slice1 =
object {
  difference {
    union { Mass1 }
      plane { <0 0 1> -2.1 inverse }
  }
	texture { LeafTex rotate <0 40 0>}
}

#declare Slice2 =
object {
  difference {
    union { Mass1 }
      plane { <0 0 1> -1.5  }
      plane { <0 0 1> -.9 inverse }
  }
	texture { LeafTex rotate <0 -25 0>}
}

#declare Slice3 =
object {
  difference {
    union { Mass1 }
      plane { <0 0 1> -.3  }
      plane { <0 0 1> .3 inverse }
  }
	texture { LeafTex }
}



//--- One Complete Tree
#declare Tree =
composite {
composite {
  object { Slice1 }
  object { Slice1 rotate <0 180 0> }
  object { Slice2 }
  object { Slice2 rotate <0 180 0> }
  object { Slice3 }
     bounded_by {
     box { UnitBox scale <2.8 4 2.8> translate <0 8 0> }
     }
  }
  composite { Trunk }
  scale <1.5 1.5 1.5>
  rotate <0 -50 0>
}




 













