//---- Atrium Parts & Building Materials


//--- Long Horizonal Frame
#declare Frame1 =
box { UnitBox scale <12 .15 .2> }

//--- Vertical Frame
#declare Frame2 =
box { UnitBox scale <.15 24 .2> }

//--- Short Horizonal Frame
#declare Frame3 =
box { UnitBox scale <4.15 .15 .2> }

//--- Vertical Frame
#declare Frame4 =
box { UnitBox scale <.15 7.5 .2> }

//--- Angle Frame
#declare AFrame1 =
box { UnitBox scale <15 .15 .2> translate <-15 0 0> rotate <0 0 39> }





//--- Top Arch Span
#declare Arch1 =
difference {
  quadric { Cylinder_Z scale <13 13 1> }
  plane { <0 1 0> 0 }
  plane { <0 0 1> -.2 }
  plane { <0 0 1> .2 inverse }
  quadric { Cylinder_Z scale <11.85 11.85 1> }
}


//--- Arch Divider 1
#declare Div1 =
box { UnitBox scale <6 .15 .2> translate <-6 0 0> }

//--- Arch Divider 2
#declare Div2 =
box { UnitBox scale <4 .15 .2> translate <-8 0 0> }

//--- Arch Divider 3
#declare Div3 =
box { UnitBox scale <2 .15 .2> translate <-10 0 0> }


//---Interior Arches
#declare InArch =
object {
 union {
  difference { Arch1 }
    box { UnitBox scale <.5 1.5 .2> translate <12.5 -1.5 0> }
    box { UnitBox scale <.5 1.5 .2> translate <-12.5 -1.5 0> }
  }
      texture { FrameColor }
	bounded_by {
	box { UnitBox scale <13 9 1> translate <0 5 0> }
	}
} 




//--- Front Entrance Face
#declare ENT1 =
composite {
 object {
  union {
    box { Frame2 translate <-12 24 0> }
    box { Frame2 translate <-8 24 0> }
    box { Frame2 translate <-4 24 0> }
    box { Frame2 translate <0 24 0> }
    box { Frame2 translate <4 24 0> }
    box { Frame2 translate <8 24 0> }
    box { Frame2 translate <12 24 0> }
  }
     texture { FrameColor }
	bounded_by {
	box { UnitBox scale <13 25 1> translate <0 24 0> }
	}
 }

 //--- Horizonal Frame around Door
 object {
  union {
    box { Frame3 translate <-8 0 0> }
    box { Frame3 translate <-8 3 0> }
    box { Frame3 translate <-8 6 0> }
    box { Frame3 translate <8 0 0> }
    box { Frame3 translate <8 3 0> }
    box { Frame3 translate <8 6 0> }
  }
     texture { FrameColor }
	bounded_by {
	box { UnitBox scale <13 4 1> translate <0 3 0> }
	}
 }

 object {
  union {
    box { Frame1 translate <0 9 0> }
    box { Frame1 translate <0 12 0> }
    box { Frame1 translate <0 15 0> }
    box { Frame1 translate <0 18 0> }
    box { Frame1 translate <0 21 0 > }
    box { Frame1 translate <0 24 0> }
  }
     texture { FrameColor }
	bounded_by {
	box { UnitBox scale <13 9 1> translate <0 17 0> }
	}
 }

 object {
  union {
    box { Frame1 translate <0 27 0> }
    box { Frame1 translate <0 30 0> }
    box { Frame1 translate <0 33 0> }
    box { Frame1 translate <0 36 0> }
    box { Frame1 translate <0 39 0> }
    box { Frame1 translate <0 42 0 > }
    box { Frame1 translate <0 45 0> }
    box { Frame1 translate <0 48 0> }
  }
     texture { FrameColor }
	bounded_by {
	box { UnitBox scale <13 12 1> translate <0 37.5 0> }
	}
 }

 //--- Tan Dividing Panel
 object {
   union {
    box { UnitBox scale <12 1.5 .01> translate <0 13.5 0> }
    box { UnitBox scale <12 1.5 .01> translate <0 28.5 0> }
  }
    texture { PanelColor }
 }

 //--- Arched Front Panel
 object {
  union { 
   difference { Arch1 translate <0 48 0> }
   difference {
     quadric { Cylinder_Z scale <8.15 8.15 1> }
     plane { <0 1 0> 0 }
     plane { <0 0 1> -.2 }
     plane { <0 0 1> .2 inverse }
     quadric { Cylinder_Z scale <7.85 7.85 1> }
     translate <0 48 0>
   }
   difference {
     quadric { Cylinder_Z scale <4.15 4.15 1> }
     plane { <0 1 0> 0 }
     plane { <0 0 1> -.2 }
     plane { <0 0 1> .2 inverse }
     quadric { Cylinder_Z scale <3.85 3.85 1> }
     translate <0 48 0>
   }
  }
    texture { FrameColor }
	bounded_by {
	box { UnitBox scale <13 7 1> translate <0 54.5 0> }
	}
 } 
 //--- Dividers for Arched Panel
 object {
   union {
    box { Div1 rotate <0 0 -51.428> }
    box { Div1 rotate <0 0 -128.57> }

    box { Div2 rotate <0 0 -25.71> }
    box { Div2 rotate <0 0 -77.142> }
    box { Div2 rotate <0 0 -102.856> }
    box { Div2 rotate <0 0 -154.284> }

    box { Div3 rotate <0 0 -12.857> }
    box { Div3 rotate <0 0 -38.571> }
    box { Div3 rotate <0 0 -64.28> }
    box { Div3 rotate <0 0 -90> }
    box { Div3 rotate <0 0 -115.71> }
    box { Div3 rotate <0 0 -141.42> }
    box { Div3 rotate <0 0 -167.14> }

    translate <0 48 0>

  }
    texture { FrameColor }
	bounded_by {
	box { UnitBox scale <13 7 1> translate <0 54.5 0> }
	}
 } 



 //--- Arched Glass
 object {
   difference {
     quadric { Cylinder_Z scale <12 12 1> }
     plane { <0 1 0> 0 }
     plane { <0 0 1> -.01 }
     plane { <0 0 1> .01 inverse }
   }
   translate <0 48 0>
      texture { GlassColor }
	bounded_by {
	box { UnitBox scale <13 7 1> translate <0 54.5 0> }
	}
 } 

 //--- Front Glass
 object {
  box { UnitBox scale <12 24 .01> translate <0 24 0> }
      texture { GlassColor }
 } 


 //--- Additional Frame under arch
 object {
  union {
    box { UnitBox scale <.5 1.5 .2> translate <12.5 46.5 0> }
    box { UnitBox scale <.5 1.5 .2> translate <-12.5 46.5 0> }
  }
      texture { FrameColor }
	bounded_by {
	box { UnitBox scale <13 2 1> translate <0 46.5 0> }
	}
 } 
}    

//--- Front Face of left Wing
#declare LWing =
composite {
  object {
   union {
     box { Frame3 translate <-4 0 0> }
     box { Frame3 translate <-4 3 0> }
     box { Frame3 translate <-4 6 0> } 
     box { Frame3 translate <-4 9 0> }
     box { Frame3 translate <-4 12 0> }
     box { Frame3 translate <-4 15 0> }
     box { Frame4 translate <-4 7.5 0> }
     box { Frame4 translate <-8 7.5 0> }
     box { UnitBox scale <4 1.5 .01>  translate <-4 13.5 0> }
   }     
      texture { FrameColor }
	bounded_by {
	box { UnitBox scale <4.2 8.3 1> translate <-4 7.3 0> }
	}
 } 

  object {
     box { UnitBox scale <4 1.5 .01>  translate <-4 13.5 0> }
      texture { PanelColor }
 } 




  object {
   union {
     box { AFrame1 translate <-8 15 0> }
     box { AFrame1 translate <-8 12 0> }
     box { AFrame1 translate <-8 9 0> }
     box { AFrame1 translate <-8 6 0> }
     box { AFrame1 translate <-8 3 0> }
     box { UnitBox scale <.15 5.8 .2> translate <-12 5.8 0> }
     box { UnitBox scale <.15 4.2 .2> translate <-16 4.2 0> }
     box { UnitBox scale <.15 2.6 .2> translate <-20 2.6 0> }
   }     
      texture { FrameColor }
	bounded_by {
	box { UnitBox scale <9.5 7.8 1> translate <-17.3 7.8 0> }
	}
 } 

  object {
   union {
     triangle { <-8 15 0> <-8 11.8 0> <-26.4 0 0> }
     triangle { <-26.4 0 0> <-22.6 0 0> <-8 11.8 0> }
   }     
      texture { PanelColor }
	bounded_by {
	box { UnitBox scale <9.5 7.8 1> translate <-17.3 7.8 0> }
	}
 } 



}

//--- Glass for Left Wing
#declare WGlass =
object {
  union {
    triangle { <-22.6 0 0> <-8 11.8 0> <0 11.8 0> }
    triangle { <-22.6 0 0> <0 0 0> <0 11.8 0> }
  }
     texture { GlassColor }
}



//--- Glass for Arched Ceiling
#declare ACGlass =
object {
  difference {
    quadric { Cylinder_Z scale <12.8 12.8 1> }
    plane { <0 1 0> 0 }
    plane { <0 0 1> -15 }
    plane { <0 0 1> 15 inverse }
    quadric { Cylinder_Z scale <12.7 12.7 1> }
  }
translate <0 48 0>
     texture { GlassColor }
}




#declare LeftWing =
composite {
  composite { LWing translate <0 0 -5> }
  composite { LWing translate <0 0 5> }
  object { WGlass translate <0 0 -5> }
  object { WGlass translate <0 0 5> }
  object { WGlass translate <0 0 -4.95> }
  object { WGlass translate <0 0 4.95> }


  //--- Roof Patch
  object {
    union {
     triangle { <0 15 -5> <-8 15 -5> <-8 15 5> }
     triangle { <0 15 -5> <0 15 5> <-8 15 5> }
     triangle { <-26.4 0 -5> <-8 15 -5> <-8 15 5> }
     triangle { <-26.4 0 -5> <-26.4 0 5> <-8 15 5> }
    }
      texture { RoofColor }
	bounded_by {
	box { UnitBox scale <14 8 6> translate <-13.4 7.6 0> }
	}
  }
	bounded_by {
	box { UnitBox scale <14 8 6> translate <-13.4 7.6 0> }
	}
}

//--- Front Side Walls
#declare FSWalls =
object {
   union {
    box { UnitBox scale <.1 15 15> translate <-12 15 0> }
    box { UnitBox scale <.1 15 15> translate <12 15 0> }
    box { UnitBox scale <.1 7.5 10> translate <-12 37.5 5> }
    box { UnitBox scale <.1 7.5 10> translate <12 37.5 5> }
    box { UnitBox scale <.1 1.5 15> translate <-12.8 46.5 0> }
    box { UnitBox scale <.1 1.5 15> translate <12.8 46.5 0> }
   }
      texture { RoofColor }
	bounded_by {
	box { UnitBox scale <13 25 16> translate <0 24.5  0> }
	}
}


//---  Side Glass on Arch
#declare SGWalls =
object {
   union {
    box { UnitBox scale <.1 1.5 15> translate <-12.8 46.5 0> }
    box { UnitBox scale <.1 1.5 15> translate <12.8 46.5 0> }
   }
      texture { GlassColor }
	bounded_by {
	box { UnitBox scale <13 25 16> translate <0 24.5  0> }
	}
}




//----------- Starts Lower Left Wing "Round Ends"

//--- Round Rib   
#declare RRib =
object {
  difference {
    quadric { Cylinder_Y scale <9 1 9> }
    plane { <0 1 0> -.15 }
    plane { <0 1 0> .15 inverse }
    plane { <0 0 1> 0 inverse }
    quadric { Cylinder_Y scale <8.8 1 8.8> }    
  }
     texture { FrameColor }
	bounded_by {
	box { UnitBox scale <9.2 .2 5> translate <0 0 -4.5> }
   	}
}

//--- Solid Rib Panel
#declare RRPanel =
object {
  difference {
    quadric { Cylinder_Y scale <8.85 1 8.85> }
    plane { <0 1 0> -1.5 }
    plane { <0 1 0> 1.5 inverse }
    plane { <0 0 1> 0 inverse }
    quadric { Cylinder_Y scale <8.8 1 8.8> }    
  }
     texture { PanelColor }
	bounded_by {
	box { UnitBox scale <9.2 2 5> translate <0 0 -4.5> }
   	}
}


//--- Vertical Frame
#declare Frame6 =
object {
 box { UnitBox scale <.15 15 .2> translate <0 15 -9> }
   texture { FrameColor }
}

//--- Vertical Frame
#declare Frame7 =
object {
 box { UnitBox scale <.2 15 .15> translate <0 15 0> }
   texture { FrameColor }
}

//--- Scaleable Panel
#declare SCPanel =
object {
 box { UnitBox scale <.15 1.5 1> }
   texture { PanelColor }
}

//--- Scaleable Glass
#declare SCGlass =
object {
 box { UnitBox scale <.05 15 1> }
   texture { GlassColor }
}



//--- Scaleable Rib
#declare SCRib =
object {
 box { UnitBox scale <.2 .15 1> }
   texture { FrameColor }
}


//---- Round Corner Building Section
#declare RoundF =
composite {
  object { RRib translate <0 0 0> }
  object { RRib translate <0 3 0> }
  object { RRib translate <0 6 0> }
  object { RRib translate <0 9 0> }
  object { RRib translate <0 12 0> }
  object { RRib translate <0 15 0> }
  object { RRib translate <0 18 0> }
  object { RRib translate <0 21 0> }
  object { RRib translate <0 24 0> }
  object { RRib translate <0 27 0> }
  object { RRib translate <0 30 0> }

  object { RRPanel translate <0 28.5 0> }
  object { RRPanel translate <0 13.5 0> }

  object { Frame6 rotate <0 0 0> }
  object { Frame6 rotate <0 -30 0> }
  object { Frame6 rotate <0 -60 0> }
  object { Frame6 rotate <0 -90 0> }
  object { Frame6 rotate <0 30 0> }
  object { Frame6 rotate <0 60 0> }
  object { Frame6 rotate <0 90 0> }

  //RoundGlass 
  object {
   difference {
    quadric { Cylinder_Y scale <8.82 1 8.82> }
    plane { <0 1 0> -15 }
    plane { <0 1 0> 15 inverse }
    plane { <0 0 1> 0 inverse }
    quadric { Cylinder_Y scale <8.8 1 8.8> }    
   }
     texture { GlassColor }
	bounded_by {
	box { UnitBox scale <9.2 16 5> translate <0 0 -4.5> }
   	}
  translate <0 15 0>
  }

	bounded_by {
	box { UnitBox scale <9.2 16 5> translate <0 15.5 -4.5> }
   	}
}








