//---- Room & Counter for Meat Grinder
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

//------ Tile Counter Top

#declare Tile1Texture =
texture {
  pigment { color rgb <0.72, 0.65, 0.59> }
  finish { ambient 0.1 phong 1 diffuse 0.4 reflection 0.35 }
}  

#declare TT1 =
union {
  object { Disk_X scale <25,  2, 2> translate y*-25 }
  object { Disk_X scale <25,  2, 2> translate y*25 }
  object { Disk_Y scale < 2, 25, 2> translate x*25 }
  object { Disk_Y scale < 2, 25, 2> translate x*-25 }
  sphere { 0, 2 translate <-25, -25, 0> }
  sphere { 0, 2 translate <-25,  25, 0> }
  sphere { 0, 2 translate < 25, -25, 0> }
  sphere { 0, 2 translate < 25,  25, 0> }
  triangle { <-25, -25, -2>, <-25, 25, -2>, <25, -25, -2> }
  triangle { <-25,  25, -2>, < 25, 25, -2>, <25, -25, -2> }
  bounded_by { box { -1, 1 scale <28, 28, 4> } }
}

#declare Tile1 =
object { TT1 texture { Tile1Texture } rotate x*90 scale <1.8, 1, 1.8> }

#declare Tile55 =
union {
  object { Tile1 translate <450, 0, -450> }
  object { Tile1 translate <450, 0, -350> }
  object { Tile1 translate <450, 0, -250> }
  object { Tile1 translate <450, 0, -150> }
  object { Tile1 translate <450, 0, -50> }
  object { Tile1 translate <350, 0, -450> }
  object { Tile1 translate <350, 0, -350> }
  object { Tile1 translate <350, 0, -250> }
  object { Tile1 translate <350, 0, -150> }
  object { Tile1 translate <350, 0, -50> }
  object { Tile1 translate <250, 0, -450> }
  object { Tile1 translate <250, 0, -350> }
  object { Tile1 translate <250, 0, -250> }
  object { Tile1 translate <250, 0, -150> }
  object { Tile1 translate <250, 0, -50> }
}

#declare Counter =
box { -1, 1 
  scale <500, 15, 500>
  texture { pigment { color Gray10 } finish { ambient 0.1 diffuse 0.6 } }
}

#declare Reflect =
union {
  //--- front wall
  plane { x, 5000
    texture {
      pigment { color Black }
      finish { ambient 0.7 diffuse 0.3 }
    }
  }
  //--- world
  sphere { 0, 50000
    texture {
      pigment { color MidnightBlue }
      finish { ambient 0.1 diffuse 0.1 }
    }
  }
  //--- Cieling
  plane { y, 1500
    texture {
      pigment { color White }
      finish { ambient 0.3 diffuse 0.5 }
    }
  }
}    

//--- Out-of-Focus Background
#declare Blur =
box { -1, 1
  scale <1000, 1000, 1>
  texture {
    pigment { image_map { gif "blur.gif" interpolate 4 } }
    finish { ambient 0.3 diffuse 0.2 }
    scale <2000, 2000, 1>
    translate <-1000, -1000, 1>
  }
}