//------ Meat Grinder with Eyeballs  ...10/22/92 M.Miller
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

global_settings {
  //assumed_gamma 1
  //ambient_light 0
  max_trace_level 20
}

#version 3.1;

#include "colors.inc"
#include "shapes.inc"
#include "grind.inc"
#include "room.inc"
#include "eyes.inc"
#include "chuck.inc"
#include "fork.inc"

camera {
  location <60, 400, -900>
  direction z*4
  up y
  right x*image_width/image_height
  look_at <60, 20, 0>
}

light_source { < 500, 1270, -3360> color White }
light_source { < 200,  270, -1360> color White }
light_source { <-700,  770,  -360> color Gold }
light_source { <-100, 1500,  1060> color Red }

union {
  object { Grinder }
  object { Counter translate <-378, -129, 400> }
  object { Tile55 translate <-378, -114, 400> }
  object { Eyes }
  object { Reflect }
  object { Eye1 rotate y*10 rotate x*30 translate <-10, -97, 70> }
  object { Eye_Fork rotate y*-20 translate <55, -112, 190> }
  rotate y*-50
}

object { Blur scale <1.1, 0.83, 1.1> rotate x*21 translate <60, -2050, 4800> }