//--- Meat Grinder ....... 8/26/81
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

//--- Main Grinder Texture
#declare MG =
texture {
  pigment { colour Gray }
  finish { ambient 0.1 diffuse 0.6 phong 1 phong_size 50 crand 0.02 brilliance 8 reflection { 0.6 } metallic }
  normal { bumps 0.1 scale 0.5 }
}

#declare Steel =
texture {
  pigment { colour Gray }
  finish { ambient 0.2 diffuse 0.4 phong 0.7 phong_size 40 crand 0.03 brilliance 3 reflection { 0.2 } }
}

//--- K/O 
#declare C1 = texture { pigment { colour Clear } }

//--- Nixxer
#declare Null = texture { pigment { colour Black } }

#declare PlateTexture =
texture {
  material_map {
    gif "perf.gif" 
    texture { Null }
    texture { C1 }
    texture { Steel }
  }
  scale <70, 70, 1>
  translate <-35, -35, 0>
}

#declare Eye1_Tex =
texture {
  pigment { image_map { gif "iris.gif" } }
  finish { ambient 0.1 diffuse 0.4 phong 1 phong_size 80 reflection { 0.15 } }
  scale <30, 30, 1>
  translate <-15, -15, 0>
}

#declare Eye2_Tex =
texture {
  pigment { image_map { gif "iris2.gif" } }
  finish { ambient 0.1 diffuse 0.4 phong 1 phong_size 80 reflection { 0.15 } }
  scale <30, 30, 1>
  translate <-15, -15, 0>
}

#declare Eye3_Tex =
texture {
  pigment { image_map { gif "iris3.gif" } }
  finish { ambient 0.1 diffuse 0.4 phong 1 phong_size 80 reflection { 0.15 } }
  scale <30, 30, 1>
  translate <-15, -15, 0>
}

//--- Dan's DFM03
#declare Wood7 =
texture {
  pigment {
    wood
    turbulence 0.08
    octaves 5
    scale <0.05, 0.05, 1>
    colour_map {
      [0 0.1   colour rgb <0.52, 0.37, 0.26> colour rgb <0.52, 0.37, 0.26>]
      [0.1 0.9 colour rgb <0.52, 0.37, 0.26> colour rgb <0.42, 0.26, 0.15>]
      [0.9 1   colour rgb <0.42, 0.26, 0.15> colour rgb <0.42, 0.26, 0.15>]
    }
  }
  finish { ambient 0.1 phong 1 reflection { 0.1 } phong_size 80 }
  scale <59, 33, 34>
  rotate y*20
}

//------- CTDS 
#declare Dot = sphere { 0, 1 }
//quadric { 1, 0, 0, -1.0 }

#declare Connector_1 = 
intersection {
  quadric { <0, 1, 1>, 0, 0, -1 }
  plane { x, 0 inverse }
  plane { x, 1}
}

#declare Connector_2 = quadric { <1, -1, 1>, 0, 0, 0 rotate z*90 }

//---- Grinder Parts
//---- Inner wall of mouth
#declare S2 = quadric { <0.002267573696145, -0.000827711954013, 0.002267573696145>, 0, 0, -1 }

//----- Torus for round cornering change plate
#declare T1 = 
quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -2500, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 2400, 0, 0, 0, 0, 1, 0, -2500, 0, 1440000> }

//---- Torus ring for mouth
#declare T2 = 
quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -4264, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 4200, 0, 0, 0, 0, 1, 0, -4264, 0, 4410000> }

#declare T3 = 
quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -71474, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 71410, 0, 0, 0, 0, 1, 0, -71474, 0, 1274847025.000001> }

#declare T4 = 
quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -78130, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 77106, 0, 0, 0, 0, 1, 0, -78130, 0, 1486333809.000001> }

#declare T5 = 
quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -240010, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 238854, 0, 0, 0, 0, 1, 0, -240010, 0, 14262808329.00001> }

#declare T6 = 
quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -163.25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 143, 0, 0, 0, 0, 1, 0, -163.25, 0 5112.25> }


#declare Scoop1 =
union {
  object { Cylinder_Z scale <42, 42, 1> translate y*84 }
  object { QCone_Z scale <50, 50, 52> translate <0, 84, 36> }
}

//--- Nubs on Change Plate
#declare Nub = sphere { 0, 1 scale <5, 3, 3> translate <0, 38, -10> }

//--- Ribs on main body
#declare Rib1 = object { Cylinder_X scale <1, 5, 12> rotate z*-6 translate y*38 }

//--- Corners for Top Clamp 
#declare Corner = object { Disk_Y scale 5 }

//---- Mouth of Meat Grinder ( where the meat go'th in)
#declare Mouth =
object {
  union {
    intersection {
      quadric { <0.001479289940828, -0.000627213044721, 0.001479289940828>, 0, 0, -1 }
      plane { y, 61.964979622397252 }
      plane { y, -0.035020377602745 inverse }
      object { S2 inverse }
    }
    intersection {
      object { T2 translate y*61.964979622397252 }
      object { S2 inverse }
    }
  }
  translate y*0.035020377602745
  texture { MG }
  bounded_by { sphere { 0, 62 translate y*31 } }
}

//--- Front Ring
#declare F_Ring =
union {
  object {
    union {
      difference {
        object { Disk_Z scale <46, 46, 10> }
        object { Scoop1 }
        object { Scoop1 rotate z*40 }
        object { Scoop1 rotate z*80 }
        object { Scoop1 rotate z*120 }
        object { Scoop1 rotate z*160 }
        object { Scoop1 rotate z*200 }
        object { Scoop1 rotate z*240 }
        object { Scoop1 rotate z*280 }
        object { Scoop1 rotate z*320 }
        object { Cylinder_Z scale <35, 35, 1> }
      }
      object { T1 rotate x*90 translate z*-5 }
      object { Nub rotate z*60 }
      object { Nub rotate z*-60 }
      object { Nub rotate z*180 }
    }
    texture { MG }
    bounded_by { box { -1, 1 scale <47, 47, 14> } }
  }
  //--- Perferated Plate where the GROUND MEAT comes out!
  object {
    union {
      object { Disk_Z scale <35, 35, 1> }
      sphere { 0, 1 scale <5, 5, 2> translate z*-1 }
    }
    texture { PlateTexture }
    translate z*-4
  }   
  //--- Shadow Plate
  object { Disk_Z scale <35, 35, 1>
    texture { pigment { colour Black } }
    translate -z
  }   
  bounded_by { box { -1, 1 scale <47, 47, 14> } }
}

//--- Body
#declare Body =
object {
  difference {
    union {
      object { QCone_X scale <550, 40, 40> translate x*550 }
      object { Rib1 }
      object { Rib1 rotate x*45 }
      object { Rib1 rotate x*90 }
      object { Rib1 rotate x*135 }
      object { Rib1 rotate x*180 }
      object { Rib1 rotate x*225 }
      object { Rib1 rotate x*270 }
      object { Rib1 rotate x*315 }
    }
    plane { x, 0 }
    plane { x, 131 inverse }
  }
  texture { MG }
  bounded_by { box { -1, 1 scale <80, 50, 50> translate x*68 } }
  scale <1, 0.9, 0.9>
}

#declare Support =
union {
  intersection {
    object { T3 rotate x*90 scale <1, 1, 4> translate <-55, -147, 0> }
    plane { y, 0 }
    plane { y, -164 inverse }
  }
  intersection {
    object { T4 rotate x*90 scale <1, 1, 0.2> translate <-55, -147, 0> }
    plane { y, 0 }
    plane { y, -164 inverse }
  }
  texture { MG }
  bounded_by { box { -1, 1 scale <50, 75, 20> translate <123, -94, 0> } }
}

#declare Top_Clamp =
union {
  object { Corner translate <-33, 0, -15> }
  object { Corner translate < 33, 0, -15> }
  object { Corner translate <-33, 0, -11> }
  object { Corner translate < 33, 0, -11> }
  object { Corner translate <-21, 0,  15> }
  object { Corner translate < 21, 0,  15> }
  box { -1, 1 scale <38, 5, 13> translate z*-2 }
  box { -1, 1 scale <33, 5, 18> translate z*-2 }
  box { -1, 1 scale <21, 5,  5> translate z*15 }
  texture { MG }
  bounded_by { box { -1, 1 scale <40, 6, 22> } }
}

#declare Handle =
union {
  union {
    object {
      difference {
        object { T5 rotate x*90 translate <-179, -123, 0> }
        object { Cylinder_Z scale <363, 363, 1> translate <-191, -145, 0> }
        plane { y, -16 inverse }
        plane { y, -164 }
      }
      texture { MG }
      bounded_by { box { -1, 1 scale <40, 106, 20> translate <164, -82, 0> } }
      scale <1, 1, 0.5>
    }
    object {
     union {
       object { Disk_X scale <10, 16, 16> translate x*158 }
       object { Disk_X scale < 5, 16, 16> translate x*140 }
       object { Disk_X scale < 6,  8,  8> translate <176, -172, 0> }   
       object { T6 rotate x*90 translate x*186 }
     }
     texture { MG }
     bounded_by { box { -1, 1 scale <40, 106, 20> translate <164, -82, 0> } }
   }
   bounded_by { box { -1, 1 scale <40, 106, 20> translate <164, -82, 0> } }
  }
  object { 
    union { 
      intersection {
        object { QCone_X scale <200, 12, 12> translate <64, -172, 0> }
        plane { x, 264 }
        plane { x, 184 inverse }
      }
      intersection {
        object { QCone_X scale <24, 12, 12> translate <208, -172, 0> }
        plane { x, 208 }
        plane { x, 184 inverse }
      }
      object { Disk_X scale <1, 12, 12> translate <183, -172, 0> }
      sphere {0, 1 scale <6, 12, 12> translate <264, -172, 0> }
    }
    texture { Wood7 }
    bounded_by { box { -1, 1 scale <46, 14, 14> translate <226, -172, 0> } }
  }
  rotate x*30
}  

//--- Complete Grinder
#declare Grinder =
union {
  object { F_Ring rotate y*90 }
  object { Body }
  object { Mouth scale <1, 1, 1.3> translate <98, 19, 0> }
  object { Support }
  object { Top_Clamp rotate y*90 scale <1, 0.5, 1> translate <108, -111, 0> }
  object { Handle }
  bounded_by { box { -1, 1 scale <145, 155, 140> translate <131, -57, 0> } }
}