//---- A Silver Fork & Eyeball 
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare Silver =
texture {  
  pigment { colour Gray }
  finish { crand 0.02 ambient 0.3 diffuse 0.6 reflection { 0.55 } brilliance 8 specular 0.5 metallic }
}

#declare Slot = object { Cylinder_Y scale <15, 1, 0.7> }

#declare Joint =
difference {
  object { Cylinder_Z scale <8.5, 5, 1> translate <-13.5, 1, 0> }
  object { Cylinder_Z scale <8, 4.6, 1> translate <-13.5, 1, 0> }
  plane { x, -13.5 }
  plane { x, -6 inverse }
  plane { z, 2 inverse }
  plane { z, -2 }
  plane { y, 1 }
  object { Cylinder_Y scale <3, 1, 1> translate <-13.5, 0, 2>  }
  object { Cylinder_Y scale <3, 1, 1> translate <-13.5, 0, -2>  }
  object { Cylinder_Y scale <5, 1, 5> translate <-8, 0, -6> }
  object { Cylinder_Y scale <5, 1, 5> translate <-8, 0, 6> }
}

#declare Stem =
difference {
  union {
    box { -1, 1 scale <24, 0.25, 1> translate <-37.5, 5.75, 0> }
    sphere { 0, 1 scale <1, 0.5, 1> translate <-61.5, 5.75, 0> }
    sphere { 0, 1 scale <1, 0.5, 1> translate <-62, 5.75, 0> }
    box { -1, 1 scale <22.5, 0.25, 10> translate <-36, 5.75, 0> }
    sphere { 0, 1 scale <3, 0.5, 1.5> translate <-58.5, 5.75, 1.3> }
    sphere { 0, 1 scale <3, 0.5, 1.5> translate <-58.5, 5.75, -1.3> }
  }
  object { Cylinder_Y scale <158, 1, 43.5> translate <-13.5, 0, 44.5>  }
  object { Cylinder_Y scale <158, 1, 43.5> translate <-13.5, 0, -44.5>  }
}

#declare Fork = 
object {
  union {
    difference {
      object { Cylinder_Z scale <15, 9.5, 1> rotate z*30 translate <6, 11.5, 0> }
      object { Cylinder_Z scale <14.5, 9, 1> rotate z*30 translate <6, 11.5, 0> }  
      plane { y, 10 inverse }
      plane { z, 0 rotate y*-5 translate z*-5 }
      plane { z, 0 rotate y*5 translate z*5 inverse }
      plane { x, -6 }
      object { Slot translate <18, 0, -2.2> }
      object { Slot translate <18, 0, 2.2> }
      object { Slot translate <18, 0, 0> }
      object { Cylinder_Y scale <5, 1, 5> translate <-8, 0, -6> }
      object { Cylinder_Y scale <5, 1, 5> translate <-8, 0, 6> }
    }
    object { Joint }
    object { Stem }
  }
  texture { Silver }
  bounded_by { box { -1, 1 scale <42 7.7 10> translate <-22 5 0> } }
}

#declare QA = color rgbf <1, 0.8, 0.8, 1>;

//--- Clearish bloody puddle
#declare Blob1 =
union {
  sphere { 0, 1 translate <-0.6, 0.2, 0> }
  sphere { 0, 1 translate <0.6, 0.2, 0> }
  sphere { 0, 1 translate y*-0.6 }
  texture {
    pigment {
      bozo
      turbulence 0.5
      color_map {
        [0 0.5 color Clear color QA]
        [0.5 1 color QA color Clear]
      }
    }
    finish { reflection { 0.3 } ambient 0.5 phong 0.2 /* refraction 0.9 */}
    scale <0.3, 0.2, 0.3>
  }
  scale <14, 18, 1.3> 
}

#declare Eye_Fork =
union {
  object { Fork rotate z*5 scale 2.2 }
  object { Eye1 rotate y*-30 rotate z*-30 translate <40, 20, 0> }
  object { Blob1 rotate x*90 rotate y*50 translate x*45 }
}