//--- Stack 'O' EyeBalls
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare Eye1_Tex =
texture {
  pigment { image_map { gif "iris.gif" } }
  finish { ambient 0.1 diffuse 0.4 phong 1 phong_size 80 reflection { 0.15 } }
  scale <30, 30, 1>
  translate <-15, -15, 0>
}

#declare Eye2_Tex =
texture {
  pigment { image_map { gif "iris2.gif" } }
  finish { ambient 0.1 diffuse 0.4 phong 1 phong_size 80 reflection { 0.15 } }
  scale <30, 30, 1>
  translate <-15, -15, 0>
}

#declare Eye3_Tex =
texture {
  pigment { image_map { gif "iris3.gif" } }
  finish { ambient 0.1 diffuse 0.4 phong 1 phong_size 80 reflection { 0.15 } }
  scale <30, 30, 1>
  translate <-15, -15, 0>
}

//--- Blue Eyes
#declare Eye1 = sphere { 0, 15 texture { Eye1_Tex } rotate y*60 }

//--- Brown Eyes
#declare Eye2 = sphere { 0, 15 texture { Eye2_Tex } rotate y*60 }

//--- Brown Eyes
#declare Eye3 = sphere { 0, 15 texture { Eye3_Tex } rotate y*60 }

#declare Eyes =
union {
  union {
    object { Eye2 rotate y*20  rotate x*20 translate <-1, 0, -43> }
    object { Eye1 rotate y*-10 rotate x*10 translate <-23, 0, -23> }
    object { Eye2 rotate y*5   rotate x*5  translate <5, 0, -15> }
    object { Eye1              rotate x*20 translate x*31 }
    object { Eye2 rotate y*10  rotate x*30 translate <5, 0, 13> }
    object { Eye2 rotate y*30  rotate x*-5 translate <13, 0, 39> }
    object { Eye3 rotate y*-20 rotate x*10 translate <-17, 0, 31> }
    object { Eye2 rotate y*-15 rotate x*25 translate <-31, 0, 5> }
    translate <98, 82, 0>
   }
  union {
    object { Eye3 rotate x*10  translate <-7, 0, -23> }
    object { Eye2 rotate y*-10 rotate x*20 translate <25, 0, -27> }
    object { Eye2 rotate y*-5  rotate x*-5 translate x*15 }
    object { Eye1 rotate y*-20 rotate x*-7 translate <-13, 0, 5> }
    object { Eye1 rotate y*20  rotate x*16 translate z*31 }
    translate <98, 102, 0>
  }
  union {
    object { Eye3 rotate y*10  rotate x*25 translate <-1, 0, -7> }
    object { Eye2 rotate y*-20 rotate x*40 translate <11, 0, 21> }
    translate <98, 122, 0>
  }
  bounded_by { box { -1, 1 scale <50, 50, 70> translate <98, 100, 0> } }
}