//--- Meat Grinder ....... 8/26/81


//--- Main Grinder Texture

#declare MG =
texture {
	color Gray
	ambient .1
	diffuse .6
	phong 1
	phong_size 50
	.02
	bumps .1
	scale <.5 .5 .5>
	brilliance 8
	reflection .6
	metallic
}

#declare Steel =
texture {
	color Gray
	ambient .2
	diffuse .4
	phong .7
	phong_size 40
	.03
	brilliance 3
	reflection .2
}


//--- K/O 
#declare C1 =
texture {
	color Clear
}

//--- Nixxer
#declare Null =
texture { color Black }


#declare PlateTexture =
texture {
	material_map {  <1 -1 0> gif "perf.gif" 
	texture { Null }
	texture { C1 }
	texture { Steel }
        }
	scale <70 70 1>
	translate <-35 -35 0>
}


#declare Eye1_Tex =
texture {
	image_map {  <1 -1 0> gif "iris.gif" }
	scale <30 30 1>
	translate <-15 -15 0>
	ambient .1
	diffuse .4
	phong 1
	phong_size 80
	reflection .15
	rotate <0 0 0>
}

#declare Eye2_Tex =
texture {
	image_map {  <1 -1 0> gif "iris2.gif" }
	scale <30 30 1>
	translate <-15 -15 0>
	ambient .1
	diffuse .4
	phong 1
	phong_size 80
	reflection .15
	rotate <0 0 0>
}

#declare Eye3_Tex =
texture {
	image_map {  <1 -1 0> gif "iris3.gif" }
	scale <30 30 1>
	translate <-15 -15 0>
	ambient .1
	diffuse .4
	phong 1
	phong_size 80
	reflection .15
	rotate <0 0 0>
}



//--- Dan's DFM03
#declare Wood7 = texture {
   wood
   turbulence 0.08
   octaves 5
   scale <0.05 .05 1>
   colour_map {
      [0.00 0.10 color red 0.52 green 0.37 blue 0.26
      color red 0.52 green 0.37 blue 0.26]
      [0.10 0.90 color red 0.52 green 0.37 blue 0.26
      color red 0.42 green 0.26 blue 0.15]
      [0.90 1.0  color red 0.42 green 0.26 blue 0.15
      color red 0.42 green 0.26 blue 0.15]
   }
   ambient .1
   phong 1
   reflection .1 
   phong_size 80
   scale <59 33 34> rotate <0 20 0>
}


//------- CTDS 

#declare Dot =
    quadric {
       < 1.0  1.0  1.0>
       < 0.0  0.0  0.0>
       < 0.0  0.0  0.0>
        -1.0
    }

#declare Connector_1 = 
   object {
      quadric {
         < 0.0  1.0  1.0>
         < 0.0  0.0  0.0>
         < 0.0  0.0  0.0>
          -1.0
      }
      clipped_by {
         plane { < 1.0  0.0  0.0> 1.0 }
         plane { <-1.0  0.0  0.0> 0.0 }
      }
   }

#declare Connector_2 =
   quadric {
      < 1.0 -1.0  1.0>
      < 0.0  0.0  0.0>
      < 0.0  0.0  0.0>
        0.0
      rotate < 0.0  0.0  90.0>
   }


//---- Grinder Parts

//---- Inner wall of mouth
#declare S2 =
         quadric {
            <0.002267573696145 -0.000827711954013 0.002267573696145>
            <0.000000000000000  0.000000000000000 0.000000000000000>
            <0.000000000000000  0.000000000000000 0.000000000000000>
            -1.0
         }

//----- Torus for round cornering change plate
#declare T1 = 
   quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -2500.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        2400.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -2500.000000 0.000000 1440000.000000 >
   }

//---- Torus ring for mouth
#declare T2 = 
   quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -4264.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        4200.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -4264.000000 0.000000 4410000.000000 >
   }


#declare T3 = 
   quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -71474.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        71410.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -71474.000000 0.000000 1274847025.000001 >
   }

#declare T4 = 
   quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -78130.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        77106.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -78130.000000 0.000000 1486333809.000001 >
   }

#declare T5 = 
   quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -240010.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        238854.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -240010.000000 0.000000 14262808329.000010 >
   }

#declare T6 = 
   quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -163.250000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        143.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -163.250000 0.000000 5112.250000 >
   }


#declare Scoop1 =
union {
quadric { Cylinder_Z scale <42 42 1> translate <0 84 0> }
quadric { QCone_Z scale <50 50 52> translate <0 84 36> }
}

//--- Nubs on Change Plate
#declare Nub = 
quadric { Sphere scale <5 3 3> translate <0 38 -10> }

//--- Ribs on main body
#declare Rib1 = 
quadric { Cylinder_X scale <1 5 12> rotate <0 0 -6> translate <0 38 0> }

//--- Corners for Top Clamp 
#declare Corner = 
intersection { Disk_Y scale <5 5 5> }




//---- Mouth of Meat Grinder ( where the meat go'th in)
#declare Mouth =
  object {
    union {
      intersection {
         quadric {
            <0.001479289940828 -0.000627213044721 0.001479289940828>
            <0.000000000000000  0.000000000000000 0.000000000000000>
            <0.000000000000000  0.000000000000000 0.000000000000000>
            -1.0
         }
	 plane { <0.0 1.0 0.0> 61.964979622397252 }
         plane { <0.0 1.0 0.0> -0.035020377602745 inverse }
         quadric { S2 inverse }
      }
       intersection {
         quartic { T2 translate <0 61.964979622397252 0> }
         quadric { S2 inverse }
       }
    }
      translate <0.0 0.035020377602745 0.0>
      texture { MG }
         bounded_by {
         quadric { Sphere scale < 62 62 62> translate <0 31 0> }
         }
  }


//--- Front Ring
#declare F_Ring =
composite {

 object {
   union {
     difference {
       intersection { Disk_Z scale <46 46 10> }
	union { Scoop1 rotate <0 0 0> }
	union { Scoop1 rotate <0 0 40> }
	union { Scoop1 rotate <0 0 80> }
	union { Scoop1 rotate <0 0 120> }
	union { Scoop1 rotate <0 0 160> }
	union { Scoop1 rotate <0 0 200> }
	union { Scoop1 rotate <0 0 240> }
	union { Scoop1 rotate <0 0 280> }
	union { Scoop1 rotate <0 0 320> }
	quadric { Cylinder_Z scale <35 35 1> }
    }
        quartic { T1 rotate <90 0 0> translate <0 0 -5> }
	quadric { Nub rotate <0 0 60> }
	quadric { Nub rotate <0 0 -60> }
	quadric { Nub rotate <0 0 180> }
  }
	  texture { MG }
	    bounded_by {
	    box { UnitBox scale <47 47 14> }
	    }
 }

//--- Perferated Plate where the GROUND MEAT comes out!
 object {
  union {
   intersection { Disk_Z scale <35 35 1> }
   quadric { Sphere scale <5 5 2> translate <0 0 -1> }
  }
     texture { PlateTexture }
     translate <0 0 -4>
 }   

//--- Shadow Plate
 object {
   intersection { Disk_Z scale <35 35 1> }
     texture { color Black }
     translate <0 0 -1>
 }   
	    bounded_by {
	    box { UnitBox scale <47 47 14> }
	    }
}


//--- Body
#declare Body =
object {
   difference {
     union {
      quadric { QCone_X scale <550 40 40> translate <550 0 0> }
      quadric { Rib1 rotate <0 0 0> }
      quadric { Rib1 rotate <45 0 0> }
      quadric { Rib1 rotate <90 0 0> }
      quadric { Rib1 rotate <135 0 0> }
      quadric { Rib1 rotate <180 0 0> }
      quadric { Rib1 rotate <225 0 0> }
      quadric { Rib1 rotate <270 0 0> }
      quadric { Rib1 rotate <315 0 0> }
     }
    plane { <1 0 0> 0 }
    plane { <1 0 0> 131 inverse }
  }
     texture { MG }
	    bounded_by {
	    box { UnitBox scale <80 50 50> translate <68 0 0> }
	    }
scale <1 .9 .9>
}


#declare Support =
composite {
   object {
    union {
     intersection {
         quartic { T3 rotate <90 0 0> scale <1 1 4> translate <-55 -147 0> }
         plane { <0 1 0> 0 }
         plane { <0 1 0> -164 inverse }
     }
     intersection {
         quartic { T4 rotate <90 0 0> scale <1 1 .2> translate <-55 -147 0> }
         plane { <0 1 0> 0 }
         plane { <0 1 0> -164 inverse }
     }
    }
	texture { MG }
    }
	    bounded_by {
	    box { UnitBox scale <50 75 20> translate <123 -94 0> }
	    }
}
      

#declare Top_Clamp =
object {
  union {
    intersection { Corner translate <-33 0 -15> }
    intersection { Corner translate <33 0 -15> }
    intersection { Corner translate <-33 0 -11> }
    intersection { Corner translate <33 0 -11> }
    box { UnitBox scale <38 5 13> translate <0 0 -2> }
    box { UnitBox scale <33 5 18> translate <0 0 -2> }
    intersection { Corner translate <-21 0 15> }
    intersection { Corner translate <21 0 15> }
    box { UnitBox scale <21 5 5> translate <0 0 15> }
  } 
     texture { MG }
	    bounded_by {
	    box { UnitBox scale <40 6 22> }
	    }
}


#declare Handle =
composite {


composite {
 object {
   difference {
     quartic { T5 rotate <90 0 0> translate <-179 -123 0> }
     quadric { Cylinder_Z scale <363 363 1> translate <-191 -145 0> }
     plane { <0 1 0> -16 inverse }
     plane { <0 1 0> -164 }
   }
     texture { MG }
	    bounded_by {
	    box { UnitBox scale <40 106 20> translate <164 -82 0> }
	    }
 scale <1 1 .5>
 }

 object {
  union {
   intersection { Disk_X scale <10 16 16> translate <158 0 0> }
   intersection { Disk_X scale <5 16 16> translate <140 0 0> }
   intersection { Disk_X scale <6 8 8> translate <176 -172 0> }   
   quartic { T6 rotate <90 0 0> translate <186 0 0> }
  }
     texture { MG }
	    bounded_by {
	    box { UnitBox scale <40 106 20> translate <164 -82 0> }
	    }
 }
	    bounded_by {
	    box { UnitBox scale <40 106 20> translate <164 -82 0> }
	    }
 }


 object { 
   union { 
    intersection {
     quadric { QCone_X scale <200 12 12> translate <64 -172 0> }
     plane { <1 0 0> 264 }
     plane { <1 0 0> 184 inverse }
    }
    intersection {
     quadric { QCone_X scale <24 12 12> translate <208 -172 0> }
     plane { <1 0 0> 208 }
     plane { <1 0 0> 184 inverse }
    }
    intersection { Disk_X scale <1 12 12> translate <183 -172 0> }
    quadric { Sphere scale <6 12 12> translate <264 -172 0> }
   }
    texture { Wood7 }
	    bounded_by {
	    box { UnitBox scale <46 14 14> translate <226 -172 0> }
	    }
  }
  rotate <30 0 0>

}  


//--- Complete Grinder

#declare Grinder =
composite {
    composite { F_Ring rotate <0 90 0> }
    object { Body }
    object { Mouth scale <1 1 1.3> translate <98 19 0> }
    composite { Support }
    object { Top_Clamp rotate <0 90 0> scale <1 .5 1> translate <108 -111 0> }
    composite { Handle }
	    bounded_by {
	    box { UnitBox scale <145 155 140> translate <131 -57 0> }
	    }

}



	