//------ Kodak Film ...10/18/92 M.Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

global_settings {
  //assumed_gamma 1
  //ambient_light 0
  max_trace_level 20
}

#version 3.1;

#include "colors.inc"
#include "shapes.inc"
#include "film.inc"

camera {
   location <0, 150, -220>
   direction z*4
   up y
   right x*image_width/image_height
   look_at y*25
}

light_source { < 400, 1270,  -660 > color White }
light_source { <-700,  470, -1660 > color Gold }

object { Film rotate y*40 translate x*10 }
object { Film rotate y*-35 translate <-20, 0, 15> }

//--- World
sphere { 0, 20000
  hollow on
  pigment { color Gray }
}

//--- Floor
plane { y, 0
  pigment { 
    color DimGray 
  }
  finish {
    ambient 0.1 
    reflection { 0.3 }
  }
}