//---- Film Canister & Film Strip
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare Film_Texture =
texture {
  pigment {
    image_map {
      gif "kodak.gif"
      interpolate 4
      map_type 2
    }
  }
  finish {
    ambient 0.3
    diffuse 0.6
    phong 1
    phong_size 100
    reflection { 0.2 }
  }
}

#declare Emultion =
texture {
  pigment { color rgb <0.7, 0.43, 0.38> }
  finish {
    ambient 0.2
    diffuse 0.5
    phong 1
    phong_size 100
    reflection { 0.15 }
  }
}

//-- K/O film strip
#declare Punch1 = box { -1, 1 scale <0.8, 1.5, 40> inverse translate y*14 }
#declare Punch2 = box { -1, 1 scale <0.8, 1.5, 40> inverse translate y*-14 }

//--- Canister
#declare Film =
union {
  object {
    union {
      union {
        cylinder { y, -y, 1 scale <12, 1, 12> translate y }
        cylinder { y, -y, 1 scale <11, 19, 11> translate y*21 }
        box { -1, 1 scale <1.5, 3, 0.5> translate <-4, 43, 0> }
        box { -1, 1 scale <1.5, 3, 0.5> translate <4, 43, 0> }
        box { -1, 1 scale <0.75, 19, 6> translate <-10.25, 21, 6> }
      }
      difference {
        cylinder { y, -y, 1 scale <12, 1, 12> translate y*41 }
        cylinder { y, -y, 1 scale <11, 15, 11> translate y*42 }
      }
      difference {
        cylinder { y, -y, 1 scale <6, 3.5, 6> translate y*43.5 }
        object { Cylinder_Y scale <5, 1, 5> }
      }
    }
    texture { Film_Texture scale <1, 47, 1> rotate y*-130 }
    bounded_by { box { -1, 1 scale <16, 25, 16> translate y*24 } }
  }

//--- Film_Strip 
  object {
    object { Cylinder_Y scale <20, 1, 20> }
    texture { Emultion }
    //--- would probable be easier with a cylinder material map
    clipped_by {
      box { -1, 1 scale <21, 17, 11> translate z*11 }
      object { Cylinder_Z scale <12.5, 12.5, 1> translate <9, -16.5, 0> inverse }
      plane { z, 0 rotate x*45 translate z*-13.9 inverse }
      box { -1, 1 scale <7.5, 12.5, 30> translate <16.5, -16.5, 0> inverse }
      object { Punch1 }
      object { Punch1 rotate y*10 }
      object { Punch1 rotate y*20 }
      object { Punch1 rotate y*30 }
      object { Punch1 rotate y*40 }
      object { Punch1 rotate y*50 }
      object { Punch1 rotate y*60 }
      object { Punch1 rotate y*70 }
      object { Punch1 rotate y*80 }
      object { Punch1 rotate y*-10 }
      object { Punch1 rotate y*-20 }
      object { Punch1 rotate y*-30 }
      object { Punch1 rotate y*-40 }
      object { Punch1 rotate y*-50 }
      object { Punch1 rotate y*-60 }
      object { Punch2 rotate y*-10 }
      object { Punch2 rotate y*-20 }
      object { Punch2 rotate y*-30 }
      object { Punch2 rotate y*-40 }
      object { Punch2 rotate y*-50 }
      object { Punch2 rotate y*-60 }
      object { Punch2 rotate y*-70 }
    }
    bounded_by { box { -1, 1 scale <22, 18, 12> translate z*11 } }
    translate <10, 21, 12>
  }
  bounded_by { box { -1, 1 scale 25 translate <8.7, 24, 10.2> } }
}