//------ P O V Letters ...10/02/92 M.Miller
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

global_settings {
  //assumed_gamma 1
  //ambient_light 0
  max_trace_level 20
}

#version 3.1;

#include "colors.inc"
#include "shapes.inc"
#include "shapes2.inc"
#include "textures.inc"
#include "World7.inc"
#include "Grid.inc"
#include "Letters.inc"
#include "Ray.inc"

camera {
  location <0, 40, -1170>
  direction z*5
  up y
  right x*image_width/image_height
  look_at y*10
}

light_source { < 400,  270, -660 > color White }
light_source { <4400, 3270, -660 > color Gold }

sphere { 0, 10000
  hollow on
  texture {
    pigment {
      gradient y
      color_map {
        [0.0 0.1 color MidnightBlue color Black]
        [0.1 1.1 color Black        color Black]
      }
      scale 10000
    }
    finish { ambient 0.2 diffuse 0.3 }
  }
}

union {
  object { GRAD_PANEL translate <   0, 100, 20> }
  object { GRAD_PANEL translate <-106, 100, 20> }
  object { GRAD_PANEL translate < 106, 100, 20> }
  object { POV }
  object { RAYTRACE translate y*-35 }
}

plane { y, -49
  texture {
    pigment { color DimGray }
    finish { ambient 0.1 diffuse 0.3 reflection 0.2 }
  }
}