//------Beveled P O V Letters ...10/04/92 M.Miller
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

//---- Front Surface of Type
#declare TypeTexture =
texture { gold2 }
texture {
  pigment {
    gradient z
    colour_map {
      [0 0.1 colour Clear colour Clear]
      [0.1 1 colour Scarlet filter 0.7 colour Scarlet filter 0.7]
    }
  }
  finish { reflection { 0.8 } ambient 0.1 diffuse 0.5 }
  scale <1, 1, 10>
}
	
//---- Stem stroke of P
#declare P1 =
object {
  difference {
    box { -1, 1 scale <15, 50, 5> translate <0, 50, 5> }
    plane { z, 0 rotate y*45 translate z*-10 }
    plane { z, 0 rotate y*-45 translate z*-10 }
    plane { z, 0 rotate x*-45 translate <0, 15, -10> }
    plane { z, 0 rotate x*45 translate <0, 85, -10> }
  }
  texture { TypeTexture }
  bounded_by { box { -1, 1 scale <16, 51, 11> translate <0, 50, 10> } }
}

#declare P2 =
object {
  union {
    difference {
      cylinder { z, -z, 1 scale <35, 35, 5> translate <26, 65, 5> }
      plane { x, 26 }
      object { Cylinder_Z scale <5, 5, 1> translate <26, 65, 10> }	
      object { QCone_Z scale 30 translate <26, 65, -30> inverse }     
      object { QCone_Z scale 15 translate <26, 65, 10>  }     
    }
    difference {
      box { -1, 1 scale <13, 15, 5> translate <13, 85, 5> }
      plane { z, 0 rotate x*45 translate <0, 85, -10> }
      plane { z, 0 rotate x*-45 translate <0, 85, -10> }
    }
    difference {
      box { -1, 1 scale <13, 15, 5> translate <13, 45, 5> }
      plane { z, 0 rotate x*45 translate <0, 45, -10> }
      plane { z, 0 rotate x*-45 translate <0, 45, -10> }
    }
  }
  texture { TypeTexture }
  bounded_by { box { -1, 1 scale <33, 37, 12> translate <30, 65, 10> } }
}

//--- Complete "P"
#declare P =
union {
  object { P1 }
  object { P2 }
}

//--- Complete "O"
#declare O =
object {
  difference {
    cylinder { z, -z, 1 scale <50, 50, 5> translate <0, 50, 5> }
    object { Cylinder_Z scale <20, 20, 1> translate y*50 }	
    object { QCone_Z scale 50 translate <0, 50, -45> inverse }     
    object { QCone_Z scale 50 translate <0, 50, 25>  }     
  }
  texture { TypeTexture }
  bounded_by { cylinder { z, -z, 1 scale <51, 51, 11> translate <0, 50, 10> } }
}

#declare V1 =
difference {
   box { -1, 1 scale <15, 70, 5> translate <0, 50, 5> }
   plane { z, 0 rotate y*45 translate z*-10 }
   plane { z, 0 rotate y*-45 translate z*-10 }
}

//--- Complete "V"
#declare V =
object {
  difference {
    union {
      object { V1 rotate z*16 }
      object { V1 rotate z*-16 }
    }
    plane { z, 0 rotate x*45 translate <0, 85, -10> }
    plane { z, 0 rotate x*-45 translate <0, 15, -10> }
    plane { y, 0 }
    plane { y, 100 inverse }	
  }
  texture { TypeTexture }
  bounded_by { box { -1, 1 scale <69, 56, 12> translate <0, 50, 10> } }
}

#declare POV =
union {
  object { P translate x*-130 }
  object { O scale <0.85, 1, 1> }
  object { V scale <0.90, 1, 1> translate x*104 }
  bounded_by { box { -1, 1 scale <160, 54, 12> translate <0, 50, 10> } }
}