//------ Tile Counter Top
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare Tile1Texture =
texture {
  pigment { colour rgb <0.68, 0.34, 0.42> }
  finish { ambient 0.05 diffuse 0.3 phong 1 reflection { 0.25 } }
}	

#declare TT1 =
union {
  cylinder { x, -x, 1 scale <25,  2, 2> translate y*-25 }
  cylinder { x, -x, 1 scale <25,  2, 2> translate y*25 }
  cylinder { y, -y, 1 scale < 2, 25, 2> translate x*25 }
  cylinder { y, -y, 1 scale < 2, 25, 2> translate x*-25 }
  sphere { 0, 2 translate <-25, -25, 0> }
  sphere { 0, 2 translate <-25,  25, 0> }
  sphere { 0, 2 translate < 25, -25, 0> }
  sphere { 0, 2 translate < 25,  25, 0> }
  triangle { <-25, -25, -2>, <-25, 25, -2>, <25, -25, -2> }
  triangle { <-25,  25, -2>, < 25, 25, -2>, <25, -25, -2> }
}

#declare Tile1 =
object { TT1 texture { Tile1Texture } rotate x*90 }

union {
  union {
    object { Tile1 }
    object { Tile1 translate x*-56 }
    object { Tile1 translate x*56 }
    object { Tile1 translate x*112 }
    object { Tile1 translate x*-112 }
    object { Tile1 translate x*168 }
    object { Tile1 translate x*-168 }
    object { Tile1 translate x*224 }
    object { Tile1 translate x*-224 }
  }
  union {
    object { Tile1 translate z*56 }
    object { Tile1 translate < -56, 0, 56> }
    object { Tile1 translate <  56, 0, 56> }
    object { Tile1 translate < 112, 0, 56> }
    object { Tile1 translate <-112, 0, 56> }
    object { Tile1 translate < 168, 0, 56> }
    object { Tile1 translate <-168, 0, 56> }
    object { Tile1 translate < 224, 0, 56> }
    object { Tile1 translate <-224, 0, 56> }
  }
  union {
    object { Tile1 translate z*-56 }
    object { Tile1 translate < -56, 0, -56> }
    object { Tile1 translate <  56, 0, -56> }
    object { Tile1 translate < 112, 0, -56> }
    object { Tile1 translate <-112, 0, -56> }
    object { Tile1 translate < 168, 0, -56> }
    object { Tile1 translate <-168, 0, -56> }
    object { Tile1 translate < 224, 0, -56> }
    object { Tile1 translate <-224, 0, -56> }
  }
  union { 
    object { Tile1 translate z*-112 }
    object { Tile1 translate < -56, 0, -112> }
    object { Tile1 translate <  56, 0, -112> }
    object { Tile1 translate < 112, 0, -112> }
    object { Tile1 translate <-112, 0, -112> }
    object { Tile1 translate < 168, 0, -112> }
    object { Tile1 translate <-168, 0, -112> }
    object { Tile1 translate < 224, 0, -112> }
    object { Tile1 translate <-224, 0, -112> }
  }
  union {
    object { Tile1 translate z*112 }
    object { Tile1 translate < -56, 0, 112> }
    object { Tile1 translate <  56, 0, 112> }
    object { Tile1 translate < 112, 0, 112> }
    object { Tile1 translate <-112, 0, 112> }
    object { Tile1 translate < 168, 0, 112> }
    object { Tile1 translate <-168, 0, 112> }
    object { Tile1 translate < 224, 0, 112> }
    object { Tile1 translate <-224, 0, 112> }
  }
  union {
    object { Tile1 translate z*168 }
    object { Tile1 translate < -56, 0, 168> }
    object { Tile1 translate <  56, 0, 168> }
    object { Tile1 translate < 112, 0, 168> }
    object { Tile1 translate <-112, 0, 168> }
    object { Tile1 translate < 168, 0, 168> }
    object { Tile1 translate <-168, 0, 168> }
    object { Tile1 translate < 224, 0, 168> }
    object { Tile1 translate <-224, 0, 168> }
  }
  union {
    object { Tile1 translate z*-168 }
    object { Tile1 translate < -56, 0, -168> }
    object { Tile1 translate <  56, 0, -168> }
    object { Tile1 translate < 112, 0, -168> }
    object { Tile1 translate <-112, 0, -168> }
    object { Tile1 translate < 168, 0, -168> }
    object { Tile1 translate <-168, 0, -168> }
    object { Tile1 translate < 224, 0, -168> }
    object { Tile1 translate <-224, 0, -168> }
  }
  union {
    object { Tile1 translate z*224 }
    object { Tile1 translate < -56, 0, 224> }
    object { Tile1 translate <  56, 0, 224> }
    object { Tile1 translate < 112, 0, 224> }
    object { Tile1 translate <-112, 0, 224> }
    object { Tile1 translate < 168, 0, 224> }
    object { Tile1 translate <-168, 0, 224> }
    object { Tile1 translate < 224, 0, 224> }
    object { Tile1 translate <-224, 0, 224> }
  }
  union {
    object { Tile1 translate z*280 }
    object { Tile1 translate < -56, 0, 280> }
    object { Tile1 translate <  56, 0, 280> }
    object { Tile1 translate < 112, 0, 280> }
    object { Tile1 translate <-112, 0, 280> }
    object { Tile1 translate < 168, 0, 280> }
    object { Tile1 translate <-168, 0, 280> }
    object { Tile1 translate < 224, 0, 280> }
    object { Tile1 translate <-224, 0, 280> }
  }
  union {
    object { Tile1 translate z*336 }
    object { Tile1 translate < -56, 0, 336> }
    object { Tile1 translate <  56, 0, 336> }
    object { Tile1 translate < 112, 0, 336> }
    object { Tile1 translate <-112, 0, 336> }
    object { Tile1 translate < 168, 0, 336> }
    object { Tile1 translate <-168, 0, 336> }
    object { Tile1 translate < 224, 0, 336> }
    object { Tile1 translate <-224, 0, 336> }
  }
  rotate y*20
  translate <-20, -2, 15>
}

//---- Grout between tile
plane { y, -2
  texture {
    pigment { colour DimGray }
    finish {
      ambient 0.2
      diffuse 0.3
    }
  }
}