//       Canon AE-1 35MM Camera ...............10/15/92 M.Miller
//--- Camera Textures & common shapes
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare Null = texture { pigment { color Black } }

//----Brush Silver
#declare Tex2 =
texture {
  pigment { color LightGray }
  finish { ambient 0.3 diffuse 0.6 phong 1 phong_size 10 brilliance 8 reflection { 0.2 metallic } }
}

//---- Gloss Black
#declare Tex3 =
texture {
  pigment { color Black }
  finish { ambient 0.1 diffuse 0.5 phong 1 phong_size 120 reflection { 0.2 } }
}

//--- Deep Green
#declare Tex4 =
texture {
  pigment { color DarkGreen }
  finish { ambient 0.4 diffuse 0.5 phong 1 }
}

//--- Red
#declare Tex5 =
texture {
  pigment { color Red }
  finish { ambient 0.3 diffuse 0.4 phong 1 }
}

//----Brush Silver
#declare B_Silver =
texture {
  pigment { color LightGray }
  finish { ambient 0.3 diffuse 0.6 phong 1 phong_size 10 brilliance 8 reflection { 0.2 metallic } }
}

//---- Gloss Black
#declare G_Black =
texture {
  pigment { color Gray05 }
  finish { ambient 0.1 diffuse 0.25 phong 1 phong_size 50 reflection { 0.2 } }
}

#declare Crown_Texture =
texture {
  material_map { gif "canon.gif" interpolate 4
    texture { Null }
    texture { Tex5 }
    texture { B_Silver }
    texture { G_Black }
  }
  scale <51, 19.3, 1>
  translate <-25.5, 0, 0>
}

//--- Better Wrinkle Texture
#declare W1 =
texture {
  normal { bump_map { gif "wrinkle.gif" bump_size 4 interpolate 4 } }
  pigment { color Gray05 }
  finish { phong 0.5 phong_size 55 ambient 0.15 diffuse 0.45 }
  scale <13, 8, 10>
}

//--- Camera Body
#declare Camera_Body_Texture =
texture {
  material_map { gif "cambody.gif" interpolate 4
    texture { Null }
    texture { G_Black }
    texture { Tex2 }
    texture { Tex3 }
    texture { Tex4 }
  }
  scale <141, 70, 1>
  translate <-70, -1, 0>
}

#declare Dial_Texture =
texture {
  pigment { image_map { gif "dial1.gif" interpolate 4 } }
  finish { ambient 0.5 diffuse 5 phong 1 phong_size 120 reflection { 0.1 } }
  scale <23, 23, 1> 
  translate <-11.5, -11.5, 0>
}

//--- Deep Gray
#declare D_Gray =
texture {
  pigment { color DimGray }
  finish { ambient 0.1 diffuse 0.3 phong 1 phong_size 10 }
}

//---- Chrome Silver
#declare C_Silver =
texture {
  pigment { color LightGray }
  finish { ambient 0.2 diffuse 0.5 phong 1 phong_size 120 brilliance 12 reflection { 0.7 } }
}

//---- F_Stops
#declare F_RING_TEXTURE =
texture {
  pigment {
    image_map { gif "fstop2.gif" interpolate 4 }
    scale <1, 37.5, 1>
    rotate y*-90
    translate y*-37.5
  }
  finish { phong 1 phong_size 80 ambient 0.8 diffuse 0.3 reflection { 0.2 } }
}

//---- Rubber Lens Grip
#declare GRIP_TEXTURE =
texture {
  pigment {
    image_map { gif "grip.gif" interpolate 4 }
    scale <1, 38.5, 1>
    rotate y*-90
    translate y*-19.5
  }
  finish { phong 0.3 phong_size 30 ambient 0.1 diffuse 0.3 }
}

//---- Lens Plate Texture
#declare Plate_Texture =
texture {
  pigment {
    image_map { gif "plate.gif" interpolate 4 }
    scale <60, 60, 1>
    translate <-30, -30, 0>
  }
  finish { phong 0.7 phong_size 70 ambient 0.5 diffuse 0.3 }
}

//--- Lens Glass
#declare Glass =
texture {
  pigment { color rgbf <0.99, 0.99, 0.99, 0.95> }
  finish { ambient 0.1 diffuse 0.2 phong 1 phong_size 200 reflection { 0.15 } }
}

#declare Lens_Back =
texture {
  pigment {
    wood
    color_map {
      [0.0 0.2 color Gray40 color Gray40]
      [0.2 0.4 color Gray30 color Gray30]
      [0.4 0.7 color Gray10 color Violet]
      [0.7 1.1 color Gray05 color Gray05]
    }
  }
  finish { ambient 0.3 diffuse 0.3 }
  scale <30, 30, 1>
}

//--- Camera Frame & Body
//--- Round Corner Frame

#declare C_FRAME =
union {
  sphere { 0, 2 translate <-57, 0,-14> }
  cylinder { x, -x, 0 scale <12.083046, 2, 2> rotate y*-155.556045 translate <-57, 0,-14> }
  sphere { 0, 2 translate <-68, 0,-9> }
  cylinder { x, -x, 0 scale <18, 2, 2> rotate y*-90 translate <-68, 0,-9> }
  sphere { 0, 2 translate <-68, 0, 9> }
  cylinder { x, -x, 0 scale <12.083046, 2, 2> rotate y*-24.443955 translate <-68, 0, 9> }
  sphere { 0, 2 translate <-57, 0, 14> }
  cylinder { x, -x, 0 scale <114, 2, 2> translate <-57, 0, 14>} 
  sphere { 0, 2 translate <57, 0, 14> }
  cylinder { x, -x, 0 scale <12.083046, 2, 2> rotate y*24.443955 translate <57, 0, 14> }
  sphere { 0, 2 translate <68, 0, 9> }
  cylinder { x, -x, 0 scale <18, 2, 2> rotate y*90 translate <68, 0, 9> }
  sphere { 0, 2 translate <68, 0,-9> }
  cylinder { x, -x, 0 scale <12.083046, 2, 2> rotate y*155.556045 translate <68, 0,-9> }
  sphere { 0, 2 translate <57, 0,-14> }
  cylinder { x, -x, 0 scale <114, 2, 2> rotate y*-180 translate <57, 0,-14> }
  sphere { 0, 2 translate <-57, 0,-14> }
}

//#declare S_CORNER = object { Disk_Y scale <2, 32, 2> translate y*34 }
#declare S_CORNER = cylinder { y, -y, 1 scale <2, 32, 2> translate y*34 }

#declare BODY_FRAME =
union {

  object {
    union {

      object { C_FRAME translate y*2 }
      object { C_FRAME translate y*66 }

      object { S_CORNER translate <-57, 0, -14> }
      object { S_CORNER translate <-68, 0,  -9> }
      object { S_CORNER translate <-68, 0,   9> }
      object { S_CORNER translate <-57, 0,  14> }
      object { S_CORNER translate < 57, 0,  14> }
      object { S_CORNER translate < 68, 0,   9> }
      object { S_CORNER translate < 68, 0,  -9> }
      object { S_CORNER translate < 57, 0, -14> }

      triangle { <-57, 66, -16>, <-57,  2, -16>, < 57, 66, -16> }
      triangle { <-57,  2, -16>, < 57, 66, -16>, < 57,  2, -16> }
      triangle { <-57, 66,  16>, <-57,  2,  16>, < 57, 66,  16> }
      triangle { <-57,  2,  16>, < 57, 66,  16>, < 57,  2,  16> }
      triangle { <-70, 66,  -9>, <-70,  2,  -9>, <-70, 66,   9> }
      triangle { <-70, 66,   9>, <-70,  2,   9>, <-70,  2,  -9> }
      triangle { < 70, 66,  -9>, < 70,  2,  -9>, < 70, 66,   9> }
      triangle { < 70, 66,   9>, < 70,  2,   9>, < 70,  2,  -9> }
      triangle { <-57.684040, 66, -15.879385>, <-57.684040, 2, -15.879385>, <-68.684044, 66, -10.879385> }
      triangle { <-57.684040,  2, -15.879385>, <-68.684044, 2, -10.879385>, <-68.684044, 66, -10.879385> }
      triangle { <-57.684040, 66,  15.879385>, <-57.684040, 2,  15.879385>, <-68.684044, 66,  10.879385> }
      triangle { <-57.684040,  2,  15.879385>, <-68.684044, 2,  10.879385>, <-68.684044, 66,  10.879385> }
      triangle { < 57.684040, 66, -15.879385>, < 57.684040, 2, -15.879385>, < 68.684044, 66, -10.879385> }
      triangle { < 57.684040,  2, -15.879385>, < 68.684044, 2, -10.879385>, < 68.684044, 66, -10.879385> }
      triangle { < 57.684040, 66,  15.879385>, < 57.684040, 2,  15.879385>, < 68.684044, 66,  10.879385> }
      triangle { < 57.684040,  2,  15.879385>, < 68.684044, 2,  10.879385>, < 68.684044, 66,  10.879385> }
      triangle { <-68, 68,  -9>, <-68, 68,   9>, <-57, 68,  14> }
      triangle { <-68, 68,  -9>, <-57, 68,  14>, <-57, 68, -14> }
      triangle { < 68, 68,  -9>, < 68, 68,   9>, < 57, 68,  14> }
      triangle { < 68, 68,  -9>, < 57, 68,  14>, < 57, 68, -14> }
      triangle { <-57, 68, -14>, <-57, 68,  14>, < 57, 68,  14> }
      triangle { <-57, 68, -14>, < 57, 68, -14>, < 57, 68,  14> }
      triangle { <-68,  0,  -9>, <-68,  0,   9>, <-57,  0,  14> }
      triangle { <-68,  0,  -9>, <-57,  0,  14>, <-57,  0, -14> }
      triangle { < 68,  0,  -9>, < 68,  0,   9>, < 57,  0,  14> }
      triangle { < 68,  0,  -9>, < 57,  0,  14>, < 57,  0, -14> }
      triangle { <-57,  0, -14>, <-57,  0,  14>, < 57,  0,  14> }
      triangle { <-57,  0, -14>, < 57,  0, -14>, < 57,  0,  14> }

    }
    texture { Camera_Body_Texture }
    bounded_by { box { -1, 1 scale <72, 35, 18> translate y*34 } }
  }

  object {
    union {
      triangle { <-57, 66, -16>, <-57,  2, -16>, <57, 66, -16> }
      triangle { <-57,  2, -16>, < 57, 66, -16>, <57,  2, -16> }
      triangle { <-57, 66,  16>, <-57,  2,  16>, <57, 66,  16> }
      triangle { <-57,  2,  16>, < 57, 66,  16>, <57,  2,  16> }
    }
    texture { W1 }
    bounded_by { box { -1, 1 scale <72, 35, 18> translate y*34 } }
    scale <1.003, 1, 1.003>
    clipped_by { box { -1, 1 scale <75, 20, 20> translate y*27 } }
  }

  object {
    union {
      triangle { <-57.684040, 66, -15.879385>, <-57.684040, 2, -15.879385>, <-68.684044, 66, -10.879385> }
      triangle { <-57.684040,  2, -15.879385>, <-68.684044, 2, -10.879385>, <-68.684044, 66, -10.879385> }
      triangle { < 57.684040, 66,  15.879385>, < 57.684040, 2,  15.879385>, < 68.684044, 66,  10.879385> }
      triangle { < 57.684040,  2,  15.879385>, < 68.684044, 2,  10.879385>, < 68.684044, 66,  10.879385> }
    }
    texture { W1 rotate y*30 }
    bounded_by { box { -1, 1 scale <72, 35, 18> translate y*34 } }
    scale <1.003, 1, 1.003>
    clipped_by { box { -1, 1 scale <75, 20, 20> translate y*27 } }
  }

  object {
    union {
      triangle { <-57.684040, 66,  15.879385>, <-57.684040, 2,  15.879385>, <-68.684044, 66,  10.879385> }
      triangle { <-57.684040,  2,  15.879385>, <-68.684044, 2,  10.879385>, <-68.684044, 66,  10.879385> }
      triangle { < 57.684040, 66, -15.879385>, < 57.684040, 2, -15.879385>, < 68.684044, 66, -10.879385> }
      triangle { < 57.684040,  2, -15.879385>, < 68.684044, 2, -10.879385>, < 68.684044, 66, -10.879385> }
    }
    texture { W1 rotate <0, -30, 0> }
    bounded_by { box { -1, 1 scale <72, 35, 18> translate y*34 } }
    scale <1.003, 1, 1.003>
    clipped_by { box { -1, 1 scale <75, 20, 20> translate y*27 } }
  }

  object {
    union {
      triangle { <-70, 66, -9>, <-70, 2, -9>, <-70, 66, 9> }
      triangle { <-70, 66,  9>, <-70, 2,  9>, <-70,  2, -9> }
      triangle { < 70, 66, -9>, < 70, 2, -9>, < 70, 66, 9> }
      triangle { < 70, 66,  9>, < 70, 2,  9>, < 70,  2, -9> }
    }
    texture { W1 rotate y*90 }
    bounded_by { box { -1, 1 scale <72, 35, 18> translate y*34 } }
    scale <1.003, 1, 1.003>
    clipped_by { box { -1, 1 scale <75, 20, 20> translate y*27 } }
  }

  bounded_by { box { -1, 1 scale <72, 35, 18> translate y*34 } }
}

//--- Camera Crown, Flash Clip, Lens Base, Shutter Trigger & Speed Dial
#declare Crown =
object {
  intersection {
    plane { y, 0 inverse }
    plane { x, 0 rotate z*-21 translate x*-25.5 inverse }
    plane { x, 0 rotate z*21 translate x*25.5 }
    plane { x, 0 rotate z*-48.7 translate <-24, 4, 0> inverse }
    plane { x, 0 rotate z*48.7 translate <24, 4, 0> }
    plane { z, 0 }
    plane { z, 0 rotate x*14 translate z*-46.5 inverse }
    plane { z, 0 rotate x*35 translate <0, 4, -46> inverse }
    plane { z, 0 rotate x*-77 translate y*11 }
  }
  texture { Crown_Texture }
  bounded_by { box { -1, 1 scale <27, 11, 25> translate <0, 9, -23> } }
}

//--- Flash Clip
#declare Clip =
union {
  object {
    union {
      difference {
        union {
          box { -1, 1 scale <10, 1, 9> translate y }
          cylinder { z, -z, 1 scale <2, 2, 9> translate <-8, 2, 0> }
          cylinder { z, -z, 1 scale <2, 2, 9> translate <8, 2, 0> }
        }
        box { -1, 1 scale <9, 1, 10> translate y*2 }
        object { Cylinder_Y scale <4, 1, 4> }
        box { -1, 1 scale <2, 8, 3.5> translate z*6 }
      }
      cylinder { y, -y, 1 scale <2, 1.2, 2> }
      box { -1, 1 scale <1, 0.5, 9> translate <7, 3.5, 0> }
      box { -1, 1 scale <1, 0.5, 9> translate <-7, 3.5, 0> }
    }
    texture { B_Silver }
    bounded_by { box { -1, 1 scale <11, 2.5, 10> translate y*2 } }
  }
  box { -1, 1 scale <10, 2.5, 10> translate <0, -2, 0.5> }
  texture { G_Black }
}

//--- Lens Base
#declare Lens_Base =
object {
  union {
    cylinder { z, -z, 1 scale <22, 22, 5> translate <-8, 22, -5> }
    cylinder { z, -z, 1 scale <22, 22, 5> translate <8, 22, -5> }
    box { -1, 1 scale <8, 11, 5> translate <0, 11, -5> }
    intersection {
      plane { y, 22 inverse }
      plane { y, 67.5 }
      plane { z, 0 }
      plane { z, -10 inverse }
      plane { x, 0 rotate z*-5.6 translate <-30, 22, 0> inverse }
      plane { x, 0 rotate z*5.6 translate <30, 22, 0> }
    }
    intersection {
      object { Cylinder_X scale <1, 7, 4.5> translate <0, 68, -10> }
      plane { x, 0 rotate z*-5.6 translate <-30, 22, 0> inverse }
      plane { x, 0 rotate z*5.6 translate <30, 22, 0> }
      plane { y, 67.5 }
      object { Cylinder_Z scale <32, 32, 1> translate y*33.5 inverse}
    }
    // object { Disk_Z scale <26, 26, 2.5> translate <0, 33.5, -12.5>  }
  }
  texture { B_Silver }
  bounded_by { box { -1, 1 scale <32, 37, 9> translate <0, 34, -5> } }
}

#declare Trigger =
union {
  union {
    object {
      union {
        intersection {
          plane { y, 0 inverse }
          plane { y, 7 }
          plane { x, -17.5 inverse }
          plane { x, 7.5 }
          plane { z, 15 }
          plane { z, -7.5 inverse }
          plane { x, 0 rotate y*53 translate <-17.5, 0, 7.5> inverse }
          plane { x, 0 rotate y*45 translate <7.5, 0, 0>  }
        }
        cylinder { y, -y, 1 scale <7.5, 3.5, 7.5> translate <-17.5, 3.5, 0> }
        cylinder { y, -y, 1 scale <7.5, 3.5, 7.5> translate y*3.5 }
        cylinder { y, -y, 1 scale <13, 3.5, 13> translate <2.5, 3.5, 20> }
        difference {
          box { -1, 1 scale <3, 1, 3.5> translate <-17.5, 1, -9> }
          box { -1, 1 scale <1.5, 2, 2.75> translate <-17.5, 1, -8.2> }
        }
        difference {
          sphere { 0, 1 scale <7, 2, 7> translate y*7 }
          object { Cylinder_Y scale <2.2, 1, 2.2> }
        }
      }
      texture { G_Black }
    }

    //--- Shutter speed dial
    object {
      union {
        cylinder { y, -y, 1 scale <12, 3.5, 12> translate <2.5, 5, 20> }
        intersection {
          cylinder { y, -y, 1 scale <2.5, 2.1, 2.5> translate y*7 }
          object { Cylinder_Y scale <1.2, 1, 1.2> inverse }
        }
      }
      texture { B_Silver }
    }

    cylinder { z, -z, 1
      scale <11.5, 11.5, 2>
      texture { Dial_Texture }
      rotate x*90
      translate <2.5, 6.9, 20>
    }
    bounded_by { box { -1, 1 scale <21, 5, 23> translate <-5.7, 4, 9.3> } }
  }

  //---- Film Advance
  object {
    difference {
      union {
        box { -1, 1 scale <9, 4, 9> translate <-8.5, 4, 9> }
        cylinder { y, -y, 1 scale <23, 4, 24> translate <-17.5, 4, 24> }
      }
      plane { x, 0 inverse }
      object { Cylinder_Y scale <20, 1, 11.1> translate <-17.5, 0, 20> }
      plane { x, 0 rotate y*75 translate <-37.5, 0, 15> }
      box { -1, 1 scale <10, 5, 20> translate <-7.5, 9, 0> }
      object { Cylinder_Z scale <10.5, 4, 1> translate <-17.5, 8, 0> }
    }
    texture { G_Black }
    bounded_by { box { -1, 1 scale <20, 5, 10> translate <-19, 4, 9> } }
    rotate y*90
    translate x*-25
  }

  //--- Finger Grip
  object {
    union {
      object { Disk_Y scale <6.5, 1, 6.5> translate <-17.5, 6.5, 0> }
      box { -1, 1 scale <6.9, 1, 6.5> translate <-10.6, 6.5, 0> }
    }
    texture { D_Gray }
  }
}

//----- Round Corner Tous for Strap Clip
#declare R1 =
quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -61.78, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 59.22, 0, 0, 0, 0, 1, 0, -61.78, 0, 876.7521> rotate x*90 }

//--- Strap Clip, Battery Door & Film Door Hinge

//--- 3 sided clip
#declare Clip1 =
object {
  union {
    difference {
      object { R1 translate <-4.3, -2.8, 0> }
      plane { x, -4.3 inverse }
      plane { y, 0 rotate z*30 translate <-4.3, -2.8, 0> }
    }
    difference {
      object { R1 translate <4.3, -2.8, 0> }
      plane { x, 4.3  }
      plane { y, 0 rotate z*-30 translate <4.3, -2.8, 0> }
    }
    difference {
      object { R1 translate y*-10 }
      plane { y, 0 rotate y*30 translate y*-10 inverse  }
      plane { y, 0 rotate y*-30 translate y*-10 inverse }
    }
    difference {
      object { Cylinder_Y scale <0.8, 1, 0.8> rotate z*30.6 translate <-4.76314, -12.75, 0> }
      plane { y, 0 rotate z*30 translate y*-10 }
      plane { y, 0 rotate z*30 translate <-4.3, -2.8, 0> inverse }
    }
    difference {
      object { Cylinder_Y scale <0.8, 1, 0.8> rotate z*-30.6 translate <4.76314, -12.75, 0> }
      plane { y, 0 rotate z*-30 translate y*-10 }
      plane { y, 0 rotate z*-30 translate <4.3, -2.8, 0> inverse }
    }
  cylinder { x, -x, 1 scale <4.3, 0.8, 0.8> translate y*2.7 }
  }
  texture { C_Silver }
  bounded_by { sphere { 0, 1 scale 12 translate y*-5 } }
}

//-- Triangle Strap Clip
#declare Strap_Clip =
union {
  object { Clip1 translate <0, -4, -0.8> }
  object { Clip1 translate <0, -4, 0.8> }
  object {
    intersection {
      sphere { 0, 1 scale <3, 4.5, 3> }
      plane { x, 2 }
      plane { x, -2 inverse }
    }
    texture { C_Silver }
  }
  bounded_by { sphere { y*-5, 14 } }
  scale <0.7, 0.8, 1>
}

#declare Hinge =
union {
  object {
    Disk_Y scale <2.5, 25, 2.5> translate y*28.5
    texture { G_Black }
  }
  object {
    intersection {
      object { Cylinder_Y scale <2, 1, 2> }
      plane { y, 0 rotate z*-42 inverse }
      plane { y, 0 rotate z*60 translate <2, 64.5, 0> }
    }
    texture { B_Silver }
  }
  bounded_by { box { -1, 1 scale <3, 30, 3> translate y*29 } }
}

#declare Battery_Door =
object {
  union {
    difference {
      box { -1, 1 scale <9, 15, 1> }
      box { -1, 1 scale <7.5, 13.5, 2> }
    }
    cylinder { y, -y, 1 scale <2.5, 15, 2.5> translate <-6.5, 0, -1> }
    cylinder { z, -z, 1 scale 2 translate x*-12.5 }
  }
  texture { G_Black }
  bounded_by { box { -1, 1 scale <13, 16, 4> translate x*-3 } }
}

//--- Camera Lens
#declare Lens =
union {

  //--- fStop rings
  object {
    union {
      cylinder { y, -y, 1 scale <31, 7.5, 31> translate y*-7.5 }
      cylinder { y, -y, 1 scale <32, 3.5, 32> translate y*-6 }
      cylinder { y, -y, 1 scale <30, 7.5, 30> translate y*-22.8 }
      cylinder { y, -y, 1 scale <32, 4.5, 32> translate y*-35 }
    }
    texture { F_RING_TEXTURE }
    bounded_by { box { -1, 1 scale <35, 21, 35> translate y*-18.5 } }
  }

  //--- Rubber Grip
  cylinder { y, -y, 1 scale <33, 19, 33> texture { GRIP_TEXTURE } translate y*-59 }

  //--- Front Rim
  object {
    difference {
      cylinder { y, -y, 1 scale <32, 6, 32> translate y*-83.5 }
      object { Cylinder_Y scale <30, 1, 30> }
    }
    texture { G_Black }
    bounded_by { box { -1, 1 scale <33, 7, 33> translate y*-83.5 } }
  }

  //--- Lens PLate
  union {
    object {
      difference {
        cylinder { z, -z, 1 scale <30, 30, 1> }
        object { Cylinder_Z scale <24, 24, 1> }
      }
      texture { Plate_Texture }
      bounded_by { box { -1, 1 scale <33, 33, 2> } }
    }

    //--- Inner lens walls
    cylinder { z, -z, 1 scale <30, 30, 1> translate z*8 texture { Lens_Back } }

    //--- Glass lens
    object {
      union {
        sphere { 0, 1 scale <30, 30, 4> translate z*3 }
        sphere { 0, 1 scale <10, 10, 6> translate z*7 }
      }
      texture { Glass }
      interior { ior 1.2 }
    }
    rotate x*-90
    translate y*-86
  }
  bounded_by { box { -1, 1 scale <37, 50, 37> translate y*-45 } }
}

//--- Some Camera Buttons
#declare Buttons =
union {
  union {
    object {
      union {
        cylinder { y, -y, 1 scale <4, 1, 4> translate <36, 69, -7.7> }
        sphere { 0, 1 scale <2, 1, 2> translate <41, 71, 9.5> }
      }
      texture { B_Silver }
    }
    object {
      union {
        cylinder { y, -y, 1 scale <3, 1.5, 3> translate <41, 69.5, 9.5> }
        sphere { 0, 1 scale <3, 0.5, 3> translate <36, 70, -7.7> }
      }
      texture { G_Black }
    }
    bounded_by { box { -1, 1 scale <7.5, 2.5, 16> translate <38, 70, 0> } }
  }

  //--- Film Rewind Crank
  union {
    object {
      union {
        intersection {
          object { QCone_Y scale <13, 35, 13> translate y*35 }
          plane { y, 6 }
          plane { y, 0 inverse }
        }
        cylinder { y, -y, 1 scale 2.5 translate <-9, 8.5, 0> }
      }
      texture { G_Black }
      bounded_by {  box { -1, 1 scale <14, 7, 14> translate y*6.5 } }
    }
    object {
      union {
        intersection {
          object { QCone_Y scale <13, 35, 13> translate y*35 }
          plane { y, 6.5 inverse }
          plane { y, 12 }
          box { -1, 1 scale <15, 2.5, 3> translate y*10.2 inverse }
        }
        box { -1, 1 scale <10, 0.5, 2.5> translate <-1, 11.2, 0> inverse }
      }
      texture { B_Silver }
      bounded_by { box { -1, 1 scale <15, 4, 15> translate y*9.3 } }
    }
    translate <55.3, 68, 0>
  }

  //--- Front Button
  union {
    cylinder { z, -z, 1 scale <4.5, 4.5, 1> texture { B_Silver } }
    sphere { 0, 1 scale <4.5, 4.5, 1> translate z*-1.1 texture { G_Black } }
    bounded_by { box { -1, 1 scale <5, 5, 3> } }
    translate <43.8, 59.5, -17>
  }
  bounded_by { box { -1, 1 scale <22.5, 15, 18> translate <50, 67, -1> } }
}

//-- Complete Camera
#declare Camera =
union {
  object { BODY_FRAME }

  object { Crown translate <0, 68, 16> }
  object { Clip translate <0, 83.5, 5.5> }
  object { Lens_Base translate <0, 0.5, -16> }
  object { Trigger scale 0.92 rotate y*33 translate <-44, 68, -10.8> }
  object { Strap_Clip rotate y*23 translate <-64, 57.8, -13.8> }
  object { Strap_Clip rotate y*-23 translate <64, 57.8, -13.8> }
  object { Hinge translate <-71.3, 1.5, 0> }
  object { Battery_Door translate <-42.2, 31, -16> }
  object { Lens rotate x*90 translate <0, 33.5, -26.4> }
  object { Buttons }

}