// Persistence of Vision Raytracer Version 1.0
//-------------- planet 22             .....miller 3/24/92
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare gold2 =
texture {
  pigment { color rgb <0.64, 0.51, 0.05> }
  finish { crand 0.02 ambient 0.3 diffuse 0.5 reflection { 0.6 } brilliance 8 specular 0.5 }
}

//----------- light blue to midnight blue
#declare n1 =
pigment {
  gradient y
  color_map {
    [0.000 0.308 color rgbf <0.722, 0.722, 0.992, 0> color rgbf <0.333, 0.333, 0.584, 0>]
    [0.308 0.992 color rgbf <0.333, 0.333, 0.584, 0> color rgbf <0.016, 0.016, 0.231, 0>]
    [0.992 1.001 color rgbf <0.016, 0.016, 0.231, 0> color rgbf <0.722, 0.722, 0.992, 0>]
  }
}

//-------------- clear - light blue - white
#declare n2 =
pigment {
  bozo
  turbulence 0.8
  color_map {
    [0.000 0.252 color rgbf <0.722, 0.722, 0.992, 0.890> color rgbf <0.333, 0.333, 0.584, 0.859>]
    [0.252 0.798 color rgbf <0.333, 0.333, 0.584, 0.859> color rgbf <0.918, 0.922, 0.929, 0>]
    [0.798 0.992 color rgbf <0.918, 0.922, 0.929, 0>     color rgbf <0.529, 0.522, 0.733, 0.243>]
    [0.992 1.001 color rgbf <0.529, 0.522, 0.733, 0.243> color rgbf <0.722, 0.722, 0.992, 0.890>]
  }
}

//-------------- clear - light blue - white
#declare n2x =
pigment {
  bozo
  turbulence 0.8
  color_map {
    [0.000 0.252 color rgbf <0.722, 0.722, 0.992, 0.89>  color rgbf <0.333, 0.333, 0.584, 0.859>]
    [0.252 0.798 color rgbf <0.333, 0.333, 0.584, 0.859> color rgbf <0.918, 0.922, 0.929, 0.22>]
    [0.798 0.992 color rgbf <0.918, 0.922, 0.929, 0.229> color rgbf <0.529, 0.522, 0.733, 0.243>]
    [0.992 1.001 color rgbf <0.529, 0.522, 0.733, 0.243> color rgbf <0.722, 0.722, 0.992, 0.89>]
  }
}

//----------light blues & light clears alternating
#declare n3 =
pigment {
  gradient y
  color_map {
    [0.000 0.155 color rgbf <0.996, 0.98,  0.761, 0.58>   color rgbf <0.722, 0.722, 0.992, 0.635>]
    [0.155 0.517 color rgbf <0.722, 0.722, 0.992, 0.635>  color rgbf <0.996, 0.98,  0.761, 0.675>]
    [0.517 0.638 color rgbf <0.996, 0.980, 0.761, 0.675>  color rgbf <0.875, 0.875, 1,     0.659>]
    [0.638 0.750 color rgbf <0.875, 0.875, 1,     0.659>  color rgbf <0.722, 0.722, 0.992, 0.702>]
    [0.750 0.871 color rgbf <0.722, 0.722, 0.992, 0.702>  color rgbf <0.357, 0.357, 0.702, 0.647>]
    [0.871 0.983 color rgbf <0.357, 0.357, 0.702, 0.647>  color rgbf <0.345, 0.345, 0.537, 0.675>]
    [0.983 1.001 color rgbf <0.345, 0.345, 0.537, 0.675>  color rgbf <0.996, 0.98,  0.761, 0.58>]
  }
}

#declare n11 =
pigment {
  gradient y
  color_map {
    [0.0 0.3  color rgb   0                                  color rgb  <0.309804, 0.184314, 0.309804>]
    [0.3 0.5  color rgb  <0.309804, 0.184314, 0.309804>      color rgbf <0.309804, 0.184314, 0.309804, 0.4>]
    [0.5 1.01 color rgbf <0.309804, 0.184314, 0.309804, 0.4> color rgbf <0.309804, 0.184314, 0.309804, 1>]
  }
}

#declare nimrod =
texture { pigment { n1 }  finish { ambient 1 diffuse 0} scale <1, 2, 1> rotate z*180 }
texture { pigment { n2x } finish { ambient 1 diffuse 0} translate x }
texture { pigment { n11 } finish { ambient 1 diffuse 0} scale <1, 2, 1> translate y*1.6 }
texture { pigment { n2 }  finish { ambient 1 diffuse 0} scale <2, 0.5, 1> translate -y }

/*-------The World in Front-----------*/
#declare World7 =
object {
  sphere { 0, 1 inverse }
  texture { nimrod }
  scale <2000, 1000, 5000>
}