//------ Tile Counter Top
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
#declare Tile1Texture =
texture {
   pigment { color Gray }
   finish { ambient 0.1 diffuse 0.3 phong 1 reflection { 0.5 } }
}

#declare Tile2Texture =
texture {
   pigment { color CadetBlue }
   finish { ambient 0.1 diffuse 0.5 phong 1 reflection { 0.5 } }
}

#declare MelamineGray =
texture {
   pigment { color Wheat }
   finish { ambient 0.3 diffuse 0.5 phong 1 crand 0.05 }
}

#declare CounterGray =
texture {
   pigment { color DimGray }
   finish { ambient 0.2 diffuse 0.4 phong 1 crand 0.05 reflection { 0.3 } }
}

#declare T1 =
union {
  object { Disk_X scale <25,  2, 2> translate y*-25 }
  object { Disk_X scale <25,  2, 2> translate y*25 }
  object { Disk_Y scale < 2, 25, 2> translate x*25 }
  object { Disk_Y scale < 2, 25, 2> translate x*-25 }
  sphere { 0, 2 translate <-25, -25, 0> }
  sphere { 0, 2 translate <-25,  25, 0> }
  sphere { 0, 2 translate < 25, -25, 0> }
  sphere { 0, 2 translate < 25,  25, 0> }
  triangle { <-25, -25, -2>, <-25, 25, -2>, <25, -25, -2> }
  triangle { <-25,  25, -2>, < 25, 25, -2>, <25, -25, -2> }
}

#declare Tile1 = object { T1 texture { Tile1Texture }  }

#declare Tile2 = object { T1 texture { Tile2Texture }  }

#declare Molding =
union {
  difference {
    box { -1, 1 scale <500, 3, 3> translate <0, 3, -10> }
    object { Cylinder_X scale <1, 4, 4> translate <0, 6, -13> }
  }
  box { -1, 1 scale <500, 2, 12.5> translate z*-7.5 }
  box { -1, 1 scale <500, 17, 4> translate <0, 19, -5> }
  box { -1, 1 scale <500, 19, 5> translate y*21 }
  object { Cylinder_X scale <1, 4, 4> translate <0, 36, -5> }
}

plane { y, 0 texture { CounterGray } }

union {
  object { Tile1 translate y*67 }
  object { Tile2 translate <  56, 67, 0> }
  object { Tile2 translate < -56, 67, 0> }
  object { Tile1 translate < 112, 67, 0> }
  object { Tile1 translate <-112, 67, 0> }
  object { Tile2 translate < 168, 67, 0> }
  object { Tile2 translate <-168, 67, 0> }
  object { Tile1 translate < 224, 67, 0> }
  object { Tile1 translate <-224, 67, 0> }
  object { Tile2 translate < 280, 67, 0> }
  object { Tile2 translate <-280, 67, 0> }
  object { Tile1 translate < 336, 67, 0> }
  object { Tile1 translate <-336, 67, 0> }
  object { Tile2 translate < 392, 67, 0> }
  object { Tile2 translate <-392, 67, 0> }

  object { Tile2 translate y*123 }
  object { Tile1 translate <  56, 123, 0> }
  object { Tile1 translate < -56, 123, 0> }
  object { Tile2 translate < 112, 123, 0> }
  object { Tile2 translate <-112, 123, 0> }
  object { Tile1 translate < 168, 123, 0> }
  object { Tile1 translate <-168, 123, 0> }
  object { Tile2 translate < 224, 123, 0> }
  object { Tile2 translate <-224, 123, 0> }
  object { Tile1 translate < 280, 123, 0> }
  object { Tile1 translate <-280, 123, 0> }
  object { Tile2 translate < 336, 123, 0> }
  object { Tile2 translate <-336, 123, 0> }
  object { Tile1 translate < 392, 123, 0> }
  object { Tile1 translate <-392, 123, 0> }

  object { Tile1 translate y*179 }
  object { Tile2 translate <  56, 179, 0> }
  object { Tile2 translate < -56, 179, 0> }
  object { Tile1 translate < 112, 179, 0> }
  object { Tile1 translate <-112, 179, 0> }
  object { Tile2 translate < 168, 179, 0> }
  object { Tile2 translate <-168, 179, 0> }
  object { Tile1 translate < 224, 179, 0> }
  object { Tile1 translate <-224, 179, 0> }
  object { Tile2 translate < 280, 179, 0> }
  object { Tile2 translate <-280, 179, 0> }
  object { Tile1 translate < 336, 179, 0> }
  object { Tile1 translate <-336, 179, 0> }
  object { Tile2 translate < 392, 179, 0> }
  object { Tile2 translate <-392, 179, 0> }

  object { Tile2 translate y*235 }
  object { Tile1 translate <  56, 235, 0> }
  object { Tile1 translate < -56, 235, 0> }
  object { Tile2 translate < 112, 235, 0> }
  object { Tile2 translate <-112, 235, 0> }
  object { Tile1 translate < 168, 235, 0> }
  object { Tile1 translate <-168, 235, 0> }
  object { Tile2 translate < 224, 235, 0> }
  object { Tile2 translate <-224, 235, 0> }
  object { Tile1 translate < 280, 235, 0> }
  object { Tile1 translate <-280, 235, 0> }
  object { Tile2 translate < 336, 235, 0> }
  object { Tile2 translate <-336, 235, 0> }
  object { Tile1 translate < 392, 235, 0> }
  object { Tile1 translate <-392, 235, 0> }

  object { Tile2 translate y*291 }
  object { Tile1 translate <  56, 291, 0> }
  object { Tile1 translate < -56, 291, 0> }
  object { Tile2 translate < 112, 291, 0> }
  object { Tile2 translate <-112, 291, 0> }
  object { Tile1 translate < 168, 291, 0> }
  object { Tile1 translate <-168, 291, 0> }
  object { Tile2 translate < 224, 291, 0> }
  object { Tile2 translate <-224, 291, 0> }
  object { Tile1 translate < 280, 291, 0> }
  object { Tile1 translate <-280, 291, 0> }
  object { Tile2 translate < 336, 291, 0> }
  object { Tile2 translate <-336, 291, 0> }
  object { Tile1 translate < 392, 291, 0> }
  object { Tile1 translate <-392, 291, 0> }

  object { Molding texture { MelamineGray } }
}