//------ Wall Socket, Plug End, & Plug Wire
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
#declare CoverColor =
texture {
   pigment { color Gray }
   finish { ambient 0.1 diffuse 0.6 phong 1 }
}

//--- Round Corners on Plate
#declare PlateCorners =
object {
  union {
    difference {
      object { Cylinder_X scale <1, 5, 5> translate y*49 }
      plane { y, 0 rotate z*45 translate y*19 }
      plane { y, 0 rotate z*-45 translate y*19 }
    }
    difference {
      object { Cylinder_X scale <1, 5, 5> translate y*-49 }
      plane { y, 0 rotate z*45 translate y*-19 inverse }
      plane { y, 0 rotate z*-45 translate y*-19 inverse }
    }
    difference {
      object { Cylinder_Y scale <5, 1, 5> translate x*-30 }
      plane { y, 0 rotate z*-45 translate y*19 inverse }
      plane { y, 0 rotate z*45 translate y*-19 }
    }
    difference {
      object { Cylinder_Y scale <5, 1, 5> translate x*30 }
      plane { y, 0 rotate z*45 translate y*19 inverse }
      plane { y, 0 rotate z*-45 translate y*-19 }
    }
  }
  texture { CoverColor }
  bounded_by { box { -1, 1 scale <37.5, 56.5, 6> } }
}

//---- Front of Receptical Plate
#declare FacePlate =
object {
  union {
    difference {
      box { -1, 1 scale <30, 49, 5> }
      object { Cylinder_Z scale <17, 17, 1> translate y*-19 }
      object { Cylinder_Z scale <17, 17, 1> translate  y*19 }
    }
    box { -1, 1 scale <17, 5, 5> }
    box { -1, 1 scale <17, 5, 5> translate  y*38 }
    box { -1, 1 scale <17, 5, 5> translate y*-38 }
    difference {
      sphere { 0, 1 scale <4, 4, 2> translate z*-5 }
      box { -1, 1 scale <0.5, 4.5, 2> translate z*-7 rotate z*30 }
    }
  }
  texture { CoverColor }
  bounded_by { box { -1, 1 scale <37.5, 56.5, 8> } }
}

#declare SocketCover =
union {
  object { PlateCorners }
  object { FacePlate }
  bounded_by { box { -1, 1 scale <37.5, 56.5, 8> } }
}

//---- Standard Socket with Ground
#declare Socket =
object {
  union {
    difference {
      object { Disk_Z scale <16, 16, 6> }
      sphere { 0, 1 scale <14, 14, 3> translate z*-6 }
      box { -1, 1 scale <1.1, 4, 8> translate <-6, 3.5, 0> }
      box { -1, 1 scale <1.1, 4, 8> translate <6, 3.5, 0> }
      plane { y, -13 }
      plane { -y, -13 }
      object { Cylinder_Z scale <3, 3, 1> translate y*-8 }
      box { -1, 1 scale <3, 1.5, 8> translate y*-9.5 }
    }
    box { -1, 1 scale <9, 1, 6> translate y*-12 }
    box { -1, 1 scale <9, 1, 6> translate  y*12 }
    difference {
      union {
        object { Disk_Y scale <4.5, 12, 4.5> translate z*-1.8 }
        object { Disk_Z scale <5, 5, 6> translate y*-8 }
        box { -1, 1 scale <5, 2.5, 6> translate y*-10.5 }
      }
      plane { z, -6 }
      object { Cylinder_Z scale <3, 3, 1> translate y*-8 }
      box { -1, 1 scale <3, 1.5, 8> translate y*-9.5 }
    }
  }
  texture { CoverColor }
  bounded_by { box { -1, 1 scale <19, 19, 7> } }
}

//--- Plug End
#declare PlugTexture =
texture {
  pigment { color White }
  finish { /*ambient 0.1*/ diffuse 0.7 phong 1 }
}

#declare Connector_1 =
object {
  quadric { <0, 1, 1>, 0, 0, -1 }
  clipped_by { plane { x, 1 } plane { -x, 0 } }
}

#declare RR =
union {
  sphere { 0, 1 translate x*4.5 texture { PlugTexture } }
  object { Connector_1 scale <8.246211, 1, 1> rotate z*75.963757 translate x*4.5 texture { PlugTexture } }
  sphere { 0, 1 translate <6.5, 8, 0> texture { PlugTexture } }
  object { Connector_1 scale <12.093387, 1, 1> rotate z*82.874984 translate <6.5, 8, 0> texture { PlugTexture } }
  sphere { 0, 1 translate <8, 20, 0> texture { PlugTexture } }
  object { Connector_1 scale <16, 1, 1> rotate y*-180 translate <8, 20, 0> texture { PlugTexture } }
  sphere { 0, 1 translate <-8, 20, 0> texture { PlugTexture } }
  object { Connector_1 scale <12.093387, 1, 1> rotate z*-82.874984 translate <-8, 20, 0> texture { PlugTexture } }
  sphere { 0, 1 translate <-6.5, 8, 0> texture { PlugTexture } }
  object { Connector_1 scale <8.246211, 1, 1> rotate z*-75.963757 translate <-6.5, 8, 0> texture { PlugTexture } }
  sphere { 0, 1 translate x*-4.5 texture { PlugTexture } }
  object { Connector_1 scale <9, 1, 1> translate x*-4.5 texture { PlugTexture } }
  sphere { 0, 1 translate x*4.5 texture { PlugTexture } }
  bounded_by { box { -1, 1 scale <14, 14, 10> translate y*11 } }
}

//--- Side Corners
#declare Sides =
object { Disk_Z scale <1, 1, 5> texture { PlugTexture } }

#declare PlugSkin =
object {
  union {
    triangle { <-4.5, 0, -6>, <4.5, 0, -6>, <-6.5, 8, -6> }
    triangle { <4.5, 0, -6>, <6.5, 8, -6>, <-6.5, 8, -6> }
    triangle { <6.5, 8, -6>, <-6.5, 8, -6>, <-8, 20, -6> }
    triangle { <-8, 20, -6>, <6.5, 8, -6>, <8, 20, -6> }
    triangle { <-4.5, 0, 6>, <4.5, 0, 6>, <-6.5, 8, 6> }
    triangle { <4.5, 0, 6>, <6.5, 8, 6>, <-6.5, 8, 6> }
    triangle { <6.5, 8, 6>, <-6.5, 8, 6>, <-8, 20, 6> }
    triangle { <-8, 20, 6>, <6.5, 8, 6>, <8, 20, 6> }
    triangle { <-4.5, -1, -5>, <4.5, -1, -5>, <-4.5, -1, 5> }
    triangle { <-4.5, -1, 5>, <4.5, -1, 5>, <4.5, -1, -5> }
    triangle { <-5.5, 0, -5>, <-5.5, 0, 5>, <-7.5, 8, -5> }
    triangle { <-7.5, 8, -5>, <-5.5, 0, 5>, <-7.5, 8, 5> }
    triangle { <-7.5, 8, -5>, <-7.5, 8, 5>, <-9, 20, -5> }
    triangle { <-9, 20, -5>, <-7.5, 8, 5>, <-9, 20, 5> }
    triangle { <5.5, 0, -5>, <5.5, 0, 5>, <7.5, 8, -5> }
    triangle { <7.5, 8, -5>, <5.5, 0, 5>, <7.5, 8, 5> }
    triangle { <7.5, 8, -5>, <7.5, 8, 5>, <9, 20, -5> }
    triangle { <9, 20, -5>, <7.5, 8, 5>, <9, 20, 5> }
  }
  texture { PlugTexture }
  bounded_by { box { -1, 1 scale <14, 14, 10> translate y*11 } }
}

#declare PlugFace =
object {
   union {
    object { Disk_Y scale <2.5, 1, 2.5> translate <9.5, 21, -6.5> }
    object { Disk_Y scale <2.5, 1, 2.5> translate <-9.5, 21, -6.5> }
    object { Disk_Y scale <2.5, 1, 2.5> translate <9.5, 21, 6.5> }
    object { Disk_Y scale <2.5, 1, 2.5> translate <-9.5, 21, 6.5> }
    box { -1, 1 scale <12, 1, 6.5> translate y*21 }
    box { -1, 1 scale <9.5, 1, 9> translate y*21 }
    box { -1, 1 scale <3.5, 1, 9> translate -y }
    box { -1, 1 scale <3.5, 1, 7> translate y*3 }
    box { -1, 1 scale <3.5, 1, 7> translate y*7 }
    box { -1, 1 scale <3.5, 1, 7> translate y*11 }
    box { -1, 1 scale <3.5, 1, 7> translate y*15 }
  }
  texture { PlugTexture }
  bounded_by { box { -1, 1 scale <14, 14, 10> translate y*11 } }
}

//---- Complete Plug End
#declare PlugEnd =
union {
  object { RR translate z*-5 }
  object { RR translate z*5 }
  object { Sides translate x*-4.5 }
  object { Sides translate x*4.5 }
  object { Sides translate <6.5, 8, 0> }
  object { Sides translate <-6.5, 8, 0> }
  object { Sides translate <8, 20, 0> }
  object { Sides translate <-8, 20, 0> }
  object { PlugSkin }
  object { PlugFace }
  bounded_by { box { -1, 1 scale <14, 14, 10> translate y*11 } }
}

//--- Plug Wire
#declare TT1 = 
quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -2398.5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 2362.5, 0, 0, 0, 0, 1, 0, -2398.5, 0, 1395351.5625> }

#declare TT2 = 
quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -2538.5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 2502.5, 0, 0, 0, 0, 1, 0, -2538.5, 0, 1565626.5625> }

#declare TT3 = 
quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -8338.5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 8302.5, 0, 0, 0, 0, 1, 0, -8338.5, 0, 17232876.5625> }

#declare Wire1 =
object {
  union {
    difference {
      object { TT1 rotate x*90 translate y*-34.5 }
      plane { y, 0 rotate z*90 }
      plane { y, 0 rotate z*-142 translate y*-34.5 inverse}
    }
    difference {
      object { TT2 rotate x*90 translate <-55.160755, -77.596298, 0> }
      plane { y, 0 rotate z*-142 translate y*-34.5 }
      plane { y, 0 rotate z*-124.6 translate <-55.160755, -77.596298, 0> }
    }
    difference {
      object { TT3 rotate x*90 translate <-111.945129, -159.909943, 0> }
      plane { y, 0 rotate z*-124.6 translate <-55.160755, -77.596298, 0> inverse }
      plane { y, 0 rotate z*124.2 translate <-111.945129, -159.909943, 0> inverse }
    }
    difference {
      object { TT2 rotate x*90 translate <-168.153458, -77.201881, 0> }
      plane { y, 0 rotate z*124.2 translate <-111.945129, -159.909943, 0> }
      plane { y, 0 rotate z*-90 translate <-168.153458, -77.201881, 0> }
    }
    object { Disk_X scale <400, 3, 3> translate <-568.153458, -112.701881, 0> }
  }
  texture { PlugTexture }
  bounded_by { box { -1, 1 scale <335.5, 68, 5> translate <-325.5, -57, 0> } }
}

//--- Double Strand insulated Wire
#declare Wire =
union {
  object { Wire1 translate z*2 }
  object { Wire1 translate z*-2 }
  bounded_by { box { -1, 1 scale <335.5, 68, 7> translate <-325.5, -57, 0> } }
}

//---- Complete Receptical with Plug & Wire
#declare Receptical =
union {
  object { SocketCover }
  object { Socket translate <0, 19, -1> }
  object { Socket translate <0, -19, -1> }
  bounded_by { box { -1, 1 scale <37.5, 56.5, 6> } }
}

//--- Receptical, Plug & Plug Wire
#declare Plugin =
union {
  object { Receptical }
  object { PlugEnd rotate x*90 translate <0, -19, -31> }
  object { Wire rotate y*-90 translate <0, -19, -30> }
  translate <-250, 135, -2>
}