//------ Old Stove Kettle ............. 9/25/92 M.Miller
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

//------ Kettle Texture
#declare  BodyTexture =
texture {
  pigment { image_map { gif "kmap.gif" map_type 2 interpolate 4 } }
  finish { ambient 0.2 diffuse 0.7 phong 0.7 phong_size 200 }
  scale <1, 83, 1>
  translate y*-29
  rotate y*-90
}

//------ Kettle Lid Texture
#declare  LidTexture =
texture {
  pigment { image_map { gif "lidmap.gif" interpolate 4 } }
  finish { ambient 0.2 diffuse 0.7 phong 0.7 phong_size 200 }
  scale <170, 170, 1>
  translate <-85, -85, 0>
}

#declare SkinTexture =
texture {
  pigment { image_map { gif "kskin.gif" } }
  finish { ambient 0.2 diffuse 0.7 phong 0.7 phong_size 200 }
}

#declare HandleTexture =
texture {
  pigment { color rgb 0.25 }
  finish { ambient 0.1 diffuse 0.4 phong 1 phong_size 80 }
}

#declare gold2 =
texture {
  pigment { colour rgb <0.64, 0.51, 0.05> }
  finish { crand 0.02 ambient 0.3 diffuse 0.5 reflection { 0.6 } brilliance 8 specular 0.5 }
}

#declare GoldTexture =
texture { gold2 }

//---- Torus for Gold Handle
#declare T1 =
quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -3208, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 3192, 0, 0, 0, 0, 1, 0, -3208, 0, 2547216> }

//---- Torus for Gold Handle
#declare T2 =
quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -4332.5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 4316.5, 0, 0, 0, 0, 1, 0, -4332.5, 0, 4658043.0625> }

//--- Main Body torus of Kettle
#declare Body =
quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -9385, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 2496, 0, 0, 0, 0, 1, 0, -9385, 0, 1557504> texture { BodyTexture } }

#declare Neck =
object {
  intersection {
    quadric { <0.000168662506325, -0.00095128127493, 0.000168662506325>, 0, 0, -1}
    plane { y, -11.872395757976930 inverse }
  }
  clipped_by { plane { y, 16.127604242023075 } }
  translate y*11.872395757976930
  bounded_by { sphere { y*14.000000000000004, 87.132657482714251} }
}

//----Gold Rim
#declare Rim =
quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -14633, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 14608, 0, 0, 0, 0, 1, 0, -14633, 0, 53348416> texture { GoldTexture } }

//---- Kettle Spout
#declare Sp =
object {
   quadric { <0.01, -0.001034381589606, 0.01>, 0, 0, -1 }
   clipped_by {
      plane { y, 0 rotate z*-33 translate y*23 }
      plane { y, -46.535417872100076 inverse }
   }
   translate y*46.535417872100076
   texture { SkinTexture }
   bounded_by { sphere { y*38.5, 42.501176454305352 } }
}

#declare Spout =
union {
   object { Sp translate y*11 }
   sphere { 0, 1 scale <20, 25, 20> }
   texture { SkinTexture }
}

//---- Pin in Top Handle
#declare Pin1 =
object {
   sphere { 0, 1 scale <8.5, 6.5, 6.5> }
   texture { GoldTexture }
}

//---- Pin Pivot in Bottom Handle
#declare Pin2 =
union {
  object { Disk_X scale <15, 4, 4> translate x*-15 }
  sphere { 0, 1 scale <4.5, 6, 6> translate x*-25.5 }
  texture { GoldTexture }
}

//---- Kettle Metallic Support Handle
#declare HandleSupport =
object {
  union {
    difference {
      object { T1 rotate x*90 translate <21, 53.8, 0> }
      plane { y, 0 rotate z*30 translate <-2.5, 18.4, 0> }
      plane { y, 0 rotate z*-52.7 translate <-9.3, 94.1, 0> inverse }
    }
    difference {
      object { T2 rotate x*90 translate <-31.5, 122.5, 0> }
      plane { y, 0 rotate z*-52.7 translate <-9.3, 94.1, 0> }
      plane { y, 0 translate y*122.5 inverse }
    }
    difference {
      intersection { Disk_Y scale <2, 12, 2> translate y*12 }
      plane { y, 0 rotate z*30 translate <-2.5, 18.4, 0> inverse }
    }
    intersection { Disk_Y scale <2, 13, 2> translate <15, 135, 0> }
  }
  texture { GoldTexture }
  scale <1, 1, 5>
}

//--- Gold Handle
/*
#declare Handle =
object {
  union {
    difference {
      object { T1 rotate x*90 translate <21, 53.8, 0> }
      plane { y, 0 rotate z*30 translate <-2.5, 18.4, 0> }
      plane { y, 0 rotate z*-52.7 translate <-9.3, 94.1, 0> inverse }
    }
    difference {
      object{ T2 rotate x*90 translate <-31.5, 122.5, 0> }
      plane { y, 0 rotate z*-52.7 translate <-9.3, 94.1, 0> }
      plane { y, 0 translate y*122.5 inverse }
    }
    difference {
      intersection { Disk_Y scale <2, 12, 2> translate y*12 }
      plane { y, 0 rotate z*30 translate <-2.5, 18.4, 0> inverse }
    }
    intersection { Disk_Y scale <2, 13, 2> translate <15, 135, 0> }
  }
  texture { HandleTexture }
  bounded_by { box { -1, 1 scale <25, 77, 4> translate y*74 } }
  scale <1, 1, 6>
}
*/

//--- Black Wood Handle
#declare Handle =
object {
  union {
    intersection {
      quadric { <0.012345679012346, -0.002798051989648, 0.012345679012346>, 0, 0, -1 }
      plane { y, 10.082560533154419 }
      plane { y, -17.917439466845579 inverse }
      translate y*17.917439466845579
    }
    difference {
      sphere { 0, 1 scale <13, 8, 13> translate y*-2.5 }
      plane { y, -6.5 }
    }
    sphere { 0, 1 scale <12, 29.5, 12> translate y*43.5 }
    sphere { 0, 1 scale <13,  5,   13> translate y*59 }
    sphere { 0, 1 scale <13,  5,   13> translate y*64 }
    sphere { 0, 1 scale <13,  5,   13> translate y*69 }
    sphere { 0, 1 scale <12, 29.5, 12> translate y*84.5 }
    intersection {
      quadric { <0.012345679012346, -0.002798051989648, 0.012345679012346>, 0, 0, -1 }
      plane { y,  17.917439466845579 }
      plane { y, -10.082560533154419 inverse }
      translate y*110.0825605
    }
    difference {
      sphere { 0, 1 scale <13, 8, 13> translate y*130.5 }
      plane { y, 134.5 inverse }
    }
  }  
  texture { HandleTexture }
  bounded_by { box { -1, 1 scale <15, 75, 15> translate y*63.5 } }
  translate y*-64
  rotate z*90
}

//----- Kettle Knob
#declare Knub = sphere { 0, 1 scale <14, 8.7, 6> translate y*11.3 }

#declare Knob =
object {
  union {
    object { Disk_Y scale <13, 4.5, 13> translate y*4.5 }
    sphere { 0, 1 scale <17, 2, 17> translate y*9 }
    object { Knub }
    object { Knub rotate  y*30 }
    object { Knub rotate  y*60 }
    object { Knub rotate  y*90 }
    object { Knub rotate y*120 }
    object { Knub rotate y*150 }
    sphere { 0, 1 scale <4, 1.5, 4> translate y*19.5 }
    sphere { 0, 1 scale <2, 3.5, 2> translate y*22.5 }
  }
  texture { GoldTexture }
  bounded_by { box { -1, 1 scale <19, 14, 19> translate y*13 } }
}

//----- Kettle Lid
#declare LidLip =
quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -12645, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 12636, 0, 0, 0, 0, 1, 0, -12645, 0, 39917124 > texture { GoldTexture } }

#declare Lid1 =
object {
   difference {
      sphere { 0, 1 scale <79, 79, 40> }
      plane { z, 0 inverse }
   }
   texture { LidTexture }
   bounded_by { box { -1, 1 scale <80, 80, 30> translate z*-15 } }
}

#declare Lid =
union {
  object { Lid1 rotate x*90 }
  object { LidLip bounded_by { box { -1, 1 scale <89, 26, 89> translate y*20 } } }
  object { Knob translate y*40 bounded_by { box { -1, 1 scale <89, 37, 89> translate y*31 } } }
}

//--- Build Kettle
#declare Kettle =
union {
  union {
    object { Body translate y*41.4 }
    object { Neck translate y*72 texture { BodyTexture translate y*41.4 } }
    object { Rim translate y*100.5 texture { GoldTexture } }
    object { Spout rotate z*35 translate <-90, 35, 0> bounded_by { box { -1, 1 scale <140, 55, 110> translate <-31, 52, 0> } } }
  }
  object { Lid scale <0.95, 1, 0.95> translate y*99.5  }
  union {
    object { Handle translate y*127.5 }
    object { HandleSupport translate <-88, -9.5, 0> }
    object { HandleSupport rotate y*180 translate <88, -9.5, 0> }
    object { Pin1 translate <-69.5, 127.5, 0> }
    object { Pin1 translate < 69.5, 127.5, 0> }
    object { Pin2 translate x*-69 }
    object { Pin2 rotate y*180 translate x*69
    bounded_by { box { -1, 1 scale <114, 80, 20> translate y*66 } } }
    rotate x*-30   //rotates handle
    translate y*82
  }
}