//------ Old Stove Kettle ............. 9/23/92 M.Miller



//------ Kettle Texture
#declare  BodyTexture =
texture {
	image_map { 2  gif "kmap.gif" interpolate 4 }
	ambient .3
	diffuse .7
	scale <1 83 1>
	translate <0 -29 0>
	phong 1
	phong_size 100
	rotate <0 -90 0>
}

//------ Kettle Lid Texture
#declare  LidTexture =
texture {
	image_map {  gif "lidmap.gif" interpolate 4 }
	ambient .3
	diffuse .7
	scale <170 170 1>
	translate <-85 -85 0>
	phong 1
	phong_size 100
}



#declare SkinTexture =
texture {
	image_map { gif "kskin.gif" }
	ambient .3
	diffuse .7
	phong 1
	phong_size 100
}

#declare HandleTexture =
texture {
	color Gray25
	ambient .3
	diffuse .5
	phong 1
	phong_size 80
}


#declare GoldTexture =
	texture { gold2 }




//--- Main Body torus of Kettle
#declare Body =
object {
   quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -9385.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        2496.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -9385.000000 0.000000 1557504.000000 >
   }
	texture { BodyTexture }
}


#declare Neck =
   object {
      intersection {
         quadric {
            <0.000168662506325 -0.00095128127493 0.000168662506325>
            <0.000000000000000  0.00000000000000 0.000000000000000>
            <0.000000000000000  0.00000000000000 0.000000000000000>
            -1.0
         }
         plane { <0.0 1.0 0.0> -11.872395757976930 inverse }
      }
	 clipped_by {
         plane { <0.0 1.0 0.0> 16.127604242023075 }
	 }
      translate <0.0 11.872395757976930 0.0>
      bounded_by {
         sphere {
            <0 14.000000000000004 0> 87.132657482714251
         }
      }
   }

//----Gold Rim

#declare Rim =
object {
   quartic {

   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -14633.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        14608.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -14633.000000 0.000000 53348416.000000 >
   }
	texture { GoldTexture }
}


//---- Kettle Spout
#declare Sp =
   object {
      quadric {
         <0.01 -0.001034381589606 0.01>
         <0.00  0.000000000000000 0.00>
         <0.00  0.000000000000000 0.00>
            -1.0
      }
      clipped_by {
         plane { <0.0 1.0 0.0> 0 rotate <0 0 -33> translate <0 23 0> }
         plane { <0.0 1.0 0.0> -46.535417872100076 inverse }
      }
      translate <0.0 46.535417872100076 0.0>
	texture { SkinTexture }
	      bounded_by {
         sphere {
            <0 38.500000000000000 0> 42.501176454305352
         }
      }
   }


#declare Spout = 
composite {
    object { Sp translate <0 11 0> }
    object {
      quadric { Sphere scale <20 25 20> }
	texture { SkinTexture }
    }
}


//---- Pin in Top Handle
#declare Pin1 =
object {
   quadric { Sphere scale <8.5 6.5 6.5> }
      texture { GoldTexture }
}

//---- Pin Pivot in Bottom Handle
#declare Pin2 =
object {
   union {
	intersection { Disk_X scale <15 4 4> translate <-15 0 0> }
	quadric { Sphere scale <4.5 6 6> translate <-25.5 0 0> }
   }
	  texture { GoldTexture }
		bounded_by { 
		box { UnitBox scale <16 7 7> translate <-15 0 0> }
		}
}		





//---- Kettle Metallic Support Handle

#declare YourTexture = texture { GoldTexture } 

#declare Dot =
    quadric {
       < 1.0  1.0  1.0>
       < 0.0  0.0  0.0>
       < 0.0  0.0  0.0>
        -1.0
    }

#declare Connector_1 = 
   object {
      quadric {
         < 0.0  1.0  1.0>
         < 0.0  0.0  0.0>
         < 0.0  0.0  0.0>
          -1.0
      }
      clipped_by {
         plane { < 1.0  0.0  0.0> 1.0 }
         plane { <-1.0  0.0  0.0> 0.0 }
      }
   }

#declare Connector_2 =
   quadric {
      < 1.0 -1.0  1.0>
      < 0.0  0.0  0.0>
      < 0.0  0.0  0.0>
        0.0
      rotate < 0.0  0.0  90.0>
   }

#declare HandleSupport =
   composite {
      object {
         quadric {
            Dot
            scale     < 2.000000  2.000000  2.000000>
            translate <-88.000000 -9.500000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 13.500000  2.000000  2.000000>
         rotate    < 0.000000  0.000000  90.000000>
         translate <-88.000000 -9.500000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 2.000000  2.000000  2.000000>
            translate <-88.000000  4.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 2.842869  2.000000  2.000000>
         rotate    < 0.000000  0.000000  85.930064>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-88.000000  4.000000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 2.000000  2.000000  2.000000>
            translate <-88.201770  6.835700  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 2.842866  2.000000  2.000000>
         rotate    < 0.000000  0.000000  73.384305>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-88.201770  6.835700  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 2.000000  2.000000  2.000000>
            translate <-89.014690  9.559860  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 2.842861  2.000000  2.000000>
         rotate    < 0.000000  0.000000  60.839414>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-89.014690  9.559860  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 2.000000  2.000000  2.000000>
            translate <-90.399900  12.042410  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 2.842867  2.000000  2.000000>
         rotate    < 0.000000  0.000000  48.293838>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-90.399900  12.042410  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 2.000000  2.000000  2.000000>
            translate <-92.291290  14.164800  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 2.842870  2.000000  2.000000>
         rotate    < 0.000000  0.000000  35.748608>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-92.291290  14.164800  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 2.000000  2.000000  2.000000>
            translate <-94.598530  15.825690  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.999969 }
            plane {     < 1.000000  0.000000  0.000000>  1.979969 inverse }
         }
         translate <-1.999969  0.000000  0.000000>
         scale     < 179.831358  1.000000  1.000000>
         translate <-0.011121  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  41.140173>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-94.598530  15.825690  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.980000  1.980000  1.980000>
            translate <-97.307200  18.191960  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.979969 }
            plane {     < 1.000000  0.000000  0.000000>  1.959970 inverse }
         }
         translate <-1.979969  0.000000  0.000000>
         scale     < 179.830983  1.000000  1.000000>
         translate <-0.011010  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  46.680207>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-97.307200  18.191960  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.960000  1.960000  1.960000>
            translate <-99.774770  20.808670  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.959970 }
            plane {     < 1.000000  0.000000  0.000000>  1.939970 inverse }
         }
         translate <-1.959970  0.000000  0.000000>
         scale     < 179.831287  1.000000  1.000000>
         translate <-0.010899  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  52.220387>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-99.774770  20.808670  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.940000  1.940000  1.940000>
            translate <-101.978190  23.651390  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.939970 }
            plane {     < 1.000000  0.000000  0.000000>  1.919970 inverse }
         }
         translate <-1.939970  0.000000  0.000000>
         scale     < 179.831388  1.000000  1.000000>
         translate <-0.010788  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  57.760594>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-101.978190  23.651390  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.920000  1.920000  1.920000>
            translate <-103.896870  26.693560  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.919970 }
            plane {     < 1.000000  0.000000  0.000000>  1.899971 inverse }
         }
         translate <-1.919970  0.000000  0.000000>
         scale     < 179.830798  1.000000  1.000000>
         translate <-0.010677  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  63.300586>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-103.896870  26.693560  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.900000  1.900000  1.900000>
            translate <-105.512890  29.906740  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.899971 }
            plane {     < 1.000000  0.000000  0.000000>  1.879971 inverse }
         }
         translate <-1.899971  0.000000  0.000000>
         scale     < 179.831426  1.000000  1.000000>
         translate <-0.010565  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  68.840820>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-105.512890  29.906740  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.880000  1.880000  1.880000>
            translate <-106.811150  33.260940  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.879971 }
            plane {     < 1.000000  0.000000  0.000000>  1.859971 inverse }
         }
         translate <-1.879971  0.000000  0.000000>
         scale     < 179.831073  1.000000  1.000000>
         translate <-0.010454  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  74.380776>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-106.811150  33.260940  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.860000  1.860000  1.860000>
            translate <-107.779530  36.724800  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.859971 }
            plane {     < 1.000000  0.000000  0.000000>  1.839972 inverse }
         }
         translate <-1.859971  0.000000  0.000000>
         scale     < 179.831522  1.000000  1.000000>
         translate <-0.010343  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  79.921019>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-107.779530  36.724800  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.840000  1.840000  1.840000>
            translate <-108.408970  40.265980  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.839972 }
            plane {     < 1.000000  0.000000  0.000000>  1.819972 inverse }
         }
         translate <-1.839972  0.000000  0.000000>
         scale     < 179.831222  1.000000  1.000000>
         translate <-0.010232  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  85.461045>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-108.408970  40.265980  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.820000  1.820000  1.820000>
            translate <-108.693600  43.851380  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.819972 }
            plane {     < 1.000000  0.000000  0.000000>  1.799972 inverse }
         }
         translate <-1.819972  0.000000  0.000000>
         scale     < 179.830679  1.000000  1.000000>
         translate <-0.010120  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  88.998734>
         translate <-108.693600  43.851380  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.800000  1.800000  1.800000>
            translate <-108.630750  47.447500  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.799972 }
            plane {     < 1.000000  0.000000  0.000000>  1.779972 inverse }
         }
         translate <-1.799972  0.000000  0.000000>
         scale     < 179.831429  1.000000  1.000000>
         translate <-0.010009  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  83.458732>
         translate <-108.630750  47.447500  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.780000  1.780000  1.780000>
            translate <-108.221020  51.020770  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.779972 }
            plane {     < 1.000000  0.000000  0.000000>  1.759973 inverse }
         }
         translate <-1.779972  0.000000  0.000000>
         scale     < 179.830838  1.000000  1.000000>
         translate <-0.009898  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  77.918561>
         translate <-108.221020  51.020770  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.760000  1.760000  1.760000>
            translate <-107.468230  54.537780  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.759973 }
            plane {     < 1.000000  0.000000  0.000000>  1.739973 inverse }
         }
         translate <-1.759973  0.000000  0.000000>
         scale     < 179.831468  1.000000  1.000000>
         translate <-0.009787  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  72.378594>
         translate <-107.468230  54.537780  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.740000  1.740000  1.740000>
            translate <-106.379420  57.965700  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.739973 }
            plane {     < 1.000000  0.000000  0.000000>  1.719973 inverse }
         }
         translate <-1.739973  0.000000  0.000000>
         scale     < 179.831264  1.000000  1.000000>
         translate <-0.009676  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  66.838182>
         translate <-106.379420  57.965700  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.720000  1.720000  1.720000>
            translate <-104.964740  61.272480  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.719973 }
            plane {     < 1.000000  0.000000  0.000000>  1.699974 inverse }
         }
         translate <-1.719973  0.000000  0.000000>
         scale     < 179.831004  1.000000  1.000000>
         translate <-0.009564  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  61.298332>
         translate <-104.964740  61.272480  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.700000  1.700000  1.700000>
            translate <-103.237440  64.427240  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.699974 }
            plane {     < 1.000000  0.000000  0.000000>  1.679974 inverse }
         }
         translate <-1.699974  0.000000  0.000000>
         scale     < 179.831459  1.000000  1.000000>
         translate <-0.009453  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  55.758131>
         translate <-103.237440  64.427240  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.680000  1.680000  1.680000>
            translate <-101.213630  67.400510  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.679974 }
            plane {     < 1.000000  0.000000  0.000000>  1.659974 inverse }
         }
         translate <-1.679974  0.000000  0.000000>
         scale     < 179.831435  1.000000  1.000000>
         translate <-0.009342  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  50.218089>
         translate <-101.213630  67.400510  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.660000  1.660000  1.660000>
            translate <-98.912230  70.164510  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.659974 }
            plane {     < 1.000000  0.000000  0.000000>  1.639975 inverse }
         }
         translate <-1.659974  0.000000  0.000000>
         scale     < 179.831103  1.000000  1.000000>
         translate <-0.009231  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  44.677951>
         translate <-98.912230  70.164510  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.640000  1.640000  1.640000>
            translate <-96.354740  72.693410  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.639975 }
            plane {     < 1.000000  0.000000  0.000000>  1.619975 inverse }
         }
         translate <-1.639975  0.000000  0.000000>
         scale     < 179.830769  1.000000  1.000000>
         translate <-0.009120  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  39.137711>
         translate <-96.354740  72.693410  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.620000  1.620000  1.620000>
            translate <-93.565050  74.963580  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.619975 }
            plane {     < 1.000000  0.000000  0.000000>  1.599975 inverse }
         }
         translate <-1.619975  0.000000  0.000000>
         scale     < 179.831118  1.000000  1.000000>
         translate <-0.009008  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  33.597682>
         translate <-93.565050  74.963580  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.600000  1.600000  1.600000>
            translate <-90.569220  76.953830  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.599983 }
            plane {     < 1.000000  0.000000  0.000000>  1.586653 inverse }
         }
         translate <-1.599983  0.000000  0.000000>
         scale     < 213.846629  1.000000  1.000000>
         translate <-0.007482  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  43.028338>
         translate <-90.569220  76.953830  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.586670  1.586670  1.586670>
            translate <-88.485380  78.898970  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.586653 }
            plane {     < 1.000000  0.000000  0.000000>  1.573313 inverse }
         }
         translate <-1.586653  0.000000  0.000000>
         scale     < 213.685977  1.000000  1.000000>
         translate <-0.007425  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  46.083058>
         translate <-88.485380  78.898970  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.573330  1.573330  1.573330>
            translate <-86.508160  80.952390  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.573313 }
            plane {     < 1.000000  0.000000  0.000000>  1.559983 inverse }
         }
         translate <-1.573313  0.000000  0.000000>
         scale     < 213.845215  1.000000  1.000000>
         translate <-0.007357  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  49.138181>
         translate <-86.508160  80.952390  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.560000  1.560000  1.560000>
            translate <-84.643200  83.108260  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.559983 }
            plane {     < 1.000000  0.000000  0.000000>  1.546653 inverse }
         }
         translate <-1.559983  0.000000  0.000000>
         scale     < 213.846665  1.000000  1.000000>
         translate <-0.007295  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  52.193062>
         translate <-84.643200  83.108260  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.546670  1.546670  1.546670>
            translate <-82.895770  85.360470  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.546653 }
            plane {     < 1.000000  0.000000  0.000000>  1.533313 inverse }
         }
         translate <-1.546653  0.000000  0.000000>
         scale     < 213.685431  1.000000  1.000000>
         translate <-0.007238  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  55.247795>
         translate <-82.895770  85.360470  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.533330  1.533330  1.533330>
            translate <-81.270850  87.702590  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.533313 }
            plane {     < 1.000000  0.000000  0.000000>  1.519983 inverse }
         }
         translate <-1.533313  0.000000  0.000000>
         scale     < 213.845745  1.000000  1.000000>
         translate <-0.007170  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  58.302760>
         translate <-81.270850  87.702590  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.520000  1.520000  1.520000>
            translate <-79.773060  90.127980  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.519983 }
            plane {     < 1.000000  0.000000  0.000000>  1.506654 inverse }
         }
         translate <-1.519983  0.000000  0.000000>
         scale     < 213.846243  1.000000  1.000000>
         translate <-0.007108  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  61.357634>
         translate <-79.773060  90.127980  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.506670  1.506670  1.506670>
            translate <-78.406650  92.629750  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.506654 }
            plane {     < 1.000000  0.000000  0.000000>  1.493314 inverse }
         }
         translate <-1.506654  0.000000  0.000000>
         scale     < 213.685913  1.000000  1.000000>
         translate <-0.007051  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  64.412797>
         translate <-78.406650  92.629750  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.493330  1.493330  1.493330>
            translate <-77.175520  95.200790  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.493314 }
            plane {     < 1.000000  0.000000  0.000000>  1.479984 inverse }
         }
         translate <-1.493314  0.000000  0.000000>
         scale     < 213.845969  1.000000  1.000000>
         translate <-0.006983  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  67.467506>
         translate <-77.175520  95.200790  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.480000  1.480000  1.480000>
            translate <-76.083150  97.833780  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.479984 }
            plane {     < 1.000000  0.000000  0.000000>  1.466654 inverse }
         }
         translate <-1.479984  0.000000  0.000000>
         scale     < 213.846201  1.000000  1.000000>
         translate <-0.006921  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  70.522604>
         translate <-76.083150  97.833780  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.466670  1.466670  1.466670>
            translate <-75.132660  100.521250  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.466654 }
            plane {     < 1.000000  0.000000  0.000000>  1.453314 inverse }
         }
         translate <-1.466654  0.000000  0.000000>
         scale     < 213.685595  1.000000  1.000000>
         translate <-0.006864  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  73.577407>
         translate <-75.132660  100.521250  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.453330  1.453330  1.453330>
            translate <-74.326740  103.255550  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.453314 }
            plane {     < 1.000000  0.000000  0.000000>  1.439984 inverse }
         }
         translate <-1.453314  0.000000  0.000000>
         scale     < 213.846225  1.000000  1.000000>
         translate <-0.006796  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  76.632456>
         translate <-74.326740  103.255550  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.440000  1.440000  1.440000>
            translate <-73.667690  106.028920  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.439984 }
            plane {     < 1.000000  0.000000  0.000000>  1.426654 inverse }
         }
         translate <-1.439984  0.000000  0.000000>
         scale     < 213.846214  1.000000  1.000000>
         translate <-0.006734  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  79.687207>
         translate <-73.667690  106.028920  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.426670  1.426670  1.426670>
            translate <-73.157370  108.833470  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.426654 }
            plane {     < 1.000000  0.000000  0.000000>  1.413315 inverse }
         }
         translate <-1.426654  0.000000  0.000000>
         scale     < 213.684976  1.000000  1.000000>
         translate <-0.006676  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  82.742328>
         translate <-73.157370  108.833470  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.413330  1.413330  1.413330>
            translate <-72.797250  111.661220  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.413315 }
            plane {     < 1.000000  0.000000  0.000000>  1.399985 inverse }
         }
         translate <-1.413315  0.000000  0.000000>
         scale     < 213.846585  1.000000  1.000000>
         translate <-0.006609  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  85.797043>
         translate <-72.797250  111.661220  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.400000  1.400000  1.400000>
            translate <-72.588330  114.504160  0.000000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.399987 }
            plane {     < 1.000000  0.000000  0.000000>  1.299988 inverse }
         }
         translate <-1.399987  0.000000  0.000000>
         scale     < 234.957932  1.000000  1.000000>
         translate <-0.005958  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  89.784604>
         translate <-72.588330  114.504160  0.000000>
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Dot
            scale     < 1.300000  1.300000  1.300000>
            translate <-72.500000  138.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }
      bounded_by {
         box {
            UnitBox
            scale < 23 81 5>
            translate <-91 66 0>
         }
      }
scale <1 1 6 >
   }




//--- Black Wood Handle
#declare Handle =
object {
    union {
      intersection {
         quadric {
            <0.012345679012346 -0.002798051989648 0.012345679012346>
            <0.000000000000000  0.000000000000000 0.000000000000000>
            <0.000000000000000  0.000000000000000 0.000000000000000>
            -1.0
         }
         plane { <0.0 1.0 0.0> 10.082560533154419 }
         plane { <0.0 1.0 0.0> -17.917439466845579 inverse }
         translate <0.0 17.917439466845579 0.0>
      }
         difference {
	    quadric { Sphere scale <13 8 13> translate <0 -2.5 0> }
	    plane { <0 1 0> -6.5 }
         } 
	 quadric { Sphere scale <12 29.5 12> translate <0 43.5 0> }
	 quadric { Sphere scale <13 5 13> translate <0 59 0> }
	 quadric { Sphere scale <13 5 13> translate <0 64 0> }
	 quadric { Sphere scale <13 5 13> translate <0 69 0> }
	 quadric { Sphere scale <12 29.5 12> translate <0 84.5 0> }

         intersection {
          quadric {
            <0.012345679012346 -0.002798051989648 0.012345679012346>
            <0.000000000000000  0.000000000000000 0.000000000000000>
            <0.000000000000000  0.000000000000000 0.000000000000000>
            -1.0
          }
            plane { <0.0 1.0 0.0> 17.917439466845579 }
            plane { <0.0 1.0 0.0> -10.082560533154419 inverse }
            translate <0 110.0825605 0>
         }
         difference {
	    quadric { Sphere scale <13 8 13> translate <0 130.5 0> }
	    plane { <0 1 0> 134.5 inverse }
         } 
   }
	texture { HandleTexture }	

	bounded_by {
	box { UnitBox scale <15 75 15> translate <0 63.5 0> }
	}
translate <0 -64 0> rotate <0 0 90>
}




//----- Kettle Knob

#declare Knub = quadric { Sphere scale <14 8.7 6> translate <0 11.3 0> }


#declare Knob =
object {
   union {
     intersection { Disk_Y scale <13 4.5 13> translate <0 4.5 0> }
     quadric { Sphere scale <17 2 17> translate <0 9 0> }
     quadric { Knub rotate <0 0 0> }   
     quadric { Knub rotate <0 30 0> }   
     quadric { Knub rotate <0 60 0> }   
     quadric { Knub rotate <0 90 0> }   
     quadric { Knub rotate <0 120 0> }   
     quadric { Knub rotate <0 150 0> }   
     quadric { Sphere scale <4 1.5 4> translate <0 19.5 0> }
     quadric { Sphere scale <2 3.5 2> translate <0 22.5 0> }
   }
	texture { GoldTexture }
	  bounded_by {
	  box { UnitBox scale <19 14 19> translate <0 13 0> }
	  }
}


//----- Kettle Lid

#declare LidLip =
object {
   quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -12645.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        12636.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -12645.000000 0.000000 39917124.000000 >
    }
    texture { GoldTexture }
}


#declare Lid1 =
object {
   difference {
      quadric { Sphere scale <79 79 40> }
      plane { <0 0 1> 0 inverse }
   }
      texture { LidTexture }
         bounded_by {
	 box { UnitBox scale <80 80 30> translate <0 0 -15> }
	 }
}

#declare Lid =
composite {
  composite {
    object { Lid1 rotate <90 0 0> }
    object { LidLip }
         bounded_by {
	 box { UnitBox scale <89 26 89> translate <0 20 0> }
	 }
  } 
  object { Knob translate <0 40 0> } 
         bounded_by {
	 box { UnitBox scale <89 37 89> translate <0 31 0> }
	 }
}






//--- Build Kettle

#declare Kettle =
composite {

  composite {
     object { Body translate <0 41.4 0> }
     object { Neck translate <0 72 0> texture { BodyTexture translate <0 41.4 0> } }
     object { Rim translate <0 100.5 0> }
     composite { Spout rotate <0 0 35> translate <-90 35 0> }
         bounded_by {
	 box { UnitBox scale <140 55 110> translate <-31 52 0> }
	 }
  }     

   composite { Lid scale <.95 1 .95> translate <0 99.5 0>  }

   composite { 
     object { Handle translate <0 127.5 0> }
     composite { HandleSupport  }
     composite { HandleSupport rotate <0 180 0> }
     object { Pin1 translate <-69.5 127.5 0> }
     object { Pin1 translate <69.5 127.5 0> }
     object { Pin2 translate <-69 0 0> }
     object { Pin2 rotate <0 180 0> translate <69 0 0> }
         bounded_by {
	 box { UnitBox scale <114 80 20> translate <0 66 0> }
	 }
	      rotate <-30 0 0>   //rotates handle   
	      translate <0 82 0>
 }


}


