//--- Dragon Skull & Horns
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#include "eye.inc"

//--- Top of Skull
#declare Sk1 =
object {
  intersection {
    union {
      sphere { 0, 1 scale <20, 15, 15> translate z*-4 }
      sphere { 0, 1 scale <17, 12.5, 12.5> translate <14, -5, -4> }
      sphere { 0, 1 scale <15, 11, 11> translate <21, -5, -4> }
      sphere { 0, 1 scale <10.5, 7.5, 7.5> translate <30, -5, -4> }
      sphere { 0, 1 scale <20, 15, 15> translate z*4 }
      sphere { 0, 1 scale <17, 12.5, 12.5> translate <14, -5, 4> }
      sphere { 0, 1 scale <15, 11, 11> translate <21, -5, 4> }
      sphere { 0, 1 scale <10.5, 7.5, 7.5> translate <30, -5, 4> }
    }
    object { Cylinder_Z scale <11, 6.5, 1> rotate z*11 translate <-19.5, -11.5, 0> inverse }
    object { Cylinder_Z scale <16, 9, 1> rotate z*25 translate <2, -16, 0> inverse }
    object { Cylinder_Z scale <13, 7, 1> rotate z*0 translate <18, -12, 0> inverse }
    object { Cylinder_Z scale <11, 6, 1> rotate z*9 translate <31, -11, 0> inverse }
  }
  texture { SkullTexture }
  bounded_by { box { -1, 1 scale <35, 20, 20> translate x*6 } }
}

//--- Bottom Jaw
#declare Sk2 =
union {
  sphere { 0, 1 scale <20, 15, 15> translate y*-5 }
  sphere { 0, 1 scale <17, 12.5, 12.5> translate <14, -5, 0> }
  sphere { 0, 1 scale <15, 11, 11> translate <21, -5, 0> }
  sphere { 0, 1 scale <10.5, 7.5, 7.5> translate <30, -5, 0> }
  texture { SkullTexture }
  bounded_by { box { -1, 1 scale <35, 20, 20> translate <6, -8, 0> } }
}

//--- Dragon Horn
#declare Horn =
  union {
    sphere { 0, 0.2 texture { HornTexture } }
    sphere { 0, 0.28667 translate <-0.36152, 0.66566, 0> texture { HornTexture } }
    sphere { 0, 0.37333 translate <-0.76729, 1.30532, 0> texture { HornTexture } }
    sphere { 0, 0.46 translate <-1.21544, 1.91603, 0> texture { HornTexture } }
    sphere { 0, 0.54667 translate <-1.70392, 2.495, 0> texture { HornTexture } }
    sphere { 0, 0.63333 translate <-2.23047, 3.03956, 0> texture { HornTexture } }
    sphere { 0, 0.72 translate <-2.7927, 3.54721, 0> texture { HornTexture } }
    sphere { 0, 0.80667 translate <-3.38801, 4.01563, 0> texture { HornTexture } }
    sphere { 0, 0.89333 translate <-4.01367, 4.44266, 0> texture { HornTexture } }
    sphere { 0, 0.98 translate <-4.66681, 4.82635, 0> texture { HornTexture } }
    sphere { 0, 1.06667 translate <-5.34443, 5.16492, 0> texture { HornTexture } }
    sphere { 0, 1.15333 translate <-6.04343, 5.45684, 0> texture { HornTexture } }
    sphere { 0, 1.24 translate <-6.76058, 5.70076, 0> texture { HornTexture } }
    sphere { 0, 1.32667 translate <-7.49261, 5.89555, 0> texture { HornTexture } }
    sphere { 0, 1.41333 translate <-8.23615, 6.04033, 0> texture { HornTexture } }
    sphere { 0, 1.5 translate <-8.98778, 6.13442, 0> texture { HornTexture } }
    sphere { 0, 1.625 translate <-10.30517, 6.10088, 0> texture { HornTexture } }
    sphere { 0, 1.75 translate <-11.61981, 6.19221, 0> texture { HornTexture } }
    sphere { 0, 1.875 translate <-12.9199, 6.40761, 0> texture { HornTexture } }
    sphere { 0, 2 translate <-14.19375, 6.74514, 0> texture { HornTexture } }
    sphere { 0, 2.125 translate <-15.42993, 7.20177, 0> texture { HornTexture } }
    sphere { 0, 2.25 translate <-16.61731, 7.77339, 0> texture { HornTexture } }
    sphere { 0, 2.375 translate <-17.74524, 8.45487, 0> texture { HornTexture } }
    sphere { 0, 2.5 translate <-18.80357, 9.24008, 0> texture { HornTexture } }
    sphere { 0, 2.72222 translate <-20.32135, 10.7, 0> texture { HornTexture } }
    sphere { 0, 2.94444 translate <-21.98833, 11.98691, 0> texture { HornTexture } }
    sphere { 0, 3.16667 translate <-23.78491, 13.08568, 0> texture { HornTexture } }
    sphere { 0, 3.38889 translate <-25.68995, 13.98336, 0> texture { HornTexture } }
    sphere { 0, 3.61111 translate <-27.68101, 14.6694, 0> texture { HornTexture } }
    sphere { 0, 3.83333 translate <-29.73468, 15.13572, 0> texture { HornTexture } }
    sphere { 0, 4.05556 translate <-31.82677, 15.37683, 0> texture { HornTexture } }
    sphere { 0, 4.27778 translate <-33.93267, 15.3899, 0> texture { HornTexture } }
    sphere { 0, 4.5 translate <-36.0276, 15.17477, 0> texture { HornTexture } }
    sphere { 0, 4.625 translate <-38.04055, 15.07177, 0> texture { HornTexture } }
    sphere { 0, 4.75 translate <-40.05304, 15.1834, 0> texture { HornTexture } }
    sphere { 0, 4.875 translate <-42.04226, 15.50839, 0> texture { HornTexture } }
    sphere { 0, 5 translate <-43.98565, 16.04306, 0> texture { HornTexture } }
    sphere { 0, 4.75 translate <-46.49339, 17.08427, 0> texture { HornTexture } }
    sphere { 0, 4.5 translate <-48.82636, 18.47359, 0> texture { HornTexture } }
    sphere { 0, 4.25 translate <-50.93654, 20.18242, 0> texture { HornTexture } }
    sphere { 0, 4 translate <-52.7805, 22.1756, 0> texture { HornTexture } }
    sphere { 0, 3.6875 translate <-53.84364, 23.16746, 0> texture { HornTexture } }
    sphere { 0, 3.375 translate <-54.97577, 24.07979, 0> texture { HornTexture } }
    sphere { 0, 3.0625 translate <-56.17095, 24.9078, 0> texture { HornTexture } }
    sphere { 0, 2.75 translate <-57.42292, 25.64714, 0> texture { HornTexture } }
    sphere { 0, 2.4375 translate <-58.72512, 26.29394, 0> texture { HornTexture } }
    sphere { 0, 2.125 translate <-60.07071, 26.8448, 0> texture { HornTexture } }
    sphere { 0, 1.8125 translate <-61.45263, 27.29685, 0> texture { HornTexture } }
    sphere { 0, 1.5 translate <-62.86364, 27.64771, 0> texture { HornTexture } }
    sphere { 0, 1.435 translate <-63.62832, 27.51942, 0> texture { HornTexture } }
    sphere { 0, 1.37 translate <-64.39816, 27.42688, 0> texture { HornTexture } }
    sphere { 0, 1.305 translate <-65.17146, 27.37028, 0> texture { HornTexture } }
    sphere { 0, 1.24 translate <-65.94656, 27.34973, 0> texture { HornTexture } }
    sphere { 0, 1.175 translate <-66.72178, 27.3653, 0> texture { HornTexture } }
    sphere { 0, 1.11 translate <-67.49544, 27.41694, 0> texture { HornTexture } }
    sphere { 0, 1.045 translate <-68.26585, 27.50454, 0> texture { HornTexture } }
    sphere { 0, 0.98 translate <-69.03134, 27.62791, 0> texture { HornTexture } }
    sphere { 0, 0.915 translate <-69.79027, 27.78679, 0> texture { HornTexture } }
    sphere { 0, 0.85 translate <-70.54097, 27.98083, 0> texture { HornTexture } }
    sphere { 0, 0.785 translate <-71.28182, 28.20961, 0> texture { HornTexture } }
    sphere { 0, 0.72 translate <-72.01123, 28.47262, 0> texture { HornTexture } }
    sphere { 0, 0.655 translate <-72.72759, 28.76932, 0> texture { HornTexture } }
    sphere { 0, 0.59 translate <-73.42937, 29.09904, 0> texture { HornTexture } }
    sphere { 0, 0.525 translate <-74.11504, 29.46107, 0> texture { HornTexture } }
    sphere { 0, 0.46 translate <-74.7831, 29.85464, 0> texture { HornTexture } }
    sphere { 0, 0.395 translate <-75.43212, 30.27887, 0> texture { HornTexture } }
    sphere { 0, 0.33 translate <-76.06069, 30.73287, 0> texture { HornTexture } }
    sphere { 0, 0.265 translate <-76.66743, 31.21563, 0> texture { HornTexture } }
    sphere { 0, 0.2 translate <-77.25105, 31.72612, 0> texture { HornTexture } }
    bounded_by { sphere { 0, 46.544993 translate <-38.625525, 15.86306, 0> } }
  }

//--- Attach Eyes & Jaw to Head
#declare Skull =
union {
  union {
    object { Sk1 }
    object { Sk2 scale <1, 0.6, 0.9> translate y*-5 }
    object { Lid2 translate <6, 1, -16.6> texture { SkullTexture } }
    object { Lid2 translate <-6, 1, -16.6> rotate y*180 texture { SkullTexture } } //Mike forgot this!
  }
  object { Eye rotate y*-28 translate <6, 1, -16.4> }
  object { GlassCap translate <6, 1, -16.4> }

  object { Eye rotate y*-196 translate <6, 1, 16.4> }
  object { GlassCap translate <6, 1, 16.4> }
}

//--- Complete Head w/ Horns
#declare Head =
union {
  object { Horn rotate y*15 translate <36, -6, 9> }
  object { Horn rotate y*-15 translate <36, -6, -9> }
  object { Skull }
}