//--- Dragon 
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

global_settings {
  //assumed_gamma 1
  //ambient_light 0.1
  max_trace_level 20
}

#version 3.1;

#include "shapes.inc"
#include "shapes2.inc"
#include "textures.inc"
#include "dragtex.inc"
#include "Back.inc"
#include "legs.inc"
#include "wing.inc"
#include "head.inc"
#include "foot.inc"
#include "worm.inc"

camera {
  location <10, 50, -145> 
  direction z*1.9
  up y
  right x*image_width/image_height
  look_at <10, 25, 0>
}

light_source { <  30, 100, -300> color rgb 1 }
light_source { <-330, 150, -500> color rgb <0.8, 0.498039, 0.196078> }
light_source { <2300,  50,  500> color rgb <0.55, 0.09, 0.09> }

#declare GlassBall =
sphere { 0, 10
  texture { Glass }
  interior { ior 1.5 }
}

//----- Complete Dragon
#declare Dragon =
union {
  object { Back }
  object { Belly scale <1, 1, 0.8> }
  object { BLeg translate z*-7 }
  object { BLeg translate z*7 }
  object { FLeg translate z*6 }
  object { FLeg translate z*-6 }
  object { Wing rotate x*-45 translate <14, 22, -4> }
  object { Wing rotate x*45 translate <14, 22, 4>  }
  object { Head scale 0.3 rotate 0 translate <45, 38, 0> }
  object { Foot scale 0.6 translate <-15, 0, -7> }
  object { Foot scale 0.6 translate <-15, 0, 7> }
  object { Foot scale 0.7 translate <12, 0, -7> }
  object { Foot scale 0.7 translate <12, 0, 7> }
  bounded_by { box { -1, 1 scale <80, 30, 50> translate <-10, 27, 0> } }
}

object { GlassBall translate <40, 10, 20> rotate y*45 }
object { Dragon rotate y*45 }

//--- Floor
plane { y, 0
  texture {
    pigment {
      checker
        color rgb 0.2
        color rgb 0.3
    }
    finish {
      ambient 0.3
      reflection { 0.4 }
    }
    scale <10, 1, 10>
    translate <0.1, 0.11, 0.3>
    rotate y*30
  }
}

fog { distance 5000 color rgb 0 }

object { Worm translate <60, -5, 30> }
object { Worm scale 2 translate <200, -5, 1000> }
object { Worm translate <60, -5, 100> }

