//------ Plants & Pot
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare X_Disk =
intersection {  
  object { Cylinder_X }
  plane { x, 0 inverse }
  plane { x, 1 }
}

#declare Y_Disk =
intersection { 
  object { Cylinder_Y }
  plane { y, 0 inverse }
  plane { y, 1 }
}

#declare Z_Disk =
intersection {  
  object { Cylinder_Z }
  plane { z, 0 inverse }
  plane { z, 1 }
}

#declare Leaf_Texture = 
texture {
  pigment { color rgb <0.184314, 0.309804, 0.184314> }
  finish { crand 0.04 ambient 0.35 diffuse 0.8 phong 1 phong_size 60 }
  normal { waves 0.8 frequency 0.05 }
  scale <10, 0.01, 10>
}

//------------- Plant Leaf
#declare LEAF_BODY =
object {
  intersection {
    sphere { 0, 20 }
    plane { z, 0 rotate y*26 translate z*-10 inverse }
    plane { z, 0 rotate y*-26 translate z*10 }  
  }
  texture { Leaf_Texture  }
  clipped_by {
    plane { y, 0 rotate z*22.5 translate y*8 inverse }
    sphere { 0, 19.9 inverse }
  }
  bounded_by { sphere { 0, 21 } }
}

#declare STEM = 
object { Z_Disk scale <77, 77, 0.7> translate <-40, -40, 0>
  texture { Leaf_Texture }
  clipped_by {
    plane { x, 0 rotate z*22.5  translate x*20 inverse }
    object { Cylinder_Z scale <76.5, 76.5, 1> translate <-40, -40, 0> inverse }
  }
  bounded_by { box { -1, 1 scale <31, 35, 21> translate <9, -12, 0> } }
}

//------- One Leaf & Stem
#declare LEAF =
union {
  object { LEAF_BODY }
  object { STEM }
  translate <-37, 40, 0 >   
}

//------- 4 Leafs in a bunch
#declare BUNCH4=
union {
  object { LEAF rotate 0 }
  object { LEAF rotate y*90 }
  object { LEAF rotate y*180 }
  object { LEAF rotate y*270 }
  bounded_by { box { -1, 1 scale <65, 35, 65> translate y*30 } }
}

//------- 3 Leafs in a bunch
#declare BUNCH3=
union {
  object { LEAF rotate y*120 }
  object { LEAF rotate y*240 }
  object { LEAF rotate 0 }
  bounded_by { box { -1, 1 scale <65, 35, 65> translate y*30 } }
}

//---  Plant Crock

#declare Torus1 = 
quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -2896, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 2880, 0, 0, 0, 0, 1, 0, -2896, 0, 2073600> }

#declare Torus2 = 
quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -2468, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 2432, 0, 0, 0, 0, 1, 0, -2468, 0, 1478656> }

#declare Grnt7 =
texture {
  pigment {
    granite
    turbulence 0.5
    color_map {
      [0.000 0.153 color rgbf <0.439, 0.310, 0.282, 0> color rgbf <0.463, 0.369, 0.259, 0>]
      [0.153 0.398 color rgbf <0.463, 0.369, 0.259, 0> color rgbf <0.541, 0.369, 0.298, 0>]
      [0.398 0.559 color rgbf <0.541, 0.369, 0.298, 0> color rgbf <0.573, 0.424, 0.286, 0>]
      [0.559 0.729 color rgbf <0.573, 0.424, 0.286, 0> color rgbf <0.494, 0.396, 0.306, 0>]
      [0.729 1.001 color rgbf <0.494, 0.396, 0.306, 0> color rgbf <0.439, 0.310, 0.282, 0>]
    }
  }
}

#declare Grnt0a =
texture {
  pigment {
    granite
    turbulence 0.6
    color_map {
      [0.000 0.153 color rgbf <0.729, 0.502, 0.451, 0.306> color rgbf <0.769, 0.686, 0.592, 0.792>]
      [0.153 0.398 color rgbf <0.769, 0.686, 0.592, 0.792> color rgbf <0.843, 0.753, 0.718, 0.396>]
      [0.398 0.559 color rgbf <0.843, 0.753, 0.718, 0.396> color rgbf <0.780, 0.667, 0.561, 0.976>]
      [0.559 0.729 color rgbf <0.780, 0.667, 0.561, 0.976> color rgbf <0.741, 0.659, 0.576, 0.820>]
      [0.729 1.001 color rgbf <0.741, 0.659, 0.576, 0.820> color rgbf <0.729, 0.502, 0.451, 0.306>]
    }
  }
}

#declare Stone1 =
texture { Grnt7 scale <2, 3, 2> rotate z*40 finish { ambient 0.2 diffuse 0.4 } }
texture { Grnt0a scale <2, 3, 2> rotate z*-30 finish { ambient 0.2 diffuse 0.4 phong 1.0 phong_size 80 } }

#declare Crock_Texture = texture { Stone1 scale <20, 35, 10> }

#declare Rib = sphere { 0, 1 scale <20, 41, 41> }

#declare Crock =
union {
  intersection {
    union {
      object { Rib rotate 0 }
      object { Rib rotate y*15 }    
      object { Rib rotate y*30 }
      object { Rib rotate y*45 }
      object { Rib rotate y*60 }
      object { Rib rotate y*75 }
      object { Rib rotate y*90 }
      object { Rib rotate y*105 }
      object { Rib rotate y*120 }
      object { Rib rotate y*135 }
      object { Rib rotate y*150 }
      object { Rib rotate y*165 }
    }
    object { Disk_Y scale <33, 10, 33> inverse translate y*26 }
 }  
 object { Torus1 translate y*26 }
 object { Torus2 translate y*26 }
 texture { Crock_Texture }
 bounded_by { sphere { 0, 50 } }
 translate y*30
}

#declare Planter =
union {
  union {
    union {
      object { BUNCH4 }
      object { BUNCH4 rotate y*45 }
      rotate y*22 scale 0.9 translate y*-12
    }
    object { BUNCH4 }
    object { BUNCH4 rotate y*45 }
    object { BUNCH4 rotate y*45 scale 0.95 translate y*20 }
    object { BUNCH3 rotate y*5 scale 0.9 translate y*35 }
    object { BUNCH3 rotate y*50 scale 0.7 translate y*48 }
    object { BUNCH3 rotate y*110 scale 0.65 translate y*60 }
    object { BUNCH3 rotate y*50 scale 0.35 translate y*72 }
    bounded_by { box { -1, 1 scale <80, 60, 80> translate y*55 } }
    translate y*20
  }
  object { Crock scale 0.75 }
  bounded_by { box { -1, 1 scale <65, 80, 65> translate y*65 } }
}