//------ Persian Pool
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

global_settings {
  //assumed_gamma 1
  //ambient_light 0
  max_trace_level 20
}

#version 3.1;

#include "shapes.inc"
#include "planter.inc"
#include "palace.inc"
#include "dragon.inc"

camera {
  location <0, 60, -460>
  direction z*4
  up y
  right x*image_width/image_height
  look_at y*28
}

sphere { 0, 1 inverse
  hollow on
  texture {
    pigment {
      gradient y
      color_map {
        [0.00 0.01 color rgb 0 color rgb 0]
        [0.01 0.06 color rgb 0 color rgb <0.184314, 0.184314, 0.309804>]
        [0.06 0.19 color rgb <0.184314, 0.184314, 0.309804> color rgb <0.184314, 0.184314, 0.309804>]
        [0.19 0.30 color rgb <0.184314, 0.184314, 0.309804> color rgb 0]
        [0.30 1.00 color rgb 0 color rgb 0]
      }
    }
    finish { ambient 1 }
    translate y*-0.01
  }
  scale 100000
}

light_source { <2000, 70, -460 > color rgb 0.752941 }
light_source { <-6050, 80, -700 > color <0.8, 0.498039, 0.196078> }
light_source { <-50, 400, -200 > color <0.8, 0.498039, 0.196078> }
light_source { <0, 10, 450> color rgb 0.8
  spotlight
  point_at <0, 70, 600>
  tightness 5
  radius 10
  falloff 45
}

#declare GlassBall =
sphere { 0, 15
  texture {
    pigment { rgbf <0.98, 0.98, 0.98, 0.9> }
    finish  { ambient 0.1 diffuse 0.1 reflection 0.1 specular 0.8 roughness 0.0003 phong 1  phong_size 400 }
  }
  interior { ior 1.45 }
  clipped_by { sphere { 0, 14  inverse  }
  }
}

object { GlassBall translate <-40, -1, 290> }
object { GlassBall translate <-55, -15, 115> }
 
//--- Place Dragon on Pool Sill
object { Dragon
  scale 1.2
  rotate y*145
  translate <62, -30, 122>
}

//---  Dragon by entrance
object { Dragon
  scale 1.2
  rotate y*40
  translate <70, 0, 420>
}

object { Planter scale 0.4 translate <-80, -14, 222> }

plane { z, -2000
  texture {
    pigment { color rgb <0.309804, 0.184314, 0.309804> }
    finish { ambient 1 diffuse 0.9 }
  }
}

