//----- Pursian Room Back Drop 0.....      9/3/92 M.Miller
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

//---- Textures For Pursian Pool

//--------- White Marble with Gray feather Viens
#declare Grnt20 =
texture {
  pigment {
    granite
    turbulence 0
    colour_map {
      [0.0 0.3 colour rgb 0 colour rgb 1]
      [0.2 0.4 colour rgb 1 colour rgb 1]
      [0.4 0.6 colour rgb 1 colour rgb 1]
      [0.6 1.0 colour rgb 1 colour rgb 1]
    }
  }
  finish { crand 0.02 }
}

//--------- Light Grays
#declare Grnt24 = 
texture {
  pigment {
    marble
    turbulence 0.6
    colour_map {
      [0.000 0.154 colour rgbf <0.894, 0.886, 0.886, 0> colour rgbf <0.745, 0.745, 0.753, 0>]
      [0.154 0.308 colour rgbf <0.745, 0.745, 0.753, 0> colour rgbf <0.902, 0.902, 0.859, 0>]
      [0.308 0.444 colour rgbf <0.902, 0.902, 0.859, 0> colour rgbf <0.729, 0.706, 0.694, 0>]
      [0.444 0.615 colour rgbf <0.729, 0.706, 0.694, 0> colour rgbf <0.588, 0.592, 0.635, 0>]
      [0.615 0.803 colour rgbf <0.588, 0.592, 0.635, 0> colour rgbf <0.608, 0.616, 0.659, 0>]
      [0.803 1.001 colour rgbf <0.608, 0.616, 0.659, 0> colour rgbf <0.894, 0.886, 0.886, 0>]
    }
  }
}

//-----Aqua Tints
#declare Grnt8a =
texture {
  pigment {
    granite
    turbulence 0.6
    colour_map {
      [0.000 0.119 colour rgbf <0.310, 0.384, 0.420, 0.631> colour rgbf <0.322, 0.369, 0.416, 0.847>]
      [0.119 0.322 colour rgbf <0.322, 0.369, 0.416, 0.847> colour rgbf <0.424, 0.369, 0.420, 0.549>]
      [0.322 0.449 colour rgbf <0.424, 0.369, 0.420, 0.549> colour rgbf <0.373, 0.424, 0.518, 0.965>]
      [0.449 0.729 colour rgbf <0.373, 0.424, 0.518, 0.965> colour rgbf <0.482, 0.573, 0.533, 0.741>]
      [0.729 1.001 colour rgbf <0.482, 0.573, 0.533, 0.741> colour rgbf <0.310, 0.384, 0.420, 0.631>]
    }
  }
}

//---------- Overtint Green with Black Cracks
#declare Crack3 =
texture {
  pigment {
    marble
    turbulence 0.85
    colour_map {
      [0.000 0.040 colour rgb 0 filter 0.6 colour rgb 0 filter 1.0]
      [0.040 0.970 colour rgbf <0.184314, 0.309804, 0.184314, 0.80> colour rgbf <0.184314, 0.309804, 0.184314, 0.90>]
      [0.970 1.001 colour rgb 0 filter 0.9 colour rgb 0 filter 1.0]
    }
  }
}

//------------- White Marble with gray veining
#declare Stone17 =
texture { Grnt20 scale <1, 2, 2> rotate z*-30 finish { ambient 0.2 diffuse 0.8 crand 0.03 } }
texture { Crack3 scale <1, 2, 1.4> rotate <10, 0, -20>  }

//------------- Medium Gray Blue Marble
#declare Stone13 =
texture { Grnt24 scale <2, 5, 2> rotate z*50 finish { ambient 0.2 crand 0.03 } }
texture { Grnt8a scale <1, 3, 2> rotate z*-30 }

//----- Column Base Texture
#declare BaseTexture =
texture { Stone17 scale <8, 8, 4> }
texture {
  pigment { colour rgb 0.752941 filter 0.4 }
  finish { phong 0.2 phong_size 150 ambient 0.15 diffuse 0.7 }
}

#declare CapTexture =
texture { Stone17 scale <8, 8, 4> }
texture {
  pigment { colour rgb 0.752941 filter 0.6}
  finish { phong 0.2 phong_size 150 ambient 0.15 diffuse 0.7 }
}

#declare ColumnTexture =
texture { Stone13 scale <5, 7, 5> }
texture {
  pigment { colour rgb 0.752941 filter 0.5 }
  finish { phong 0.5 phong_size 150 ambient 0.15 diffuse 0.6 }
}

#declare PoolTexture =
texture { Stone13 scale <25, 17, 25> }
texture {
  pigment { colour rgb 0.752941 filter 0.3 }
  finish { phong 1 phong_size 100 ambient 0.25 diffuse 0.5 reflection { 0.2 } }
}

#declare TopPanelTexture =
texture {
  pigment { colour rgb 0.5 }
  finish { ambient 0.3 diffuse 0.5 crand 0.07 }
}

#declare AWallTexture =
texture {
  pigment { colour rgb 0.3 }
  finish { ambient 0.3 diffuse 0.5 crand 0.08 }
}

#declare BMoldingTexture =
texture {
  pigment { colour rgb 0.7 }
  finish { ambient 0.3 diffuse 0.5 crand 0.06 }
}

#declare CWallTexture =
texture { Stone13 scale <10, 10, 5> }
texture {
  pigment { colour rgbf 0.4 }
  finish { ambient 0.3 diffuse 0.5 crand 0.06 }
}

#declare DMoldingTexture =
texture {
  pigment { colour rgb 0.7 }
  finish { ambient 0.3 diffuse 0.5 crand 0.06 }
}

#declare MosacPanelTexture =
texture {
  pigment { image_map { png "mosaic.png" } }
  finish { ambient 0.4 diffuse 0.2 }
  scale <47, 9, 1>
  translate <-23, -4.5, 0>
}

#declare ArchTexture =
texture { Stone17 scale <8, 8, 4> }
texture {
  pigment { colour rgb 0.752941 filter 0.6 }
  finish { ambient 0.15 diffuse 0.7 }
}

#declare FloorTexture =
texture { 
  pigment { colour rgb 0.25 }
  finish { ambient 0.2 diffuse 0.4 reflection { 0.2 } phong 1 phong_size 100 crand 0.05 }
}

#declare Lob1Texture =
texture {
  pigment { colour rgb 0.2 }
  finish { ambient 0.4 diffuse 0.3 reflection { 0.25 } crand 0.05 }
}

#declare Lob2Texture =
texture {
  pigment { colour rgb 0.3 }
  finish { ambient 0.7 diffuse 0.4 phong 1 crand 0.05 }
}

//-------------------------------------------------------------------

//--- Start Constuction
#declare Arch =
object { 
  union {
    difference {
      union {
        object { Disk_Z scale <21.5, 18, 10> translate <-9.5, 90, 0> }
        object { Disk_Z scale <21.5, 18, 10> translate <9.5, 90, 0> }
      }
      object { Cylinder_Z scale <17.5, 14, 1> translate <-9.5, 90, 0> }
      object { Cylinder_Z scale <17.5, 14, 1> translate <9.5, 90, 0> }
      box { -1, 1 scale <13, 20, 12> translate y*90 }
      box { -1, 1 scale <19, 7, 12> translate y*74 }
    }
    difference {
      union {
        object { Disk_Z scale <25, 14, 10> translate <-21, 117, 0> }
        object { Disk_Z scale <25, 14, 10> translate <21, 117, 0> }
      }
      object { Cylinder_Z scale <21, 10, 1> translate <-21, 117, 0> }
      object { Cylinder_Z scale <21, 10, 1> translate <21, 117, 0> }
      plane { y, 117 inverse }
      plane { x, -13 }
      plane { x, 13 inverse }
    }
    box { -1, 1 scale <2, 3.875, 10> translate <-21, 73.8, 0> }
    box { -1, 1 scale <2, 3.875, 10> translate <21, 73.8, 0> }
  }
  texture { ArchTexture }
  bounded_by { box { -1, 1 scale <48, 23, 12> translate y*94 } }
  translate z*-11
}

//--- Wall Panel 
#declare TopWall =
object {
  difference {
    box { -1, 1 scale <66, 22, 9> translate <0, 96, 0.5> }
    object { Cylinder_Z scale <29, 18, 1> translate y*90 }
    object { Cylinder_Z scale <5, 2.5, 1> translate y*108.5 }
    box { -1, 1 scale <20, 6, 11> translate y*74 }            
  }
  texture { TopPanelTexture }
  bounded_by { box { -1, 1 scale <67, 23, 10> translate <0, 96, 0.5> } }
  translate z*-11
}

//--- Column

//---Torus for Base
#declare T9 =
quartic { <1, 0, 0, 0, 2, 0, 0, 2, 0, -84.5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 59.5, 0, 0, 0, 0, 1, 0, -84.5, 0, 885.0625> sturm }

//--- Base
//--- Leaf Section of Base
#declare B1 =
union {
  difference { 
    sphere { 0, 1 scale <2, 6.5, 2.5> }
    sphere { 0, 1 scale <2, 8, 3> translate x*-1.5 }
  }
  difference { 
    sphere { 0, 1 scale <1, 5.75, 1.75> }
    sphere { 0, 1 scale <1, 4.75, 1> translate -x }
  }
  sphere { 0, 1 scale <0.5, 3, 0.5> translate x*-0.5 }
  texture { BaseTexture }
  bounded_by { box { -1, 1 scale <2.5, 7, 3> } } 
  translate x*-5.5
}

//--- Base Mass
#declare B2 =
union {
  cylinder { y, -y, 1 scale <6.5, 3, 6.5> translate y*8 }
  cylinder { y, -y, 1 scale <5.5, 6, 5.5> translate y*11 }
  cylinder { y, -y, 1 scale <9.5, 1, 9.5> translate y }
  object { T9 translate y*2.5 }
  texture { BaseTexture }
}

//--- Complete Base
#declare Base =
union {
  union {
    object { B1 rotate 0 }
    object { B1 rotate y*45 }
    object { B1 rotate y*90 }
    object { B1 rotate y*135 }
    object { B1 rotate y*180 }
    object { B1 rotate y*225 }
    object { B1 rotate y*270 }
    object { B1 rotate y*315 }
    translate y*11.5
  }
  object { B2 }
  bounded_by { box { -1, 1 scale <10, 9.5, 10> translate y*9 } }
}

//----- Column Caps

#declare Rib1 =
union {
   sphere { <-6.5, 11, 0>, 1 }
   sphere { <-5.5, 6, 0>, 1 }
   cylinder { y, -y, 1 scale <1, 2.5, 1> translate <-5.5, 8.5, 0> }
}

#declare Cap =
union {
  object { Rib1 rotate y*30 }
  object { Rib1 rotate y*5 }
  object { Rib1 rotate y*30 }
  object { Rib1 rotate y*-15 }
  object { Rib1 rotate y*-30 }
  object { Rib1 rotate y*-45 }
  object { Rib1 rotate y*-60 }
  object { Rib1 rotate y*-75 }
  object { Rib1 rotate y*-90 }
  object { Rib1 rotate y*-105 }
  object { Rib1 rotate y*-120 }
  object { Rib1 rotate y*-135 }
  object { Rib1 rotate y*-150 }
  object { Rib1 rotate y*-165 }
  object { Rib1 rotate y*-180 }
  object { Rib1 rotate y*-210 }
  object { Rib1 rotate y*-225 }
  cylinder { y, -y, 1 scale <6.5, 0.5, 6.5> translate y*0.5 }
  cylinder { y, -y, 1 scale <5.5, 2.5, 5.5> translate y*3.5 }
  box { -1, 1 scale <8.5, 2, 8.5> translate y*14 }
  texture { CapTexture }
  bounded_by { box { -1, 1 scale <10, 7.5, 10> translate y*7 } }
}

//--- Main Column Section
#declare Column1 =
cylinder { y, -y, 1
  scale <5.5, 20, 5.5>
  texture { ColumnTexture }
}

//--- Complet Column
#declare Column =
union {
  object { Column1 translate y*37 }
  object { Cap translate y*56 }
  object { Base }   
  bounded_by { box { -1, 1 scale <11.5, 37, 11.5> translate y*35 } }
}

//----- Wall

#declare AWall = box { -1, 1 scale <23, 21, 2> texture { AWallTexture } }
#declare BMolding = box { -1, 1 scale <24, 1.5, 3> texture { BMoldingTexture } }
#declare CWall = box { -1, 1 scale <23, 9, 2> texture { CWallTexture } }
#declare DMolding = box { -1, 1 scale <24, 3.7, 3> texture { DMoldingTexture } }
#declare EMolding = box { -1, 1 scale <24, 2, 12> texture { ArchTexture } }
#declare MosacPanel = box { -1, 1 scale <23.5, 4.5, 2.5> texture { MosacPanelTexture } }

//--- Complete Wall with Arch opening & 4 Columns
#declare Wall =
union {
  union {
    object { AWall translate <-43, 49, 0> }
    object { BMolding translate <-43, 26.6, 0> }
    object { CWall translate <-43, 16, 0> }
    object { DMolding translate <-43, 3.5, 0> }
    object { EMolding translate <-43, 72, -9> }
    object { MosacPanel translate <-43, 32.5, 0> }
    bounded_by { box { -1, 1 scale <25, 38, 14> translate <-43, 37, -8.5> } }
  }
  union {
    object { AWall translate <43, 49, 0> }
    object { BMolding translate <43, 26.6, 0> }
    object { CWall translate <43, 16, 0> }
    object { DMolding translate <43, 3.5, 0> }
    object { EMolding translate <43, 72, -9> }
    object { MosacPanel translate <43, 32.5, 0> }
    bounded_by { box { -1, 1 scale <25, 38, 14> translate <43, 37, -8.5> } }
  }
  object { TopWall }
  object { Arch }

  object { Column translate <28.5, 0, -11.5> }
  object { Column translate <-28.5, 0, -11.5> }
  object { Column translate <57.5, 0, -11.5> }
  object { Column translate <-57.5, 0, -11.5> }
  bounded_by { box { -1, 1 scale <68, 60, 14> translate <0, 59, -8.5> } }
}

//----- Scaleable Wall

#declare SWall =
union {
  box { -1, 1 scale <1, 3.5, 3> translate y*3.5   texture { DMoldingTexture } }
  box { -1, 1 scale <1, 9, 2>   translate y*16    texture { CWallTexture scale <0.1, 1, 1> } }
  box { -1, 1 scale <1, 1.5, 3> translate y*26.5  texture { BMoldingTexture } }
  box { -1, 1 scale <1, 21, 2>  translate y*49    texture { AWallTexture } }
  box { -1, 1 scale <1, 2, 12>  translate <0, 72, -9>   texture { ArchTexture scale <0.05, 1, 1> } }
  box { -1, 1 scale <1, 22, 9>  translate <0, 96, -11>  texture { TopPanelTexture } }
  bounded_by { box { -1, 1 scale <1.1, 60, 14> translate <0, 59, -8.5> } }
}

//---- Floor & Pool

//--- Floor outside Door
box { -1, 1 scale <260, 2, 300> translate <0, -2, 880> texture { Lob1Texture } }

#declare Lob1 =
union {
  triangle { <-260, 2, -125>, <-100, 2, -125>, <-260, 2,  125> }
  triangle { <-100, 2, -125>, < -60, 2,  -85>, <-260, 2,  125> }
  triangle { <-260, 2,  125>, < -60, 2,  -85>, < 260, 2,  125> }
  triangle { < -60, 2,  -85>, <  60, 2,  -85>, < 260, 2,  125> }
  triangle { < 260, 2,  125>, <  60, 2,  -85>, < 100, 2, -125> }
  triangle { < 100, 2, -125>, < 260, 2,  125>, < 260, 2, -125> }
  texture { Lob1Texture }
  bounded_by { box { -1, 1 scale <260, 1, 126> translate y*2 } }
}

#declare Lob2 =
union {
  triangle { <-260,  2, -125>, <-260, -2, -125>, <-100, 2, -125> }
  triangle { <-260, -2, -125>, <-100, -2, -125>, <-100, 2, -125> }
  triangle { <-100,  2, -125>, <-100, -2, -125>, < -60, 2,  -85> }
  triangle { <-100, -2, -125>, < -60, -2,  -85>, < -60, 2,  -85> }
  triangle { < -60,  2,  -85>, < -60, -2,  -85>, <  60, 2,  -85> }
  triangle { < -60, -2,  -85>, <  60, -2,  -85>, <  60, 2,  -85> }
  triangle { < 100,  2, -125>, < 100, -2, -125>, <  60, 2,  -85> }
  triangle { < 100, -2, -125>, <  60, -2,  -85>, <  60, 2,  -85> }
  triangle { < 260,  2, -125>, < 260, -2, -125>, < 100, 2, -125> }
  triangle { < 260, -2, -125>, < 100, -2, -125>, < 100, 2, -125> }
  texture { Lob2Texture }
  bounded_by { box { -1, 1 scale <270, 3, 30> translate z*-103 } }
}

#declare Lob =
union {
  object { Lob1 }
  object { Lob2 }
  bounded_by { box { -1, 1 scale <260, 3, 126> translate 0 } }
}

union {
  object { Lob translate <0,  -2, 480> }
  object { Lob translate <0,  -6, 460> }
  object { Lob translate <0, -10, 440> }
  object { Lob translate <0, -14, 420> }
  object { Lob translate <0, -18, 300> }
  object { Lob translate <0, -22, 280> }
  object { Lob translate <0, -26, 260> }
  object { Lob translate <0, -30, 240> }
}

//--- Pool Floor
#declare PoolFloor =
difference {
  box { -1, 1 scale <260, 5, 230> }
  object { Cylinder_Y scale <64, 1, 64> translate z*69 }
  texture { Lob1Texture }
  bounded_by { box { -1, 1 scale <260, 6, 230> } }
}

//--- Pool Wall
#declare PoolWall =
difference {
  cylinder { y, -y, 1 scale <81, 7, 81> translate z*69 }
  object { Cylinder_Y scale <63, 1, 63> translate z*69 }
  texture { PoolTexture }
  bounded_by { box { -1, 1 scale <85, 8, 85> translate z*69 } }
}

//--- Pool Water
#declare Watery =
box { -1, 1
  scale <100, 1, 100>
  texture {
    pigment { colour rgb <0.372549, 0.623529, 0.623529> }
    finish { ambient 0.5 diffuse 0.2 phong 1 reflection { 0.8 } }
  }
}

//--- Pool Bottom
#declare PBottom =
box { -1, 1
  scale <100, 1, 100>
  texture {
    pigment { colour rgb <0.184314, 0.184314, 0.309804> }
    finish { ambient 0.3 diffuse 0.4 }
  }
}

//----- Complete Pursian Backdrop
object { Wall translate z*600 }
object { Wall translate <-170, 0, 500> }
object { Wall translate < 170, 0, 500> }

// object { Wall rotate y*-90 translate <-106, 0, 552> }
// object { Wall rotate y*90 translate <106, 0, 552> }

object { SWall scale <50.01, 1, 1> rotate y*-90 translate <-106, 0, 552> }
object { SWall scale <50.01, 1, 1> rotate  y*90 translate < 106, 0, 552> }
object { SWall scale <18.51, 1, 1> translate <-85.5, 0, 600> } 
object { SWall scale <18.51, 1, 1> translate < 85.5, 0, 600> } 

object { Column scale 1.7 translate <-56, -16, 250> }
object { Column scale 1.7 translate < 56, -16, 250> }

union {
  object { PoolFloor }
  object { PoolWall }
  object { Watery translate <0, 1, 69> }
  object { PBottom translate 0 }
  bounded_by { box { -1, 1 scale <260, 8, 230> } }
  translate y*-37
}