//--- Eye & Eye Lid
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare Lid2 = 
union {
  intersection {
    sphere { 0, 1 scale <8, 6, 6> }
    plane { y, 0 inverse }
    rotate x*30
  }	
  intersection {
    sphere { 0, 1 scale <8, 6, 6> }
    plane { y, 0  }
    rotate x*-30
  }	
  intersection {
    sphere { 0, 1 scale <9, 7, 7> }
    plane { y, 0 inverse }
    rotate x*40
  }	
  intersection {
    sphere { 0, 1 scale <9, 7, 7> }
    plane { y, 0 }
    rotate x*-40
  }	
}

//--- Eye Ball
#declare Eye =
union {
  sphere { 0, 1
    scale <7, 5, 5>
    texture { SkullTexture }
  }
  sphere { 0, 5
    translate -z
    texture { 
      pigment {
        wood
        color_map {
          [0.00 0.20 color rgb 0 color rgb 0]
          [0.20 0.25 color rgb <1, 1, 0> color rgb <1, 1, 0>]
          [0.25 0.60 color rgb 1 color rgb 1]
          [0.60 1.00 color rgb 1 color rgb x]
        }
      }
      finish { ambient 0.3 phong 1 }
      scale <5, 30, 10>
    }
  }
}

//--- Gold Tin Skin over Eye
#declare GlassCap =
sphere { 0, 1
  scale <7, 6.1, 6.1>
  texture { 
    pigment { color rgbf <0.8, 0.498039, 0.196078, 0.9999999> }
    finish { phong 1 phong_size 90 }
  }
  interior { ior 2 }
}