//---- Dragon Texures
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

//--- A Spotted Lizard Texture
#declare TX13 =
texture {
  pigment {
    leopard
    color_map {
      [0.00 0.01 color rgb 0.329412 color rgb <0.184314, 0.309804, 0.184314>]
      [0.01 0.70 color rgb 0.329412 color rgb <0.8, 0.498039, 0.196078>]
      [0.70 1.00 color rgb <0.8, 0.498039, 0.196078> color rgb <0.8, 0.498039, 0.196078>]
    }
  }
  finish {
    ambient 0.1
  }
  scale 0.05
}
texture {
  pigment {
    gradient y
    color_map {
      [0.0 0.5 color rgb <0.8, 0.498039, 0.196078> color rgb 0.752941 filter 0.2]
      [0.5 0.7 color rgb 0.752941 filter 0.2 color rgb 0.752941 filter 0.7]
      [0.7 1.0 color rgb 0.752941 filter 0.7 color rgbf 1]
    }
  }
  finish { phong 1 }
  scale <1, 2, 1>
  translate <0, -1, 0>
}

#declare Scales =
texture {
  pigment {
    leopard
    color_map {
      [0.00 0.05 color rgb 0.329412 color rgb <0.184314, 0.309804, 0.184314>]
      [0.05 0.70 color rgb 0.329412 color rgb <0.8, 0.498039, 0.196078>]
      [0.70 1.00 color rgb <0.8, 0.498039, 0.196078> color rgb <0.8, 0.498039, 0.196078>]
    }
  }
  finish { ambient 0.1 }
  scale 0.05
}
texture {
  pigment {
    gradient y
    color_map {
      [0.0 0.3 color rgb 0 color rgbf <0.184314, 0.309804, 0.184314, 0.2>]
      [0.3 0.5 color rgbf <0.184314, 0.309804, 0.184314, 0.2> color rgbf <0.184314, 0.309804, 0.184314, 0.5>]
      [0.5 1.0 color rgbf <0.184314, 0.309804, 0.184314, 0.5> color rgbf 1]
    }
  }
  finish { phong 1 }
  scale <1, 2, 1>
  translate -y
}

//---- Back Spine Texture
#declare  BackTexture =  texture { TX13 }

//--- Belly Texture
#declare BellyTexture = texture { TX13 scale 10 translate <0, 18, 0> }

//--- Back Leg Texture
#declare BLegTexture =  texture { TX13 scale <10, 11.5, 10> translate <0, 13, 0> }

//--- Front Leg Texture
#declare FLegTexture = texture { TX13 scale < 10, 11.5, 10 > translate <0, 13.5, 0>}

//--- Head Texture
#declare SkullTexture = texture { TX13 scale 15 translate <0, 0, 0>}

//--- Horn Texture
#declare HornTexture =
texture {
  Scales
  scale 20
  translate 0
}
texture {
  pigment {
    gradient x
    color_map {
      [0.0 0.4 color rgbf 1 color rgbf 1]
      [0.4 0.7 color rgbf 1 color rgb <0.8, 0.498039, 0.196078>]
      [0.7 1.0 color rgb <0.8, 0.498039, 0.196078> color rgb <0.8, 0.498039, 0.196078>]
    }
  }
  scale <80, 1, 1>
}

//--- Dragon Wing Texture
#declare WingTTexture = 
texture {
  TX13
  scale <1, 100, 1>
}
texture {
  pigment {
    gradient y
    color_map {
      [0.0 0.5 color rgbf 1 color rgbf 1]
      [0.5 1.0 color rgbf 1 color rgb <0.8, 0.498039, 0.196078>]
    }
  }
  scale <1, 50, 1>
}

//--- CTDS INFO
#declare Dot = sphere { 0, 1 }

#declare Connector_1 = 
object {
  quadric { <0, 1, 1>, 0, 0, -1 }
  clipped_by {
    plane { x, 1 }
    plane { -x, 0 }
  }
}

#declare Connector_2 = quadric { <1, -1, 1>, 0, 0, 0 rotate z*90 }