//------ Plants & Pot





#declare X_Disk = intersection {  
  quadric { Cylinder_X }
  plane { <1.0 0.0 0.0> 0.0 inverse }
  plane { <1.0 0.0 0.0> 1.0 }
}


#declare Y_Disk = intersection { 
  quadric { Cylinder_Y }
  plane { <0.0 1.0 0.0> 0.0 inverse }
  plane { <0.0 1.0 0.0> 1.0 }
}


#declare Z_Disk = intersection {  
  quadric { Cylinder_Z }
  plane { <0.0 0.0 1.0> 0.0 inverse }
  plane { <0.0 0.0 1.0> 1.0 }
}



#declare Leaf_Texture = 
texture {
	color DarkGreen 
	.04
	ambient .35
	diffuse .8
	waves .8
	frequency .05
	phong 1
	phong_size 60
	scale <10 .01 10>
}


//------------- Plant Leaf
#declare LEAF_BODY =
object {
	intersection {
	quadric { Sphere scale < 20 20 20> }
	plane { <0 0 1> 0 rotate <0 26 0> translate <0 0 -10> inverse }
	plane { <0 0 1> 0 rotate <0 -26 0> translate <0 0 10>  }	
	}
		texture {
		Leaf_Texture 
		}
			clipped_by {
				plane { <0 1 0> 0 rotate <0 0 22.5> 
				translate <0 8 0> inverse 
				}
				quadric { Sphere scale <19.9 19.9 19.9> inverse }
			}
	bounded_by {
	quadric { Sphere scale <21 21 21>  }
	}
}



#declare STEM = 
object {
	intersection { Z_Disk scale <77 77 .7> translate <-40 -40 0> }
		texture {
		Leaf_Texture
		}
		clipped_by {
		plane { <1 0 0> 0 rotate <0 0 22.5>  translate <20 0 0> inverse }
		quadric { Cylinder_Z scale <76.5 76.5 1> translate <-40 -40 0> inverse }
		}
	bounded_by { 
	box { UnitBox scale <31 35 21> translate <9 -12 0> }
	}
}



//------- One Leaf & Stem
#declare LEAF =
composite {
	object { LEAF_BODY }
	object { STEM }
translate <-37 40 0 >   
}

//------- 4 Leafs in a bunch
#declare BUNCH4=
composite {
	composite { LEAF rotate <0 0 0> }
	composite { LEAF rotate <0 90 0> }
	composite { LEAF rotate <0 180 0> }
	composite { LEAF rotate <0 270 0> }
		bounded_by {
		box { UnitBox scale <65 35 65> translate <0 30 0> }
		} 
}


//------- 3 Leafs in a bunch
#declare BUNCH3=
composite {
	composite { LEAF rotate <0 120 0> }
	composite { LEAF rotate <0 240 0> }
	composite { LEAF rotate <0 0 0> }
		bounded_by {
		box { UnitBox scale <65 35 65> translate <0 30 0> }
		} 
}




//---  Plant Crock

#declare Torus1 = 
   quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -2896.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        2880.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -2896.000000 0.000000 2073600.000000 >
   }

#declare Torus2 = 
   quartic {
   <    1.000000 0.000000 0.000000 0.000000 2.000000
        0.000000 0.000000 2.000000 0.000000 -2468.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        0.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 0.000000 2.000000 0.000000
        2432.000000 0.000000 0.000000 0.000000 0.000000
        1.000000 0.000000 -2468.000000 0.000000 1478656.000000 >
   }


#declare Grnt7 = texture {
   granite
   turbulence 0.5
   colour_map {
      [0.000 0.153   colour red  0.439  green  0.310  blue  0.282  alpha  0.000
      colour red  0.463  green  0.369  blue  0.259  alpha  0.000]
      [0.153 0.398   colour red  0.463  green  0.369  blue  0.259  alpha  0.000
      colour red  0.541  green  0.369  blue  0.298  alpha  0.000]
      [0.398 0.559   colour red  0.541  green  0.369  blue  0.298  alpha  0.000
      colour red  0.573  green  0.424  blue  0.286  alpha  0.000]
      [0.559 0.729   colour red  0.573  green  0.424  blue  0.286  alpha  0.000
      colour red  0.494  green  0.396  blue  0.306  alpha  0.000]
      [0.729 1.001   colour red  0.494  green  0.396  blue  0.306  alpha  0.000
      colour red  0.439  green  0.310  blue  0.282  alpha  0.000]
   }
}

#declare Grnt0a = texture {
   granite
   turbulence 0.6
   colour_map {
      [0.000 0.153   colour red  0.729  green  0.502  blue  0.451  alpha  0.306
      colour red  0.769  green  0.686  blue  0.592  alpha  0.792]
      [0.153 0.398   colour red  0.769  green  0.686  blue  0.592  alpha  0.792
      colour red  0.843  green  0.753  blue  0.718  alpha  0.396]
      [0.398 0.559   colour red  0.843  green  0.753  blue  0.718  alpha  0.396
      colour red  0.780  green  0.667  blue  0.561  alpha  0.976]
      [0.559 0.729   colour red  0.780  green  0.667  blue  0.561  alpha  0.976
      colour red  0.741  green  0.659  blue  0.576  alpha  0.820]
      [0.729 1.001   colour red  0.741  green  0.659  blue  0.576  alpha  0.820
      colour red  0.729  green  0.502  blue  0.451  alpha  0.306]
   }
}






#declare Stone1 =
texture { Grnt7 scale <2 3 2> rotate <0 0 40> ambient .2 diffuse .4 }
texture { Grnt0a scale <2 3 2> rotate <0 0 -30> ambient .2 diffuse .4 phong 1.0 phong_size 80
}









#declare Crock_Texture =
texture {
	Stone1
	scale <20 35 10>
	}


#declare Rib = quadric { Sphere scale <20 41 41> }

#declare Crock =
object {
   union {
	intersection {
	   union {
		quadric { Rib rotate <0 0 0> }
		quadric { Rib rotate <0 15 0> }		
		quadric { Rib rotate <0 30 0> }
		quadric { Rib rotate <0 45 0> }
		quadric { Rib rotate <0 60 0> }
		quadric { Rib rotate <0 75 0> }
		quadric { Rib rotate <0 90 0> }
		quadric { Rib rotate <0 105 0> }
		quadric { Rib rotate <0 120 0> }
		quadric { Rib rotate <0 135 0> }
		quadric { Rib rotate <0 150 0> }
		quadric { Rib rotate <0 165 0> }
	   }
	           intersection { Disk_Y scale <33 10 33> inverse translate <0 26 0> }
       }	
			quartic { Torus1 translate <0 26 0> }
			quartic { Torus2 translate <0 26 0> }
    }	
		texture { Crock_Texture }
			   bounded_by {
				sphere { <0 0 0> 50 }
		   	   }
translate <0 30 0>
}


#declare Planter =
composite {
   composite {
     composite {
	composite { BUNCH4 }
	composite { BUNCH4 rotate <0 45 0> }
        rotate <0 22 0> scale <.9 .9 .9> translate <0 -12 0>
     }
	composite { BUNCH4 }
	composite { BUNCH4 rotate <0 45 0> }
	composite { BUNCH4 rotate <0 45 0> scale <.95 .95 .95> translate <0 20 0> }
	composite { BUNCH3 rotate <0 5 0> scale <.9 .9 .9> translate <0 35 0> }
	composite { BUNCH3 rotate <0 50 0> scale <.7 .7 .7> translate <0 48 0> }
	composite { BUNCH3 rotate <0 110 0> scale <.65 .65 .65> translate <0 60 0> }
	composite { BUNCH3 rotate <0 50 0> scale <.35 .65 .35> translate <0 72 0> }
		bounded_by {
		box { UnitBox scale <80 60 80> translate <0 55 0> }
		} 

        translate <0 20 0>
    }
  object { Crock scale <.75 .75 .75> }
		bounded_by {
		box { UnitBox scale <65 80 65> translate <0 65 0> }
		} 

}




