//--- One Complete Dragon



//**********************************************************
//---- Dragon Texures

//--- A Spotted Lizard Texture
#declare TX13 =
     texture {
	leopard
	color_map {
	[0 .01 color DimGray color DarkGreen]
	[.01 .7 color DimGray color Gold]
	[.7 1 color Gold color Gold]
	}
	ambient .1
	scale <.05 .05 .05>
	}

     texture {
	gradient <0 1 0>
	color_map {
	[0 .5 color Gold color Gray alpha .2]
	[.5 .7 color Gray alpha .2 color Gray alpha .7]
	[.7 1 color Gray alpha .7 color Clear]
	}
	scale <1 2 1>
	translate <0 -1 0>
	phong 1
   	}



#declare Scales =
      texture {
	leopard
	color_map {
	[0 .05 color DimGray color DarkGreen]
	[.05 .7 color DimGray color Gold]
	[.7 1 color Gold color Gold]

	}
	ambient .1
	scale <.05 .05 .05>
	}
      texture {
	gradient <0 1 0>
	color_map {
	[0 .3 color Black color DarkGreen alpha .2]
	[.3 .5 color DarkGreen alpha .2 color DarkGreen alpha .5]
	[.5 1 color DarkGreen alpha .5 color Clear]
	}
	scale <1 2 1>
	translate <0 -1 0>
	phong 1

   	}




//---- Back Spine Texture
#declare  BackTexture  =   
    	 texture { TX13 }

//--- Belly Texture
#declare BellyTexture =
texture { TX13
	scale <10 10 10>
	translate <0 18 0>
}

//--- Back Leg Texture
#declare BLegTexture = 
   texture { TX13
	scale <10 11.5 10>
	translate <0 13 0> 
        }

//--- Front Leg Texture
#declare FLegTexture =       
texture { TX13
	scale < 10 11.5 10 >
	translate <0 13.5 0>
	}

//--- Head Texture
#declare SkullTexture =
texture { TX13
	scale <15 15 15>
	translate <0 0 0>
	}

//--- Horn Texture
#declare HornTexture =
    texture { Scales
	scale <20 20 20>
	translate <0 0 0>
	}
    texture {
	gradient <1 0 0>
	color_map {
	[0 .4 color Clear color Clear]
	[.4 .7 color Clear color Gold]
	[.7 1 color Gold color Gold]
	}
	scale <80 1 1>
}



//--- Dragon Wing Texture
#declare WingTTexture = 
   texture {
	TX13
	scale <1 100 1>
	}
   texture {
	gradient <0 1 0>
	color_map {
	[0 .5 color Clear color Clear]
	[.5 1 color Clear color Gold]
	}
	scale <1 50 1>
	}




//--- CTDS INFO

#declare DOT = sphere { <0 0 0> 1 }

#declare Dot =
    quadric {
       < 1.0  1.0  1.0>
       < 0.0  0.0  0.0>
       < 0.0  0.0  0.0>
        -1.0
    }

#declare Connector_1 = 
   object {
      quadric {
         < 0.0  1.0  1.0>
         < 0.0  0.0  0.0>
         < 0.0  0.0  0.0>
          -1.0
      }
      clipped_by {
         plane { < 1.0  0.0  0.0> 1.0 }
         plane { <-1.0  0.0  0.0> 0.0 }
      }
   }

#declare Connector_2 =
   quadric {
      < 1.0 -1.0  1.0>
      < 0.0  0.0  0.0>
      < 0.0  0.0  0.0>
        0.0
      rotate < 0.0  0.0  90.0>
   }


//*****************************************************
//--- Eye & Eye Lid


#declare Lid2 = 
union {
  intersection {
    quadric { Sphere scale <8 6 6> }
    plane { <0 1 0> 0 inverse }
    rotate <30 0 0> 
    }	
  intersection {
    quadric { Sphere scale <8 6 6> }
    plane { <0 1 0> 0  }
    rotate <-30 0 0> 
    }	
  intersection {
    quadric { Sphere scale <9 7 7> }
    plane { <0 1 0> 0 inverse }
    rotate <40 0 0> 
    }	
  intersection {
    quadric { Sphere scale <9 7 7> }
    plane { <0 1 0> 0  }
    rotate <-40 0 0> 
    }	
}

//--- Eye Ball
#declare Eye =
composite {
   object {
     quadric { Sphere scale <7 5 5> }
	texture { SkullTexture }
   }
   object {
     quadric { Sphere scale <5 5 5> translate <0 0 -1> }
	texture { 
	wood
	color_map {
	[0 .2 color Black color Black]
	[.2 .25 color Yellow color Yellow]
	[.25 .6 color White color White]
	[.6 1 color White color Red]
	}
	ambient .3
	phong 1
	scale <5 30 10>
	}
   }
}

//--- Gold Tin Skin over Eye
#declare GlassCap =
object {
   quadric { Sphere scale <7 6.1 6.1> }
	texture { 
	color Gold alpha .9999999
	refraction 1
	ior 2
	phong 1
	phong_size 90
	}
}


//****************************************************************************
//--- Dragon Skull & Horns

//--- Top of Skull
#declare Sk1 =
object {
   intersection {
      union {
	quadric { Sphere scale <20 15 15> translate <0 0 -4>  }
	quadric { Sphere scale <17 12.5 12.5> translate <14 -5 -4> }
	quadric { Sphere scale <15 11 11> translate <21 -5 -4>  }
	quadric { Sphere scale <10.5 7.5 7.5> translate <30 -5 -4> }

	quadric { Sphere scale <20 15 15> translate <0 0 4> }
	quadric { Sphere scale <17 12.5 12.5> translate <14 -5 4> }
	quadric { Sphere scale <15 11 11> translate <21 -5 4>  }
	quadric { Sphere scale <10.5 7.5 7.5> translate <30 -5 4> }
	}
           quadric { Cylinder_Z scale <11 6.5 1> rotate <0 0 11> translate <-19.5 -11.5 0> inverse }
           quadric { Cylinder_Z scale <16 9 1> rotate <0 0 25> translate <2 -16 0> inverse }
           quadric { Cylinder_Z scale <13 7 1> rotate <0 0 0> translate <18 -12 0> inverse }
           quadric { Cylinder_Z scale <11 6 1> rotate <0 0 9> translate <31 -11 0> inverse }

   }
		texture { SkullTexture }
		   bounded_by {
		   box { UnitBox scale <35 20 20> translate <6 0 0> }
		   }
}


//--- Bottom Jaw
#declare Sk2 =
object {
      union {
	quadric { Sphere scale <20 15 15> translate <0 -5 0>  }
	quadric { Sphere scale <17 12.5 12.5> translate <14 -5 0> }
	quadric { Sphere scale <15 11 11> translate <21 -5 0>  }
	quadric { Sphere scale <10.5 7.5 7.5> translate <30 -5 0> }
	}
		texture { SkullTexture }
		   bounded_by {
		   box { UnitBox scale <35 20 20> translate <6 -8 0> }
		   }	
}


//--- Dragon Horn
#declare Horn =
   composite {
      object {
   sphere { DOT 
            scale     < 0.200000  0.200000  0.200000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.286670  0.286670  0.286670>
            translate <-0.361520  0.665660  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.373330  0.373330  0.373330>
            translate <-0.767290  1.305320  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.460000  0.460000  0.460000>
            translate <-1.215440  1.916030  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.546670  0.546670  0.546670>
            translate <-1.703920  2.495000  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.633330  0.633330  0.633330>
            translate <-2.230470  3.039560  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.720000  0.720000  0.720000>
            translate <-2.792700  3.547210  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.806670  0.806670  0.806670>
            translate <-3.388010  4.015630  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.893330  0.893330  0.893330>
            translate <-4.013670  4.442660  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.980000  0.980000  0.980000>
            translate <-4.666810  4.826350  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.066670  1.066670  1.066670>
            translate <-5.344430  5.164920  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.153330  1.153330  1.153330>
            translate <-6.043430  5.456840  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.240000  1.240000  1.240000>
            translate <-6.760580  5.700760  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.326670  1.326670  1.326670>
            translate <-7.492610  5.895550  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.413330  1.413330  1.413330>
            translate <-8.236150  6.040330  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.500000  1.500000  1.500000>
            translate <-8.987780  6.134420  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.625000  1.625000  1.625000>
            translate <-10.305170  6.100880  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.750000  1.750000  1.750000>
            translate <-11.619810  6.192210  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.875000  1.875000  1.875000>
            translate <-12.919900  6.407610  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 2.000000  2.000000  2.000000>
            translate <-14.193750  6.745140  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 2.125000  2.125000  2.125000>
            translate <-15.429930  7.201770  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 2.250000  2.250000  2.250000>
            translate <-16.617310  7.773390  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 2.375000  2.375000  2.375000>
            translate <-17.745240  8.454870  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 2.500000  2.500000  2.500000>
            translate <-18.803570  9.240080  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 2.722220  2.722220  2.722220>
            translate <-20.321350  10.700000  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 2.944440  2.944440  2.944440>
            translate <-21.988330  11.986910  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 3.166670  3.166670  3.166670>
            translate <-23.784910  13.085680  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 3.388890  3.388890  3.388890>
            translate <-25.689950  13.983360  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 3.611110  3.611110  3.611110>
            translate <-27.681010  14.669400  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 3.833330  3.833330  3.833330>
            translate <-29.734680  15.135720  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 4.055560  4.055560  4.055560>
            translate <-31.826770  15.376830  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 4.277780  4.277780  4.277780>
            translate <-33.932670  15.389900  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 4.500000  4.500000  4.500000>
            translate <-36.027600  15.174770  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 4.625000  4.625000  4.625000>
            translate <-38.040550  15.071770  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 4.750000  4.750000  4.750000>
            translate <-40.053040  15.183400  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 4.875000  4.875000  4.875000>
            translate <-42.042260  15.508390  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 5.000000  5.000000  5.000000>
            translate <-43.985650  16.043060  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 4.750000  4.750000  4.750000>
            translate <-46.493390  17.084270  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 4.500000  4.500000  4.500000>
            translate <-48.826360  18.473590  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 4.250000  4.250000  4.250000>
            translate <-50.936540  20.182420  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 4.000000  4.000000  4.000000>
            translate <-52.780500  22.175600  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 3.687500  3.687500  3.687500>
            translate <-53.843640  23.167460  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 3.375000  3.375000  3.375000>
            translate <-54.975770  24.079790  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 3.062500  3.062500  3.062500>
            translate <-56.170950  24.907800  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 2.750000  2.750000  2.750000>
            translate <-57.422920  25.647140  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 2.437500  2.437500  2.437500>
            translate <-58.725120  26.293940  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 2.125000  2.125000  2.125000>
            translate <-60.070710  26.844800  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.812500  1.812500  1.812500>
            translate <-61.452630  27.296850  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.500000  1.500000  1.500000>
            translate <-62.863640  27.647710  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.435000  1.435000  1.435000>
            translate <-63.628320  27.519420  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.370000  1.370000  1.370000>
            translate <-64.398160  27.426880  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.305000  1.305000  1.305000>
            translate <-65.171460  27.370280  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.240000  1.240000  1.240000>
            translate <-65.946560  27.349730  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.175000  1.175000  1.175000>
            translate <-66.721780  27.365300  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.110000  1.110000  1.110000>
            translate <-67.495440  27.416940  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.045000  1.045000  1.045000>
            translate <-68.265850  27.504540  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.980000  0.980000  0.980000>
            translate <-69.031340  27.627910  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.915000  0.915000  0.915000>
            translate <-69.790270  27.786790  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.850000  0.850000  0.850000>
            translate <-70.540970  27.980830  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.785000  0.785000  0.785000>
            translate <-71.281820  28.209610  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.720000  0.720000  0.720000>
            translate <-72.011230  28.472620  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.655000  0.655000  0.655000>
            translate <-72.727590  28.769320  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.590000  0.590000  0.590000>
            translate <-73.429370  29.099040  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.525000  0.525000  0.525000>
            translate <-74.115040  29.461070  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.460000  0.460000  0.460000>
            translate <-74.783100  29.854640  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.395000  0.395000  0.395000>
            translate <-75.432120  30.278870  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.330000  0.330000  0.330000>
            translate <-76.060690  30.732870  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.265000  0.265000  0.265000>
            translate <-76.667430  31.215630  0.000000>
         }
         texture {
            HornTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.200000  0.200000  0.200000>
            translate <-77.251050  31.726120  0.000000>
         }
         texture {
            HornTexture
         }
      }
      bounded_by {
   sphere { DOT 
            scale < 46.544993  46.544993  46.544993>
            translate <-38.625525  15.863060  0.000000>
         }
      }
   }



//--- Attach Eyes & Jaw to Head
#declare Skull =
composite {
object { Sk1 }
object { Sk2 scale <1 .6 .9> translate <0 -5 0> }
object { 
   union { Lid2 }
   translate <6 1 -16.6> 
      texture { SkullTexture } 
}
composite { Eye rotate <0 -28 0> translate <6 1 -16.4> }
object { GlassCap translate <6 1 -16.4> }

composite { Eye rotate <0 -196 0> translate <6 1 16.4> }
object { GlassCap translate <6 1 16.4> }

}


//--- Complete Head w/ Horns
#declare Head =
composite {
composite { Horn rotate <0 15 0> translate <36 -6 9> }
composite { Horn rotate <0 -15 0> translate <36 -6 -9> }
composite { Skull }
}


//*****************************************************************
//--- Back & Front Legs

//--- Back Legs
#declare YourThing1 =
   composite {
      object {
   sphere { DOT 
            scale     < 3.500000  3.500000  3.500000>
            translate <-16.000000  18.000000  0.000000>
         }
         texture {
            BLegTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  3.416839 }
            plane {     < 1.000000  0.000000  0.000000>  2.928719 inverse }
         }
         translate <-3.416839  0.000000  0.000000>
         scale     < 4.505166  1.000000  1.000000>
         translate <-0.758427  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -29.013531>
         translate <-16.000000  18.000000  0.000000>
         texture {
            BLegTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 3.000000  3.000000  3.000000>
            translate <-13.982160  16.880870  0.000000>
         }
         texture {
            BLegTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  2.928719 }
            plane {     < 1.000000  0.000000  0.000000>  2.440599 inverse }
         }
         translate <-2.928719  0.000000  0.000000>
         scale     < 4.505147  1.000000  1.000000>
         translate <-0.650083  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -37.006619>
         translate <-13.982160  16.880870  0.000000>
         texture {
            BLegTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 2.500000  2.500000  2.500000>
            translate <-12.139550  15.492030  0.000000>
         }
         texture {
            BLegTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  2.440599 }
            plane {     < 1.000000  0.000000  0.000000>  1.952479 inverse }
         }
         translate <-2.440599  0.000000  0.000000>
         scale     < 4.505156  1.000000  1.000000>
         translate <-0.541735  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -45.000000>
         translate <-12.139550  15.492030  0.000000>
         texture {
            BLegTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 2.000000  2.000000  2.000000>
            translate <-10.507970  13.860450  0.000000>
         }
         texture {
            BLegTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.952479 }
            plane {     < 1.000000  0.000000  0.000000>  1.464359 inverse }
         }
         translate <-1.952479  0.000000  0.000000>
         scale     < 4.505147  1.000000  1.000000>
         translate <-0.433388  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -52.993381>
         translate <-10.507970  13.860450  0.000000>
         texture {
            BLegTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.500000  1.500000  1.500000>
            translate <-9.119130  12.017840  0.000000>
         }
         texture {
            BLegTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.464360 }
            plane {     < 1.000000  0.000000  0.000000>  0.976240 inverse }
         }
         translate <-1.464360  0.000000  0.000000>
         scale     < 4.505166  1.000000  1.000000>
         translate <-0.325040  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -60.986469>
         translate <-9.119130  12.017840  0.000000>
         texture {
            BLegTexture
         }
      }
      object {
   sphere { DOT 
            translate <-8.000000  10.000000  0.000000>
         }
         texture {
            BLegTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.705738 }
            plane {     < 1.000000  0.000000  0.000000>  0.974707 inverse }
         }
         translate <-0.974707  0.000000  0.000000>         
         scale     < 4.361386  1.000000  1.000000>
         translate < 0.223486  0.000000  0.000000>
         rotate    < 0.000000  0.000000  21.823158>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-8.000000  10.000000  0.000000>
         texture {
            BLegTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.750000  1.750000  1.750000>
            translate <-11.115420  11.247540  0.000000>
         }
         texture {
            BLegTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  2.436768 }
            plane {     < 1.000000  0.000000  0.000000>  1.705737 inverse }
         }
         translate <-1.705737  0.000000  0.000000>
         scale     < 4.361378  1.000000  1.000000>
         translate < 0.391101  0.000000  0.000000>
         rotate    < 0.000000  0.000000  32.690459>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-11.115420  11.247540  0.000000>
         texture {
            BLegTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 2.500000  2.500000  2.500000>
            translate <-13.939760  13.060070  0.000000>
         }
         texture {
            BLegTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  3.167798 }
            plane {     < 1.000000  0.000000  0.000000>  2.436768 inverse }
         }
         translate <-2.436768  0.000000  0.000000>
         scale     < 4.361382  1.000000  1.000000>
         translate < 0.558715  0.000000  0.000000>
         rotate    < 0.000000  0.000000  43.557670>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-13.939760  13.060070  0.000000>
         texture {
            BLegTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 3.250000  3.250000  3.250000>
            translate <-16.371730  15.372580  0.000000>
         }
         texture {
            BLegTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  3.898829 }
            plane {     < 1.000000  0.000000  0.000000>  3.167798 inverse }
         }
         translate <-3.167798  0.000000  0.000000>
         scale     < 4.361384  1.000000  1.000000>
         translate < 0.726329  0.000000  0.000000>
         rotate    < 0.000000  0.000000  54.424930>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-16.371730  15.372580  0.000000>
         texture {
            BLegTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 4.000000  4.000000  4.000000>
            translate <-18.324100  18.102130  0.000000>
         }
         texture {
            BLegTexture
         }
      }
      bounded_by {
   sphere { DOT 
            scale < 11.929979  11.929979  11.929979>
            translate <-14.662050  15.551065  0.000000>
         }
      }
   }




#declare YourThing2 =
   composite {
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  3.913797 }
            plane {     < 1.000000  0.000000  0.000000>  0.978449 inverse }
         }
         translate <-3.913797  0.000000  0.000000>
         scale     < 4.738542  1.000000  1.000000>
         translate <-0.825950  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -38.791763>
         translate <-18.324100  18.102130  0.000000>
         texture {
            BLegTexture
         }
      }
      object {
   sphere { DOT 
            translate <-7.000000  9.000000  0.000000>
         }
         texture {
            BLegTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.240346 }
            plane {     < 1.000000  0.000000  0.000000>  0.992277 inverse }
         }
         translate <-0.992277  0.000000  0.000000>
         scale     < 7.999284  1.000000  1.000000>
         translate < 0.124046  0.000000  0.000000>
         rotate    < 0.000000  0.000000 -7.070642>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-7.000000  9.000000  0.000000>
         texture {
            BLegTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.250000  1.250000  1.250000>
            translate <-9.000060  8.751920  0.000000>
         }
         texture {
            BLegTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.488415 }
            plane {     < 1.000000  0.000000  0.000000>  1.240346 inverse }
         }
         translate <-1.240346  0.000000  0.000000>
         scale     < 7.999257  1.000000  1.000000>
         translate < 0.155058  0.000000  0.000000>
         rotate    < 0.000000  0.000000  0.027292>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-9.000060  8.751920  0.000000>
         texture {
            BLegTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.500000  1.500000  1.500000>
            translate <-11.015440  8.752880  0.000000>
         }
         texture {
            BLegTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.495270 }
            plane {     < 1.000000  0.000000  0.000000>  1.329125 inverse }
         }
         translate <-1.495270  0.000000  0.000000>
         scale     < 12.562165  1.000000  1.000000>
         translate <-0.119030  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  7.275212>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-11.015440  8.752880  0.000000>
         texture {
            BLegTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.333330  1.333330  1.333330>
            translate <-13.098890  9.018860  0.000000>
         }
         texture {
            BLegTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.329126 }
            plane {     < 1.000000  0.000000  0.000000>  1.162991 inverse }
         }
         translate <-1.329126  0.000000  0.000000>
         scale     < 12.562895  1.000000  1.000000>
         translate <-0.105798  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  14.672598>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-13.098890  9.018860  0.000000>
         texture {
            BLegTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.166670  1.166670  1.166670>
            translate <-15.130750  9.550870  0.000000>
         }
         texture {
            BLegTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.162991 }
            plane {     < 1.000000  0.000000  0.000000>  0.996847 inverse }
         }
         translate <-1.162991  0.000000  0.000000>
         scale     < 12.562180  1.000000  1.000000>
         translate <-0.092579  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  22.070646>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-15.130750  9.550870  0.000000>
         texture {
            BLegTexture
         }
      }
      object {
   sphere { DOT 
            translate <-17.077200  10.340080  0.000000>
         }
         texture {
            BLegTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.409664 }
            plane {     < 1.000000  0.000000  0.000000>  0.939776 inverse }
         }
         translate <-0.939776  0.000000  0.000000>
         scale     < 2.749556  1.000000  1.000000>
         translate < 0.341792  0.000000  0.000000>
         rotate    < 0.000000  0.000000 -13.442719>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-17.077200  10.340080  0.000000>
         texture {
            BLegTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.500000  1.500000  1.500000>
            translate <-18.500000  10.000000  0.000000>
         }
         texture {
            BLegTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.455214 }
            plane {     < 1.000000  0.000000  0.000000>  0.970143 inverse }
         }
         translate <-1.455214  0.000000  0.000000>
         scale     < 4.000000  1.000000  1.000000>
         translate <-0.363803  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -75.963757>
         translate <-18.500000  10.000000  0.000000>
         texture {
            BLegTexture
         }
      }
      object {
   sphere { DOT 
            translate <-18.000000  8.000000  0.000000>
         }
         texture {
            BLegTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.462019 }
            plane {     < 1.000000  0.000000  0.000000>  0.974679 inverse }
         }
         translate <-0.974679  0.000000  0.000000>
         scale     < 4.358899  1.000000  1.000000>
         translate < 0.223607  0.000000  0.000000>
         rotate    < 0.000000  0.000000 -63.434949>
         translate <-18.000000  8.000000  0.000000>
         texture {
            BLegTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.500000  1.500000  1.500000>
            translate <-17.000000  6.000000  0.000000>
         }
         texture {
            BLegTexture
         }
      }



      object {
   sphere { DOT 
            scale     < 1.300000  1.300000  1.300000>
            translate <-17.400000  7.500000  0.000000>
         }
         texture {
            BLegTexture
         }
      }

      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.493520 }
            plane {     < 1.000000  0.000000  0.000000>  0.995680 inverse }
         }
         translate <-1.493520  0.000000  0.000000>
         scale     < 10.723805  1.000000  1.000000>
         translate <-0.139272  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -68.198591>
         translate <-17.000000  6.000000  0.000000>
         texture {
            BLegTexture
         }
      }

//----------------------- Heel
      object {
   sphere { DOT 
            translate <-15.000000  1.000000  0.000000>

         }
         texture {
            BLegTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.963328 }
            plane {     < 1.000000  0.000000  0.000000>  0.674329 inverse }
         }
         translate <-0.963328  0.000000  0.000000>
         scale     < 3.590110  1.000000  1.000000>
         translate <-0.268328  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -26.565051>
         translate <-15.000000  1.000000  0.000000>
         texture {
            BLegTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.700000  0.700000  0.700000>
            translate <-14.000000  0.500000  0.000000>
         }
         texture {
            BLegTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.698742 }
            plane {     < 1.000000  0.000000  0.000000>  0.399281 inverse }
         }
         translate <-0.698742  0.000000  0.000000>
         scale     < 16.657497  1.000000  1.000000>
         translate <-0.041948  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -2.862405>
         translate <-14.000000  0.500000  0.000000>
         texture {
            BLegTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.400000  0.400000  0.400000>
            translate <-9.000000  0.250000  0.000000>
         }
         texture {
            BLegTexture
         }
      }
      bounded_by {
   sphere { DOT 
            scale < 12.850359  12.850359  12.850359>
            translate <-10.000000  5.650000  0.000000>
         }
      }
   }


//--- Back Hind Leg
#declare BLeg = 
   composite {
        composite { YourThing1 }
        composite { YourThing2 }
      bounded_by {
   sphere { DOT 
            scale < 17.904595  17.904595  17.904595>
            translate <-11.162050  10.951065  0.000000>
         }
      }
   }


//*******************************************************************

//--- Front Legs
#declare Thing1 =
   composite {

      object {
   sphere { DOT 
            scale     < 4 4 4>
            translate < 15 20 1>
         }
         texture {
            FLegTexture
         }
      }

      object {
   sphere { DOT 
            scale     < 1.500000  1.500000  1.500000>
            translate < 13.000000  17.000000  0.000000>
         }
         texture {
            FLegTexture
         }
      }
      object {
         Connector_1
         scale     < 1.507879  1.500000  1.500000>
         rotate    < 0.000000  0.000000 -51.607055>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 13.000000  17.000000  0.000000>
         texture {
            FLegTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.500000  1.500000  1.500000>
            translate < 12.063530  15.818170  0.000000>
         }
         texture {
            FLegTexture
         }
      }
      object {
         Connector_1
         scale     < 1.507887  1.500000  1.500000>
         rotate    < 0.000000  0.000000 -36.748762>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 12.063530  15.818170  0.000000>
         texture {
            FLegTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.500000  1.500000  1.500000>
            translate < 10.855310  14.915990  0.000000>
         }
         texture {
            FLegTexture
         }
      }
      object {
         Connector_1
         scale     < 1.507881  1.500000  1.500000>
         rotate    < 0.000000  0.000000 -21.890526>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 10.855310  14.915990  0.000000>
         texture {
            FLegTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.500000  1.500000  1.500000>
            translate < 9.456150  14.353800  0.000000>
         }
         texture {
            FLegTexture
         }
      }
      object {
         Connector_1
         scale     < 1.507884  1.500000  1.500000>
         rotate    < 0.000000  0.000000 -7.032359>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 9.456150  14.353800  0.000000>
         texture {
            FLegTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.500000  1.500000  1.500000>
            translate < 7.959610  14.169190  0.000000>
         }
         texture {
            FLegTexture
         }
      }
      object {
         Connector_1
         scale     < 1.507884  1.500000  1.500000>
         rotate    < 0.000000  0.000000  7.825952>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 7.959610  14.169190  0.000000>
         texture {
            FLegTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.500000  1.500000  1.500000>
            translate < 6.465770  14.374510  0.000000>
         }
         texture {
            FLegTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.597463 }
            plane {     < 1.000000  0.000000  0.000000>  1.497621 inverse }
         }
         translate <-1.497621  0.000000  0.000000>
         scale     < 17.735024  1.000000  1.000000>
         translate < 0.084444  0.000000  0.000000>
         rotate    < 0.000000  0.000000  54.404616>
         translate < 6.465770  14.374510  0.000000>
         texture {
            FLegTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.600000  1.600000  1.600000>
            translate < 7.499690  15.818920  0.000000>
         }
         texture {
            FLegTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.697304 }
            plane {     < 1.000000  0.000000  0.000000>  1.597463 inverse }
         }
         translate <-1.597463  0.000000  0.000000>
         scale     < 17.735143  1.000000  1.000000>
         translate < 0.090073  0.000000  0.000000>
         rotate    < 0.000000  0.000000  44.711252>
         translate < 7.499690  15.818920  0.000000>
         texture {
            FLegTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.700000  1.700000  1.700000>
            translate < 8.762060  17.068630  0.000000>
         }
         texture {
            FLegTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.797145 }
            plane {     < 1.000000  0.000000  0.000000>  1.697304 inverse }
         }
         translate <-1.697304  0.000000  0.000000>
         scale     < 17.735049  1.000000  1.000000>
         translate < 0.095703  0.000000  0.000000>
         rotate    < 0.000000  0.000000  35.017863>
         translate < 8.762060  17.068630  0.000000>
         texture {
            FLegTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.800000  1.800000  1.800000>
            translate < 10.216820  18.087940  0.000000>
         }
         texture {
            FLegTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.896987 }
            plane {     < 1.000000  0.000000  0.000000>  1.797145 inverse }
         }
         translate <-1.797145  0.000000  0.000000>
         scale     < 17.735069  1.000000  1.000000>
         translate < 0.101333  0.000000  0.000000>
         rotate    < 0.000000  0.000000  25.324405>
         translate < 10.216820  18.087940  0.000000>
         texture {
            FLegTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.900000  1.900000  1.900000>
            translate < 11.822440  18.847750  0.000000>
         }
         texture {
            FLegTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.996828 }
            plane {     < 1.000000  0.000000  0.000000>  1.896987 inverse }
         }
         translate <-1.896987  0.000000  0.000000>
         scale     < 17.735057  1.000000  1.000000>
         translate < 0.106963  0.000000  0.000000>
         rotate    < 0.000000  0.000000  15.630866>
         translate < 11.822440  18.847750  0.000000>
         texture {
            FLegTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 2.000000  2.000000  2.000000>
            translate < 13.533070  19.326360  0.000000>
         }
         texture {
            FLegTexture
         }
      }
      bounded_by {
   sphere { DOT 
            scale < 7.828848  7.828848  7.828848>
            translate < 10.249420  16.997775  0.000000>
         }
      }
   }


#declare Thing2 =
   composite {
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.997902 }
            plane {     < 1.000000  0.000000  0.000000>  1.498427 inverse }
         }
         translate <-1.997902  0.000000  0.000000>
         scale     < 21.816683  1.000000  1.000000>
         translate <-0.091577  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -38.692192>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 13.533070  19.326360  0.000000>
         texture {
            FLegTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.500000  1.500000  1.500000>
            translate < 5.010000  12.500000  0.000000>
         }
         texture {
            FLegTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.423025 }
            plane {     < 1.000000  0.000000  0.000000>  0.948683 inverse }
         }
         translate <-1.423025  0.000000  0.000000>
         scale     < 3.000000  1.000000  1.000000>
         translate <-0.474342  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -71.565051>
         translate < 5.010000  12.500000  0.000000>
         texture {
            FLegTexture
         }
      }
      object {
   sphere { DOT 
            translate < 5.510000  11.000000  0.000000>
         }
         texture {
            FLegTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.386750 }
            plane {     < 1.000000  0.000000  0.000000>  0.554700 inverse }
         }
         translate <-0.554700  0.000000  0.000000>
         scale     < 0.666667  1.000000  1.000000>
         translate < 0.832050  0.000000  0.000000>
         rotate    < 0.000000  0.000000 -33.690068>
         translate < 5.510000  11.000000  0.000000>
         texture {
            FLegTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 2.500000  2.500000  2.500000>
            translate < 7.010000  10.000000  0.000000>
         }
         texture {
            FLegTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  2.432521 }
            plane {     < 1.000000  0.000000  0.000000>  0.973009 inverse }
         }
         translate <-2.432521  0.000000  0.000000>
         scale     < 4.216370  1.000000  1.000000>
         translate <-0.576923  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -67.380135>
         translate < 7.010000  10.000000  0.000000>
         texture {
            FLegTexture
         }
      }
      object {
   sphere { DOT 
            translate < 9.510000  4.000000  0.000000>
         }
         texture {
            FLegTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.473911 }
            plane {     < 1.000000  0.000000  0.000000>  0.982607 inverse }
         }
         translate <-0.982607  0.000000  0.000000>
         scale     < 5.291503  1.000000  1.000000>
         translate < 0.185695  0.000000  0.000000>
         rotate    < 0.000000  0.000000 -68.198591>
         translate < 9.510000  4.000000  0.000000>
         texture {
            FLegTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.500000  1.500000  1.500000>
            translate < 10.510000  1.500000  0.000000>
         }
         texture {
            FLegTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.423025 }
            plane {     < 1.000000  0.000000  0.000000>  0.948683 inverse }
         }
         translate <-1.423025  0.000000  0.000000>
         scale     < 3.000000  1.000000  1.000000>
         translate <-0.474342  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -18.434949>
         translate < 10.510000  1.500000  0.000000>
         texture {
            FLegTexture
         }
      }
      object {
   sphere { DOT 
            translate < 12.010000  1.000000  0.000000>
         }
         texture {
            FLegTexture
         }
      }

/*
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.996546 }
            plane {     < 1.000000  0.000000  0.000000>  0.498273 inverse }
         }
         translate <-0.996546  0.000000  0.000000>
         scale     < 12.000000  1.000000  1.000000>
         translate <-0.083045  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -4.763642>
         translate < 12.010000  1.000000  0.000000>
         texture {
            FLegTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.500000  0.500000  0.500000>
            translate < 18.010000  0.500000  0.000000>
         }
         texture {
            FLegTexture
         }
      }
 
*/

     bounded_by {
   sphere { DOT 
            scale < 13.057376  13.057376  13.057376>
            translate < 9.255000  7.000000  0.000000>
         }
      }
   }



#declare FLeg = 
   composite {
      composite { Thing1 }
      composite { Thing2 }
      bounded_by {
   sphere { DOT 
            scale < 15.772958  15.772958  15.772958>
            translate < 9.255000  10.663180  0.000000>
         }
      }
   }


//************************************************************
//----- Dragon's Back Spine & under Belly

//--- Back Spine Section
#declare Dot3 =
union {
    quadric { Sphere scale <1 1 .6> translate <0 0 .4> }
    quadric { Sphere scale <1 1 .6> translate <0 0 -.4> }
    quadric { Sphere scale <1 .4 1.2> }
}

//--- Modified Back Spine Texture
#declare Dot2 =
union {
    quadric { Sphere scale <1 1 .6> translate <0 0 .4> }
    quadric { Sphere scale <1 1 .6> translate <0 0 -.4> }
    quadric { Sphere scale <.4 .4 1.2> }
}

//--- Dragon's Spine
#declare Back =
   composite {

      object {
         union {
            Dot3 } texture { BackTexture }
            translate <-80.000000  16.000000  0.000000>
         }
          
             
      object {
         union {
            Dot3 }  texture { BackTexture }
            scale     < 1.133330  1.133330  1.133330>
            translate <-79.158740  13.947780  0.000000>
         }
          
             
      object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 1.266670  1.266670  1.266670>
            translate <-78.107570  11.994730  0.000000>
         }
          
             
      object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 1.400000  1.400000  1.400000>
            translate <-76.858010  10.162260  0.000000>
         }
          
             
      object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 1.533330  1.533330  1.533330>
            translate <-75.423750  8.470450  0.000000>
         }
          
             
      object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 1.666670  1.666670  1.666670>
            translate <-73.820510  6.937820  0.000000>
         }
          
             
      object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 1.800000  1.800000  1.800000>
            translate <-72.065840  5.581180  0.000000>
         }
          
             
      object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 1.933330  1.933330  1.933330>
            translate <-70.178990  4.415370  0.000000>
         }
          
             
      object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 2.066670  2.066670  2.066670>
            translate <-68.180600  3.453190  0.000000>
         }
          
             
      object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 2.200000  2.200000  2.200000>
            translate <-66.092590  2.705160  0.000000>
         }
          
             
      object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 2.333330  2.333330  2.333330>
            translate <-63.937820  2.179490  0.000000>
         }
          
             
      object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 2.466670  2.466670  2.466670>
            translate <-61.739910  1.881930  0.000000>
         }
          
             
      object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 2.600000  2.600000  2.600000>
            translate <-59.522950  1.815750  0.000000>
         }
          
             
      object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 2.733330  2.733330  2.733330>
            translate <-57.311200  1.981670  0.000000>
         }
          
             
      object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 2.866670  2.866670  2.866670>
            translate <-55.128920  2.377860  0.000000>
         }
          
             
      object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 3.000000  3.000000  3.000000>
            translate <-53.000000  3.000000  0.000000>
         }
          
             
      object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 3.200000  3.200000  3.200000>
            translate <-49.797940  4.049410  0.000000>
         }
          
             
      object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 3.400000  3.400000  3.400000>
            translate <-46.631320  5.201320  0.000000>
         }
          
             
      object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 3.600000  3.600000  3.600000>
            translate <-43.503410  6.454540  0.000000>
         }
          
             
      object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 3.800000  3.800000  3.800000>
            translate <-40.417460  7.807760  0.000000>
         }
          
             
      object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 4.000000  4.000000  4.000000>
            translate <-37.376640  9.259600  0.000000>
         }
          
             
      object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 4.200000  4.200000  4.200000>
            translate <-34.384130  10.808540  0.000000>
         }
          
             
      object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 4.400000  4.400000  4.400000>
            translate <-31.443010  12.452980  0.000000>
         }
          
             
	object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 4.600000  4.600000  4.600000>
            translate <-28.556340  14.191220  0.000000>
         }
          
             
      object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 4.800000  4.800000  4.800000>
            translate <-25.727090  16.021450  0.000000>
         }
          
             
      object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 5.000000  5.000000  5.000000>
            translate <-22.958220  17.941780  0.000000>
         }
          
             
      object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 5.625000  5.625000  5.625000>
            translate <-19.135150  19.525610  0.000000>
         }
          
             
      object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 6.250000  6.250000  6.250000>
            translate <-15.174720  20.725320  0.000000>
         }
          
             
      object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 6.875000  6.875000  6.875000>
            translate <-11.115400  21.529250  0.000000>
         }
          
             
      object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 7.500000  7.500000  7.500000>
            translate <-6.996650  21.929580  0.000000>
         }
          
             
      object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 7.200000  7.200000  7.200000>
            translate <-3.959920  21.964200  0.000000>
         }
          
             
      object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 6.900000  6.900000  6.900000>
            translate <-0.928630  21.779180  0.000000>
         }
          
             
      object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 6.600000  6.600000  6.600000>
            translate < 2.081340  21.375490  0.000000>
         }
          
             
      object {
         union {
            Dot3 } texture { BackTexture }
            scale     < 6.300000  6.300000  6.300000>
            translate < 5.054250  20.755220  0.000000>
         }
          
             
      object {
         union {
            Dot2 } texture { BackTexture }
            scale     < 6.000000  6.000000  6.000000>
            translate < 7.974530  19.921640  0.000000>
         }
          
             
      object {
         union {
            Dot2 } texture { BackTexture }
            scale     < 5.687500  5.687500  5.687500>
            translate < 11.228690  19.867860  0.000000>
         }
          
             
      object {
         union {
            Dot2 } texture { BackTexture }
            scale     < 5.375000  5.375000  5.375000>
            translate < 14.460540  20.251880  0.000000>
         }
          
             
      object {
         union {
            Dot2 } texture { BackTexture }
            scale     < 5.062500  5.062500  5.062500>
            translate < 17.611470  21.066720  0.000000>
         }
          
             
      object {
         union {
            Dot2 } texture { BackTexture }
            scale     < 4.750000  4.750000  4.750000>
            translate < 20.624320  22.297620  0.000000>
         }
          
             
      object {
         union {
            Dot2 } texture { BackTexture }
            scale     < 4.437500  4.437500  4.437500>
            translate < 23.444430  23.922220  0.000000>
         }
          
             
      object {
         union {
            Dot2 } texture { BackTexture }
            scale     < 4.125000  4.125000  4.125000>
            translate < 26.020630  25.911080  0.000000>
         }
          
             
      object {
         union {
            Dot2 } texture { BackTexture }
            scale     < 3.812500  3.812500  3.812500>
            translate < 28.306190  28.228090  0.000000>
         }
          
             
      object {
         union {
            Dot2 } texture { BackTexture }
            scale     < 3.500000  3.500000  3.500000>
            translate < 30.259650  30.831240  0.000000>
         }
          
             
      object {
         union {
            Dot2 } texture { BackTexture }
            scale     < 3.375000  3.375000  3.375000>
            translate < 32.152550  32.726220  0.000000>
         }
          
             
      object {
         union {
            Dot2 } texture { BackTexture }
            scale     < 3.250000  3.250000  3.250000>
            translate < 34.286770  34.344580  0.000000>
         }
          
             
      object {
         union {
            Dot2 } texture { BackTexture }
            scale     < 3.125000  3.125000  3.125000>
            translate < 36.622240  35.655920  0.000000>
         }
          
             
      object {
         union {
            Dot2 } texture { BackTexture }
            scale     < 3.000000  3.000000  3.000000>
            translate < 39.115070  36.635620  0.000000>
         }
          
             
      bounded_by {
         quadric {
            Sphere     scale < 71.745147  71.745147  71.745147>
            translate <-19.442465  19.425685  0.000000>
         }
      }
   }


//--- Dragon Gutt
#declare Belly =
object {
   union {
	quadric { Sphere scale <15 9 8> translate <-4 18 0> }
	quadric { Sphere scale <9 6 4> rotate <0 0 30> translate <14 19 2> }
	quadric { Sphere scale <9 6 4> rotate <0 0 30> translate <14 19 -2> }
   }
	    texture { BellyTexture }
}	



//*************************************************************************************
//----- Dragon Wing


#declare W1 =
   composite {
      object {
   sphere { DOT 
            scale     < 0.200000  0.200000  0.200000>
            translate < 1.000000  47.999990  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.399042 }
            plane {     < 1.000000  0.000000  0.000000>  0.199521 inverse }
         }
         translate <-0.199521  0.000000  0.000000>
         scale     < 14.423059  1.000000  1.000000>
         translate < 0.013833  0.000000  0.000000>
         rotate    < 0.000000  0.000000 -76.520089>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 1.000000  47.999990  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.400000  0.400000  0.400000>
            translate < 0.325970  45.188110  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.598563 }
            plane {     < 1.000000  0.000000  0.000000>  0.399042 inverse }
         }
         translate <-0.399042  0.000000  0.000000>
         scale     < 14.423042  1.000000  1.000000>
         translate < 0.027667  0.000000  0.000000>
         rotate    < 0.000000  0.000000 -83.415451>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 0.325970  45.188110  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.600000  0.600000  0.600000>
            translate <-0.005600  42.315650  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.798084 }
            plane {     < 1.000000  0.000000  0.000000>  0.598563 inverse }
         }
         translate <-0.598563  0.000000  0.000000>
         scale     < 14.423037  1.000000  1.000000>
         translate < 0.041500  0.000000  0.000000>
         rotate    < 0.000000  0.000000 -89.689497>
         translate <-0.005600  42.315650  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.800000  0.800000  0.800000>
            translate < 0.010070  39.424160  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.997605 }
            plane {     < 1.000000  0.000000  0.000000>  0.798084 inverse }
         }
         translate <-0.798084  0.000000  0.000000>
         scale     < 14.423064  1.000000  1.000000>
         translate < 0.055334  0.000000  0.000000>
         rotate    < 0.000000  0.000000 -82.794124>
         translate < 0.010070  39.424160  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            translate < 0.372770  36.555460  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         Connector_1
         scale     < 2.891541  1.000000  1.000000>
         rotate    < 0.000000  0.000000 -75.898830>
         translate < 0.372770  36.555460  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            translate < 1.077250  33.751050  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         Connector_1
         scale     < 2.891538  1.000000  1.000000>
         rotate    < 0.000000  0.000000 -69.003703>
         translate < 1.077250  33.751050  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            translate < 2.113310  31.051500  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         Connector_1
         scale     < 3.550663  1.000000  1.000000>
         rotate    < 0.000000  0.000000 -71.909292>
         translate < 2.113310  31.051500  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            translate < 3.215870  27.676360  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         Connector_1
         scale     < 3.550668  1.000000  1.000000>
         rotate    < 0.000000  0.000000 -78.647661>
         translate < 3.215870  27.676360  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            translate < 3.914790  24.195160  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         Connector_1
         scale     < 3.550675  1.000000  1.000000>
         rotate    < 0.000000  0.000000 -85.386406>
         translate < 3.914790  24.195160  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            translate < 4.200390  20.655990  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         Connector_1
         scale     < 3.550662  1.000000  1.000000>
         rotate    < 0.000000  0.000000 -87.874962>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 4.200390  20.655990  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            translate < 4.068730  17.107770  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         Connector_1
         scale     < 3.550671  1.000000  1.000000>
         rotate    < 0.000000  0.000000 -81.136515>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 4.068730  17.107770  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            translate < 3.521640  13.599500  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         Connector_1
         scale     < 3.550672  1.000000  1.000000>
         rotate    < 0.000000  0.000000 -74.397925>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 3.521640  13.599500  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            translate < 2.566670  10.179660  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         Connector_1
         scale     < 3.550661  1.000000  1.000000>
         rotate    < 0.000000  0.000000 -67.659362>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 2.566670  10.179660  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            translate < 1.217020  6.895510  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         Connector_1
         scale     < 4.087040  1.000000  1.000000>
         rotate    < 0.000000  0.000000  64.865470>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 1.217020  6.895510  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            translate <-0.518930  10.595560  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         Connector_1
         scale     < 4.087040  1.000000  1.000000>
         rotate    < 0.000000  0.000000  60.294016>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-0.518930  10.595560  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            translate <-2.544260  14.145480  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         Connector_1
         scale     < 4.087032  1.000000  1.000000>
         rotate    < 0.000000  0.000000  55.722384>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-2.544260  14.145480  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            translate <-4.846090  17.522670  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.999701 }
            plane {     < 1.000000  0.000000  0.000000>  0.899731 inverse }
         }
         translate <-0.999701  0.000000  0.000000>
         scale     < 40.858223  1.000000  1.000000>
         translate <-0.024468  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate   < 0.000000  0  51.151029>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-4.846090  17.522670  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.900000  0.900000  0.900000>
            translate <-7.409770  20.705670  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.899731 }
            plane {     < 1.000000  0.000000  0.000000>  0.799760 inverse }
         }
         translate <-0.899731  0.000000  0.000000>
         scale     < 40.858085  1.000000  1.000000>
         translate <-0.022021  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  46.579519>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-7.409770  20.705670  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.800000  0.800000  0.800000>
            translate <-10.218980  23.674200  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.799042 }
            plane {     < 1.000000  0.000000  0.000000>  0.599281 inverse }
         }
         translate <-0.799042  0.000000  0.000000>
         scale     < 20.410723  1.000000  1.000000>
         translate <-0.039148  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  42.008032>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-10.218980  23.674200  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.600000  0.600000  0.600000>
            translate <-13.255860  26.409390  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.599281 }
            plane {     < 1.000000  0.000000  0.000000>  0.399521 inverse }
         }
         translate <-0.599281  0.000000  0.000000>
         scale     < 20.410726  1.000000  1.000000>
         translate <-0.029361  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  37.436354>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-13.255860  26.409390  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.400000  0.400000  0.400000>
            translate <-16.501090  28.893820  0.000000>
        }
         texture {
            WingTTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.399521 }
            plane {     < 1.000000  0.000000  0.000000>  0.199760 inverse }
         }
         translate <-0.399521  0.000000  0.000000>
         scale     < 20.410697  1.000000  1.000000>
         translate <-0.019574  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  32.865052>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-16.501090  28.893820  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.200000  0.200000  0.200000>
            translate <-19.934000  31.111700  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      bounded_by {
   sphere { DOT 
            scale < 27.142934  27.142934  27.142934>
            translate <-7.466805  27.047750  0.000000>
         }
      }
   }





#declare W2 =
   composite {

      object {
   sphere { DOT 
            scale     < 0.200000  0.200000  0.200000>
            translate <-26.000000  16.500000  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.399419 }
            plane {     < 1.000000  0.000000  0.000000>  0.199709 inverse }
         }
         translate <-0.199709  0.000000  0.000000>
         scale     < 18.527783  1.000000  1.000000>
         translate < 0.010779  0.000000  0.000000>
         rotate    < 0.000000  0.000000 -5.395173>
         translate <-26.000000  16.500000  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.400000  0.400000  0.400000>
            translate <-22.305490  16.151080  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.599128 }
            plane {     < 1.000000  0.000000  0.000000>  0.399419 inverse }
         }
         translate <-0.399419  0.000000  0.000000>
         scale     < 18.527736  1.000000  1.000000>
         translate < 0.021558  0.000000  0.000000>
         rotate    < 0.000000  0.000000 -9.517504>
         translate <-22.305490  16.151080  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.600000  0.600000  0.600000>
            translate <-18.645630  15.537480  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.798837 }
            plane {     < 1.000000  0.000000  0.000000>  0.599128 inverse }
         }
         translate <-0.599128  0.000000  0.000000>
         scale     < 18.527743  1.000000  1.000000>
         translate < 0.032337  0.000000  0.000000>
         rotate    < 0.000000  0.000000 -13.640054>
         translate <-18.645630  15.537480  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.800000  0.800000  0.800000>
            translate <-15.039350  14.662360  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.899673 }
            plane {     < 1.000000  0.000000  0.000000>  0.799709 inverse }
         }
         translate <-0.799709  0.000000  0.000000>
         scale     < 37.095973  1.000000  1.000000>
         translate < 0.021558  0.000000  0.000000>
         rotate    < 0.000000  0.000000 -17.762571>
         translate <-15.039350  14.662360  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.900000  0.900000  0.900000>
            translate <-11.505310  13.530250  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.999637 }
            plane {     < 1.000000  0.000000  0.000000>  0.899673 inverse }
         }
         translate <-0.899673  0.000000  0.000000>
         scale     < 37.095938  1.000000  1.000000>
         translate < 0.024253  0.000000  0.000000>
         rotate    < 0.000000  0.000000 -21.884928>
         translate <-11.505310  13.530250  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            translate <-8.061800  12.147020  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         Connector_1
         scale     < 3.710953  1.000000  1.000000>
         rotate    < 0.000000  0.000000 -26.007478>
         translate <-8.061800  12.147020  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            translate <-4.726630  10.519810  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         Connector_1
         scale     < 3.710936  1.000000  1.000000>
         rotate    < 0.000000  0.000000 -30.129907>
         translate <-4.726630  10.519810  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            translate <-1.517080  8.657060  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         Connector_1
         scale     < 3.710946  1.000000  1.000000>
         rotate    < 0.000000  0.000000 -34.252457>
         translate <-1.517080  8.657060  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            translate < 1.550260  6.568390  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         Connector_1
         scale     < 2.766590  1.000000  1.000000>
         rotate    < 0.000000  0.000000  21.286728>
         rotate    < 0.000000 -180.000000  0.000000>
         translate < 1.550260  6.568390  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            translate <-1.027580  7.572760  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         Connector_1
         scale     < 2.766594  1.000000  1.000000>
         rotate    < 0.000000  0.000000  12.115687>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-1.027580  7.572760  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            translate <-3.732550  8.153430  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         Connector_1
         scale     < 2.766592  1.000000  1.000000>
         rotate    < 0.000000  0.000000  2.944376>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-3.732550  8.153430  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            translate <-6.495490  8.295540  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         Connector_1
         scale     < 2.766600  1.000000  1.000000>
         rotate    < 0.000000  0.000000 -6.226435>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-6.495490  8.295540  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            translate <-9.245770  7.995480  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         Connector_1
         scale     < 2.766592  1.000000  1.000000>
         rotate    < 0.000000  0.000000 -15.397523>
         rotate    < 0.000000 -180.000000  0.000000>
         translate <-9.245770  7.995480  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            translate <-11.913060  7.260910  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.196927 }
            plane {     < 1.000000  0.000000  0.000000>  0.997439 inverse }
         }
         translate <-0.997439  0.000000  0.000000>
         scale     < 13.945472  1.000000  1.000000>
         translate < 0.071524  0.000000  0.000000>
         rotate    < 0.000000  0.000000 -47.773794>
         translate <-11.913060  7.260910  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.200000  1.200000  1.200000>
            translate <-10.033810  5.190290  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.396414 }
            plane {     < 1.000000  0.000000  0.000000>  1.196927 inverse }
         }
         translate <-1.196927  0.000000  0.000000>
         scale     < 13.945469  1.000000  1.000000>
         translate < 0.085829  0.000000  0.000000>
         rotate    < 0.000000  0.000000 -38.648608>
         translate <-10.033810  5.190290  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.400000  1.400000  1.400000>
            translate <-7.849960  3.443910  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.595902 }
            plane {     < 1.000000  0.000000  0.000000>  1.396414 inverse }
         }
         translate <-1.396414  0.000000  0.000000>
         scale     < 13.945455  1.000000  1.000000>
         translate < 0.100134  0.000000  0.000000>
         rotate    < 0.000000  0.000000 -29.523059>
         translate <-7.849960  3.443910  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.600000  1.600000  1.600000>
            translate <-5.416780  2.065990  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.795390 }
            plane {     < 1.000000  0.000000  0.000000>  1.595902 inverse }
         }
         translate <-1.595902  0.000000  0.000000>
         scale     < 13.945489  1.000000  1.000000>
         translate < 0.114439  0.000000  0.000000>
         rotate    < 0.000000  0.000000 -20.397860>
         translate <-5.416780  2.065990  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 1.800000  1.800000  1.800000>
            translate <-2.795860  1.091390  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      object {
         quadric {
            Connector_2 
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.994878 }
            plane {     < 1.000000  0.000000  0.000000>  1.795390 inverse }
         }
         translate <-1.795390  0.000000  0.000000>
         scale     < 13.945412  1.000000  1.000000>
         translate < 0.128744  0.000000  0.000000>
         rotate    < 0.000000  0.000000 -11.272561>
         translate <-2.795860  1.091390  0.000000>
         texture {
            WingTTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 2.000000  2.000000  2.000000>
            translate <-0.053560  0.544790  0.000000>
         }
         texture {
            WingTTexture
         }
      }
      bounded_by {
   sphere { DOT 
            scale < 18.830486  18.830486  18.830486>
            translate <-11.824870  7.622395  0.000000>
         }
      }
   }




//---- Complete Wing
#declare W = 
   composite {
      composite { W1 }
      composite { W2 }
      bounded_by {
   sphere { DOT 
            scale < 32.387591  32.387591  32.387591>
            translate <-10.499805  23.372390  0.000000>
         }
      }
   }


#declare SkinTexture =
texture {
    color Gray
    alpha .65
    ambient .2
    diffuse .7
    phong 1
    phong_size 10
}


#declare Skin =
object {
  difference { 
    intersection { Disk_Z scale <47 47 .2> translate <21 -1 0> }
       quadric { Cylinder_Z scale <9 12 1> rotate <0 0 0> translate <-23 4 0> }
       quadric { Cylinder_Z scale <10.5 7.5 1> rotate <0 0 -22> translate <-23 24 0> }
       quadric { Cylinder_Z scale <12 17 1> rotate <0 0 14> translate <-12.5 44 0> }
       quadric { Cylinder_Z scale <24 24 1> translate <24 41 0> }
       quadric { Cylinder_Z scale <6 3 1> rotate <0 0 -24> translate <-4 5 0> }
       quadric { Cylinder_Z scale <6 3 1> rotate <0 0 -24> translate <-1 4 0> }
       plane { <0 1 0> 0  }
       plane { <-1 0 0> -4 }
       plane { <-1 0 0> .5 rotate <0 0 -21.5>  }

  }
	  texture { SkinTexture }
		bounded_by {
		box { UnitBox scale <20 30 5> translate <-10 23 0> }
		}
}	


#declare Wing =
composite {
composite { W }
object { Skin }
}



//***********************************************
//---- Foot


#declare YourTexture =    
    texture { BLegTexture }
    texture {
	gradient <1 0 0>
	color_map {
	[0 .4 color Clear color Clear]
	[.4 .6 color Clear color Scarlet alpha .5]
	[.6 1 color Scarlet alpha .5 color Scarlet]
	}
	scale <11 1 1>
	}


#declare Your1 =
   composite {
      object {
   sphere { DOT 
            scale     < 1.500000  1.500000  1.500000>
            translate < 0.000000  1.500000  0.000000>
         }
         texture {
            YourTexture
         }
      }

      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.479591 }
            plane {     < 1.000000  0.000000  0.000000>  0.986394 inverse }
         }
         translate <-1.479591  0.000000  0.000000>
         scale     < 6.000000  1.000000  1.000000>
         translate <-0.246598  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -9.462322>
         translate < 0.000000  1.500000  0.000000>
         texture {
            YourTexture
         }
      }

      object {
   sphere { DOT 
            translate < 3.000000  1.000000  0.000000>
         }
         texture {
            YourTexture
         }
      }


      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.995123 }
            plane {     < 1.000000  0.000000  0.000000>  0.696586 inverse }
         }
         translate <-0.995123  0.000000  0.000000>
         scale     < 10.088497  1.000000  1.000000>
         translate <-0.098639  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  9.462322>
         translate < 3.000000  1.000000  0.000000>
         texture {
            YourTexture
         }
      }

      object {
   sphere { DOT 
            scale     < 0.700000  0.700000  0.700000>
            translate < 6.000000  1.500000  0.000000>
         }
         texture {
            YourTexture
         }
      }


      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.695679 }
            plane {     < 1.000000  0.000000  0.000000>  0.496914 inverse }
         }
         translate <-0.695679  0.000000  0.000000>
         scale     < 8.958236  1.000000  1.000000>
         translate <-0.077658  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -33.690068>
         translate < 6.000000  1.500000  0.000000>
         texture {
            YourTexture
         }
      }

      object {
   sphere { DOT 
            scale     < 0.500000  0.500000  0.500000>
            translate < 7.500000  0.500000  0.000000>
         }
         texture {
            YourTexture
         }
      }


      object {
         Connector_1
         scale     < 1.500000  0.500000  0.500000>
         translate < 7.500000  0.500000  0.000000>
         texture {
            YourTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.500000  0.500000  0.500000>
            translate < 9.000000  0.500000  0.000000>
         }
         texture {
            YourTexture
         }
      }

      bounded_by {
   sphere { DOT 
            scale <9 9 9>
            translate < 4.000000  1.500000  0.000000>
         }
      }
   }




#declare Your2 =
   composite {

      object {
   sphere { DOT 
            scale     < 1.500000  1.500000  1.500000>
            translate <-0.497600  1.500000  1.125000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.479591 }
            plane {     < 1.000000  0.000000  0.000000>  0.986394 inverse }
         }
         translate <-1.479591  0.000000  0.000000>
         scale     < 6.000007  1.000000  1.000000>
         translate <-0.246598  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -9.462312>
         rotate    < 0.000000 -29.999964  0.000000>
         translate <-0.497600  1.500000  1.125000>
         texture {
            YourTexture
         }
      }
      object {
   sphere { DOT 
            translate < 2.100480  1.000000  2.625000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.995123 }
            plane {     < 1.000000  0.000000  0.000000>  0.696586 inverse }
         }
         translate <-0.995123  0.000000  0.000000>
         scale     < 10.088508  1.000000  1.000000>
         translate <-0.098639  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  9.462312>
         rotate    < 0.000000 -29.999964  0.000000>
         translate < 2.100480  1.000000  2.625000>
         texture {
            YourTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.700000  0.700000  0.700000>
            translate < 4.698560  1.500000  4.125000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.695679 }
            plane {     < 1.000000  0.000000  0.000000>  0.496914 inverse }
         }
         translate <-0.695679  0.000000  0.000000>
         scale     < 8.958243  1.000000  1.000000>
         translate <-0.077658  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -33.690039>
         rotate    < 0.000000 -29.999964  0.000000>
         translate < 4.698560  1.500000  4.125000>
         texture {
            YourTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.500000  0.500000  0.500000>
            translate < 5.997600  0.500000  4.875000>
         }
         texture {
            YourTexture
         }
      }
      bounded_by {
   sphere { DOT 
            scale < 8 8 8>
            translate < 2.250000  1.500000  2.500000>
         }
      }
   }


#declare Your3 =
   composite {

      object {
   sphere { DOT 
            scale     < 1.500000  1.500000  1.500000>
            translate <-0.397110  1.500000 -0.750000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  1.479591 }
            plane {     < 1.000000  0.000000  0.000000>  0.986394 inverse }
         }
         translate <-1.479591  0.000000  0.000000>
         scale     < 5.999989  1.000000  1.000000>
         translate <-0.246599  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -9.462339>
         rotate    < 0.000000  30.000059  0.000000>
         translate <-0.397110  1.500000 -0.750000>
         texture {
            YourTexture
         }
      }
      object {
   sphere { DOT 
            translate < 2.200960  1.000000 -2.250000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.995123 }
            plane {     < 1.000000  0.000000  0.000000>  0.696586 inverse }
         }
         translate <-0.995123  0.000000  0.000000>
         scale     < 10.088508  1.000000  1.000000>
         translate <-0.098639  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000  9.462312>
         rotate    < 0.000000  29.999964  0.000000>
         translate < 2.200960  1.000000 -2.250000>
         texture {
            YourTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.700000  0.700000  0.700000>
            translate < 4.799040  1.500000 -3.750000>
         }
         texture {
            YourTexture
         }
      }
      object {
         quadric {
            Connector_2
         }
         clipped_by {
            plane {     < 1.000000  0.000000  0.000000>  0.695679 }
            plane {     < 1.000000  0.000000  0.000000>  0.496914 inverse }
         }
         translate <-0.695679  0.000000  0.000000>
         scale     < 8.958243  1.000000  1.000000>
         translate <-0.077658  0.000000  0.000000>
         rotate    < 0.000000  180.000000  0.000000>
         rotate    < 0.000000  0.000000 -33.690039>
         rotate    < 0.000000  29.999964  0.000000>
         translate < 4.799040  1.500000 -3.750000>
         texture {
            YourTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.500000  0.500000  0.500000>
            translate < 6.098080  0.500000 -4.500000>
         }
         texture {
            YourTexture
         }
      }
      object {
         Connector_1
         scale     < 1.499993  0.500000  0.500000>
         rotate    < 0.000000  30.000155  0.000000>
         translate < 6.098080  0.500000 -4.500000>
         texture {
            YourTexture
         }
      }
      object {
   sphere { DOT 
            scale     < 0.500000  0.500000  0.500000>
            translate < 7.397110  0.500000 -5.250000>
         }
         texture {
            YourTexture
         }
      }
      bounded_by {
   sphere { DOT 
            scale < 6.672403  6.672403  6.672403>
            translate < 3.000000  1.500000 -2.500000>
         }
      }
   }


#declare Foot = 
   composite {
      composite { Your1 }
      composite { Your2 }
      composite { Your3 }
      bounded_by {
   sphere { DOT 
            scale < 12 12 12>
            translate < 3.751200  1.500000 -0.187500>
         }
      }
   }






//----- Complete Dragon
#declare Dragon =
composite {
	composite { Back }
	object { Belly scale <1 1 .8> }
	composite { BLeg translate <0 -1 -7> }
	composite { BLeg translate <0 -1 7> }
	composite { FLeg translate <0 0 6> }
	composite { FLeg translate <0 0 -6> }
	composite { Wing rotate <-45 0 0> translate <14 22 -4> }
	composite { Wing rotate <45 0 0> translate <14 22 4>  }
	composite { Head scale <.3 .3 .3> rotate <0 0 0> translate <45 38 0> }
	composite { Foot scale <.6 .6 .6> translate <-15 -1 -7> }
	composite { Foot scale <.6 .6 .6> translate <-15 -1 7> }
	composite { Foot scale <.7 .7 .7> translate <12 0 -7> }
	composite { Foot scale <.7 .7 .7> translate <12 0 7> }
  	
            bounded_by {
	    box { UnitBox scale <80 30 50> translate <-10 27 0> }
	    }
}


