//---- Glass Windshield, Frame & Mirrors
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare Frame =
object {
  union { 
    difference {
      cylinder { z, -z, 1 scale <32, 9, 1> }
      object { Cylinder_Z scale <30, 7, 1> }
      plane { x, -27 }
      plane { x, 27 inverse }
    }
    box { -1, 1 scale <1, 7, 1> translate <-26, 10.5, 0> }
    box { -1, 1 scale <1, 7, 1> translate < 26, 10.5, 0> }
    box { -1, 1 scale <1.5, 6, 1.5> translate <0, 13, 0> }
    cylinder { x, -x, 1 scale <2.5, 1, 1> translate <-29.5, 14.5, 0> }
    cylinder { x, -x, 1 scale <2.5, 1, 1> translate < 29.5, 14.5, 0> }
    cylinder { y, -y, 1 scale <1, 7.5, 1> translate <-30, 9, 0> }
    cylinder { y, -y, 1 scale <1, 7.5, 1> translate < 30, 9, 0> }
    cylinder { x, -x, 1 scale <6, 1, 1> translate <-35, 4, 0> }
    cylinder { x, -x, 1 scale <6, 1, 1> translate < 35, 4, 0> }
    sphere { 0, 2 translate <-40, 4, 0> }
    sphere { 0, 2 translate <40, 4, 0> }
    difference {
      union {
        sphere { 0, 1 scale <4.5, 4.5, 2> translate <-40, 4, 2.5> }
        sphere { 0, 1 scale <4.5, 4.5, 2> translate < 40, 4, 2.5> }
      }
      plane { z, 3 inverse }
      rotate x*-15
    }
  }
  texture { CromeTexture }
  bounded_by { box { -1, 1 scale <46, 13, 5> translate <0, 11, 2> } }
}

#declare Shield =
object {
  difference {
    box { -1, 1 scale <26, 9.5, .5> translate y*13.5 }
    object { Cylinder_Z scale <2, 2, 1> translate y*23 }
  }
//  texture { Mike_Miller_Glass }
  material { 
    texture {
      pigment { color rgbf <0.90, 0.94, 1.0, 0.8> }
      finish { ambient 0.8 diffuse 0.1 phong 1 phong_size 100 reflection { 0.2 } crand 0.001 }
    }
  }
  bounded_by { box { -1, 1 scale <46, 13, 5> translate <0, 11, 2> } }
}

#declare WindShield =
union {
  object { Frame }
  object { Shield }
  bounded_by { box { -1, 1 scale <46, 13, 5> translate <0, 11, 2> } }
  rotate y*-90
  rotate z*11
  translate <-18, 63.5, 0>
}