//--- Car Tires & Spoked rims
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

//--- Spoke Wire
#declare W1 =
union {
  object { Connector_1 scale <13.425722, 0.5, 0.5> rotate z*-75.53275 rotate y*63.434949 translate <1.5, 13, -2> texture { SpokeTexture } }
  object { Connector_1 scale <13.425722, 0.5, 0.5> rotate z*75.53275 rotate y*-63.434949 translate <-3, 0, -5> texture { SpokeTexture } }
  bounded_by { sphere { 0, 8.885522 translate <0, 6.5, -3.5> } }
}

#declare SP = 
object {
  W1
  bounded_by { sphere { 0, 8.885522 translate < 0, 6.5, -3.5> } }
}

//--- All Spokes
#declare Spokes =
union {
  object { SP }
  object { SP rotate z*30 }
  object { SP rotate z*60 }
  object { SP rotate z*90 }
  object { SP rotate z*120 }
  object { SP rotate z*150 }
  object { SP rotate z*180 }
  object { SP rotate z*210 }
  object { SP rotate z*240 }
  object { SP rotate z*270 }
  object { SP rotate z*300 }
  object { SP rotate z*330 }
  bounded_by { box { -1, 1 scale <15, 15, 6> } }
}

//--- Tire torus
#declare TT =
quartic { <1, 0, 0, 0, 2 0, 0, 2, 0, -754 0, 0, 0, 0, 0 0, 0, 0, 0, 0 1, 0, 0, 2, 0 690, 0, 0, 0, 0 1, 0, -754, 0, 119025> }

#declare Tread =
object {
/*
  object {
    TT
    rotate x*90
    texture { TireTexture }
  }
*/

  object {
    difference {
      cylinder { z, -z, 1 scale <23, 23, 3> }
      object { Cylinder_Z scale <15, 15, 1> }
      rotate x*90
    }
    texture { TreadTexture }
  }
  rotate x*-90
}

#declare Rim =
object {
  union {
    difference {
      cylinder { z, -z, 1 scale <15, 15, 3.5> }
      object { Cylinder_Z scale <13, 13, 1> }
    }
    cylinder { z, -z, 1 scale <3, 3, 5> }	
    sphere { 0, 1 scale <4, 4, 2> translate z*-5 }
  }
  texture { SpokeTexture }
}

//--- Complete Tire with Rim
#declare Tire = 
union {
   object { Tread }
   object { Rim }
   object { Spokes }
   bounded_by { box { -1, 1 scale <24, 24, 10> } }
}