//---- Car Lights
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare Lamp =
object {
  difference {
    union {
      cylinder { z, -z, 1 scale <8, 8, 1> translate <-18, 17, 0> }
      cylinder { z, -z, 1 scale <8, 8, 1> translate < 18, 17, 0> }
      sphere { 0, 1 scale <7.8, 7.8, 8> translate <-18, 17, 1> }
      sphere { 0, 1 scale <7.8, 7.8, 8> translate < 18, 17, 1> }
      cylinder { y, -y, 1 scale <1, 2, 1> translate <-18, 7, 0> }
      cylinder { y, -y, 1 scale <1, 2, 1> translate < 18, 7, 0> }
    }
    sphere { 0, 1 scale <7.8, 7.8, 8> translate <-18, 17, -5> }
    sphere { 0, 1 scale <7.8, 7.8, 8> translate < 18, 17, -5> }
  }
  texture { CromeTexture }
  bounded_by { box { -1, 1 scale <34, 15, 10> translate <0, 12, 5> } }
}

#declare LightSupport =
union {
  sphere { 0, 1 translate x*-30.00001 texture { CromeTexture } }
  object { Connector_1 scale <6.246365, 1, 1> rotate z*25.360657 translate <-30.00001, -0, 0> texture { CromeTexture } }
  sphere { 0, 1 translate <-24.35561, 2.67541, 0> texture { CromeTexture } }
  object { Connector_1 scale <6.246358, 1, 1> rotate z*19.725065 translate <-24.35561, 2.67541, 0> texture { CromeTexture } }
  sphere { 0, 1 translate <-18.47577, 4.7836, 0> texture { CromeTexture } }
  object { Connector_1 scale <6.246367, 1, 1> rotate z*14.089325 translate <-18.47577, 4.7836, 0> texture { CromeTexture } }
  sphere { 0, 1 translate <-12.41731, 6.30418, 0> texture { CromeTexture } }
  object { Connector_1 scale <6.246364, 1, 1> rotate z*8.453525 translate <-12.41731, 6.30418, 0> texture { CromeTexture } }
  sphere { 0, 1 translate <-6.23881, 7.22244, 0> texture { CromeTexture } }
  object { Connector_1 scale <6.246353, 1, 1> rotate z*2.817882 translate <-6.23881, 7.22244, 0> texture { CromeTexture } }
  sphere { 0, 1 translate <-0.00001, 7.52952, 0> texture { CromeTexture } }
  object { Connector_1 scale <6.246363, 1, 1> rotate z*-2.817877 translate <-0.00001, 7.52952, 0> texture { CromeTexture } }
  sphere { 0, 1 translate <6.2388, 7.22244, 0> texture { CromeTexture } }
  object { Connector_1 scale <6.246364, 1, 1> rotate z*-8.453525 translate <6.2388, 7.22244, 0> texture { CromeTexture } }
  sphere { 0, 1 translate <12.4173, 6.30418, 0> texture { CromeTexture } }
  object { Connector_1 scale <6.246367, 1, 1> rotate z*-14.089325 translate <12.4173, 6.30418, 0> texture { CromeTexture } }
  sphere { 0, 1 translate <18.47576, 4.7836, 0> texture { CromeTexture } }
  object { Connector_1 scale <6.246354, 1, 1> rotate z*-19.724979 translate <18.47576, 4.7836, 0> texture { CromeTexture } }
  sphere { 0, 1 translate <24.3556, 2.67542, 0> texture { CromeTexture } }
  object { Connector_1 scale <6.246369, 1, 1> rotate z*-25.36074 translate <24.3556, 2.67542, 0> texture { CromeTexture } }
  sphere { 0, 1 translate x*30 texture { CromeTexture } }
  bounded_by { sphere { 0, 34.51798 translate <-0.000005, 3.76476, 0> } }
}

#declare Lens = 
object {
  Sphere
  scale <7.5, 7.5, 0.3>
  texture { LensTexture }
}

#declare HeadLights =
union {
  object { Lamp }
  object { LightSupport }
  object { Lens translate <-18, 17, -1> }
  object { Lens translate < 18, 17, -1> }
  bounded_by { box { -1, 1 scale <34, 15, 10> translate <0, 12, 5> } }
}