//----- Car Hood
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare HoodTexture =
texture { BodyTexture }

#declare Dot = sphere { 0, 1 }

#declare Connector_1 = 
object {
  quadric { <0, 1, 1>, 0, 0, -1 }
  clipped_by {
    plane { x, 1 }
    plane { -x, 0 }
  }
}

#declare Connector_2 = quadric { <1, -1, 1>, 0, 0, 0 rotate z*90 }

/*----------------------------------------------------------------------------*/

#declare Joints =
union {
  sphere { 0, 3 translate <-22, 62, -27> texture { HoodTexture } }
  object { Connector_1 scale <8, 3, 3> translate <-22, 62, -27> texture { HoodTexture } }
  sphere { 0, 3 translate <-14, 62, -27> texture { HoodTexture } }
  object { Connector_1 scale <85, 3, 3> rotate y*-8.797411 translate <-14, 62, -27> texture { HoodTexture } }
  sphere { 0, 3 translate <70, 62, -14> texture { HoodTexture } }
  object { Connector_1 scale <28, 3, 3> rotate y*-90 translate <70, 62, -14> texture { HoodTexture } }
  sphere { 0, 3 translate <70, 62, 14> texture { HoodTexture } }
  object { Connector_1 scale <85, 3, 3> rotate y*-171.202589 translate <70, 62, 14> texture { HoodTexture } }
  sphere { 0, 3 translate <-14, 62, 27> texture { HoodTexture } }
  object { Connector_1 scale <8, 3, 3> rotate y*-180 translate <-14, 62, 27> texture { HoodTexture } }
  sphere { 0, 3 translate <-22, 62, 27> texture { HoodTexture } }
  object { Connector_1 scale <54, 3, 3> rotate y*90 translate <-22, 62, 27> texture { HoodTexture } }
  sphere { 0, 3 translate <-22, 62, -27> texture { HoodTexture } }
  bounded_by { sphere { 0, 63.285859 translate <24, 62, 0> } }
}

//--- Round Cornered Hood Joints
#declare HoodJoints = 
object {
  Joints
  bounded_by { sphere { 0, 63.285859 translate <24, 62, 0> } }
}