//---- Car Textures 0......................... 8/20/92 Miller
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

//--- Main Body Texture
#declare C1 =
texture {
  pigment { color LightWood }
  finish { ambient 0.2 diffuse 0.4 phong 1 phong_size 90 reflection { 0.2 } }
}

//---Clear to K/O the side pipe exits
#declare C2 =
texture {
  pigment { color Clear }
  finish { ambient 1 diffuse 0 }
}


//--- Gold Trim
#declare C3 =
texture {
  pigment { color Gold }
  finish { ambient 0.2 diffuse 0.4 phong 1 phong_size 90 reflection { 0.6 } }
}

//--- Seat Texture
#declare SeatTexture =
texture {
  pigment { color rgb <0.36, 0.20, 0.09> }
  finish { ambient 0.2 diffuse 0.6 phong 0.07 crand 0.05 phong_size 70 }
}

//--- Dark pin stripes
#declare C4 =
texture {
  pigment { color LightWood }
  finish { ambient 0.1 diffuse 0.3 }
}

//--- Nixxer
#declare Null =
texture { pigment { color Green } }

#declare BodyTexture =
texture {
  material_map {
    //<1, -1, 0>
    gif "carmap.gif"
    texture { Null }
    texture { C2 }
    texture { C3 }
    texture { C1 }
    texture { C4 }
  }
  scale <190, 42, 1>
  translate <70, 29, 0>
}

#declare LensTexture =
texture {
  pigment { color White filter 0.89 }
  finish { ambient 0.2 diffuse 0.4 phong 1 phong_size 90 }
  normal { bumps 0.8 scale 0.2 }
}

//--- Glass Windshield
//#declare GlassTexture =
//texture { Mike_Miller_Glass }

#declare CromeTexture =
texture {
  pigment { color LightGray }
  finish { ambient 0.3 diffuse 0.6 phong 1 phong_size 20 crand 0.02 brilliance 10 reflection { 0.6 } }
}

#declare MessTexture =
texture {
  pigment { color Gray }
  finish { ambient 0.2 diffuse 0.5 phong 1 phong_size 50 crand 0.03 brilliance 9 reflection { 0.5 } }
  normal { waves 0.9 rotate x*90 rotate y*90 scale <10, 10, 0.1> }
}

#declare TireTexture =
texture {
  pigment { color Gray05 }
  finish { ambient 0.2 diffuse 0.9 phong 0.7 phong_size 15 }
}

#declare SpokeTexture =
texture { CromeTexture }

#declare TreadTexture =
texture {
  pigment { color Gray05 }
  finish { crand 0.09 ambient 0.2 diffuse 0.9 phong 0.7 phong_size 15 }
  normal { bump_map { /* 2 <1, -1, 0> */ gif "t2.gif" bump_size 500 interpolate 4 } scale <5, 2, 5> }
}

//---  BodyFrame Texture
#declare  BodyFrameTexture =
texture {
  pigment { color Gray10 }
  finish { ambient 0.2 diffuse 0.4 phong 0.5 phong_size 20 reflection { 0.4 } }
}

#declare SkirtTexture =
texture {
  pigment { color rgb <0.29, 0.10, 0.09> }
  finish { ambient 0.2 diffuse 0.3 phong 1 phong_size 140 reflection 0.15 }
}

//------- CTDS 
#declare Dot = sphere { 0, 1 }

#declare Connector_1 = 
object {
  quadric { <0, 1, 1>, 0, 0, -1 }
  clipped_by {
    plane {  x, 1 }
    plane { -x, 0 }
  }
}

#declare Connector_2 = quadric { <1, -1, 1>, 0, 0, 0 rotate z*90 }